#!/usr/bin/perl
print "Content-type: text/html\n\n";

# CORANTO.CGI FILENAME
# What is your coranto file name?
my $crCGI = 'coranto.cgi';

# TO DO:
# Rewrite removal sub

###############################################
# NOTHING BELOW THIS LINE NEEDS TO BE EDITED
###############################################

eval {
main();
};
if ($@){
&EmailSub_Die($@);
}

sub main {
	# Set $JustLoadSubs to 1 to prevent Coranto from running
	$JustLoadSubs = 1;
	require $crCGI;

	NeedFile('crcore.pl');
	$CurrentTime = time;
	use Fcntl qw(:DEFAULT);
	NeedFile('cruser.pl');
	NeedFile('crlib.pl');
	
	&ReadForm();
	
	$scripturl = &GetScriptURL unless $scripturl;
	&ReadConfigInfo;
	&ReadProfileInfo;
	InitGTD($CConfig{'DateFormat'}, 'GetTheDate');
	InitGTD($CConfig{'InternalDateFormat'}, 'GetTheDate_Internal');
	ReadUserInfo();
	NeedFile('crlang.pl');

	if ($CConfig{'AddonsLoaded'}){
	NeedFile('craddon.pl');
	LoadAddons();
	}

	$EnableCategories = 1 if $CConfig{AddonsLoaded} =~ /(cra_tintinnabulum\.pl|cra_ncategory.pl)/;
	
	{
		my $output;
		my $prof = $in{'prof'};
		
		# Now to decide what action to take
		if ($in{'action'} eq 'add'){
		&EmailSub_Add();
		$output = &Email_ProcessTMPL("$prof", "$CConfig{'admin_path'}/$newsprofiles{$prof}->{'Add_Template'}");
		}
		elsif ($in{'action'} eq 'remove'){
		EmailSub_Remove();
		$output = &Email_ProcessTMPL("$prof", "$CConfig{'admin_path'}/$newsprofiles{$prof}->{'Remove_Template'}");
		}
		else {
		$output = &Email_ProcessTMPL("$prof", "$CConfig{'admin_path'}/$newsprofiles{$prof}->{'Sub_Template'}");
		}
		
		print $output;
		
	}
	
	exit;
}

sub EmailSub_Add {
my $prof = $in{'prof'};

# Check to see if address is valid
{
	if ($in{'email'}=~ tr/;<>*|`&$!#()[]{}:'"//) {
	print &Email_ProcessTMPL("$prof", "$CConfig{'admin_path'}/$newsprofiles{$prof}->{'Invalid_Template'}");
	exit;
	}
}

# Check to see if address is already on the list
{
my $fh = CRopen("$newsprofiles{$prof}->{'ListFile'}") || &EmailSub_Die("Cannot open file $newsprofiles{$prof}->{'ListFile'}");
my @emails = <$fh>;
close($fh);

	foreach my $email(@emails){
	chomp($email);
	
		if ($email eq $in{'email'}){
		# What to do if email is already in DB
		print &Email_ProcessTMPL("$prof", "$CConfig{'admin_path'}/$newsprofiles{$prof}->{'AlreadySub_Template'}");
		exit;
		}
	}
}

# Everything seems okay... add to list

my $fh = CRopen(">>$newsprofiles{$prof}->{'ListFile'}") || &EmailSub_Die("Cannot open file $newsprofiles{$prof}->{'ListFile'}");
print $fh "$in{'email'}\n";
close($fh);
}

sub EmailSub_Remove {
my $prof = $in{'prof'};
my $fh;
my @list;

# Read list file into array
$fh = CRopen("$newsprofiles{$prof}->{'ListFile'}") || &EmailSub_Die("Cannot open file $newsprofiles{$prof}->{'ListFile'}");
@list = <$fh>;
close($fh);

# Check to see if an email is there first!
{
my $exists = 0;

	foreach my $email(@list){
	chomp($email);
		if ($email eq $in{'email'}){
		$exists = 1;
		}
	}
	
	unless ($exists == 1){
	print &Email_ProcessTMPL("$prof", "$CConfig{'admin_path'}/$newsprofiles{$prof}->{'RemoveError_Template'}");
	exit;
	}	
}

# Recreate list from array
my $fh = CRopen(">$newsprofiles{$prof}->{'ListFile'}") || &EmailSub_Die("Cannot open file $newsprofiles{$prof}->{'ListFile'}");

	foreach my $email(@list){
	chomp($email);
		unless ($email eq $in{'email'}){
		print $fh "$email\n";
		}
	}

close($fh);
@list = ();
}

sub Email_ProcessTMPL {
my ($prof, $file) = @_;

my $output = &ProcessTMPL("$file");

$output =~ s/<EmailSubCGI>/$newsprofiles{$prof}->{'EmailSubCGI'}/gi;
$output =~ s/<EmailList>/$prof/gi;
$output =~ s/<EmailListName>/$newsprofiles{$prof}->{'DisplayName'}/gi;
$output =~ s/<EmailAddress>/$in{'email'}/gi;

return $output;
}

sub EmailSub_Die {
my $error = shift;

print qq~
<html>
<head>
<title>Error!</title>
</head>
<body>
<p>An error has occured... it is:<br><br>$error</p>~;
exit;
}
