#! CRADDON 1
#! NAME Unofficial Email Addon
#! DESCRIPTION la la la
#! VERSION 0.7 beta

# TO DO:
# BuildNews and mail sending code
# Do some checking during profile saving to make sure the user provided the necessary information
# Improve error-handling for mail sending subs...
# Anything else that comes to mind :)

#use strict;
#use vars qw(%newsprofiles %Addons %in %CConfig %userdata %newscategories $CurrentTime $CurrentUser $Subject);

my $addon = Addon->new('Unofficial Email Addon');

eval {
	$addon->isPrivacyCompatible();
};
if ($@){}

################################
# PROFILE STUFF
################################

$addon->registerAdminFunction('Email_EditProfile','Email_EditProfile');
$addon->registerAdminFunction('Email_EditProfileSave','Email_EditProfileSave');
$addon->addProfileType('E-mail');

my $ManageProfiles_Links = <<'END_CODE';
	if ($newsprofiles{$i}->{'type'} eq 'E-mail'){
	$actions .= ' [' . PageLink( {'action' => 'admin', 'adminarea' => 'Email_EditProfile', 'prof' => $i} ) . 'Edit List Settings</a>] ';
	
		if (exists $newsprofiles{$i}->{'MailingList'} && $newsprofiles{$i}->{'MailingList'} == 0){
		$actions .= '[' . PageLink({'action' => 'admin', 'adminarea' => 'Email_EditList', 'prof' => $i}) . 'Edit List' . '</a>] ';
		}

	}
END_CODE

my $ProfileList_NewType_Status = <<'END_CODE';
	if ($newsprofiles{$i}->{'type'} eq 'E-mail'){
	$status .= 'This is an e-mail list profile... status support coming soon!';
	}
END_CODE

my $AddProfile_NewType = <<'END_CODE';
	if ($proftype eq 'E-mail'){
	$newsprofiles{$prof} = { 'enabled' => 0,
		'HowSent' => 0,
		'DisplayName' => "$prof",
		'SendInterval' => 7,
		'Method' => '',
		'cats' => ['AllCategories'],
		'ListFile' => "$CConfig{'admin_path'}/$prof.txt",
		'style' => '',
		'template' => 'viewnews.tmpl',
		'From' => $userdata{$CurrentUser}->{'Email'},
		'Subject' => '',
		'AllowManual' => 1,
		'lastSend' => $CurrentTime,
		'Sub_Template' => 'email_sub.tmpl',
		'Add_Template' => 'email_add.tmpl',
		'Remove_Template' => 'email_remove.tmpl',
		'FastSending' => 0,
		'AlreadySub_Template' => 'email_alreadysub.tmpl',
		'RemoveError_Template' => 'email_removeerror.tmpl',
		'Invalid_Template' => 'email_invalid.tmpl',
		'type' => $proftype
	};
	}
END_CODE

$addon->hook('ProfileList_NewType_Functions', \$ManageProfiles_Links, -5);
$addon->hook('AddProfile_NewType', \$AddProfile_NewType, -5);
$addon->hook('ProfileList_NewType_Status', \$ProfileList_NewType_Status, -5);

sub Email_EditProfile {
	&ReadProfileInfo();
	my $prof = $in{'prof'};
	$addon->pageHeader("Email Profile $prof");
	print $addon->form({'prof' => $prof, 'action' => 'admin', 'adminarea' => 'Email_EditProfileSave'});
	SettingsEngine_Display(Email_ProfileDef($prof), $newsprofiles{$prof});
	print $addon->submitButton('Save Settings'), '</form>';
	$addon->pageFooter();
}

sub Email_ProfileDef {
	my $prof = shift;
	my @EditProfileSettings = (
		['heading: General Settings'],
		['HowSent', 'Send E-mail', 
			qq~When and how e-mailed news items will be sent out. They may be:<div align="left" class="description"><ul><li> sent automatically as each news item is posted, one item per e-mail (specifically, the e-mails will be sent once you build news after posting a new item)</li><br><li> sent automatically the first time you build news after the number of days specified in the next setting, with all items submitted since the previous e-mail going out in a single letter</li></ul></div>~,
			[ [1, 'Automatically, with every new item'], [2, 'Automatically, at regular intervals'], [3, 'Manually Only'] ] ]);

		# HOOK: EditProfDefinition_1
		if($Addons{'EditProfDefinition_1'}){my $w;foreach $w (@{$Addons{'EditProfDefinition_1'}}){my $addon=$w->[2];eval ${$w->[0]};AErr($addon,$@)if $@;};}

		my $email_url = "$newsprofiles{$prof}->{'EmailSubCGI'}?prof=$prof";
		
		unless ($newsprofiles{$prof}->{'EmailSubCGI'}){
		$email_url = $scripturl;
		$email_url =~ s/(coranto\.cgi|coranto.pl)/email_sub.cgi\?prof=$prof/gi;
		}
		
		push(@EditProfileSettings,
		['DisplayName', 'Display Name', 'The name that you want your users to see for this list. Default is the profile name.'],
		['AllowManual', 'Allow Manual Mailings', 'Do you want to let Coranto users compose emails manually and send them to this list?', 'yn'],
		['SendInterval', 'Automatic Sending Interval', "The number of days between automatic e-mails. Ignore unless the previous setting is set to &quot;Automatically, at regular intervals&quot;."],
		['SendMailOrSMTP', 'SendMail or SMTP', 'Select here whether to use SendMail ( or a clone program ) or SMTP to send emails. You must select one or the other', [ ['SendMail', 'SendMail ( or clone )'], ['SMTP', 'SMTP'] ]],
		['MailingList', 'Mailing List', "Set this to Yes if you currently got a MajorDomo-type system running and would prefer that Coranto work with it.", 'yn'],
		['heading: Server Settings'],
		['SMTPServer','SMTP Server', 'The IP address or URL of the server you are using to send the mailings. Usually something along the lines of smtp.host.com. Only needed if you chose SMTP above.'],
		['SendMail','SendMail', 'The location of SendMail ( or a SendMail clone ) on your server. Only needed if you chose SendMail above.'],
		['heading: List Options'],
		['ListFile', 'List File', "The name of the file used to store users email addresses. Default is <b>$CConfig{'admin_path'}/$prof.txt</b>. Not used if you select to use mailing list software."],
		['EmailSubCGI','Email Subscription CGI', "The URL to the email subscription CGI script. You only need to set this if you are using Coranto to send the emails and not an external mailing list software.<br><br>To link to this list, try <b>$email_url</b>"],
		['heading: Mailing List Software'],
		['ListAddr', 'List Address', "The email address that the mailing list software uses when sending out emails. An email will be sent to this list and the software takes care of sending it to it's own email list. An example of this is listbot.com"],
		['heading: Formatting Settings'],
		['UseHTML', 'Use HTML', 'If the style you are using contains HTML, you might want to set this to Yes. Otherwise, set it to No. All HTML formatting will be converted to plain text.', 'yn'],
		['style', 'Style', "The style used to format news items.", GetStyleSelect()],
		['template', 'Template', "Template used to format the email sent during Submit/Build News. Can include standard header and footer information in each e-mail; templates are in the standard Coranto .tmpl format, and should include &lt;EmailSubCGI&gt; where appropriate.", GetTMPLSelect(1)],
		['ManualTemplate', 'Manual Mailing Template', 'Similiar to above, except should only contain &lt;InsertContent&gt;, &lt;InsertTitle&gt;, and &lt;EmailSubCGI&gt; ( if applicable ).', GetTMPLSelect() ],
		['From', 'E-mail From', "The e-mail address that e-mails will appear to be sent from. This should be an address you check regularly."],
		['Subject', 'E-mail Subject', "The subject that e-mails will be sent with."],
		['heading: Subscription CGI'],
		['Sub_Template','Default Content', 'The template you want to display to the user if they are not subscribing/removing themselves. Should be just a form to allow subscription/removal.<br><br>The following tags can be used:<br>&lt;EmailAddress&gt;<br>&lt;EmailListName&gt;<br>&lt;EmailList&gt;<br>&lt;EmailSubCGI&gt;', GetTMPLSelect()],
		['Add_Template', 'Subscribed Template', 'The template you want to display after a user has added themselves to a list.<br><br>Can include the following tags:<br>&lt;EmailAddress&gt;<br>&lt;EmailListName&gt;<br>&lt;EmailList&gt;<br>&lt;EmailSubCGI&gt;', GetTMPLSelect()],
		['Remove_Template', 'Removal Template', 'The template you want to display after a user has removed themselves from a list.<br><br>Can include the following tags:<br>&lt;EmailAddress&gt;<br>&lt;EmailListName&gt;<br>&lt;EmailList&gt;<br>&lt;EmailSubCGI&gt;', GetTMPLSelect()],
		['AlreadySub_Template', "'Already Subscribed' Template", 'The template you want to display if an user is already on the list and is trying to subscribe.<br><br>Can include the following tags:<br>&lt;EmailAddress&gt;<br>&lt;EmailListName&gt;<br>&lt;EmailList&gt;<br>&lt;EmailSubCGI&gt;', GetTMPLSelect()],
		['RemoveError_Template', "'Cannot Remove' Template", 'The template you want to display if an user is not on the list and is trying to unsubscribe.<br><br>Can include the following tags:<br>&lt;EmailAddress&gt;<br>&lt;EmailListName&gt;<br>&lt;EmailList&gt;<br>&lt;EmailSubCGI&gt;', GetTMPLSelect()],
		['Invalid_Template', "'Invalid Address' Template", 'The template you want to display if an user attempts to subscribe an address that appears to be invalid.<br><br>Can include the following tags:<br>&lt;EmailAddress&gt;<br>&lt;EmailListName&gt;<br>&lt;EmailList&gt;<br>&lt;EmailSubCGI&gt;', GetTMPLSelect()],
		['heading: Misc'],
		['FastSending','Use Fast Sending', 'Do you want to use the experimental fast sending feature? If you have problems sending email to large lists ( >100 users ), this might be a solution. If unsure whether you should enable this or not, select <b>Yes</b>', yn]
		);

	# HOOK: EditProfDefinition_2
	if($Addons{'EditProfDefinition_2'}){my $w;foreach $w (@{$Addons{'EditProfDefinition_2'}}){my $addon=$w->[2];eval ${$w->[0]};AErr($addon,$@)if $@;};}
		
	return \@EditProfileSettings;
}

sub Email_EditProfileSave {
	my $prof = $in{'prof'};

	# HOOK: EditProfileSave
	if($Addons{'EditProfileSave'}){my $w;foreach $w (@{$Addons{'EditProfileSave'}}){my $addon=$w->[2];eval ${$w->[0]};AErr($addon,$@)if $@;};}

	SettingsEngine_Save(Email_ProfileDef($prof), $newsprofiles{$prof});
	WriteProfileInfo();

	# Do some checking to make sure all necessary information was given
	#my $profile = $newsprofiles{$prof};
	#unless ($profile->{'whatever'}) {
	#$addon->minorError("One or more required fields was left blank. Please go back and double-check that you entered all applicable information.");
	#}
	
	# Create e-mail list file, if necessary
	if ($newsprofiles{$prof}->{'ListFile'} && $newsprofiles{$prof}->{'MailingList'} == 0){
		unless (-e $newsprofiles{$prof}->{'ListFile'}){
		my $fh = $addon->open("+<<$newsprofiles{$prof}->{'ListFile'}");
		close($fh);
		}
	}

	MainProfileList();
}

########################
# MAILING LIST STUFF
########################

$addon->registerAdminFunction('Email_EditList','Email_EditList');
$addon->registerAdminFunction('Email_EditListSave','Email_EditListSave');

sub Email_EditList {
my $prof = $in{'prof'};

my $num = 0;
my $textarea;

my $fh = $addon->open("+<<$newsprofiles{$prof}->{'ListFile'}");

$addon->pageHeader("Edit List: $prof", 1);

	while(<$fh>){
		if ($_){
		$textarea .= $_;
		$num++;
		}
	}

close($fh);

print $addon->descParagraph("From this page, you can manually edit your <b>$prof</b> list, which currently has $num subscribers.");

print $addon->form({'action' => 'admin', 'adminarea' => 'Email_EditListSave', 'prof' => $prof});
print qq~<center><textarea name="EmailList">$textarea</textarea></center><br>~;
print $addon->submitButton('Save!') . '</form>';

$addon->pageFooter();
exit;
}

sub Email_EditListSave {
my $prof = $in{'prof'};

my $fh = $addon->open(">$newsprofiles{$prof}->{'ListFile'}");
chomp($in{'EmailList'});
print $fh qq~$in{'EmailList'}~;
close($fh);

$addon->simplePage("List Saved!","Your changes to the <b>$prof</b> email list have been saved!");
exit;
}

############################
# MANUAL MAILING INTERFACE
############################

$addon->addMainFunction('Compose Email', 'Manually send email to people on your mailing lists!', 'Email_ComposeManual');
$addon->registerMainFunction('Email_ComposeManual', 'Email_ComposeManual');
$addon->registerMainFunction('Email_SendManual', 'Email_SendManual');

sub Email_ComposeManual {
$addon->pageHeader('Send Manual Email');

print $addon->descParagraph('From here, you can send a written email to any of your currently enabled mailing lists! Only lists that allow manual sending are listed below.');

	my $list = qq~<select name="list">~;

	foreach my $prof (sort keys %newsprofiles){
		if ($newsprofiles{$prof}->{'type'} eq 'E-mail' && $newsprofiles{$prof}->{'enabled'} == 1 && ($newsprofiles{$prof}->{'AllowManual'} == 1 || $newsprofiles{$prof}->{'HowSent'} == 3)){
			$list .= qq~<option value="$prof">$prof</option>~;
		}
	}

	$list .= qq~</select>~;

print $addon->form({'action'=>'Email_SendManual'});
print $addon->fieldsTable();
print $addon->fieldsTableRow('List', qq~$list~);
print $addon->fieldsTableRow('Subject', qq~<input type="text" name="Subject">~);
print $addon->fieldsTableRow('Text', qq~<textarea name="Text" rows="10" cols="45"></textarea>~);
print '</table>';
print '<center>' . $addon->submitButton('Send Mail') . '</center>';
print '</form>';

$addon->pageFooter();
exit;
}

##################################
# AUTOMATIC MAILING 
#################################

sub Email_DoMailing {
# This is the sub that actually takes care of sending out all the emails
# This sub is called during Build News

# Pass two variables to sub.... profile name and the content to be emailed.
my ($prof, $content, $subject) = @_;

	unless ($subject && $subject ne ''){
	$subject = $newsprofiles{$prof}->{'Subject'};
	}

	# Replace <EmailSubCGI> in content with URL to sub script
	unless ($newsprofiles{$prof}->{'MailingList'} == 1){
	$content =~ s/<EmailSubCGI>/$newsprofiles{$prof}->{'EmailSubCGI'}/gi;
	}

	unless ($newsprofiles{$prof}->{'UseHTML'} == 1){
	# Strip out all HTML and do some simple text wrapping for older email clients
	$content = HTMLtoText($content);
	$content = SimpleWrap($content);
	}

	if ($newsprofiles{$prof}->{'FastSending'} == 1){
	#print qq~We can use fast sending~;
	my $pid = fork();
	
		if ($pid){
		#print qq~fork id: $pid~;
		exit(1);
		}
	
		else {
			if ($newsprofiles{$prof}->{'SendMailOrSMTP'} eq 'SendMail'){
			Email_DoSendMail($prof, $content, $subject);
			}
			else {
			Email_DoSMTP($prof, $content, $subject);
			}
		}
	}
	else {
		if ($newsprofiles{$prof}->{'SendMailOrSMTP'} eq 'SendMail'){
		Email_DoSendMail($prof, $content, $subject);
		}
		else {
		Email_DoSMTP($prof, $content, $subject);
		}
	}

}

sub Email_DoSendMail {
my ($prof, $content, $subject) = @_;
my $mail;

	if ($newsprofiles{$prof}->{'MailingList'} == 1){
		# We are using a mailing list program
		open($mail, "| $newsprofiles{$prof}->{'SendMail'} -t") || Email_Error("Could not connect to SendMail ( or SendMail clone ): $@");
		print $mail "Content-type: text/html\n" if $newsprofiles{$prof}->{'UseHTML'} == 1;
		print $mail "To: $newsprofiles{$prof}->{'ListAddr'}\n";
		print $mail "From: $newsprofiles{$prof}->{'From'}\n";
		print $mail "Subject: $subject\n";
		print $mail "$content\n";
		close($mail);
	}
	else {
		# We are using a list generated by Coranto itself
		my $fh = $addon->open($newsprofiles{$prof}->{'ListFile'});

			while(<$fh>){
				chomp($_);
				open($mail, "| $newsprofiles{$prof}->{'SendMail'} -t") || Email_Error("Could not connect to SendMail ( or SendMail clone ): $@");
				print $mail "Content-type: text/html\n" if $newsprofiles{$prof}->{'UseHTML'} == 1;
				print $mail "To: $_\n";
				print $mail "From: $newsprofiles{$prof}->{'From'}\n";
				print $mail "Subject: $subject\n";
				print $mail "$content\n";
				close($mail);
			}

		close($fh);
	}
}

{
	my $smtp_module_loaded = 0;
	
	sub Email_DoSMTP {
	my ($prof, $content, $subject) = @_;

		unless ($smtp_module_loaded == 1){
			eval {
			require Net::SMTP;
			Net::SMTP->import();
			};
			if ($@){
				Email_Error($@);
			}
		}

		$smtp_module_loaded = 1;

		if ($newsprofiles{$prof}->{'MailingList'} == 1){
			# We are using a mailing list program, so only send one email to the address specified in the profile
			my $smtp = Net::SMTP->new("$newsprofiles{$prof}->{'SMTPServer'}") || Email_Error("Could not connect to SMTP server $newsprofiles{$prof}->{'SMTPServer'}: $!");

			$smtp->mail("$newsprofiles{$prof}->{'From'}");
			$smtp->to("$newsprofiles{$prof}->{'ListAddr'}");
			$smtp->data();
			$smtp->datasend("Content-type: text/html\n") if $newsprofiles{$prof}->{'UseHTML'} == 1;
			$smtp->datasend("To: $newsprofiles{$prof}->{'ListAddr'}\n");
			$smtp->datasend("Subject: $subject\n");
			$smtp->datasend("$content");
			$smtp->dataend();

			# Close SMTP server connection
			$smtp->quit;
		}
		else {
			# We are using a list generated by Coranto itself
			
			# Open connection to smtp server
			my $smtp = Net::SMTP->new("$newsprofiles{$prof}->{'SMTPServer'}") || Email_Error("Could not connect to SMTP server $newsprofiles{$prof}->{'SMTPServer'}: $!");

			# Open email list file
			my $fh = $addon->open($newsprofiles{$prof}->{'ListFile'});

			while(<$fh>){
				chomp($_);
				$smtp->mail("$newsprofiles{$prof}->{'From'}");
				$smtp->to("$_");

				$smtp->data();
				$smtp->datasend("Content-type: text/html\n") if $newsprofiles{$prof}->{'UseHTML'} == 1;
				$smtp->datasend("To: $_\n");
				$smtp->datasend("Subject: $subject\n");
				$smtp->datasend("$content");
				$smtp->dataend();
			}

			# Close email list file
			close($fh);

			# Close SMTP server connection
			$smtp->quit;
		}
	}

}

#########################
# SUBMIT NEWS
#########################

sub Email_SubmitNews {
&InitUserFieldVars();
$Date = GetTheDate($newstime);
&BasicDateVars($newstime);

my %selectedcats;

	foreach my $prof (keys %newsprofiles){
	
		foreach my $i (@{$newsprofiles{$prof}->{'cats'}}) {
		$selectedcats{$i} = 1;
		}

		if ($newsprofiles{$prof}->{'type'} eq 'E-mail' && $newsprofiles{$prof}->{'enabled'} == 1 && $newsprofiles{$prof}->{'HowSent'} == 1 && ($selectedcats{$in{'Category'}} == 1 || $selectedcats{'AllCategories'} == 1)) {
			my $style = $newsprofiles{$prof}->{'style'};
			my $newshtml = $style->();
			
			#print $newshtml;
			
			my $content = &ProcessTMPL("$CConfig{'admin_path'}/$newsprofiles{$prof}->{'template'}", $newshtml, $in{'Subject'}) || Email_Error("Could not find file $newsprofiles{$prof}->{'template'}");
			Email_DoMailing($prof, $content, $in{'Subject'});
		}
	}
}

$addon->hook('SaveNews_2','Email_SubmitNews', -10);

#########################
# MANUAL EMAILING
#########################

sub Email_SendManual {
my $prof = $in{'list'};
my $content = &ProcessTMPL("$CConfig{'admin_path'}/$newsprofiles{$prof}->{'ManualTemplate'}", $in{'Text'}, $in{'Subject'}) || Email_Error("Could not find file $newsprofiles{$prof}->{'ManualTemplate'}");

Email_DoMailing($prof, $content, $in{'Subject'});

$addon->pageHeader('Email Sent');
print $addon->descParagraph('Your email message has been successfully sent... have a nice day!');
$addon->pageFooter();
exit;
}

#########################
# ERROR HANDLER
#########################

sub Email_Error {
my $error = shift;
$addon->minorError("$error");
exit;
}

##########################
# BUILDNEWS CODE
##########################

my $BuildNews_NewType_Open = <<'END_CODE';
	if ($newsprofiles{$i}->{'type'} eq 'E-mail'){
		delete $ActiveProfiles{$i} unless $newsprofiles{$i}->{'HowSent'} == 2;
	
		my $interval = $newsprofiles{$i}->{'SendInterval'} * 60 * 60 * 24;
		my $NextSend = $newsprofiles{$i}->{'lastSend'} + $interval;
	
		unless ($CurrentTime >= $NextSend){
			# Check if it's been SendInterval days since message last sent
			delete $ActiveProfiles{$i};
		}
	}
END_CODE

$addon->hook('BuildNews_NewType_Open', \$BuildNews_NewType_Open);

my $BuildNews_ProfileType = <<'END_CODE';
	if ($newsprofiles{$i}->{'type'} eq 'E-mail') {
		if (($newsprofiles{$i}->{'lastSend'} && $newsprofiles{$i}->{'lastSend'} < $newstime) && ($newstime <= $CurrentTime)){
		$Date = GetTheDate($newstime);
		$FileName = $i;
		$ProfileName = $i;
		my $item = &{$newsprofiles{$i}->{'style'}};
		$item = HTMLtoText($item) unless $newsprofiles{$i}->{'UseHTML'};
		$EmailContent{$i} .= $item;
		}
		
		# if newstime < lastSend, we remove profile from %ActiveProfiles
		if ($newstime < $newsprofiles{$i}->{'lastSend'}){
		delete $ActiveProfiles{$i};
		}
	}
END_CODE

$addon->hook('BuildNews_ProfileType', \$BuildNews_ProfileType);

my $BuildNews_Post = <<'END_CODE';

	foreach my $i (keys %ActiveProfiles){
		if ($newsprofiles{$i}->{'type'} eq 'E-mail' && $EmailContent{$i}){
		$newsprofiles{$i}->{'lastSend'} = $CurrentTime;
		my $content = &ProcessTMPL("$CConfig{'admin_path'}/$newsprofiles{$i}->{'template'}", $EmailContent{$i}, $newsprofiles{$i}->{'subject'}) || Email_Error("Could not find file $newsprofiles{$i}->{'template'}");
		Email_DoMailing($i, $content);
		}
	}
	
END_CODE

$addon->hook('BuildNews_Post', \$BuildNews_Post);

1;
