#!/usr/bin/perl



# ========================================================================

# Change the way your test database is built by setting the following values



# The number of news items to include

$ItemNumber = 150;



# How far apart these items should be, in seconds.

# 60 * 60 * 1 = 1 hour intervals

$ItemSpacing = (60 * 60 * 1);



# How many words per item

$WordsPerItem = 100;



# set the following two variables to change the range in the size of the words generated

# the default settings will generate words between 3 and 13 letters long

# random size words are used so that testing with addons or functions that snip the news text

# will be dealing with a more real world situation



# Shortest word (in letters)

$MinLetters = 3;



# Longest word (in letters)

$MaxLetters = 13;



# The username of the fake poster

$fakeUserName = "Fake User";



# the  category you wish the news placed in

$fakeNewsCat = "(default)";



# The fake subject you want to use - this will be followed by a number

$fakeSubject = "Fake Item #";



# End of user configued values

# In other words don't mess around below this line

# ========================================================================

my @alpha = split(//,'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ');



# set initial newsid

$newsid = time;

$newsid =~ tr/0123456789/pEkFuVyZlA/;

$newsid .= RandomWord(8);



# check to see if running as cgi and print appropiate header if it is



$info = $ENV {'HTTP_REFERER'};



if($info)

    {

    print "Content-type: text/html\n\n";

    $cgi = 1;

    }



$TheCounter = 1;

$NowTime = time;



if(-e "crcfg.dat") { require "crcfg.dat"; }

else

    {

    if($cgi) { print "<br>\ncrcfg.dat file not found - can not continue\n"; }

    else { print "\ncrcfg.dat file not found - can not continue\n"; }

    exit()

    }



$TimeDiff = (($ItemNumber + 1) * $ItemSpacing);



# @alpha = split(//, 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ');



# check for existence of newsdat.txt file

# if it exists rename it by adding an underscore and 4 random letters

if(-e "newsdat.txt") {

    $newFileName = "newsdat_" . lc(RandomWord(4)) . ".txt";



    if($cgi) { print "\n\n<br>Renaming existing newsdat.txt file to "

                         . $newFileName; }

    else { print "\n\nRenaming existing newsdat.txt file to "

                     . $newFileName; }



    rename("newsdat.txt", $newFileName)

        || die "Could not rename existing newsdat.txt file - aborting";

    }



open(ND, ">newsdat.txt");



if($cgi) { print "<br>"; }



print "\n\nCreating newsdat.txt file\n\n";



if($cgi) { print "<br>"; }



while($TheCounter <= $ItemNumber) {

    $Text = '';



    for($Count2 = 1; $Count2 <= $WordsPerItem; $Count2++) {

        for($Count3 = 0; $Count3 <= ($r = int(rand($MaxLetters

                                                       - $MinLetters

                                                       + 1))

                                         + $MinLetters); $Count3++) {

            $Text .= $alpha[int(rand(26))]; }



        $Text .= " ";

        }



    $User = $fakeUserName;

    $Subject = "$fakeSubject$TheCounter";

    $Category = $fakeNewsCat;

    $newstime = ($NowTime - ($ItemSpacing * $TheCounter));

    $newsline = JoinDataFile();

    print ND $newsline . "\n";



    # compute newsid in the normal Coranto style

    $newsid = $newstime;

    $newsid =~ tr/0123456789/pEkFuVyZlA/;

    $newsid .= RandomWord(8);



    $TheCounter++;



    unless($TheCounter % 20) { print '.'; }

    }



close(ND);



if($cgi) { print "\n\n<br>Complete.\n"; }

else { print "\n\n\nComplete.\n"; }



# RandomWord(x) returns a random string of x characters. (Letters only.)

# Used to create the newsid - borrowed from the Coranto core

sub RandomWord

    {

    my $letters = shift;

    my ($word, $i);



    for($i = 0; $i < $letters; $i++) {

        $word .= $alpha[int(rand(52))]; }



    return $word;

    }

