
sub FirstTimePage {

	$crlang = $in{'SessionLanguage'};
	if($crlang && -e "$CConfig{'lang_path'}/$crlang") {
		NeedFile("$CConfig{'lang_path'}/$crlang");
		unless ($crlangVersion == $crlangVer) {
			CRcough('Your crsetup.pl and language files are mismatched -- that is, they come from different versions or builds of Coranto. Visit <a href="http://coranto.org/">the Coranto homepage</a>, download a new copy of Coranto, and upload new versions of crsetup.pl and the language files.',1);
		}
	}
	
	print &header;
	my $prog = $abspath || GetDirInfo();
		
	CRHTMLHead(CRgetmsg('Coranto Setup'));
	print
		MidHeading(CRgetmsg('Welcome to Coranto')),
		StartForm({'action' => 'setup', 'setupstep' => 1}, 'name="setup"'),
	
		MidParagraph(CRgetmsg(q~Congratulations: one of the most problematic parts of setup, getting Coranto to run as a CGI script, is complete. Now, you need to give Coranto some information -- the paths where its files are stored, the name you'd like to log in with, and various other important details. On this and the next couple of pages, Coranto will ask you for this information.~), 1),

		MidHeading(CRgetmsg('Licensing')),
		MidParagraph(q~<p>Copyright (c) 2007 - present, The Coranto Community (http://www.coranto.org)</p>
		<p>Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:</p>
		<p>The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.</p>
		<p>THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.</p>
		<center><select name="license" onchange="safety(document.setup)"><option value="" selected>Please select an option</option><option value="1">I agree -- I will comply with the Coranto license</option><option value="0">I disagree</option></select></center>~, 1),
	
		MidHeading(CRgetmsg('Privacy')),
		MidParagraph(CRgetmsg('_PRIVACY_INFO') . q~
			<center><P>~ . CRgetmsg('Please choose your privacy settings') . q~: <select name="PublicOrPrivate" onchange="pvtoggle(document.setup)"><option value="1">~ . CRgetmsg('Public') . q~</option><option value="0">~ . CRgetmsg('Private') . q~</option></select></center>~, 1),
		SettingsTable(CRgetmsg('Version Checking?'), qq~<select name="VersionChecking"><option value="1" selected>~ . CRgetmsg('Yes (On)') . q~</option><option value="0">~ . CRgetmsg('No (Off)') . q~</option></select>~, CRgetmsg(q~Set this to 'Yes' if you would like an image to be displayed on the main page indicating the version number of the most up to date stable release of Coranto.~)),
		SettingsTable(CRgetmsg('Urgent Notification?'), qq~<select name="UrgentNotification"><option value="1" selected>~ . CRgetmsg('Yes (On)') . q~</option><option value="0">~ . CRgetmsg('No (Off)') . q~</option></select>~, CRgetmsg(q~Set this to 'Yes' if you'd like us to notify you of important news (bug fixes, new releases, etc.). These news will automatically appear inside your Coranto Administration View. During connection some simple stats (such as version number, and win/unix server) might be transmitted to the Coranto site for statistical analysis. No private info (name, email etc) will be collected at all.~)),
	
		MidHeading(CRgetmsg('File Paths')),
		MidParagraph(($prog ne '.' ? CRgetmsg('It looks like the absolute path to the directory where coranto.cgi is located in is <b>[_1]</b>.', $prog) . CRgetmsg('This guess is accurate 95% of the time. Please refer to the setup documentation for how to change this path if you are absolutely certain that the absolute path to your directory is something different.') : CRgetmsg('Unfortunately, Coranto could not automatically determine the absolute path to where coranto.cgi is located. You can still continue with the setup, but please refer to the setup documentation for how to specify this path. If you are not sure what the path is, please contact your host.')) .
			q~<p>~ . CRgetmsg('In the boxes below, please enter the absolute paths for the two different Coranto directories: <b>News Files</b> and <b>Archive Files</b>. You must enter <b>absolute paths</b> here, not URLs. (Use forward / slashes, even on Windows servers, and do not include a trailing slash.) It is possible to change these settings once you have completed the setup as well.'), 1);
	Setup_PathSettings("$prog/data", "$prog/data/arc");

	my @dirpaths = ("$prog/addons", "$prog/docs", "$prog/languages", "$prog/templates");
	my $direrr = Setup_VerifyDirectories(@dirpaths);
	if( $direrr ) {
		print
			MidHeading(CRgetmsg('Additional File Paths')),
			MidParagraph(CRgetmsg(q~Coranto has discovered that some necessary folders doesn't exist at their default locations, see details below. Please verify that the folders exists and has the right permissions (CHMOD settings) or specify new paths below.~) . qq~<p>$direrr~, 1);
		Setup_ExtraPathSettings(@dirpaths);
	}
		
	print qq~<input type="hidden" name="SessionLanguage" value="$crlang">~;
	print q~<div class="submit"><input type="submit" class="inputsubmit" name="sbmt" value="Continue Setup"></div></form><script language="javascript">
		function pvtoggle (form) {
			if (form.PublicOrPrivate[form.PublicOrPrivate.selectedIndex].value == 0) {
				form.VersionChecking.disabled = true;
				form.VersionChecking.value = 0;
				form.UrgentNotification.disabled = true;
				form.UrgentNotification.value = 0;
			}
			else {
				form.VersionChecking.disabled = false;
				form.VersionChecking.value = 1;
				form.UrgentNotification.disabled = false;
				form.UrgentNotification.value = 1;
			}
		}
		function safety (form) {
			if (form.license[form.license.selectedIndex].value == 1) {
				form.PublicOrPrivate.disabled = false;
				form.VersionChecking.disabled = false;
				form.UrgentNotification.disabled = false;
				form.htmlfile_path.disabled = false;
				form.archive_path.disabled = false;
				form.sbmt.disabled = false;
			}
			else {
				form.PublicOrPrivate.disabled = true;
				form.VersionChecking.disabled = true;
				form.UrgentNotification.disabled = true;
				form.htmlfile_path.disabled = true;
				form.archive_path.disabled = true;
				form.sbmt.disabled = true;
			}
		}
		safety(document.setup);</script>~;
	&CRHTMLFoot_NoNav;
}

sub Setup_PathSettings {
	my ($news, $arc) = @_;
	print
		SettingsTable(CRgetmsg('News Files Path') . ':', qq~<input type="text" name="htmlfile_path" size="50" value="$news">~, CRgetmsg(q~Absolute path to the directory where you'd like the news files -- the ones to be used on your web pages -- to be generated by default~)),
		SettingsTable(CRgetmsg('Archive Files Path') . ':', qq~<input type="text" name="archive_path" size="50" value="$arc">~, CRgetmsg(q~Absolute path to the directory where you'd like news archive to be generated by default. Often the same as the News File path~));
}

sub Setup_ExtraPathSettings {
	my ($addondir, $docsdir, $langdir, $tmpldir) = @_;
	print
		SettingsTable(CRgetmsg('Addon Path') . ':', qq~<input type="text" name="addon_path" size="50" value="$addondir">~, CRgetmsg(q~Absolute path (<b>not</b> URL) to the directory where the addons are located. Use forward slashes (/), even on Windows systems. Do not include a trailing slash.~)),
		SettingsTable(CRgetmsg('Documentation Path') . ':', qq~<input type="text" name="docs_path" size="50" value="$docsdir">~, CRgetmsg(q~Absolute path (<b>not</b> URL) to the directory where the (addon) documenation files are located. Use forward slashes (/), even on Windows systems. Do not include a trailing slash.~)),
		SettingsTable(CRgetmsg('Language Path') . ':', qq~<input type="text" name="lang_path" size="50" value="$langdir">~, CRgetmsg(q~Absolute path (<b>not</b> URL) to the directory where the language files are located. Use forward slashes (/), even on Windows systems. Do not include a trailing slash.~)),
		SettingsTable(CRgetmsg('Template Path') . ':', qq~<input type="text" name="tmpl_path" size="50" value="$tmpldir">~, CRgetmsg(q~Absolute path (<b>not</b> URL) to the directory where the templates are located. Use forward slashes (/), even on Windows systems. Do not include a trailing slash.~));
}

sub Setup_VerifyDirectories {
	my (@dirpaths) = @_;
	my $errmsg = '';
	for $dir (@dirpaths) {
		if (!-d $dir) {
			$errmsg .= CRgetmsg('Could not locate directory <b>[_1]</b>', $dir) . "<br>";
		}
	}
	return $errmsg;
}
  

sub SetupHandler {
	
	$crlang = $in{'SessionLanguage'};
	if($crlang && -e "$CConfig{'lang_path'}/$crlang") {
		NeedFile("$CConfig{'lang_path'}/$crlang");
		unless ($crlangVersion == $crlangVer) {
			CRcough('Your crsetup.pl and language files are mismatched -- that is, they come from different versions or builds of Coranto. Visit <a href="http://coranto.org/">the Coranto homepage</a>, download a new copy of Coranto, and upload new versions of crsetup.pl and the language files.',1);
		}
	}

		
	if ($CConfig{'firsttime'} ne 'yes') {
		CRcough(CRgetmsg(q~This script appears to have already been set up. If you'd like to go through set up again, re-upload the original nsettings.cgi file.~));
	}
	
	my $prog = $abspath || GetDirInfo();
	
	if ($in{'setupstep'} == 1) {
		print &header;
		unless ($in{'license'}) {
			CRcough(CRgetmsg(q~If you do not agree to the license conditions, please delete the Coranto files from your server.~));
		}
		unless ($in{'htmlfile_path'} && $in{'archive_path'}) {
			CRcough(CRgetmsg('You must enter paths for both directories.'));
		}
		my ($news, $arc) = (SecurePath($in{'htmlfile_path'}), SecurePath($in{'archive_path'}));
		my $err;

		# PARAHEAD: Fetch the folders the user has specified or set them to the default locations (2005-05-09)
		my $addondir = $in{'addon_path'} || "$prog/addons";
		my $docsdir = $in{'docs_path'} || "$prog/docs";
		my $langdir = $in{'lang_path'} || "$prog/languages";
		my $tmpldir = $in{'tmpl_path'} || "$prog/templates";

		my @dirpaths = ("$prog", "$news", "$arc", "$addondir", "$docsdir", "$langdir", "$tmpldir");
		# PARAHEAD: Verify that the folders the user has specified exists (2005-05-09)
		my $direrr = Setup_VerifyDirectories(@dirpaths);
		$err .= $direrr;

		# TRIES TO READ Coranto paths from cruser first (allowing easier installation from sites with no writing access to the cgi-bin directory)
		# this falls back to the default case if no settings are found in cruser
		NeedFile('cruser.pl');
		my $data = $data_path?"$data_path":($abspath?"$abspath/data":"$prog/data");
		my @paths = ("$data/nsettings.cgi", "$data/crcfg.dat", "$data/nsbk.cgi", "$data/newsdat.txt", "$prog/crlang.pl");

		for $file (@paths) {
			if (!-e $file) {
				$err .= CRgetmsg('Could not locate file <b>[_1]</b>. The file does not appear to exist. Verify that this file is where it should be.', $file) . "<br />";
			} elsif(!-r $file) {
				$err .= CRgetmsg('Could not read file <b>[_1]</b>. The file appears to exist but is not readable. Check file permissions.', $file) . "<br />";
			} elsif(!-w $file) {
				$err .= CRgetmsg('Could not write to file <b>[_1]</b>. The file appears to exist but is not writable. Check file permissions.', $file) . "<br />";
			}
		}

		unless (open(TEST, ">>$news/delete.me")) {
			$err .= CRgetmsg('Could not create a new file in your News Files directory ([_1]). Check permissions on this directory.', $news);
		}
		close(TEST);
		unlink("$news/delete.me");

#		$CConfig{'PublicOrPrivate'} = $in{'PublicOrPrivate'} unless(defined($CConfig{'PublicOrPrivate'}));
#		$CConfig{'isPublicSite'} = $in{'PublicOrPrivate'} unless(defined($CConfig{'isPublicSite'}));
		$CConfig{'PublicOrPrivate'} = $in{'PublicOrPrivate'} if(defined($in{'PublicOrPrivate'}));
		$CConfig{'isPublicSite'} = $in{'PublicOrPrivate'} if(defined($in{'isPublicSite'}));
		
		$CConfig{'UrgentNotification'} = $in{'UrgentNotification'} if(defined($in{'UrgentNotification'}));
		$CConfig{'VersionChecking'} = $in{'VersionChecking'} if(defined($in{'VersionChecking'}));
				
		if ($err) {
			CRHTMLHead('File Error');
			print
				StartForm({'action' => 'setup', 'setupstep' => 1, 'license' => 1}),
				MidParagraph(CRgetmsg('Whilst testing that all necessary files could be written to, Coranto encountered some errors. Details on the errors are below. Errors are probably caused either by incorrect paths, which you can correct in the boxes below, or incorrect file permissions (CHMOD settings).') . qq~<p>$err~, 1);
			Setup_PathSettings($news, $arc);
			Setup_ExtraPathSettings("$addondir", "$docsdir", "$langdir", "$tmpldir") if($direrr);
			print qq~<input type="hidden" name="SessionLanguage" value="$crlang">~;
			print SubmitButton(CRgetmsg('Continue Setup')), '</form>';
			CRHTMLFoot_NoNav();
			exit;
		}
		
		$CConfig{'htmlfile_path'} = $news;
		$CConfig{'archive_path'} = $arc;
		$CConfig{'addon_path'} = $addondir;
		$CConfig{'docs_path'} = $docsdir;
		$CConfig{'lang_path'} = $langdir;
		$CConfig{'tmpl_path'} = $tmpldir;
		
		CRHTMLHead(CRgetmsg('Coranto Setup'));
		my $rpass = RandomWord(8);

		# Present the available languages, the language that was choosen when the user logged in is preselected
		my $langoptstr = &GetLangOptions({}, $crlang);

		# Fallback gracefully
#		$langoptstr ||= qq~<option value="$prog/crlang.pl" selected>English</option>~;

		print
			StartForm({'action' => 'setup', 'setupstep' => 2}),
			MidHeading(CRgetmsg('File and Path Tests')),
			MidParagraph(CRgetmsg('Testing paths and file permissions... all tests were successful. The paths you entered seem correct, as do file permissions.'), 1),
			MidHeading(CRgetmsg('Create New User')),
			MidParagraph(CRgetmsg(q~Please choose the username and password you'd like to use to log in to Coranto. By default, the username you choose will appear beside your news posts. This user will be your Super-Admin user, and will be the only user with authority to remove standard Admin-level users.~), 1),
			SettingsTable(CRgetmsg('Username') . ':', '<input type="text" name="user">', CRgetmsg('Usernames may contain only letters, numbers, and underscores (_).')),
			SettingsTable(CRgetmsg('Password') . ':', qq~<input type="text" name="pass" value="$rpass">~, CRgetmsg('Your password must be a minimum of five characters. A randomly-generated secure password is suggested in the box above.')),
			SettingsTable(CRgetmsg('E-mail') . ':', qq~<input type="text" name="email">~, CRgetmsg('Your email address.')),
			MidHeading(CRgetmsg('Language Settings') . ':'),
			MidParagraph(CRgetmsg('This setting will allow you to have a global default language when a user logs in to Coranto but the prefered language can be changed individually user by user as well. The translations are kindly provided by Coranto users.')),
			SettingsTable(CRgetmsg('Language') . ':', qq~<select name="GlobalLanguage">$langoptstr</select>~, CRgetmsg('Choose your prefered language for Coranto'));
		
		print qq~<input type="hidden" name="SessionLanguage" value="$crlang">~;
			
		print SubmitButton(CRgetmsg('Continue Setup')), '</form>';
		CRHTMLFoot_NoNav();
		exit;
	}
	elsif ($in{'setupstep'} == 2) {
		print header();
		my $user = $in{'user'};
		my $pass = $in{'pass'};
		$CConfig{'GlobalLanguage'} = $in{'GlobalLanguage'};
		CRcough(CRgetmsg('Username &quot;[_1]&quot; contains illegal characters. Only letters, numbers, and underscores are permitted in usernames.', $user)) if ($user =~ /[^a-zA-Z0-9_]/);
		CRcough(CRgetmsg('Usernames have to be at least 3 characters long.')) unless length($user) > 2;
		CRcough(CRgetmsg('Passwords have to be at least 5 characters long.')) unless length($pass) > 4;
		CRcough(CRgetmsg('You must enter a valid Email address.')) unless length $in{'email'} > 2;
		NeedFile('crcrypt.pl');
		my $crcrypt = new CRcrypt;
		$userdata{$user}->{'CPassword'} = $crcrypt->GetHash($pass . $user);
		$userdata{$user}->{'UserLevel'} = 3;
		$userdata{$user}->{'Email'} = $in{'email'};
		WriteUserInfo();
		CRHTMLHead(CRgetmsg('Coranto Setup'));
		
		print 
			StartForm({'action' => 'setup', 'setupstep' => 3, 'user' => $user, 'email' => $in{'email'}}),
			MidHeading(CRgetmsg(q~Account '[_1]' Created~, $user)),
			MidParagraph(CRgetmsg('Please remember your password. You will need it to use Coranto in the future, and it is not easily reset if you forget it.'), 1),
			MidParagraph(CRgetmsg(q~To get Coranto started quickly, some of the more essential settings are organized into a single page below. All these settings will be available in Coranto's Administration section in the future, and you will be able to change anything you enter here.~), 1);
		NeedFile('cradmin.pl');

		SettingsEngine_Display(SetupSettingsLoad(), \%CConfig);
		print qq~<input type="hidden" name="SessionLanguage" value="$crlang">~;
		print 
			MidParagraph(CRgetmsg('After you click the button below, there may be a delay of about thirty seconds as a basic security check is performed and setup continues at the Coranto site.')),
			SubmitButton(CRgetmsg('Continue Setup (Almost finished!)'));
		CRHTMLFoot_NoNav();
		exit;
	}
	elsif ($in{'setupstep'} == 3) {
		NeedFile('cradmin.pl');
		$CConfig{'currentversion'} = $crcgiVer;
		$CConfig{'currentrc'} = $crcgiRC;
		$CConfig{'currentbuild'} = $crcgiBuild;
		$CConfig{'firsttime'} = 'no';
		$CConfig{'SuperAdmin'} = $in{'user'};
		my $afi = OpenAddons();
		if ($afi->{'backup'}) {
			my @AddonsLoaded = split(/~/, $CConfig{'AddonsLoaded'});
			push(@AddonsLoaded, 'cra_backup.pl');
			$CConfig{'AddonsLoaded'} = join('~', @AddonsLoaded);
		}

		SettingsEngine_Save(&SetupSettingsLoad(), \%CConfig);

		if ($CConfig{'PublicOrPrivate'}) {
			# public installation
#			print "Location: http://coranto.org/scripts/done.php?b=$crcgiBuild&rc=$crcgiRC&u=" . URLescape($scripturl) . '&v=' . URLescape($crcgiVer) . "\n\n";
			print &header;
			CRHTMLHead(CRgetmsg('Setup Complete'));
			my $coranto_support_link=URLescape("http://coranto.org/forum");
#			my $coranto_mail_link=URLescape("http://www.gweilo.org/mailman/listinfo/coranto_gweilo.org");
			print MidParagraph('<br>' . CRgetmsg('If you need any further assistence with Coranto, we invite you to join us at the Coranto Support Forums where you will find help, tutorials, and more: [_1]', qq~<a href="$coranto_support_link">$coranto_support_link</a>~) . '<br>');
			print MidParagraph(CRgetmsg('Setup is complete.<p>Click [_1]here[_2] to continue', PageLink(), '</a>'));
			&CRHTMLFoot_NoNav;
		}
		else {#private installation
			print &header;
			CRHTMLHead(CRgetmsg('Setup Complete'));
			print MidParagraph(CRgetmsg('Setup is complete.<p>Click [_1]here[_2] to continue', PageLink(), '</a>'));
			&CRHTMLFoot_NoNav;
		}
		exit;
	}
}


sub SetupSettingsLoad {
	NeedFile('cruser.pl');
	my $cfgfupa = $data_path?"$data_path":($abspath?"$abspath/data":GetDirInfo() . "/data");
	NeedFile("$cfgfupa/crcfg.dat");
	
	InitGTD('<Field: Hour>:<Field: Minute>:<Field: Second> <Field: AMPM>, <Field: Month_Name> <Field: Day>', 'GetFullDisplayTime');
	my @SetupSettings = (
	['heading: ' . CRgetmsg('Your Site')],		
	['SiteTitle', CRgetmsg('Site Name'), CRgetmsg('The name of your site. This will be displayed on Coranto script pages.')],
	['SiteLink', CRgetmsg('Site Link'), CRgetmsg(q~If you'd like a &quot;Back to Your Site&quot; link on Coranto script pages, enter a URL here. Otherwise, leave blank.~)],
	['heading: ' . CRgetmsg('Date &amp; Time Settings')],
	['Standard_Time_Zone', CRgetmsg('Time Zone'), CRgetmsg('Your time zone. Any name or abbreviation is acceptable -- this is for display purposes only.')],
	['Daylight_Time_Zone', CRgetmsg('Daylight Savings Time Zone'), CRgetmsg('As above, but during Daylight Savings Time.')],
	['TimeOffset', CRgetmsg('Server Time Offset'), CRgetmsg(q~Often, your server will be in a different time zone than you are. You can enter the difference, in hours, between the server's time and the time you would like displayed on news items. For instance, if your server is in London and you are in Boston, set this to -5. Changing this setting will not affect existing news items; only new items will have an adjusted time. (The server's current time is: [_1])~, GetFullDisplayTime($CurrentTime))],
	['12HourClock', CRgetmsg('12/24 Hour Clock?'), CRgetmsg('Choose between a 12 hour (AM/PM) and 24 hour clock.'), 
		[ ['1', CRgetmsg('12 Hour (AM/PM)')], ['0', CRgetmsg('24 Hour')] ] ]);
	return \@SetupSettings;
}
 
sub UpgradeToNewFolderStructure {
		my $msg = "";
		my $okmsg = "";
		my $datafolder = $data_path?"$data_path":($abspath?"$abspath/data":GetDirInfo() . "/data");
		
		unless(-d $datafolder) {
			# Try and create the addons sub folder
			my $patherr = CRCreatePath($datafolder);
			if( $patherr ) {
				$msg .= "<li><p>$patherr</p></li>";
				$msg .= "<li><p>Your data folder does not seem to be at the default location and it could not be created, so please create the folder: '$datafolder'</p></li>";
			} else {
				$okmsg .= "<li><p>The upgrade script sucessfully created the folder '$datafolder'</p></li>";
			}
		}

		if(!-d $datafolder) {
			$msg .= "<li><p>Your data folder does not seem to be at the default location, please refer to the upgrade documentation for assistance. An intelligent guess is that you should create the folder below and move the files nsettings.cgi, crcfg.dat and newsdat.txt to it.<br>'<strong>" . GetDirInfo() . "/data</strong>'.</p></li>";
		} elsif(!-w $datafolder || !-r $datafolder) {
			$msg .= "<li><p>Your data folder exists, but it is not possible for Coranto to read or write to it.</p></li>";
		} else {
			if(!-e "$datafolder/nsettings.cgi") {
				if( rename("$CConfig{'admin_path'}/nsettings.cgi", "$datafolder/nsettings.cgi") ) {
					$okmsg .= "<li><p>Moved '$CConfig{'admin_path'}/nsettings.cgi' to '$datafolder/nsettings.cgi'</p></li>";
#					if( rename("$CConfig{'admin_path'}/nsettings.lock", "$datafolder/nsettings.lock") ) {
#						$okmsg .= "<li><p>Moved '$CConfig{'admin_path'}/nsettings.lock' to '$datafolder/nsettings.lock'</p>";
#					} else {
#						$msg .= "<li><p>Could not move nsettings.lock from folder '$CConfig{'admin_path'}' to '$datafolder'</p>";
#					}
				} else {
					$msg .= "<li><p>Could not move nsettings.cgi from folder '$CConfig{'admin_path'}' to '$datafolder'</p></li>";
				}
			}
			if(!-e "$datafolder/crcfg.dat") {
				if( rename("$CConfig{'admin_path'}/crcfg.dat", "$datafolder/crcfg.dat") ) {
					$okmsg .= "<li><p>Moved '$CConfig{'admin_path'}/crcfg.dat' to '$datafolder/crcfg.dat'</p></li>";
				} else {
					$msg .= "<li><p>Could not move crcfg.dat from folder '$CConfig{'admin_path'}' to '$datafolder'</p></li>";
				}
			}
			if(!-e "$datafolder/newsdat.txt") {
				if( rename("$CConfig{'htmlfile_path'}/newsdat.txt", "$datafolder/newsdat.txt") ) {
					$okmsg .= "<li><p>Moved '$CConfig{'htmlfile_path'}/newsdat.txt' to '$datafolder/newsdat.txt'</p></li>";
				} else {
					$msg .= "<li><p>Could not move newsdat.txt from folder '$CConfig{'htmlfile_path'}' to '$datafolder'</p></li>";
				}
			}
		}
		
		if(!$CConfig{'htmlfile_path'}) {
			$CConfig{'htmlfile_path'} = $datafolder;
			$okmsg .= "<li><p>You didn't had a default html output folder specified, so it was automatically set to '$CConfig{'htmlfile_path'}'</p></li>";
		}
		if(!-d $CConfig{'htmlfile_path'}) {
			$msg .= "<li><p>Your default html output folder is currently set to: '$CConfig{'htmlfile_path'}'<br>However, it does not seem to exist.</p></li>";
		} elsif(!-w $CConfig{'htmlfile_path'}) {
			$msg .= "<li><p>Your default html output folder is currently set to: '$CConfig{'htmlfile_path'}'<br>It does exist, but Coranto can not write to it.</p></li>";
		}
		if(!$CConfig{'archive_path'}) {
			$CConfig{'archive_path'} = $datafolder;
			$okmsg .= "<li><p>You didn't had a default html archive output folder specified, so it was automatically set to '$CConfig{'archive_path'}'</p></li>";
		}
		if(!-d $CConfig{'archive_path'}) {
			$msg .= "<li>Your default html archive output folder is currently set to: '$CConfig{'archive_path'}'.However, it does not seem to exists.</p></li>";
		} elsif(!-w $CConfig{'archive_path'}) {
			$msg .= "<li><p>Your default html archive output folder is currently set to: '$CConfig{'archive_path'}'<br>It does exist, but Coranto can not write to it.</p></li>";
		}
		
		
		my $addondir = "$CConfig{'admin_path'}/addons";
#print header();			
		unless(-d $addondir) {
			# Try and create the addons sub folder
			my $patherr = CRCreatePath($addondir);
			if( $patherr ) {
				$msg .= "<li><p>$patherr</p></li>";
				$msg .= "<li><p>Your addon folder does not seem to be at the default location and it could not be created, so please create the folder: '$addondir'</p></li>";
			} else {
				$okmsg .= "<li><p>The upgrade script sucessfully created the folder '$addondir'</p></li>";
			}
		}
		if(-d $addondir) {
			# Try and move the addons in the base folder to the new addon sub folder
			opendir(ADDONDIR, $CConfig{'admin_path'});
			my @addonfiles = readdir(ADDONDIR);
			closedir(ADDONDIR);
			@addonfiles = grep(/^cra_\S+\.pl$/, @addonfiles);
			my $allAddonsOK = 1;
			if( @addonfiles ) {
				if(!-w $addondir) {
					$msg .= "<li><p>The new addons sub folder exists, but it is not writable so the addons currently located in the Coranto base folder can not be moved there automatically.</p></li>";
				} else {
					my $moveAddons = '';
					my $notMoved = '';
					foreach my $af (@addonfiles) {
						unless (-e "$addondir/$af") {
							if( rename("$CConfig{'admin_path'}/$af", "$addondir/$af") ) {
								$moveAddons .= "<br>$af";
							} else {
								$notMoved .= "<br><em>$af</em>: $!";
								$allAddonsOK = 0;
							}
						} else {
							$notMoved .= "<br><em>$af</em>: The addon already existed in the new folder";
						}
					}
					$msg .= "<li><p>The addons below could not be moved to the new addon folder:$notMoved</p></li>" if $notMoved;
					$okmsg .= "<li><p>The following addons where successfully moved to the new addon folder:$moveAddons</p></li>" if $moveAddons;
				}
			}
			if($allAddonsOK) {
				my @addons = split(/~/, $CConfig{'AddonsLoaded'});
				my $missingAddon = '';
				foreach my $af (@addons) {
					unless (-e "$addondir/$af") {
						$missingAddon .= "<br>$af";
					}
				}
				$msg .= "<li><p>For some reason there are addons missing which you currently depend upon. The upgrade script could not locate the following addons in the new addon folder, so please place them there manually.$missingAddon</p></li>" if $missingAddon;
			}
		}
		
		my $docsdir = "$CConfig{'admin_path'}/docs";
		unless(-d $docsdir) {
			my $patherr = CRCreatePath($docsdir);
			if( $patherr ) {
				$msg .= "<li><p>$patherr</p></li>";
				$msg .= "<li><p>Your documentation folder does not seem to be at the default location and it could not be created, so please create the folder: '$docsdir'</p></li>";
			} else {
				$okmsg .= "<li><p>Sucessfully created the folder '$docsdir', but you need to FTP the docs provided with the Coranto distribution to that folder.</p></li>";
			}
		}
		my $langdir = "$CConfig{'admin_path'}/languages";
		unless(-d $langdir) {
			my $patherr = CRCreatePath($langdir);
			if( $patherr ) {
				$msg .= "<li><p>$patherr</p></li>";
				$msg .= "<li><p>Your language folder does not seem to be at the default location and it could not be created, so please create the folder: '$langdir'</p></li>";
			} else {
				$okmsg .= "<li><p>Sucessfully created the folder '$langdir', but you need to FTP the language files you want to use to that folder.</p></li>";
			}
		}
		my $tmpldir = "$CConfig{'admin_path'}/templates";
		unless(-d $tmpldir) {
			my $patherr = CRCreatePath($tmpldir);
			if( $patherr ) {
				$msg .= "<li><p>$patherr</p></li>";
				$msg .= "<li><p>Your template folder does not seem to be at the default location and it could not be created, so please create the folder: '$tmpldir'</p></li>";
			} else {
				$okmsg .= "<li><p>The upgrade script sucessfully created the folder '$tmpldir'</p></li>";
			}
		}
		if(-d $tmpldir) {
			# Try and move the templates in the base folder to the new template sub folder
			opendir(TMPLDIR, $CConfig{'admin_path'});
			my @templatefiles = readdir(TMPLDIR);
			closedir(TMPLDIR);
			@templatefiles = grep(/^\S+\.tmpl$/, @templatefiles);
			if(@templatefiles) {
				if(!-w $tmpldir) {
					$msg .= "<li><p>The new template sub folder exists, but it is not writable so the templates currently located in the Coranto base folder can not be moved there automatically.</p></li>";
				} else {
					my $moveTemplates = '';
					my $notMoved = '';
					foreach $tf (@templatefiles) {
						if( rename("$CConfig{'admin_path'}/$tf", "$tmpldir/$tf") ) {
							$moveTemplates .= "<br>$tf";
						} else {
							$notMoved .= "<br>$tf: $!";
						}
					}
					$msg .= "<li><p>The templates below could not be moved to the new template folder:$notMoved</p></li>" if $notMoved;
					$okmsg .= "<li><p>The following templates where successfully moved to the new template folder:$moveTemplates</p></li>" if $moveTemplates;
				}
			}
		}
				
		if($nsettingspath) {
			$msg .= '<li><p>You have previously used the $nsettingspath variable defined in cruser.pl. This variable has now been replaced with the $data_path variable, please read the upgrade documentation for more details on how to upgrade your cruser.pl file!';
			$msg .= qq~<br>Your path to nsettings.cgi is currently <b>$nsettingspath</b></p></li>~;
		}
		if($nsbkpath) {
			$msg .= '<li><p>You have previously used the $nsbkpath variable defined in cruser.pl. This variable has now been replaced with the $data_path variable, please read the upgrade documentation for more details on how to upgrade your cruser.pl file!';
			$msg .= qq~<br>Your path to nsbk.cgi is currently <b>$nsbkpath</b></p></li>~;
		}
		if($cfgpath) {
			$msg .= '<li><p>You have previously used the $cfgpath variable defined in cruser.pl. This variable has now been replaced with the $data_path variable, please read the upgrade documentation for more details on how to upgrade your cruser.pl file!';
			$msg .= qq~<br>Your path to crcfg.dat is currently <b>$cfgpath</b></p></li>~;
		}

		if($msg) {
			if(defined $CConfig{'currentbuild'} && ($CConfig{'currentbuild'} < 45)) {
				my $completemsg = "<strong>You have used an old version of Coranto which doesnt use the new folder structure. The automatic upgrade was not able to move all files to this new folder structure, so please follow the directions below and manually fix the errors and then hit reload to complete the upgrade!</strong><br><ul>$msg</ul>";
				$completemsg .= "<strong>The tasks below was succesfully executed during the upgrade:</strong><br><ul>$okmsg</ul>" if $okmsg;
				my $forceButton = ($in{'ForceUpgrade'})?"Upgrade has been forced, click here to log in":"Click here to force the upgrade to complete!<br>Do consider if this is really what you want though,<br>the errors above will NOT be solved unless you manually correct them!";
				$completemsg .= qq~<strong><a href="$scripturl?ForceUpgrade=1">$forceButton</A></strong>~;
				SimpleConfirmationPage("Upgrade Failure!", $completemsg);
			}
		} elsif($okmsg) {
			if(defined $CConfig{'currentbuild'} && ($CConfig{'currentbuild'} < 45)) {
				my $loginMsg = qq~<strong><a href="$scripturl">Click here to log in</a></strong>~;
				SimpleConfirmationPage("Upgrade Sucessfull!", "<strong>Upgrade Sucessfull!</strong><br><ul>$okmsg</ul>$loginMsg");
			}
		} else {
			# Return to normal Coranto control, eg. present a login screen
			return;
		}

		# If there is no errormessage or if the user has forced the upgrade to complete, make it happen...
		if($in{'ForceUpgrade'} || !$msg) {
			$CConfig{'currentversion'} = $crcgiVer;
			$CConfig{'currentrc'} = $crcgiRC;
			$CConfig{'currentbuild'} = $crcgiBuild;
		}
		exit;
}


# Create a complete path structure using the module File::Path
{
	my $moduleLoaded = 0;
	sub CRCreatePath {
		my ($dirpath) = @_;
		unless( $moduleLoaded ) {
			eval{ require File::Path }; 
			if($@) {
				# To bad, we can not use the File::Path module...
				return "Could not load the module File::Path: $@";	
			} else {
				$moduleLoaded = 1;
			}
		}
		eval { File::Path::mkpath($dirpath) };
		return $@;
	}
}	
 
1;
