# crlang.pl
# This file contains English-language messages for Coranto.
# Do not translate this file; see the Coranto website for more information on
# how to translate Coranto's messages into a foreign language.

$crlangVersion = 2;

%Messages = (
#####################################################################################
#HEADER: Setup Messages
#SECTION: Page 1
q~Coranto Setup~
  => q~Coranto Setup~,
q~Welcome to Coranto~
  => q~Welcome to Coranto~,
q~Congratulations: one of the most problematic parts of setup, getting Coranto to run as a CGI script, is complete. Now, you need to give Coranto some information -- the paths where its files are stored, the name you'd like to log in with, and various other important details. On this and the next couple of pages, Coranto will ask you for this information.~
  => q~Congratulations: one of the most problematic parts of setup, getting Coranto to run as a CGI script, is complete. Now, you need to give Coranto some information -- the paths where its files are stored, the name you'd like to log in with, and various other important details. On this and the next couple of pages, Coranto will ask you for this information.~,
q~Licensing~
  => q~Licensing~,
q~Please select an option~
  => q~Please select an option~,
q~I agree -- I will comply with the Coranto license~
  => q~I agree -- I will comply with the Coranto license~,
q~Privacy~
  => q~Privacy~,
q~_PRIVACY_INFO~ # Privacy information, should this really be translated?
  => <<'EOSENTANCE',
	Coranto is designed to allow for a good degree of privacy for its users, and two privacy levels are available to
	cater for different users' needs.  No personal information about users is logged without your permission, and we do not share
	any information with third-parties or use it for junk mail.<p>
	The standard privacy setting, 'Public', will suit most users. At your option, you can choose to disable the version checking
	image (to speed page loading and/or to prevent the URL to your coranto.cgi appearing as a referrer in our server logs). You
	can also choose whether or not you would like to share the name and email address of your SuperAdmin user with us, solely to allow
	us to notify you of any major bugs or security holes discovered in the version of the script you are running.  You will be passed
	briefly to our server during the setup process to allow you to sign up for our forums and update mailing list if you desire. The
	URL to your coranto.cgi is passed to our server at this stage solely to allow us to provide you with a link back to your completed
	installation, and is not logged. For greater privacy, you can set your web browser or firewall to hide the referrer; this is a
	function of your computer's setup, and is beyond Coranto's control.<p>
	If you are running Coranto on a private network that is not linked to the Internet, or require the absolute maximum privacy
	possible, you may choose the 'Private' setting. You will not be passed to our server during the setup process, and all links
	or image calls to third-party servers in the script will be disabled.  Note that if you choose this option, YOU WILL BE UNABLE TO
	RUN ANY ADDONS WHICH DO NOT ALSO COMPLY WITH THIS PRIVACY SETTING. Be aware that if you choose this option, you are acknowledging
	that Coranto's creators bear no responsibility (and have no means) to contact you should a bug or security hole be found in the
	script, nor to provide you with support for the script's operation. You agree that it is your own responsibility to regularly
	check the News section of our site, and also the forum section where you may find news on new releases, bugs, etc.
EOSENTANCE
q~Please choose your privacy settings~
  => q~Please choose your privacy settings~,
q~Public~
  => q~Public~,
q~Private~
  => q~Private~,
q~Version Checking?~
  => q~Version Checking?~,
q~Set this to 'Yes' if you would like an image to be displayed on the main page indicating the version number of the most up to date stable release of Coranto.~
  => q~Set this to 'Yes' if you would like an image to be displayed on the main page indicating the version number of the most up to date stable release of Coranto.~,
q~Urgent Notification?~
  => q~Urgent Notification?~,
q~Set this to 'Yes' if you'd like us to notify you of important news (bug fixes, new releases, etc.). These news will automatically appear inside your Coranto Administration View. During connection some simple stats (such as version number, and win/unix server) might be transmitted to the Coranto site for statistical analysis. No private info (name, email etc) will be collected at all.~
  => q~Set this to 'Yes' if you'd like us to notify you of important news (bug fixes, new releases, etc.). These news will automatically appear inside your Coranto Administration View. During connection some simple stats (such as version number, and win/unix server) might be transmitted to the Coranto site for statistical analysis. No private info (name, email etc) will be collected at all.~,
q~File Paths~
  => q~File Paths~,
q~It looks like the absolute path to the directory where coranto.cgi is located in is <b>[_1]</b>.~
  => q~It looks like the absolute path to the directory where coranto.cgi is located in is <b>[_1]</b>.~,
q~This guess is accurate 95% of the time. Please refer to the setup documentation for how to change this path if you are absolutely certain that the absolute path to your directory is something different.~
  => q~This guess is accurate 95% of the time. Please refer to the setup documentation for how to change this path if you are absolutely certain that the absolute path to your directory is something different.~,
q~Unfortunately, Coranto could not automatically determine the absolute path to where coranto.cgi is located. You can still continue with the setup, but please refer to the setup documentation for how to specify this path. If you are not sure what the path is, please contact your host.~
  => q~Unfortunately, Coranto could not automatically determine the absolute path to where coranto.cgi is located. You can still continue with the setup, but please refer to the setup documentation for how to specify this path. If you are not sure what the path is, please contact your host.~,
q~In the boxes below, please enter the absolute paths for the two different Coranto directories: <b>News Files</b> and <b>Archive Files</b>. You must enter <b>absolute paths</b> here, not URLs. (Use forward / slashes, even on Windows servers, and do not include a trailing slash.) It is possible to change these settings once you have completed the setup as well.~
  => q~In the boxes below, please enter the absolute paths for the two different Coranto directories: <b>News Files</b> and <b>Archive Files</b>. You must enter <b>absolute paths</b> here, not URLs. (Use forward / slashes, even on Windows servers, and do not include a trailing slash.) It is possible to change these settings once you have completed the setup as well.~,
q~News Files Path~
  => q~News Files Path~,
q~Absolute path to the directory where you'd like the news files -- the ones to be used on your web pages -- to be generated by default~
  => q~Absolute path to the directory where you'd like the news files -- the ones to be used on your web pages -- to be generated by default~,
q~Archive Files Path~
  => q~Archive Files Path~,
q~Absolute path to the directory where you'd like news archive to be generated by default. Often the same as the News File path~
  => q~Absolute path to the directory where you'd like news archive to be generated by default. Often the same as the News File path~,
q~Additional File Paths~
  => q~Additional File Paths~,
q~Coranto has discovered that some necessary folders doesn't exist at their default locations, see details below. Please verify that the folders exists and has the right permissions (CHMOD settings) or specify new paths below.~
  => q~Coranto has discovered that some necessary folders doesn't exist at their default locations, see details below. Please verify that the folders exists and has the right permissions (CHMOD settings) or specify new paths below.~,
q~Continue Setup~
  => q~Continue Setup~,
  
#SECTION: Page 1 error messages
q~This script appears to have already been set up. If you'd like to go through set up again, re-upload the original nsettings.cgi file.~
  => q~This script appears to have already been set up. If you'd like to go through set up again, re-upload the original nsettings.cgi file.~,
q~If you do not agree to the license conditions, please delete the Coranto files from your server.~
  => q~If you do not agree to the license conditions, please delete the Coranto files from your server.~,
q~You must enter paths for both directories.~
  => q~You must enter paths for both directories.~,
q~Could not locate directory <b>[_1]</b>~
  => q~Could not locate directory <b>[_1]</b>~,
q~Could not locate file <b>[_1]</b>. The file does not appear to exist. Verify that this file is where it should be.~
  => q~Could not locate file <b>[_1]</b>. The file does not appear to exist. Verify that this file is where it should be.~,
q~Could not read file <b>[_1]</b>. The file appears to exist but is not readable. Check file permissions.~
  => q~Could not read file <b>[_1]</b>. The file appears to exist but is not readable. Check file permissions.~,
q~Could not write to file <b>[_1]</b>. The file appears to exist but is not writable. Check file permissions.~
  => q~Could not write to file <b>[_1]</b>. The file appears to exist but is not writable. Check file permissions.~,
q~Could not create a new file in your News Files directory ([_1]). Check permissions on this directory.~
  => q~Could not create a new file in your News Files directory ([_1]). Check permissions on this directory.~,
q~Whilst testing that all necessary files could be written to, Coranto encountered some errors. Details on the errors are below. Errors are probably caused either by incorrect paths, which you can correct in the boxes below, or incorrect file permissions (CHMOD settings).~
  => q~Whilst testing that all necessary files could be written to, Coranto encountered some errors. Details on the errors are below. Errors are probably caused either by incorrect paths, which you can correct in the boxes below, or incorrect file permissions (CHMOD settings).~,
  
#SECTION: Page 2
q~File and Path Tests~
  => q~File and Path Tests~,
q~Testing paths and file permissions... all tests were successful. The paths you entered seem correct, as do file permissions.~
  => q~Testing paths and file permissions... all tests were successful. The paths you entered seem correct, as do file permissions.~,
q~Create New User~
  => q~Create New User~,
q~Please choose the username and password you'd like to use to log in to Coranto. By default, the username you choose will appear beside your news posts. This user will be your Super-Admin user, and will be the only user with authority to remove standard Admin-level users.~
  => q~Please choose the username and password you'd like to use to log in to Coranto. By default, the username you choose will appear beside your news posts. This user will be your Super-Admin user, and will be the only user with authority to remove standard Admin-level users.~,
q~Usernames may contain only letters, numbers, and underscores (_).~
  => q~Usernames may contain only letters, numbers, and underscores (_).~,
q~Your password must be a minimum of five characters. A randomly-generated secure password is suggested in the box above.~
  => q~Your password must be a minimum of five characters. A randomly-generated secure password is suggested in the box above.~,
q~E-mail~
  => q~E-mail~,
q~Your email address.~
  => q~Your email address.~,
q~Language Settings~
  => q~Language Settings~,
q~This setting will allow you to have a global default language when a user logs in to Coranto but the prefered language can be changed individually user by user as well. The translations are kindly provided by Coranto users.~
  => q~This setting will allow you to have a global default language when a user logs in to Coranto but the prefered language can be changed individually user by user as well. The translations are kindly provided by Coranto users.~,
q~Choose your prefered language for Coranto~
  => q~Choose your prefered language for Coranto~,

#SECTION: Page 2 error messages
q~Username &quot;[_1]&quot; contains illegal characters. Only letters, numbers, and underscores are permitted in usernames.~
  => q~Username &quot;[_1]&quot; contains illegal characters. Only letters, numbers, and underscores are permitted in usernames.~,
q~Usernames have to be at least 3 characters long.~
  => q~Usernames have to be at least 3 characters long.~,
q~Passwords have to be at least 5 characters long.~
  => q~Passwords have to be at least 5 characters long.~,
q~You must enter a valid Email address.~
  => q~You must enter a valid Email address.~,

#SECTION: Page 3
q~Account '[_1]' Created~
  => q~Account '[_1]' Created~,
q~Please remember your password. You will need it to use Coranto in the future, and it is not easily reset if you forget it.~
  => q~Please remember your password. You will need it to use Coranto in the future, and it is not easily reset if you forget it.~,
q~To get Coranto started quickly, some of the more essential settings are organized into a single page below. All these settings will be available in Coranto's Administration section in the future, and you will be able to change anything you enter here.~
  => q~To get Coranto started quickly, some of the more essential settings are organized into a single page below. All these settings will be available in Coranto's Administration section in the future, and you will be able to change anything you enter here.~,
q~After you click the button below, there may be a delay of about thirty seconds as a basic security check is performed and setup continues at the Coranto site.~
  => q~After you click the button below, there may be a delay of about thirty seconds as a basic security check is performed and setup continues at the Coranto site.~,
q~Your Site~
  => q~Your Site~,
q~Continue Setup (Almost finished!)~
  => q~Continue Setup (Almost finished!)~,
  
#SECTION: Page 4, Setup Complete
q~Setup Complete~
  => q~Setup Complete~,
q~If you need any further assistence with Coranto, be welcome to the Coranto Unofficial Site Support Forums where you will find help and tutorials: [_1]~
  => q~If you need any further assistence with Coranto, be welcome to the Coranto Unofficial Site Support Forums where you will find help and tutorials: [_1]~,
q~Setup is complete.<p>Click [_1]here[_2] to continue~
  => q~Setup is complete.<p>Click [_1]here[_2] to continue~,



#####################################################################################
#HEADER: General Sentances
# If your language needs a different character set, you may have to change this tag.
q~<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">~
  => q~<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">~,
# Coranto's SQL support check
q~You have tried to enable Coranto's SQL support, but DBI could not be loaded. It has been automatically disabled.~
  => q~You have tried to enable Coranto's SQL support, but DBI could not be loaded. It has been automatically disabled.~,
# Powered by Coranto
q~Powered by [_1]~
  => q~Powered by [_1]~,


    
#####################################################################################
#HEADER: Login & Logout Messages
q~Coranto Login (Authorized Users Only)~
  => q~Coranto Login (Authorized Users Only)~,
q~Password~
  => q~Password~,
q~Remember Password?~
  => q~Remember Password?~,
q~Username~
  => q~Username~,
q~Language~
  => q~Language~,
q~User Setting~
  => q~User Setting~,
q~Global Site Setting~
  => q~Global Site Setting~,
q~Log In~
  => q~Log In~,
q~Your account has been disabled. Contact the administrator of this site for more information.~
  => q~Your account has been disabled. Contact the administrator of this site for more information.~,
q~Login Failure~
  => q~Login Failure~,
q~The information you entered is incorrect. Please use the link below and try again.~
  => q~The information you entered is incorrect. Please use the link below and try again.~,
q~You have been logged out.~
  => q~You have been logged out.~,



#####################################################################################
#HEADER: Main Page
q~Main Page~
  => q~Main Page~,
q~Submit News~
  => q~Submit News~,
q~Create a new news item and add it to the database.~
  => q~Create a new news item and add it to the database.~,
q~Build News~
  => q~Build News~,
q~Generate news HTML files from the database. News must be built before any new or changed items will appear on your site.~
  => q~Generate news HTML files from the database. News must be built before any new or changed items will appear on your site.~,
q~Modify News~
  => q~Modify News~,
q~Remove or edit existing news items.~
  => q~Remove or edit existing news items.~,
q~You may only edit items that you have previously submitted.~
  => q~You may only edit items that you have previously submitted.~,
q~You may edit any news items, including those submitted by others.~
  => q~You may edit any news items, including those submitted by others.~,
q~User Info~
  => q~User Info~,
q~Change information associated with your user account, such as your password.~
  => q~Change information associated with your user account, such as your password.~,
q~Administration~
  => q~Administration~,
q~Configure Coranto and change all available settings.~
  => q~Configure Coranto and change all available settings.~,
q~Log Out~
  => q~Log Out~,
q~Log out of Coranto. You will have to enter your username and password to gain access again.~
  => q~Log out of Coranto. You will have to enter your username and password to gain access again.~,

#SECTION: Misc information
q~You are logged in as user [_1].~
  => q~You are logged in as user [_1].~,
q~Back To [_1]~
  => q~Back To [_1]~,
q~Your Version~
  => q~Your Version~,
q~Current Version~
  => q~Current Version~,
q~Unofficial Coranto Web Site~
  => q~Unofficial Coranto Web Site~,
q~<b>Download Upgrade</b> (if available)~
  => q~<b>Download Upgrade</b> (if available)~,



#####################################################################################
#HEADER: Submit News
q~Submit~
  => q~Submit~,
q~Reset~
  => q~Reset~,
q~Date~
  => q~Date~,
q~Save Changes~
  => q~Save Changes~,
q~News Saved~
  => q~News Saved~,
q~The submitted news item has been added to the database.~
  => q~The submitted news item has been added to the database.~,
q~<b>Build News has been run automatically</b>, so the item should be visible on your site immediately.~
  => q~<b>Build News has been run automatically</b>, so the item should be visible on your site immediately.~,
q~<b>You must build news</b> before this item will be visible on your site.~
  => q~<b>You must build news</b> before this item will be visible on your site.~,
q~News Built~
  => q~News Built~,
q~News HTML files have been built from the database. This means that your site should now reflect any new or changed items.~
  => q~News HTML files have been built from the database. This means that your site should now reflect any new or changed items.~,



#####################################################################################
#HEADER: Modify News Page
# Used as: Search for (text box) in field (select box).
q~Search for~
  => q~Search for~,
q~in field~
  => q~in field~,
q~(All Fields)~
  => q~(All Fields)~,
# Used as: Jump to: (date select boxes)
q~Jump to~
  => q~Jump to~,
# Used as a verb, not a noun. (it's a label on a button)
q~Preview~
  => q~Preview~,
# Also used as a verb.
q~Search~
  => q~Search~,
# Again, a button label.
q~Go~
  => q~Go~,
# An abbreviation for Delete, used to label the checkbox column in Modify News.
q~Del.~
  => q~Del.~,
q~Edit~
  => q~Edit~,
q~User~
  => q~User~,
q~Category~
  => q~Category~,
q~Delete Checked Items~
  => q~Delete Checked Items~,
q~Next Page~
  => q~Next Page~,
q~Previous Page~
  => q~Previous Page~,
q~First Page~
  => q~First Page~,
q~No items could be found.~
  => q~No items could be found.~,
q~Changes Saved~
  => q~Changes Saved~,
q~Your changes to this item have been saved. Now, close this window to return to Modify News.~
  => q~Your changes to this item have been saved. Now, close this window to return to Modify News.~,
q~<b>Build News has been run automatically</b>, so your changes should be visible on your site immediately.~
  => q~<b>Build News has been run automatically</b>, so your changes should be visible on your site immediately.~,
q~<b>You must build news</b> before your changes will be visible on your site.~
  => q~<b>You must build news</b> before your changes will be visible on your site.~,


#####################################################################################
#HEADER: User Info
q~Change Password~
  => q~Change Password~,
q~Leave the password fields blank if you do not want to change the password.~
  => q~Leave the password fields blank if you do not want to change the password.~,
q~Leave the password fields blank if you don't want to change your password.~
  => q~Leave the password fields blank if you don't want to change your password.~,
q~Current Password~
  => q~Current Password~,
q~New Password~
  => q~New Password~,
q~Verify New Password~
  => q~Verify New Password~,
q~Edit User Profile~
  => q~Edit User Profile~,
q~The current password that you entered is not correct.~
  => q~The current password that you entered is not correct.~,
q~The passwords entered do not match. Please type in your new password again, and retype it in the "Verify Password" field.~
  => q~The passwords entered do not match. Please type in your new password again, and retype it in the "Verify Password" field.~,
q~Passwords must be at least 5 characters long.~
  => q~Passwords must be at least 5 characters long.~,
q~User Info Saved~
  => q~User Info Saved~,
q~Changes to your user info have been saved. If you changed your password, you will be asked to log in again once you move to another page. If you changed other information, you may need to build news before changes appear on your site.~
  => q~Changes to your user info have been saved. If you changed your password, you will be asked to log in again once you move to another page. If you changed other information, you may need to build news before changes appear on your site.~,



#####################################################################################
#HEADER: Administration Page
q~Global Settings~
  => q~Global Settings~,
q~Change most global Coranto settings.~
  => q~Change most global Coranto settings.~,
q~Manage Profiles~
  => q~Manage Profiles~,
q~Create, edit, or remove news profiles, which control how news is selected from the database and published or displayed.~
  => q~Create, edit, or remove news profiles, which control how news is selected from the database and published or displayed.~,
q~User Management~
  => q~User Management~,
q~Edit Users~
  => q~Edit Users~,
q~Add new user accounts or remove/edit existing ones.~
  => q~Add new user accounts or remove/edit existing ones.~,
q~Edit News Styles~
  => q~Edit News Styles~,
q~Create, edit, or remove news styles, which control what news looks like (that is, what HTML is used to display news items) on your site.~
  => q~Create, edit, or remove news styles, which control what news looks like (that is, what HTML is used to display news items) on your site.~,
q~Edit User Fields~
  => q~Edit User Fields~,
q~Create, edit, or remove user information fields (the fields users see in User Info).~
  => q~Create, edit, or remove user information fields (the fields users see in User Info).~,
q~News &amp; Fields Configuration~
  => q~News &amp; Fields Configuration~,
q~Edit News Fields~
  => q~Edit News Fields~,
q~Create, edit, or remove news fields (the fields on Submit and Modify News forms).~
  => q~Create, edit, or remove news fields (the fields on Submit and Modify News forms).~,
q~Date &amp; Time Settings~
  => qq~Date &amp; Time Settings~,
q~Change settings involving times, like time zones and date formats.~
  => q~Change settings involving times, like time zones and date formats.~,
q~Addon Manager~
  => q~Addon Manager~,
q~Enable, disable, or view information on installed addons, and download new addons.~
  => q~Enable, disable, or view information on installed addons, and download new addons.~,
q~Edit File Paths~
  => q~Edit File Paths~,
q~Change settings regarding all the filepaths.~
  => q~Change settings regarding all the filepaths.~,
q~Full Rebuild~
  => q~Full Rebuild~,
q~Rebuild all news items. (Build News tries to build only changed items.) Necessary if you edit files manually.~
  => q~Rebuild all news items. (Build News tries to build only changed items.) Necessary if you edit files manually.~,
q~You are not authorized to access administrative functions.~
  => q~You are not authorized to access administrative functions.~,


#####################################################################################
#HEADER: General Settings Page
q~Change Settings~
  => q~Change Settings~,
q~General Settings~
  => q~General Settings~,
q~Site Name~
  => q~Site Name~,
q~The name of your site. This will be displayed on Coranto script pages.~
  => q~The name of your site. This will be displayed on Coranto script pages.~,
q~Site Link~
  => q~Site Link~,
q~If you'd like a &quot;Back to Your Site&quot; link on Coranto script pages, enter a URL here. Otherwise, leave blank.~
  => q~If you'd like a &quot;Back to Your Site&quot; link on Coranto script pages, enter a URL here. Otherwise, leave blank.~,
q~Super Administrator~
  => q~Super Administrator~,
q~Choose who the Super Administrator should be. Since you can see this box you are either the current Super Admin or there isn't a Super Admin set.~
  => q~Choose who the Super Administrator should be. Since you can see this box you are either the current Super Admin or there isn't a Super Admin set.~,
q~Language Global Settings~
  => q~Language Global Settings~,
q~Choose the language for your site. This is valid for all users without a specific setting (i.e. user-settings overule this parameter).~
  => q~Choose the language for your site. This is valid for all users without a specific setting (i.e. user-settings overule this parameter).~,
q~Option Pages Layout~
  => q~Option Pages Layout~,
q~Choose the type of layout you want to use when presenting option overview pages like the Main and Admin pages, either the normal two box column layout or the one option per line (the 'Facelift') layout.~
  => q~Choose the type of layout you want to use when presenting option overview pages like the Main and Admin pages, either the normal two box column layout or the one option per line (the 'Facelift') layout.~,
q~Option Sections Layout~
  => q~Option Sections Layout~,
q~Some option pages have the options grouped together in logical sections, choose the type of header layout you want to use above such a group of options.~
  => q~Some option pages have the options grouped together in logical sections, choose the type of header layout you want to use above such a group of options.~,
q~Two Box Column Layout~
  => q~Two Box Column Layout~,
q~One Option Per Line Layout~
  => q~One Option Per Line Layout~,
q~Show a headline above each option section~
  => q~Show a headline above each option section~,
q~Create a visual separation between the sections~
  => q~Create a visual separation between the sections~,
q~No header or separation between the sections~
  => q~No header or separation between the sections~,
q~Privacy~
  => q~Privacy~,
q~Public or Private~
  => q~Public or Private~,
q~Set this to 'Public' if you would like to have a version check image on the main page, be notified of new releases of Coranto, enable links to the Coranto website and documentation, or allow all addons to work regardless of their privacy status. Set this to 'Private' if you are running Coranto on a private network with no connection to the Internet, or if you would like the highest level of privacy available. Note that on the 'Private' setting, you will find links to our server and documentation hosted there are disabled, and you will not be able to use addons which haven't been certified as compliant with your privacy setting by their authors~
  => q~Set this to 'Public' if you would like to have a version check image on the main page, be notified of new releases of Coranto, enable links to the Coranto website and documentation, or allow all addons to work regardless of their privacy status. Set this to 'Private' if you are running Coranto on a private network with no connection to the Internet, or if you would like the highest level of privacy available. Note that on the 'Private' setting, you will find links to our server and documentation hosted there are disabled, and you will not be able to use addons which haven't been certified as compliant with your privacy setting by their authors~,
q~Version Check Image~
  => q~Version Check Image~,
q~Set this to 'Yes' if you would like an image to be displayed on the main page indicating the current version number.~
  => q~Set this to 'Yes' if you would like an image to be displayed on the main page indicating the current version number.~,
q~Urgent Notification~
  => q~Urgent Notification~,
q~Set this to 'Yes' if you'd like us to notify you of important news (bug fixes, new releases, etc.). These news will automatically appear inside your Coranto Administration View.~
  => q~Set this to 'Yes' if you'd like us to notify you of important news (bug fixes, new releases, etc.). These news will automatically appear inside your Coranto Administration View.~,
q~Misc~
  => q~Misc~,
q~Enable XHTML BR~
  => q~Enable XHTML BR~,
q~If set to <b>Yes</b>, newlines in news posts will be replaced with &lt;br /&gt;, instead of the usual &lt;br&gt;.~
  => q~If set to <b>Yes</b>, newlines in news posts will be replaced with &lt;br /&gt;, instead of the usual &lt;br&gt;.~,
q~Modify News Link','Do you want the Modify News Edit link to open in the current window, instead of a new one?~
  => q~Modify News Link','Do you want the Modify News Edit link to open in the current window, instead of a new one?~,
q~Enable SQL~
  => q~Enable SQL~,
q~Do you want to allow Coranto to work with SQL-based addons such as CorantoSQL~
  => q~Do you want to allow Coranto to work with SQL-based addons such as CorantoSQL~,
q~Debug Options~
  => q~Debug Options~,
q~Show Config~
  => q~Show Config~,
q~Do you want to allow you to display the configuration when debugging? This can be a security risk, so be careful. If not sure, set it to <b>No</b>~
  => q~Do you want to allow you to display the configuration when debugging? This can be a security risk, so be careful. If not sure, set it to <b>No</b>~,
q~Show Newsdat.txt~
  => q~Show Newsdat.txt~,
q~Do you want to allow you to display the contents of newsdat.txt when debugging? This can be a security risk, so be careful. If not sure, set it to <b>No</b>~
  => q~Do you want to allow you to display the contents of newsdat.txt when debugging? This can be a security risk, so be careful. If not sure, set it to <b>No</b>~,
q~Show Addons~
  => q~Show Addons~,
q~Do you want to allow you to display which addons you have installed when debugging? This can be a security risk, so be careful. If not sure, set it to <b>No</b>~
  => q~Do you want to allow you to display which addons you have installed when debugging? This can be a security risk, so be careful. If not sure, set it to <b>No</b>~,

#SECTION: Advanced Settings
q~Advanced Settings~
  => q~Advanced Settings~,
q~Build News Automatically (Submit)~
  => q~Build News Automatically (Submit)~,
q~If set to Yes, Coranto will automatically build news when you submit news. This results in changes being visible to users immediately after making them.~
  => q~If set to Yes, Coranto will automatically build news when you submit news. This results in changes being visible to users immediately after making them.~,
q~Build News Automatically (Modify)~
  => q~Build News Automatically (Modify)~,
q~If set to Yes, Coranto will automatically build news when you modify a news item. This means that changes will be visible as soon as you make them, but it also means that things may be slow if you modify several news items~
  => q~If set to Yes, Coranto will automatically build news when you modify a news item. This means that changes will be visible as soon as you make them, but it also means that things may be slow if you modify several news items~,
q~Archive HTML file extension~
  => q~Archive HTML file extension~,
q~The extension that will be given to to archive HTML files. (No period, just the extension.) For instance, <b>html</b> or <b>shtml</b>. You will need to perform a full rebuild for changes to this setting to take effect.~
  => q~The extension that will be given to to archive HTML files. (No period, just the extension.) For instance, <b>html</b> or <b>shtml</b>. You will need to perform a full rebuild for changes to this setting to take effect.~,
q~Items Per Modify News Page~
  => q~Items Per Modify News Page~,
q~The number of news items that are displayed on each Modify News page.~
  => q~The number of news items that are displayed on each Modify News page.~,
q~Default Search Field at Modify News Page~
  => q~Default Search Field at Modify News Page~,
q~Choose which field that should be selected by default for the search box when you enter the Modify News page.~
  => q~Choose which field that should be selected by default for the search box when you enter the Modify News page.~,



#####################################################################################
#HEADER: General Edit Profiles Page
q~Current Profiles~
  => q~Current Profiles~,
q~Archiving is currently <b>[_1]</b>.~
  => q~Archiving is currently <b>[_1]</b>.~,
q~This profile is not filtered by time or number.~
  => q~This profile is not filtered by time or number.~,
q~A maximum of <b>[quant,_1,day,days,]</b> [bool,_2,or,] <b>[quant,_3,item,items,]</b> will be included in this profile.~
  => q~A maximum of <b>[quant,_1,day,days,]</b> [bool,_2,or,] <b>[quant,_3,item,items,]</b> will be included in this profile.~,
q~Items must be older than <b>[quant,_1,day,days]</b>.~
  => q~Items must be older than <b>[quant,_1,day,days]</b>.~,
q~This profile is set to skip the first <b>[quant,_1,item,items]</b>.~
  => q~This profile is set to skip the first <b>[quant,_1,item,items]</b>.~,
q~Profile type~
  => q~Profile type~,
# Description label of a Standard Profile
q~Standard Profile~
  => q~Standard~,
q~Profile &quot;[_1]&quot; is currently <b>disabled</b>.~
  => q~Profile &quot;[_1]&quot; is currently <b>disabled</b>.~,
q~Edit General Settings~
  => q~Edit General Settings~,
q~Edit Archiving Settings~
  => q~Edit Archiving Settings~,
q~Profile Name~
  => q~Profile Name~,
q~Profile names may only contain letters, numbers, and underscores (_). As well, while uppercase letters are allowed, use of lowercase letters only is recommended to avoid confusion. (<b>After creating a profile, you must edit & enable it.</b>)~
  => q~Profile names may only contain letters, numbers, and underscores (_). As well, while uppercase letters are allowed, use of lowercase letters only is recommended to avoid confusion. (<b>After creating a profile, you must edit & enable it.</b>)~,
q~Create Profile~
  => q~Create Profile~,
q~Invalid profile information.~
  => q~Invalid profile information.~,
q~Archiving Settings for &quot;[_1]&quot;~
  => q~Archiving Settings for &quot;[_1]&quot;~,
q~The File Path you have specified (<strong>[_1]</strong>) does not seem to exist, are you sure it is correct?~
  => q~The File Path you have specified (<strong>[_1]</strong>) does not seem to exist, are you sure it is correct?~,
q~Invalid profile &quot;[_1]&quot;.~
  => q~Invalid profile &quot;[_1]&quot;.~,
q~Profile name &quot;[_1]&quot; contains illegal characters. Only letters, numbers, and underscores are permitted in profile names.~
  => q~Profile name &quot;[_1]&quot; contains illegal characters. Only letters, numbers, and underscores are permitted in profile names.~,
q~Profile [_1] already exists.~
  => q~Profile [_1] already exists.~,
q~Please enter a profile name.~
  => q~Please enter a profile name.~,
q~Are you sure you would like to delete profile <strong>[_1]</strong>?~
  => q~Are you sure you would like to delete profile <strong>[_1]</strong>?~,


#####################################################################################
#HEADER: Edit Specific Profile Settings Page
q~The display name you want to use for this profile. Default is the profile name.~
  => q~The display name you want to use for this profile. Default is the profile name.~,
q~File Name~
  => q~File Name~,
q~The name of the text file which this profile will generate (example: [_1].txt)~
  => q~The name of the text file which this profile will generate (example: [_1].txt)~,
q~File Path~
  => q~File Path~,
q~The absolute path to the directory in which files will be created, with no trailing slash. <b>Leave blank</b> to use the default HTML Files path (currently [_1]).~
  => q~The absolute path to the directory in which files will be created, with no trailing slash. <b>Leave blank</b> to use the default HTML Files path (currently [_1]).~,
q~Filter By Time~
  => q~Filter By Time~,
q~The number of days after which news will be considered old. News posted more than the specified number of days ago will not be included in this profile (though it will be archived, if that is enabled). <b>Leave blank</b> if you do not want to filter by time.~
  => q~The number of days after which news will be considered old. News posted more than the specified number of days ago will not be included in this profile (though it will be archived, if that is enabled). <b>Leave blank</b> if you do not want to filter by time.~,
q~Filter By Number~
  => q~Filter By Number~,
q~The maximum number of news items that will be included in this profile. For instance, if you set this to 10, then the 11th-newest item will not be included (though it will be archived, if that is enabled). <b>Leave blank</b> if you do not want to filter by number.~
  => q~The maximum number of news items that will be included in this profile. For instance, if you set this to 10, then the 11th-newest item will not be included (though it will be archived, if that is enabled). <b>Leave blank</b> if you do not want to filter by number.~,
q~Skip Days~
  => q~Skip Days~,
q~If you want to skip news items rather than start with the most recent item, set this to the number of days to be skipped. For instance, if you set this to 3, the first item in this profile will be over 3 days old. <b>Leave blank</b> if you do not want to skip items by days.~
  => q~If you want to skip news items rather than start with the most recent item, set this to the number of days to be skipped. For instance, if you set this to 3, the first item in this profile will be over 3 days old. <b>Leave blank</b> if you do not want to skip items by days.~,
q~Skip Items~
  => q~Skip Items~,
q~Headlines~
  => q~Headlines~,
q~If you want to skip news items rather than start with the most recent item, set this to the number of items to be skipped. For instance, if you set this to 3, the first item in this profile will be the 4th available item. <b>Leave blank</b> if you do not want to skip items. This is applied after <b>Skip Days</b>~
  => q~If you want to skip news items rather than start with the most recent item, set this to the number of items to be skipped. For instance, if you set this to 3, the first item in this profile will be the 4th available item. <b>Leave blank</b> if you do not want to skip items. This is applied after <b>Skip Days</b>~,
q~News Style~
  => q~News Style~,
q~The news style to use when generating HTML. [_1]~
  => q~The news style to use when generating HTML. [_1]~,
q~Display Coranto Link~
  => q~Display Coranto Link~,
q~Adds a link to the Coranto home page to the end of the generated text file. With this version of Coranto, you should include a link on every page of your site that contains news items. If a page contains only headlines that link to full news items, it is exempt from the linking requirement. The default will be link turned off (as the old AmphibianWeb website is in the hands of cybersuqatters). As options, you can choose to link to the unofficial site, or to display the 'Powered by Coranto' text with no link.~
  => q~Adds a link to the Coranto home page to the end of the generated text file. With this version of Coranto, you should include a link on every page of your site that contains news items. If a page contains only headlines that link to full news items, it is exempt from the linking requirement. The default will be link turned off (as the old AmphibianWeb website is in the hands of cybersuqatters). As options, you can choose to link to the unofficial site, or to display the 'Powered by Coranto' text with no link.~,
q~No link~
  => q~No link~,
q~Link pointing to Unofficial Site~
  => q~Link pointing to Unofficial Site~,
q~Link pointing to Coranto Support Forum~
  => q~Link pointing to Coranto Support Forum~,
q~Text without link~
  => q~Text without link~,
  
#SECTION: Headlines
q~Enable Headlines~
  => q~Enable Headlines~,
q~Creates a file called [_1] that contains the same news items as this profile does, but uses a different style. (Headline styles are generally more concise than normal styles and don't include the full news text.)~
  => q~Creates a file called [_1] that contains the same news items as this profile does, but uses a different style. (Headline styles are generally more concise than normal styles and don't include the full news text.)~,
q~Headlines Style~
  => q~Headlines Style~,
q~The news style used when creating headlines. Only necessary if headlines are enabled. [_1]~
  => q~The news style used when creating headlines. Only necessary if headlines are enabled. [_1]~,
q~Number of Headlines~
  => q~Number of Headlines~,
q~The maximum number of news items headlines will be generated for. Useful for including headlines of only the few most recent items. <b>Leave blank</b> to create headlines for all items included in this profile.~
  => q~The maximum number of news items headlines will be generated for. Useful for including headlines of only the few most recent items. <b>Leave blank</b> to create headlines for all items included in this profile.~,
q~Headline Sort Order~
  => q~Headline Sort Order~,
q~Allows news to be sorted in an order other than the default. Note that no matter what the sort order, filtering by number will restrict the headlines to the <i>n</i> newest items.~
  => q~Allows news to be sorted in an order other than the default. Note that no matter what the sort order, filtering by number will restrict the headlines to the <i>n</i> newest items.~,

#SECTION: Advanced Profile Settings
q~Advanced Profile Settings~
  => q~Advanced Profile Settings~,
q~HTML Template~
  => q~HTML Template~,
q~To generate an HTML file containing the news from the profile, enter the name of a standard .tmpl file below. If creation of an HTML file isn't needed, as is usually the case, <b>leave this blank</b>.~
  => q~To generate an HTML file containing the news from the profile, enter the name of a standard .tmpl file below. If creation of an HTML file isn't needed, as is usually the case, <b>leave this blank</b>.~,
q~HTML User File Name~
  => q~HTML User File Name~,
q~The name (+ extension) of the file to be generated using the above template and the style for this profile. Only necessary if an HTML template has been specified in the previous setting.~
  => q~The name (+ extension) of the file to be generated using the above template and the style for this profile. Only necessary if an HTML template has been specified in the previous setting.~,
q~HTML File Title~
  => q~HTML File Title~,
q~The title of the generated HTML file. Only necessary if an HTML template has been specified in the previous setting.~
  => q~The title of the generated HTML file. Only necessary if an HTML template has been specified in the previous setting.~,
q~Sort Order~
  => q~Sort Order~,
q~Allows news to be sorted in an order other than the default. Note that no matter what the sort order, filtering by number will restrict the profile to the <i>n</i> newest items. As well, archives always use the default sort order.'~
  => q~Allows news to be sorted in an order other than the default. Note that no matter what the sort order, filtering by number will restrict the profile to the <i>n</i> newest items. As well, archives always use the default sort order.~,
q~Anchor Tags~
  => q~Anchor Tags~,
q~Creates &lt;a name&gt; tags with news, allowing links directly to news items. Unless you're going to be including more than one profile (that is, two or more text files) on a single HTML page, you should leave this on.~
  => q~Creates &lt;a name&gt; tags with news, allowing links directly to news items. Unless you're going to be including more than one profile (that is, two or more text files) on a single HTML page, you should leave this on.~,
  
#SECTION: Sorting options
q~Default (Reverse Chronological)~
  => q~Default (Reverse Chronological)~,
q~Chronological (Oldest First)~
  => q~Chronological (Oldest First)~,
q~Alphabetical (By Subject)~
  => q~Alphabetical (By Subject)~,
q~True Alphabetical (aAbBcC) (By Subject)~
  => q~True Alphabetical (aAbBcC) (By Subject)~,


    
#####################################################################################
#HEADER: Edit Specific Profile Archive Settings Page
q~General Archiving Settings~
  => q~General Archiving Settings~,
q~Archive Type~
   => q~Archive Type~,
q~_ARCHIVE_TYPE_DESCRIPTION~ # Description of the different archive types
  => <<'EOSENTANCE',
Controls if and how archiving is performed. When archiving is enabled, news items which are too old to be included in [_1] 
are placed in archives.<br><br> Set to Disabled to disable all archiving for this profile. Set to Single File to place all old items in one text file, called [_2]. 
Set to Monthly, Weekly, or Daily to create multiple archives, each holding a month's, week's, or day's news, respectively.
EOSENTANCE
q~Disabled (News will not be archived)~
  => q~Disabled (News will not be archived)~,
q~Single File~
  => q~Single File~,
q~Monthly Archives~
  => q~Monthly Archives~,
q~Weekly Archives~
  => q~Weekly Archives~,
q~Daily Archives~
  => q~Daily Archives~,
q~Archive File Path~
  => q~Archive File Path~,
q~The absolute path to the directory in which archive files will be created, with no trailing slash. <b>Leave blank</b> to use the default Archive Files path (currently [_1]).~
  => q~The absolute path to the directory in which archive files will be created, with no trailing slash. <b>Leave blank</b> to use the default Archive Files path (currently [_1]).~,
q~News Style~
  => q~News Style~,
q~The news style to use for the archives. [_1]~
  => q~The news style to use for the archives. [_1]~,
q~Settings for Monthly, Weekly, and Daily Archiving Only~
  => q~Settings for Monthly, Weekly, and Daily Archiving Only~,
q~Archive Links File~
  => q~Archive Links File~,
q~The name of the file which will contain links to the various archives. For example, <b>[_1]-archive.html</b>.~
  => q~The name of the file which will contain links to the various archives. For example, <b>[_1]-archive.html</b>.~,
q~Archive Links Template~
  => q~Archive Links Template~,
q~The name of the template (.tmpl) file used to configure the style of the archive links page. Most users should use the default, <b>arclink.tmpl</b>.~
  => q~The name of the template (.tmpl) file used to configure the style of the archive links page. Most users should use the default, <b>arclink.tmpl</b>.~,
q~Archive Template~
  => q~Archive Template~,
q~The name of the template (.tmpl) file used to configure the style of the archives. Most users should use the default, <b>archive.tmpl</b>.~
  => q~The name of the template (.tmpl) file used to configure the style of the archives. Most users should use the default, <b>archive.tmpl</b>.~,
  


#####################################################################################
#HEADER: File Settings Page
q~News Files Path~
  => q~News Files Path~,
q~Absolute path (<b>not</b> URL) to the directory where you'd like the news files (the ones included in your pages) to be generated by default. The directory may need to be world-writable. On UNIX servers, this means you CHMOD the directory 777. Use forward slashes (/), even on Windows systems. Do not include a trailing slash.~
  => q~Absolute path (<b>not</b> URL) to the directory where you'd like the news files (the ones included in your pages) to be generated by default. The directory may need to be world-writable. On UNIX servers, this means you CHMOD the directory 777. Use forward slashes (/), even on Windows systems. Do not include a trailing slash.~,
q~Archive Files Path~
  => q~Archive Files Path~,
q~Absolute path (<b>not</b> URL) to the directory where you'd like your news archives to be generated. Often the same as the News Files path or a subfolder to it. The directory may need to be world-writable. On UNIX servers, this means you must CHMOD the directory 777. Use forward slashes (/), even on Windows systems. Do not include a trailing slash.~
  => q~Absolute path (<b>not</b> URL) to the directory where you'd like your news archives to be generated. Often the same as the News Files path or a subfolder to it. The directory may need to be world-writable. On UNIX servers, this means you must CHMOD the directory 777. Use forward slashes (/), even on Windows systems. Do not include a trailing slash.~,
q~Addon Path~
  => q~Addon Path~,
q~Absolute path (<b>not</b> URL) to the directory where the addons are located. Use forward slashes (/), even on Windows systems. Do not include a trailing slash.~
  => q~Absolute path (<b>not</b> URL) to the directory where the addons are located. Use forward slashes (/), even on Windows systems. Do not include a trailing slash.~,
q~Documentation Path~
  => q~Documentation Path~,
q~Absolute path (<b>not</b> URL) to the directory where the (addon) documenation files are located. Use forward slashes (/), even on Windows systems. Do not include a trailing slash.~
  => q~Absolute path (<b>not</b> URL) to the directory where the (addon) documenation files are located. Use forward slashes (/), even on Windows systems. Do not include a trailing slash.~,
q~Language Path~
  => q~Language Path~,
q~Absolute path (<b>not</b> URL) to the directory where the language files are located. Use forward slashes (/), even on Windows systems. Do not include a trailing slash.~
  => q~Absolute path (<b>not</b> URL) to the directory where the language files are located. Use forward slashes (/), even on Windows systems. Do not include a trailing slash.~,
q~Template Path~
  => q~Template Path~,
q~Absolute path (<b>not</b> URL) to the directory where the templates are located. Use forward slashes (/), even on Windows systems. Do not include a trailing slash.~
  => q~Absolute path (<b>not</b> URL) to the directory where the templates are located. Use forward slashes (/), even on Windows systems. Do not include a trailing slash.~,
q~Program & Data File Paths~
  => q~Program & Data File Paths~,
q~Program Files Path~
  => q~Program Files Path~,
q~Absolute path (<b>not</b> URL) to the directory where this script and its program files are located. If you need to change this, please do so by specifying the $abspath variable in the files coranto.cgi and viewnews.cgi~
  => q~Absolute path (<b>not</b> URL) to the directory where this script and its program files are located. If you need to change this, please do so by specifying the $abspath variable in the files coranto.cgi and viewnews.cgi~,
q~Data Path~
  => q~Data Path~,
q~Absolute path (<b>not</b> URL) to the directory where the data files (nsettings.cgi, newsdat.txt and crcfg.dat) are located. If you would like to change this path, please do so by specifying the $data_path variable in the file cruser.pl.~
  => q~Absolute path (<b>not</b> URL) to the directory where the data files (nsettings.cgi, newsdat.txt and crcfg.dat) are located. If you would like to change this path, please do so by specifying the $data_path variable in the file cruser.pl.~,



#####################################################################################
#HEADER: Date & Time Settings
q~Time Options~
  => q~Time Options~,
q~Time Zone~
  => q~Time Zone~,
q~Your time zone. Any name or abbreviation is acceptable -- this is for display purposes only."],~
  => q~Your time zone. Any name or abbreviation is acceptable -- this is for display purposes only."],~,
q~Daylight Savings Time Zone~
  => q~Daylight Savings Time Zone~,
q~As above, but during Daylight Savings Time.~
  => q~As above, but during Daylight Savings Time.~,
q~Server Time Offset~
  => q~Server Time Offset~,
q~Often, your server will be in a different time zone than you are. You can enter the difference, in hours, between the server's time and the time you would like displayed on news items. For instance, if your server is in London and you are in Boston, set this to -5. Changing this setting will not affect existing news items; only new items will have an adjusted time. (The server's current time is: [_1])~
  => q~Often, your server will be in a different time zone than you are. You can enter the difference, in hours, between the server's time and the time you would like displayed on news items. For instance, if your server is in London and you are in Boston, set this to -5. Changing this setting will not affect existing news items; only new items will have an adjusted time. (The server's current time is: [_1])~,
q~12/24 Hour Clock?~
  => q~12/24 Hour Clock?~,
q~Choose between a 12 hour (AM/PM) and 24 hour clock.~
  => q~Choose between a 12 hour (AM/PM) and 24 hour clock.~,
q~12 Hour (AM/PM)~
  => q~12 Hour (AM/PM)~,
q~24 Hour~
  => q~24 Hour~,
q~Date Formats~
  => q~Date Formats~,
'_DATE_SETTINGS_INTRO' => <<'EOSENTANCE', # Introduction text for date & time
	The following settings allow you to configure how dates &amp;
	times appear. The general date format controls the date used in news items.
	The internal date format controls the date used on Coranto administrative pages.
	The three archive date formats control the date used to label monthly, weekly, and daily archives
	respectively. To insert a component of the date or time, use &lt;Field: Name&gt; where Name is one of:
	<b>Year</b>, <b>TwoDigitYear</b>, <b>Month_Name</b>, <b>Abbrev_Month_Name</b>, <b>Month_Number</b>,
	<b>TwoDigitMonth</b>, <b>Weekday</b>, <b>Abbrev_Weekday</b>, <b>Day</b>, <b>TwoDigitDay</b>, <b>Hour</b>,
	<b>TwoDigitHour</b>, <b>Minute</b>, <b>Second</b>, <b>AMPM</b>, or <b>Time_Zone</b>. Remember that spacing and capitalization
	matter: &lt;Field: Day&gt; is valid, but &lt;field:day&gt is not (it contains three errors, actually).
EOSENTANCE
q~General Date Format~
  => q~General Date Format~,
q~Internal Date Format~
  => q~Internal Date Format~,
q~Monthly Archive Date Format~
  => q~Monthly Archive Date Format~,
q~Weekly Archive Date Format~
  => q~Weekly Archive Date Format~,
q~Daily Archive Date Format~
  => q~Daily Archive Date Format~,
q~Example of current format: [_1]	~
  => q~Example of current format: [_1]	~,



#####################################################################################
#HEADER: Edit Users Settings
q~Current Users~
  => q~Current Users~,
q~Administrator Level~
  => q~Administrator~,
q~complete access to all functions~
  => q~complete access to all functions~,
q~High Level~
  => q~High~,
q~can post news and modify all posts~
  => q~can post news and modify all posts~,
q~Standard Level~
  => q~Standard~,
q~can post news and modify own posts~
  => q~can post news and modify own posts~,
q~User &quot;[_1]&quot; last logged in on [_2]. User level: <b>[_3]</b>~
  => q~User &quot;[_1]&quot; last logged in on [_2]. User level: <b>[_3]</b>~,
q~never~ # As in: User last logged in on (never).
  => q~never~,
q~Administrator users can only be edited or deleted by the Super Administrator.~
  => q~Administrator users can only be edited or deleted by the Super Administrator.~,
q~Edit User Info~
  => q~Edit User Info~,
q~Convert to [_1] Level User~
  => q~Convert to [_1] Level User~,
q~Enable User~
  => q~Enable User~,
q~Disable User~
  => q~Disable User~,
q~Delete User~
  => q~Delete User~,
q~Create New User~
  => q~Create New User~,
q~Usernames may contain only letters, numbers, and underscores (_).~
  => q~Usernames may contain only letters, numbers, and underscores (_).~,
q~User [_1] does not exist.~
  => q~User [_1] does not exist.~,
q~That is an administrative user.~
  => q~That is an administrative user.~,
q~The username must be at least 3 characters long.~
  => q~The username must be at least 3 characters long.~,
q~Username &quot;[_1]&quot; contains illegal characters. Only letters, numbers, and underscores are permitted in usernames.~
  => q~Username &quot;[_1]&quot; contains illegal characters. Only letters, numbers, and underscores are permitted in usernames.~,
q~That user already exists.~
  => q~That user already exists.~,
q~Passwords must be at least 5 characters long.~
  => q~Passwords must be at least 5 characters long.~,
q~Invalid user level.~
  => q~Invalid user level.~,
q~Are you sure that you want to create an Administrator user? Administrator users have complete access to all functions, and, once created, <b>can only be deleted by the Super Administrator</b>. Administrator users can delete or modify your files. Administrator users can do almost anything. As a general rule, only give Administrator accounts to those who already have full access to your server.~
  => q~Are you sure that you want to create an Administrator user? Administrator users have complete access to all functions, and, once created, <b>can only be deleted by the Super Administrator</b>. Administrator users can delete or modify your files. Administrator users can do almost anything. As a general rule, only give Administrator accounts to those who already have full access to your server.~,
q~Are you sure that you want to create a guest user? Users which start with the word guest are special: they can't access User Info or Modify News.~
  => q~Are you sure that you want to create a guest user? Users which start with the word guest are special: they can't access User Info or Modify News.~,
q~User [_1] does not exist.~
  => q~User [_1] does not exist.~,
q~Cannot remove administrative users.~
  => q~Cannot remove administrative users.~,
q~Are you sure you want to remove user &quot;[_1]&quot? When a user is removed, everything in the user database associated with that user is removed as well. For instance, the user's e-mail address will be deleted, and will no longer be displayed in news items posted by that user. Disabling rather than removing the user is usually a better choice.~
  => q~Are you sure you want to remove user &quot;[_1]&quot? When a user is removed, everything in the user database associated with that user is removed as well. For instance, the user's e-mail address will be deleted, and will no longer be displayed in news items posted by that user. Disabling rather than removing the user is usually a better choice.~,
q~The User Fields allow you to associate information with a particular user and display that information in news items posted by that user. For example, you could store the email addresses of users and display a user's address on the items that he or she posts.~
  => q~The User Fields allow you to associate information with a particular user and display that information in news items posted by that user. For example, you could store the email addresses of users and display a user's address on the items that he or she posts.~,
q~Current User Fields~
  => q~Current User Fields~,
q~Editable by user~
  => q~Editable by user~,
q~Editable only by administrator~
  => q~Editable only by administrator~,
q~HTML forbidden~
  => q~HTML forbidden~,
q~HTML allowed~
  => q~HTML allowed~,
q~Create New User Field~
  => q~Create New User Field~,
q~User Field Name~
  => q~User Field Name~,
q~User field names may only contain letters, numbers, and underscores (_).~
  => q~User field names may only contain letters, numbers, and underscores (_).~,
q~Field &quot;[_1]&quot; does not exist.~
  => q~Field &quot;[_1]&quot; does not exist.~,
q~Sorry, but you cannot remove the Email field.~
  => q~Sorry, but you cannot remove the Email field.~,
q~Are you sure that you want to delete field &quot;[_1]&quot;? If you delete the field, all information that has previously been stored in it will be deleted as well.~
  => q~Are you sure that you want to delete field &quot;[_1]&quot;? If you delete the field, all information that has previously been stored in it will be deleted as well.~,
q~Field name &quot;[_1]&quot; contains illegal characters. Only letters, numbers, and underscores are permitted in field names.~
  => q~Field name &quot;[_1]&quot; contains illegal characters. Only letters, numbers, and underscores are permitted in field names.~,
q~Field &quot;[_1]&quot; already exists.~
  => q~Field &quot;[_1]&quot; already exists.~,
q~Please enter a field name.~
  => q~Please enter a field name.~,



#####################################################################################
#HEADER: General Edit News Fields Page
q~News fields are the fields available for users to enter information when submitting or modifying news.~
  => q~News fields are the fields available for users to enter information when submitting or modifying news.~,
q~Current News Fields~
  => q~Current News Fields~,
q~Single-Line Text Field~
  => q~Single-Line Text Field~,
q~Multi-Line Text Field~
  => q~Multi-Line Text Field~,
q~Drop-Down Box~
  => q~Drop-Down Box~,
q~Checkbox~
  => q~Checkbox~,
q~Radio Button~
  => q~Radio Button~,
q~Move Up~
  => q~Move Up~,
q~Move Down~
  => q~Move Down~,
q~Create New News Field~
  => q~Create New News Field~,
q~Enter both the internal and display name of the field that you wish to create. The internal name is the name which will be used to refer to this field in your news style settings; it may contain only letters, numbers, and underscores, and will always begin with &quot;CustomField_&quot;. The display name is the name shown to users when submitting or modifying news.~
  => q~Enter both the internal and display name of the field that you wish to create. The internal name is the name which will be used to refer to this field in your news style settings; it may contain only letters, numbers, and underscores, and will always begin with &quot;CustomField_&quot;. The display name is the name shown to users when submitting or modifying news.~,
q~Field Type~
  => q~Field Type~,
q~Edit Field &quot;[_1]&quot;~
  => q~Edit Field &quot;[_1]&quot;~,
q~That field does not exist.~
  => q~That field does not exist.~,
q~Could not find field.~
  => q~Could not find field.~,
q~This is already the first item.~
  => q~This is already the first item.~,
q~This is already the last item.~
  => q~This is already the last item.~,
q~Please enter an internal name.~
  => q~Please enter an internal name.~,
q~Field name [_1] contains illegal characters. Only letters, numbers, and underscores are permitted in field names.~
  => q~Field name [_1] contains illegal characters. Only letters, numbers, and underscores are permitted in field names.~,
q~Field [_1] already exists.~
  => q~Field [_1] already exists.~,
q~That field cannot be deleted.~
  => q~That field cannot be deleted.~,
q~Are you sure that you want to delete field &quot;[_1]&quot;? Any data that has been stored in this field will be deleted!~
  => q~Are you sure that you want to delete field &quot;[_1]&quot;? Any data that has been stored in this field will be deleted!~,


#####################################################################################
#HEADER: Edit Specific News Field Page
q~The name that will label this field in Submit News and Modify News. This is that name that users will see.~
  => q~The name that will label this field in Submit News and Modify News. This is that name that users will see.~,
q~Submit Permissions~
  => q~Submit Permissions~,
q~Controls which users will be shown this field when submitting news. (Administrators are always shown all fields.)~
  => q~Controls which users will be shown this field when submitting news. (Administrators are always shown all fields.)~,
q~All Users~
  => q~All Users~,
q~&quot;High&quot; level users~
  => q~&quot;High&quot; level users~,
q~Administrators only~
  => q~Administrators only~,
q~Modify Permissions~
  => q~Modify Permissions~,
q~Controls which users will be shown this field when modifying news. (Administrators are always shown all fields.)~
  => q~Controls which users will be shown this field when modifying news. (Administrators are always shown all fields.)~,
q~Disable HTML~
  => q~Disable HTML~,
q~When enabled, prevents HTML from being used in this field by causing HTML tags to be displayed as part of the news item rather than be interpreted by the browser.~
  => q~When enabled, prevents HTML from being used in this field by causing HTML tags to be displayed as part of the news item rather than be interpreted by the browser.~,
q~Field Size~
  => q~Field Size~,
q~The size, in characters, of the text box.~
  => q~The size, in characters, of the text box.~,
q~Maximum Length~
  => q~Maximum Length~,
q~The number of characters users will be able to enter into this field. Leave blank to not provide a maximum length.~
  => q~The number of characters users will be able to enter into this field. Leave blank to not provide a maximum length.~,
q~Parse Links~
  => q~Parse Links~,
q~Automatically parse links in this field during Submit/Modify. Most users should leave this on.~
  => q~Automatically parse links in this field during Submit/Modify. Most users should leave this on.~,
q~Parse Links Attributes~
  => q~Parse Links Attributes~,
q~If you have enabled the Parse Links option above, here is where you specify what attributes the automatically created A tag should contain, eg <em>class="linkstyle"</em>. Leave blank to create a plain (clean) link.~
  => q~If you have enabled the Parse Links option above, here is where you specify what attributes the automatically created A tag should contain, eg <em>class="linkstyle"</em>. Leave blank to create a plain (clean) link.~,
q~Default Value~
  => q~Default Value~,
q~What will initially be in the text box when a user goes to the Submit News page. Leave blank for a normal, empty text box.~
  => q~What will initially be in the text box when a user goes to the Submit News page. Leave blank for a normal, empty text box.~,
q~Rows~
  => q~Rows~,
q~The height, in lines, of the text box~
  => q~The height, in lines, of the text box~,
q~Columns~
  => q~Columns~,
q~The width, in characters, of the text box.~
  => q~The width, in characters, of the text box.~,
q~Convert Newlines~
  => q~Convert Newlines~,
q~Convert newlines (what you type when you hit Enter) into &lt;br&gt; tags? This is necessary for HTML. Most users should leave this on.~
  => q~Convert newlines (what you type when you hit Enter) into &lt;br&gt; tags? This is necessary for HTML. Most users should leave this on.~,
q~On Value~
  => q~On Value~,
q~What will be saved in the field if the checkbox is checked.~
  => q~What will be saved in the field if the checkbox is checked.~,
q~Checked By Default~
  => q~Checked By Default~,
q~Do you want the checkbox to be automatically checked by default?~
  => q~Do you want the checkbox to be automatically checked by default?~,
q~Options~
  => q~Options~,
q~Enter the options you want this field to contain. Seperate each option with a | (pipe) and put the option you want to be default in brackets. In the following example the option "is" would be default: coranto|[is]|cool~
  => q~Enter the options you want this field to contain. Seperate each option with a | (pipe) and put the option you want to be default in brackets. In the following example the option "is" would be default: coranto|[is]|cool~,
q~Split Options~
  => q~Split Options~,
q~What do you want radio button options to be split by? A good choice would be something like &lt;br&gt; (line break).~
  => q~What do you want radio button options to be split by? A good choice would be something like &lt;br&gt; (line break).~,
q~Field Size~
  => q~Field Size~,
q~The size of the drop-down box (number of options you want to be displayed). Leave blank if you do not want to use this feature.~
  => q~The size of the drop-down box (number of options you want to be displayed). Leave blank if you do not want to use this feature.~,
q~Strip Code~
  => q~Strip Code~,
q~Do you want to strip SSI, PHP, and other codes from the field input?~
  => q~Do you want to strip SSI, PHP, and other codes from the field input?~,



#####################################################################################
#HEADER: The Addon Manager Page
q~For a list of current addons, click [_1]here[_2]~
  => q~For a list of current addons, click [_1]here[_2]~,
q~Filename~
  => q~Filename~,
q~Version~
  => q~Version~,
q~Documentation Available~
  => q~Documentation Available~,
q~View Documentation~
  => q~View Documentation~,
q~Visit Site~
  => q~Visit Site~,
q~No addons found.~
  => q~No addons found.~,
q~Addons Found~
  => q~Addons Found~,
q~You must provide an addon name.~
  => q~You must provide an addon name.~,
q~Couldn't find addon [_1].~
  => q~Couldn't find addon [_1].~,
q~Was asked to display documentation for addon [_1], but could not find [_2].~
  => q~Was asked to display documentation for addon [_1], but could not find [_2].~,
q~Coranto Documentation~
  => q~Coranto Documentation~,
q~close window to return to Coranto~
  => q~close window to return to Coranto~,


#####################################################################################
#HEADER: News Style Page
q~Current News Styles~
  => q~Current News Styles~,
q~Style Name~
  => q~Style Name~,
q~This style is empty.~
  => q~This style is empty.~,
q~This style is used by all archives.~
  => q~This style is used by all archives.~,
q~This style is currently used by <b>no</b> profiles.~
  => q~This style is currently used by <b>no</b> profiles.~,
q~This style is currently used by profile <b>[_1]</b>.~
  => q~This style is currently used by profile <b>[_1]</b>.~,
q~This style is currently used by profiles~
  => q~This style is currently used by profiles~,
q~Style type~
  => q~Style type~,
q~Create New News Style~
  => q~Create New News Style~,
# Description label of a Standard Style
q~Standard Style~
  => q~Standard~,
q~Create Style~
  => q~Create Style~,
q~Style name must contain at least 3 alphanumeric characters.~
  => q~Style name must contain at least 3 alphanumeric characters.~,
q~A style with that name (or a similar name) already exists.~
  => q~A style with that name (or a similar name) already exists.~,
q~That style doesn't exist.~
  => q~That style doesn't exist.~,

# SECTION: Edit Style
q~Edit Style [_1]~
  => q~Edit Style [_1]~,
q~Below, enter the HTML code you'd like this style to use. Where you'd like to include one of the various components of a news item, enter &lt;Field: FieldName&gt; where FieldName is the name of the appropriate field. For example, use &lt;Field: Text&gt; to insert the text of the news item.~
  => q~Below, enter the HTML code you'd like this style to use. Where you'd like to include one of the various components of a news item, enter &lt;Field: FieldName&gt; where FieldName is the name of the appropriate field. For example, use &lt;Field: Text&gt; to insert the text of the news item.~,
q~The following basic fields are available~
  => q~The following basic fields are available~,
q~[_1]Fuller documentation[_2] of style-editing options is available.~
  => q~[_1]Fuller documentation[_2] of style-editing options is available.~,
q~That style doesn't exist.~
  => q~That style doesn't exist.~,
q~Style cannot be empty. (You can delete a style instead.)~
  => q~Style cannot be empty. (You can delete a style instead.)~,
q~Edit Style~
  => q~Edit Style~,
q~That style is invalid and has a syntax error. Check, in particular, that all ifs are properly matched and ended. Perl reported the following error, which may or may not be helpful~
  => q~That style is invalid and has a syntax error. Check, in particular, that all ifs are properly matched and ended. Perl reported the following error, which may or may not be helpful~,
q~Style Changes Saved~
  => q~Style Changes Saved~,
q~Your changes to style &quot;[_1]&quot; have been saved.~
  => q~Your changes to style &quot;[_1]&quot; have been saved.~,
q~That style doesn't exist.~
  => q~That style doesn't exist.~,
q~That style can't be deleted.~
  => q~That style can't be deleted.~,
q~That style is still being used by profile(s)~
  => q~That style is still being used by profile(s)~,
q~That style is still being used by [bool,_1,profile,profiles] [_2]. While [bool,_1,a profile,profiles] are still using this style, it cannot be deleted.~
  => q~That style is still being used by [bool,_1,profile,profiles] [_2]. While [bool,_1,a profile,profiles] are still using this style, it cannot be deleted.~,
q~Any changes that you made have been saved.~
  => q~Any changes that you made have been saved.~,
q~You may have to build news for the results of your changes to become visible.~
  => q~You may have to build news for the results of your changes to become visible.~,



#####################################################################################
#HEADER: Buttons and 'labels'
q~Confirm Action~
  => q~Confirm Action~,
q~Yes, I'm sure~
  => q~Yes, I'm sure~,
q~Reset~
  => q~Reset~,
q~Yes (On)~
  => q~Yes (On)~,
q~No (Off)~
  => q~No (Off)~,
q~Save Settings~
  => q~Save Settings~,
q~Delete~
  => q~Delete~,
q~Edit~
  => q~Edit~,
q~Disable~
  => q~Disable~,
q~Enable~
  => q~Enable~,

#SECTION: Informational messages
q~Error~
  => q~Error~,
q~on~
  => q~on~,
q~off~
  => q~off~,
q~disabled~ # As in: User (disabled)
  => q~disabled~,
q~Internal Name~
  => q~Internal Name~,
q~Display Name~
  => q~Display Name~,
q~Create Field~
  => q~Create Field~,
q~Changes has NOT been saved~
  => q~Changes has NOT been saved~,

);



#####################################################################################
#HEADER: The Days Of The Week
#SECTION: Full weekday names
@Week_Days = (
	q~Sunday~,
	q~Monday~,
	q~Tuesday~,
	q~Wednesday~,
	q~Thursday~,
	q~Friday~,
	q~Saturday~
);

#SECTION: Abbreviated weekday names
@Abbrev_Week_Days = (
	q~Sun~,
	q~Mon~,
	q~Tue~,
	q~Wed~,
	q~Thu~,
	q~Fri~,
	q~Sat~
);



#####################################################################################
#HEADER: The Name Of The Months
#SECTION: Full month names
@Months = ( # The name of the months 
	q~January~,
	q~February~,
	q~March~,
	q~April~,
	q~May~,
	q~June~,
	q~July~,
	q~August~,
	q~September~,
	q~October~,
	q~November~,
	q~December~
);

#SECTION: Abbreviated month names
@Abbrev_Months = (
	q~Jan~,
	q~Feb~,
	q~Mar~,
	q~Apr~,
	q~May~,
	q~Jun~,
	q~Jul~,
	q~Aug~,
	q~Sep~,
	q~Oct~,
	q~Nov~,
	q~Dec~
);


1;

