#!/usr/bin/perl

# Before attempting to set up this script, please read
# readme.txt, which you should have received along with this!

# EXTRA SERVER INFORMATION
# Coranto tries to determine its path and URL automatically. This works in 90%
# of cases, but some servers aren't cooperative and don't allow this information
# to be found automatically. Though it won't hurt, there's no need to fill this out
# unless you encounter problems.
#
# If you encounter problems (particularly with incorrect URLs, or fatal error messages
# about files not being found), fill in the two variables below.

$abspath = '';
# Set the above to the absolute path to Coranto's directory, without
# a trailing slash. Example:
# $abspath = '/absolute/path/to/coranto';

$scripturl = '';
# Set the above to the URL to coranto.cgi. Example:
# $scripturl = 'http://www.myserver.com/coranto/coranto.cgi';
# END EXTRA SERVER INFORMATION

#######
# START (Unless you know Perl, don't change anything after this point.)
#######

# Don't change these numbers! Used internally.
$crcgiBuild = 51;
$crcgiVer = '1.32.0';
$crcgiRC = 0;
$crlangVer = 2;

	unless ($JustLoadSubs == 1){
		eval {
			unless ($scripturl){
			$scripturl = GetScriptURL();
			}
		&main();
		};
		
		if ($@) {
			CRdie("Untrapped Error: $@");
		}
	}

# In order to trap as many errors as possible, we run everything via an eval.
# If $JustLoadSubs is set, that means we're being included by an external
# script which doesn't want us to run, so don't.

# This is the first sub to be executed.
sub main {
	
	# mod_perl?
	if (exists $ENV{'MOD_PERL'}) {
		print "Content-Type: text/html\n\nSorry, Coranto does not currently run under mod_perl.";
		exit;
	}

	# Try and be compatible with Microsoft IIS.
	unshift @INC, $1 if $0 =~ m!(.*)(\\|\/)!;

	# Include the directory we presumable is running in. 
	push @INC, GetDirInfo();
	
	# If extra server information was specified, use it.
	push @INC, $abspath if $abspath;

	# We're done. Now load the core and start running it.
	NeedFile('crcore.pl');
	RunCoranto();
}

# Takes care of loading in external Perl files.
my %LoadedFiles;	
sub NeedFile {
	my $file = shift;
	unless ($LoadedFiles{$file}) {
		eval { require $file; };
		if ($@) {
			if (-e $file) {
				if (-r $file) {
					CRdie("Could not include file $file. The file, however, appears to exist. This usually indicates
						some form of syntax error in the file. Message: $@");
				}
				else {
					CRdie("Could not include file $file. The file appears to exist but is not readable. Check file permissions. Full Message: $@");
				}
			}
			else {
				CRdie("Could not include file $file. The file does not appear to exist. Verify that this file is where it should be.<br>Full Message: $@",1);
			}
		}
		$LoadedFiles{$file} = 1;
	}
}

# Gets our current absolute path. Used both to locate files and for error messages.
{
	$CRWorkingDir = '';
	sub GetDirInfo {
		return $CRWorkingDir if ($CRWorkingDir);
		eval q~use FindBin qw($RealBin); $CRWorkingDir = $RealBin unless($RealBin eq '/');~;
		eval q~use Cwd; $CRWorkingDir = getcwd();~ unless ($CRWorkingDir);
		eval q~$CRWorkingDir = `pwd`; chomp $CRWorkingDir;~ unless($CRWorkingDir);
		$CRWorkingDir = '.' unless ($CRWorkingDir);
		$CRWorkingDir =~ s!\\!/!g;
	 	return $CRWorkingDir;
	}
}

# Gets our full URL. Needed for error messages.
sub GetScriptURL { 'http' . ( defined $ENV{'HTTPS'} and $ENV{'HTTPS'} ne 'off' ? 's' : '' ) . '://' . ($ENV{'HTTP_HOST'} ? $ENV{'HTTP_HOST'} : $ENV{'SERVER_NAME'}) . ($ENV{'SERVER_PORT'} != 80 && $ENV{'HTTP_HOST'} !~ /:/ ? ":$ENV{'SERVER_PORT'}" : '') . $ENV{'SCRIPT_NAME'} }

# CRHTMLHead: Displays the standard HTML header used by all script pages.
# NOTE: At the login page, the hooks in this sub is *only* accessible if
#       the $EarlyAddonLoad param in cruser.pl is set to 1
sub CRHTMLHead {
	unless ($HTMLHeaderPrinted) {
	my ($title, $adminnav) = @_;
	$title =~ s/</&lt;/g;
	$title =~ s/>/&gt;/g;
#	$title =~ s/"/&quot;/g;
	$title =~ s//&quot;/g;
	print qq~
	<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
	<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en">
	<html>
	<head>
	<title>Coranto: $title</title>
	~ . CRgetmsg(q~<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">~);
	
	print qq~
	<link  href="../../crstyles/coranto.css" rel="stylesheet" type="text/css" />~;
	
	# HOOK: CRHTMLHead_Head
	if($Addons{'CRHTMLHead_Head'}){my $w;foreach $w (@{$Addons{'CRHTMLHead_Head'}}){my $addon=$w->[2];eval ${$w->[0]};AErr($addon,$@)if $@;};}
	print qq~
	</head> 
	<body>
	<div id="wrapper">~;
	# HOOK: CRHTMLHead
	if($Addons{'CRHTMLHead'}){my $w;foreach $w (@{$Addons{'CRHTMLHead'}}){my $addon=$w->[2];eval ${$w->[0]};AErr($addon,$@)if $@;};}
	print qq~
	<div id="header">	
	<p class="sitelink">~;
	print qq~<a href="$CConfig{'SiteLink'}">~ if $CConfig{'SiteLink'};
	print $CConfig{'SiteTitle'};
	print '</a>' if $CConfig{'SiteLink'};
	print '</p>';

	# Changed the link printout slightly to make it easier for addons to override it if needed be. (1.31.5)
	my $corantolink = "Coranto v$crcgiVer" . ( $crcgiRC ? " RC-$crcgiRC" : '' );
#	$corantolink = ('<p class="corantolink"><a href="http://coranto.org/" class="miniheader">' . $corantolink . '</a></p>') if $CConfig{'PublicOrPrivate'};
		$corantolink = '<p class="corantolink"><a href="http://coranto.org/">' . $corantolink . '</a></p>';
	# HOOK: CRHTMLHead_CRLink
	if($Addons{'CRHTMLHead_CRLink'}){my $w;foreach $w (@{$Addons{'CRHTMLHead_CRLink'}}){my $addon=$w->[2];eval ${$w->[0]};AErr($addon,$@)if $@;};}
	print $corantolink;
		
	print qq~
	</div>
	<h1>$title</h1>~;
	# HOOK: CRHTMLHead_Message
	if($Addons{'CRHTMLHead_Message'}){my $w;foreach $w (@{$Addons{'CRHTMLHead_Message'}}){my $addon=$w->[2];eval ${$w->[0]};AErr($addon,$@)if $@;};}

CRMenuBar('top') if($CConfig{'MenuPosition'} =~ /top/);

CRMenuBar('left') if($CConfig{'MenuPosition'} =~ /left/);
        
	print qq~
	<div id="content">~;
	
	if ($CurrentUser) {
		print qq~
		<p class="miniheader"> ~ . CRgetmsg('You are logged in as user [_1].', $CurrentUser);
		if ($adminnav) {
			print '<br>' . CRgetmsg('Back To [_1]', PageLink( {'action' => 'mainpage'} ) . CRgetmsg('Main Page') . '</a>') . ' | ' .
					CRgetmsg('Back To [_1]', PageLink( {'action' => 'admin'} ) . CRgetmsg('Administration') . '</a>');
		}

		# HOOK: CRHTMLHead_UserBar
		if($Addons{'CRHTMLHead_UserBar'}){my $w;foreach $w (@{$Addons{'CRHTMLHead_UserBar'}}){my $addon=$w->[2];eval ${$w->[0]};AErr($addon,$@)if $@;};}

		print qq~
		</p>~;
    	}
	$HTMLHeaderPrinted = 1;
	} # end unless $HTMLHeaderPrinted
}

sub CRMenuBar {
	my $position = shift;
	my $menu = '';
	
	# HOOK: CRMenuBar_Init
	if($Addons{'CRMenuBar_Init'}){my $w;foreach $w (@{$Addons{'CRMenuBar_Init'}}){my $addon=$w->[2];eval ${$w->[0]};AErr($addon,$@)if $@;};}

	if(defined $in{'action'} && $in{'action'} ne 'logout' && !$menu) {
		if($position =~ /left|right/) {
	       $menu .= qq~
			<div id="menublock">
			<ul>~;

			my $mpage = CRgetmsg('Main Page');
			$mpage =~ s/ /&nbsp;/g;
			$menu .= "<li>" . PageLink( {'action' => 'mainpage'} ) . "$mpage</a></li><li>";
	
			my @funclist = map { $_->[0] =~ s/ /&nbsp;/; PageLink( {'action' => $_->[2]}) . "$_->[0]</a>&nbsp;"; } @MenuFunctions;
			
			# HOOK: CRMenuBar_Funclist_Vertical
			if($Addons{'CRMenuBar_Funclist_Vertical'}){my $w;foreach $w (@{$Addons{'CRMenuBar_Funclist_Vertical'}}){my $addon=$w->[2];eval ${$w->[0]};AErr($addon,$@)if $@;};}
			
			@funclist = grep(!/>Header<|>Break</, @funclist);
			$menu .= join('</li><li>', reverse(@funclist));
			$menu .= qq~
					</li></ul>
					</div>~;
		} else {
			$menu .= q~
			<div id="menubar"><ul>~;
			my $mpage = CRgetmsg('Main Page');
			$mpage =~ s/ /&nbsp;/g;
			$menu .= "<li>" . PageLink( {'action' => 'mainpage'} ) . "$mpage</a></li><li>";
		
			my @funclist = map { $_->[0] =~ s/ /&nbsp;/; PageLink( {'action' => $_->[2]}) . "$_->[0]</a>&nbsp;"; } @MenuFunctions;
			
			# HOOK: CRMenuBar_Funclist_Horizontal
			if($Addons{'CRMenuBar_Funclist_Horizontal'}){my $w;foreach $w (@{$Addons{'CRMenuBar_Funclist_Horizontal'}}){my $addon=$w->[2];eval ${$w->[0]};AErr($addon,$@)if $@;};}
			
			@funclist = grep(!/>Header<|>Break</, @funclist);
			$menu .= join('</li><li>', reverse(@funclist));
			if ($CConfig{'SiteLink'}) {
				my $sitelink = CRgetmsg('Back To [_1]', $CConfig{'SiteTitle'});
				$sitelink =~ s/ /&nbsp;/g;
				$menu .= qq~<li><a href="$CConfig{'SiteLink'}">$sitelink</a></li> ~;
			}
			$menu .= q~
					</li></ul>
					</div>~;
		}
	}
	
	print $menu;
}

sub CRHTMLFoot_NoNav {
	print '</div>
	</div></body></html>';
}

# CRHTMLFoot: Displays the HTML footer used by all script pages.
# Jackanape:  When stripping tables, added an empty foot div to maintain content div height for floating pages, such as admin.
sub CRHTMLFoot {
	print '<div class="foot">&nbsp;</div></div>';

	CRMenuBar('bottom') if($CConfig{'MenuPosition'} =~ /bottom/);
	
	# HOOK: CRHTMLFoot_2
	if($Addons{'CRHTMLFoot_2'}){my $w;foreach $w (@{$Addons{'CRHTMLFoot_2'}}){my $addon=$w->[2];eval ${$w->[0]};AErr($addon,$@)if $@;};}
	print '</div></body></html>';
}

# CRdie: Generates a pretty error message with as much information as possible.
sub CRdie {
#	if ($CRdied) {
#		exit;
#	}
	undef %Addons;
#	$CRdied++;
	my $msg = shift;
	my $enableHTML = shift;
	$msg =~ s/\n//g;
	$msg =~ s/<br>/\n/g;
	unless ($enableHTML) {
		$msg =~ s/</&lt;/g;
		$msg =~ s/>/&gt;/g;
	}
	$msg =~ s/\n/<br>/g;
	if (!$HeaderPrinted) {
		print "Content-type: text/html\nCache-control: no-cache\n\n";
		$HeaderPrinted=1;
	}
	if (!$HTMLHeaderPrinted) {
		CRHTMLHead("Fatal Error");
	}
	print qq~<div id="content"><p>An error has occurred. The exact description of the error is:</p>
	<p class="message">$msg</p>
	<p>If this error indicates a problem that you don't know how to solve, see the Coranto documentation
	and FAQ. If these resources don't help, make a (detailed!) post to the <a href="http://coranto.org/forum">Coranto Forum</a>.</p>
	<h2>USEFUL INFORMATION</h2>\n~;
	if ($!) {
		print "Perl may have generated the following error: $!\n<br>";
	}
	
#PARAHEAD: 2005-03-02 Added support for StackTrace as suggested by LoneOwl
# http://coranto.org/forum/viewtopic.php?t=5492
	print "Stack Trace:\n<blockquote>";
	my $stack = '';	
	my $i = 0;
	while (my (undef, $filename, $line, $sub) = caller($i++)) {
		$sub =~ s/^.*:://;
		$stack = "$sub in $filename, line $line<br>" . $stack;
	}
	print "$stack</blockquote>\n"; 
#PARAHEAD: End modification
	
	print "Perl Version: $]\n<br>";
	print "Script Version: $crcgiVer\n<br>";
	print "Script Build: $crcgiBuild\n<br>";
	print "Script RC: $crcgiRC\n<br>";
	print "Script URL: $scripturl\n<br>";
	print '@INC: <ul><li>' . join("</li>\n<li>", @INC) . '</li></ul>';
	($0 =~ m,(.*)/[^/]+,)   && unshift (@INC, "$1");
	($0 =~ m,(.*)\\[^\\]+,) && unshift (@INC, "$1");
	print "Script Location (Method 1): $0\n<br>";
	my $dirname = GetDirInfo();
	$dirname =~ s/\\/\//g;
	print "Script Location (Method 2): $dirname\n<br>";
	print "<br>\n<b>ENVIRONMENT VARIABLES</b>\n<br>";
	while (($key, $value) = each %ENV) {
		unless ($key eq "HTTP_COOKIE") {
			print "$key: $value\n<br>";
		}
	}
	print "<br>\n<b>MESSAGE:</b> $msg\n<br>";
	CRHTMLFoot_NoNav();
	exit;
}
1;	
	
