package CRLog;
use vars qw($VERSION $MAX_ENTRIES $logfile $logpath);

$VERSION = '1.00.00';
$MAX_ENTRIES = 500;

require 5.005;

use strict;
use Fcntl qw(:DEFAULT :flock);


sub openLog {
	my ($self) = @_;
	$logpath = "./crlog.txt";
	$logfile = main::CRopen('>>' . $logpath);
}

sub message {
	my ($self, $msg) = @_;
	my $timestamp = _getTimestamp();
	print $logfile "$timestamp: $msg\n";
}


sub closeLog {
	my ($self) = @_;
	close($logfile);

	my $linecount = 0;
	$logfile = main::CRopen('<' . $logpath);
	$linecount++ while <$logfile>;
	close($logfile);
	if($linecount > $MAX_ENTRIES) {
		my $tmppath = './crlog.tmp';
		rename( $logpath, $tmppath );
		my $tmpfile = main::CRopen('<' . $tmppath);
		$logfile = main::CRopen('>' . $logpath);
		while(<$tmpfile>) {
			if(--$linecount < ($MAX_ENTRIES-100)) {
				print $logfile $_;
			}
		}
		close($logfile);
		close($tmpfile);
		unlink($tmppath);
	}
}


sub _getTimestamp {
	my ($Second,$Minute,$Hour,$Day, $Month,$Year) = (localtime())[0,1,2,3,4,5]; 
	$Year += 1900;
	$Month = sprintf('%.2d', ($Month+1));
	$Day = sprintf('%.2d', $Day);
	$Hour = sprintf('%.2d', $Hour);
	$Minute = sprintf('%.2d', $Minute);
	$Second = sprintf('%.2d', $Second);
	return("$Year-$Month-$Day $Hour:$Minute:$Second");
}
	

1;