
sub FirstTimePage {
	print header();
	NeedFile('crlang.pl');
	CRHTMLHead('Coranto Setup');
	print MidHeading('Welcome to Coranto');
	print StartForm({'action' => 'setup', 'setupstep' => 1});
	print MidParagraph(q~Congratulations: one of the most problematic parts of setup, getting Coranto to run as a CGI script, is complete. 
	Now, you need to give Coranto some information -- the paths where its files are stored, the name you'd like to log
	in with, and various other important details. On this and the next couple of pages, Coranto will ask you for this information.~,1);
	print MidHeading('Licensing');
	print MidParagraph(q~This is the download version of Coranto. Although it is and will continue to be available for free download, 
	in order to prevent confusion and make support easier, we ask that you do not distribute copies of it yourself.
	<p>The primary license requirement for this version is that you include a link to the Coranto homepage on your news page(s). Specifically,
	<b>every page which contains full news items must include a link</b> to the Coranto site (http://www.amphibianweb.com/coranto/), preferably
	via the phrase <i>Powered by <a href="http://www.amphibianweb.com/coranto/" target="_blank">Coranto</a></i>. Pages which contain only headlines linking
	to full news items are exempt.
	<p>The Display Link option, on by default, makes Coranto include the link automatically. If you prefer, you can turn this option off and include the link
	yourself, provided that it remains in a visible location and is not significantly smaller than the main text on the page.
	<!-- <p>Full license details are at the top of coranto.cgi. Please read them before continuing. -->
	<p align="center"><select name="license"><option value="" selected>Please select an option</option>
	<option value="1">I agree -- I will comply with the Coranto license</option>
	<option value="0">I disagree</option></select>~,1);
	print MidHeading('File Paths');
	my $dir = GetDirInfo();
	print MidParagraph(q~In the boxes below, please enter the absolute paths for the three different Coranto directories: <b>Program Files</b>,
	<b>News Files</b>, and <b>Archive Files</b>. The directory which coranto.cgi is currently in is the Program Files directory; the setup
	documentation provides information on selecting the other two.
	<p>You must enter <b>absolute paths</b> here, not URLs. (Use forward / slashes, even on Windows servers, and do not include a trailing slash.) ~ . 
	($dir ? qq~It looks like the path to the current directory (the Program Files directory) is <b>$dir</b>. This guess is accurate 95% of the time; only 
	disregard it if you are absolutely certain that the absolute path to your directory is something different.~ : "Unfortunately, Coranto could not
	automatically determine the absolute path to its directory. If you're not sure what the path is, please contact your host."), 1);
	Setup_PathSettings($dir, $dir, $dir);
	print SubmitButton('Continue Setup'), '</form>';
	CRHTMLFoot_NoNav();
}

sub Setup_PathSettings {
	my ($prog, $news, $arc) = @_;
	print SettingsTable('Program Files Path:', qq~<input type="text" name="admin_path" size="50" value="$prog">~, q~Absolute path to the directory 
	where this script and its program files are located.~);
	print SettingsTable('News Files Path:', qq~<input type="text" name="htmlfile_path" size="50" value="$news">~, q~Absolute path to the directory 
	where you'd like the news files -- the ones to be used on your web pages -- to be generated by default. You should already have uploaded
	the news database, <i>newsdat.txt</i>, to this directory.~);
	print SettingsTable('Archive Files Path:', qq~<input type="text" name="archive_path" size="50" value="$arc">~, q~Absolute path to the directory 
	where you'd like news archive to be generated by default. Often the same as the News File path.~);
}


sub SetupHandler {
	if ($CConfig{'firsttime'} ne 'yes') {
		CRcough("This script appears to have already been set up. If you'd like to go through set up again, re-upload the original nsettings.cgi file.");
	}
	NeedFile('crlang.pl');
	if ($in{'setupstep'} == 1) {
		print header();
		unless ($in{'license'}) {
			CRcough('If you do not agree to the license conditions, please delete the Coranto files from your server.');
		}
		unless ($in{'admin_path'} && $in{'htmlfile_path'} && $in{'archive_path'}) {
			CRcough('You must enter paths for all three directories.');
		}
		my ($prog, $news, $arc) = (SecurePath($in{'admin_path'}), SecurePath($in{'htmlfile_path'}), SecurePath($in{'archive_path'}));
		my $err;
		my @paths = ("$prog/nsettings.cgi", "$prog/crcfg.dat", "$prog/nsbk.cgi", "$news/newsdat.txt");
		foreach $i (@paths) {
			unless (open(TEST, ">>$i")) {
				$err .= "Could not open <b>$i</b> for writing. ";
			}
			close(TEST);
		}
		unless (open(TEST, ">>$news/delete.me")) {
			$err .= "Could not create a new file in your News Files directory ($news). Check permissions on this directory.";
		}
		unlink("$news/delete.me");
		close(TEST);
		if ($err) {
			CRHTMLHead('File Error');
			print StartForm({'action' => 'setup', 'setupstep' => 1, 'license' => 1});
			print MidParagraph(qq~While testing that all necessary files could be written to, Coranto encountered some errors. Details on the errors are below.
			Errors are probably caused either by incorrect paths, which you can correct in the boxes below, or incorrect file permissions (CHMOD settings).
			<p>$err~, 1);
			Setup_PathSettings($prog, $news, $arc);
			print SubmitButton('Continue Setup'), '</form>';
			CRHTMLFoot_NoNav();
			exit;
		}
		$CConfig{'admin_path'} = $prog;
		$CConfig{'htmlfile_path'} = $news;
		$CConfig{'archive_path'} = $arc;
		CRHTMLHead('Coranto Setup');
		print StartForm({'action' => 'setup', 'setupstep' => 2});
		print MidHeading('File and Path Tests');
		print MidParagraph("Testing paths and file permissions... all tests were successful. The paths you entered seem correct, as do file permissions.", 1);
		print MidHeading('Create Account');
		print MidParagraph("Please choose the username and password you'd like to use to log in to Coranto. By default, the username you choose will appear
		beside your news posts.", 1);
		print SettingsTable('Username:', '<input type="text" name="user">', 
			"Your username may only contain letters, numbers, and underscores.");
		my $rpass = RandomWord(8);
		print SettingsTable('Password:', qq~<input type="text" name="pass" value="$rpass">~,
			"Your password must be a minimum of five characters. A randomly-generated secure password is suggested in the box above.");
		print SettingsTable('Email:', qq~<input type="text" name="email">~, 
			"Your email address.");
		print MidHeading('Language Settings');
		print MidParagraph("This version of Coranto supports only English, so you don't need to set any language options.");
		print SubmitButton('Continue Setup'), '</form>';
		CRHTMLFoot_NoNav();
		exit;
	}
	elsif ($in{'setupstep'} == 2) {
		print header();
		my $user = $in{'user'};
		my $pass = $in{'pass'};
		CRcough("Username &quot;$user&quot; contains illegal characters. Only letters, numbers, and underscores are permitted in usernames.") if ($user =~ /[^a-zA-Z0-9_]/);
		CRcough("Usernames have to be at least 3 characters long.") unless length($user) > 2;
		CRcough("Passwords have to be at least 5 characters long.") unless length($pass) > 4;
		NeedFile('crcrypt.pl');
		my $crcrypt = new CRcrypt;
		$userdata{$user}->{'CPassword'} = $crcrypt->GetHash($pass . $user);
		$userdata{$user}->{'UserLevel'} = 3;
		$userdata{$user}->{'Email'} = $in{'email'};
		WriteUserInfo();
		CRHTMLHead('Coranto Setup');
		print StartForm({'action' => 'setup', 'setupstep' => 3, 'user' => $user, 'email' => $in{'email'}});
		print MidHeading("Account $user Created");
		print MidParagraph("Please remember your password. You will need it to use Coranto in the future, and it is not easily reset if you forget it.", 1);
		print MidParagraph("To get Coranto started quickly, some of the more essential settings are organized into a single page below. All these settings will be available in Coranto's Administration section in the future, and you will be able to change anything you enter here.", 1);
		NeedFile('cradmin.pl');
		SettingsEngine_Display(SetupSettingsLoad(), \%CConfig);
		print MidParagraph('After you click the button below, there may be a delay of about thirty seconds as a basic security check is performed and setup continues at the Coranto site.');
		print SubmitButton('Continue Setup (Almost finished!)');
		CRHTMLFoot_NoNav();
		exit;
	}
	elsif ($in{'setupstep'} == 3) {
		NeedFile('cradmin.pl');
		SettingsEngine_Save(SetupSettingsLoad(), \%CConfig);
		$CConfig{'firsttime'} = 'no';
		my $afi = OpenAddons();
		if ($afi->{'backup'}) {
			my @AddonsLoaded = split(/~/, $CConfig{'AddonsLoaded'});
			push(@AddonsLoaded, 'cra_backup.pl');
			$CConfig{'AddonsLoaded'} = join('~', @AddonsLoaded);
		}
		print "Location: http://www.amphibianweb.com/coranto/postinstall.cgi?u=" . URLescape($scripturl) . "\n\n";
		exit;
	}
}
		
		
sub SetupSettingsLoad {
	NeedFile('crcfg.dat');
	InitGTD('<Field: Hour>:<Field: Minute>:<Field: Second> <Field: AMPM>, <Field: Month_Name> <Field: Day>', 'GetFullDisplayTime');
	my @SetupSettings = (
	['heading: Your Site'],		
	['SiteTitle', 'Site Name', "The name of your site. Will be displayed on Coranto administrative pages."],
	['SiteLink', 'Site Link', "If you'd like a <i>Back to Your Site</i> link on Coranto administrative pages, enter the URL here. Otherwise, leave this blank."],
	['heading: Date and Time'],
	['Standard_Time_Zone', 'Time Zone', "Your time zone. Any name or abbreviation is acceptable -- this is for display purposes only."],
	['Daylight_Time_Zone', 'Daylight Savings Time Zone', "As above, but during Daylight Savings Time."],
	['TimeOffset', 'Server Time Offset', "Often, your server will be in a different time zone than you are. You can enter the difference, in hours, between the server's time and the time you would like displayed on news items. For instance, if your server is in London and you are in Boston, set this to -5. 
		Changing this setting will not affect existing news items; only new items will have an adjusted time. (The server's current time is: " . GetFullDisplayTime($CurrentTime) . ")"],
	['12HourClock', '12/24 Hour Clock', "Choose between a 12 hour (AM/PM) and 24 hour clock.", 
		[ ['1', '12 Hour (AM/PM)'], ['0', '24 Hour'] ] ],
	['heading: <i>news.txt</i> Settings'],
	["descrip: <i>news.txt</i> will contain your news items in HTML format. It is designed to be included into your webpage. It is possible to customize this file a great deal; some of the most important settings are below. Once setup is complete, go to Manage Profiles and edit the <i>news</i> profile to see further settings."],
	["descrip: By default, your news will be generated using a very basic style which you'll probably want to change. After setup is done, go to Administration, then Edit News Styles, then edit Default Style to change the HTML Coranto uses to generate <i>news.txt</i>."],
	['agefilter', 'Filter News By Time', "The number of days after which news will be considered old. News posted more than the specified number of days ago will not be included in <i>news.txt</i> (though it will be archived, if that is enabled). <b>Leave blank</b> if you do not want to filter by time."],
	['numfilter', 'Filter News By Number', "The maximum number of news items that will be included in <i>news.txt</i>. For instance, if you set this to 10, then the 11th-newest item will not be included (though it will be archived, if that is enabled). <b>Leave blank</b> if you do not want to filter by number."],
	['archive', 'Archive Type', "If you'd like to create archives of old news, choose the type of archive here. (The archive won't be created until you have at least one news item that doesn't match the filter settings above.) <br><br>
			Set to Single File to place all old items in one text file, called news-archive.txt.
			Set to Monthly, Weekly, or Daily to create multiple archives, each holding a month's, week's, or day's news, respectively.", 
			[ ['0', 'Disabled (News will not be archived)'], ['1', 'Single File'], ['2', 'Monthly Archives'], ['3', 'Weekly Archives'], ['4', 'Daily Archives'] ] ]);
	return \@SetupSettings;
}
	


1;