#! CRADDON 1
#! NAME ZNotice
#! VERSION beta build 4 - modified
#! HOMEPAGE http://www.b000.net

######
# Originally written by Zac West
# Modified by Lawrence Williams to eliminate use of global variables
######

my $addon = new Addon("znotice");

$addon->checkBuild("28"); 

$addon->addAdminFunction("znotice", "Edit or replace the current notice.", "znoticedit");
$addon->registerAdminFunction("znoticedit", "ZNOTICE_EDIT");
$addon->registerAdminFunction("znoticesave", "ZNOTICE_SAVE");
$addon->registerAdminFunction("znoticeclear", "ZNOTICE_CLEAR");
$addon->registerAdminFunction("znoticelevel", "ZNOTICE_LEVEL");

sub ZNOTICE_EDIT {
$addon->pageHeader("znotice");

print $addon->heading("ZNotice Level");
print $addon->descParagraph("Lowest rank to not see the ZNotice:");
print $addon->form({'action' => 'admin', 'adminarea' => 'znoticelevel'});

if ($CConfig{'znotice_level'} == 1) {
print qq~ <input type="radio" name="level" value="1" CHECKED> - Nobody Can View It<br> ~;
}
else {
print qq~ <input type="radio" name="level" value="1"> - Nobody Can View It<br> ~;
}

if ($CConfig{'znotice_level'} == 2) {
print qq~ <input type="radio" name="level" value="2" CHECKED> - High Level Users & Administrators Don't See It<br>~;
}
else {
print qq~ <input type="radio" name="level" value="2"> - High Level Users & Administrators Don't See It<br>~;
}

if ($CConfig{'znotice_level'} == 3) {
print qq~<input type="radio" name="level" value="3" CHECKED> - Administrators Can't See It<br>~;
}
else {
print qq~ <input type="radio" name="level" value="3"> - Administrators Can't See It<br>~;
}

if ($CConfig{'znotice_level'} == 4) {
print qq~ <input type="radio" name="level" value="4" CHECKED> - Everybody Can View It<br>~;
}
else {
print qq~ <input type="radio" name="level" value="4"> - Everybody Can View It<br>~;
}

print $addon->submitButton("Change Level");
print "</form>";

print $addon->heading("Edit ZNotice");
print $addon->descParagraph("This allows you to edit the notice on all pages.");
print $addon->form({'action' => 'admin', 'adminarea' => 'znoticesave'});
print qq~ <center><input type="text" name="title" value="$CConfig{'znotice_title'}"> (Title):<br><textarea cols="50" rows="8" name="notice">$CConfig{'znotice'}</textarea></center><br>~;
print $addon->submitButton("Edit ZNotice");
print qq~ </form></center><br><br>~;

print $addon->heading("Clear ZNotice");
print $addon->descParagraph("Use the following button to reset znotice and disable it on pages.");
print $addon->form({'action' => 'admin', 'adminarea' => 'znoticeclear'}); 
print qq~ <center><input type="hidden" name="go" value="yes">~;
print $addon->submitButton("Clear All Data & Reset");
print qq~ </form></center></center>~;

$addon->pageFooter();
}

sub ZNOTICE_SAVE {
	if (length($in{'notice'}) > "1") {
	$CConfig{'znotice'} = $in{'notice'};
	$CConfig{'znotice_title'} = $in{'title'};
	$addon->simplePage("znotice saved", "The notice was sucessfully saved.", 1);
	}
	else {
	$addon->simplePage("znotice error", "The notice you submitted was either misread or too small. Please try again", 0);
	}
}

sub ZNOTICE_CLEAR {
	if ($in{'go'} eq "yes") {
	$CConfig{'znotice'} = "";
	$CConfig{'znotice_title'} = "";
	$addon->simplePage("znotice cleared", "All notices cleared. ZNotice will not show up on pages until you readd one.", 1);
	}
	else {
	$addon->simplePage("znotice error", "There was an error clearing znotice files. Please try again.", 1);
	}
}

sub ZNOTICE_LEVEL {
	if ($in{'level'}) {
	$CConfig{'znotice_level'} = $in{'level'};
	$addon->simplePage("znotice level set", "Lowest ZNotice possible has been set.", 1);
	}
	else {
	$addon->simplePage("znotice error", "There was an error setting znotice level. Please try again.", 1);
	}
}

$addon->hook("CRHTMLHead_Message", "ZNOTICE_MAIN");

sub ZNOTICE_MAIN {
my $zuserlevel = $userdata{$CurrentUser}->{'UserLevel'};

	unless ($zuserlevel >= $CConfig{'znotice_level'}) {	
		if (length($CConfig{'znotice'}) > 1) {
		print qq~ <center><b>$CConfig{'znotice_title'}</b><br> $CConfig{'znotice'}</center><br><br> ~;
		}
	}
}

1;