#! CRADDON 1
#! NAME X MultiSubmit
#! DESCRIPTION Manage custom "submit news" pages, where only the news fields of your choice are presented.
#! VERSION 2.4.3
#! HOMEPAGE http://coranto.gweilo.org
#! DOC 1

#use strict;
#use vars qw(@XMS_Profs %CConfig %Subs %in %XMS_DB %newscategories %XMSFieldDB %userdata $CurrentUser $up %xms_hash %xms_selected_users @fieldDB_internalorder @fieldDB %fieldDB);
#no strict "refs";

my $addon = Addon->new('X MultiSubmit');

$::xms_build = 17;
$::xms_version = '2.4.3';

$addon->checkBuild(36);

eval {
$addon->isPrivacyCompatible;
};
if ($@){}

$addon->addAdminFunction('X MultiSubmit','Manage profiles, and change settings.','xms-admin');
$addon->registerAdminFunction('xms-admin','XMS_Admin');
$addon->registerAdminFunction('xms-settings','XMS_Settings');
$addon->registerAdminFunction('xms-settings-save','XMS_Settings_Save');
$addon->registerAdminFunction('xms-prof','XMS_Profiles');
$addon->registerAdminFunction('xms-prof-add','XMS_AddProf');
$addon->registerAdminFunction('xms-prof-edit','XMS_EditProfile');
$addon->registerAdminFunction('xms-prof-save','XMS_EditProfile_Save');
$addon->registerAdminFunction('xms-prof-endisable','XMS_EnDisAble');
$addon->registerAdminFunction('xms-prof-remove','XMS_RemoveProf');

$addon->registerAdminFunction('xms-prof-moveupdown','XMS_MoveUpDown1');

	# Check to see if XMS needs to upgrade and do so, if needed
	unless (exists $CConfig{'XMS_Installed'}){
	&XMS_AutoUpgrade();
	$CConfig{'XMS_Installed'} = 1;
	}

#####################################################################
	
{
NeedCFG();

	unless(@XMS_Profs){
		NeedFile('cradmin.pl');
		XMS_LoadProf();
		foreach my $prof(keys %::XMS_DB){
		push(@XMS_Profs, $prof);
		}
		SaveCRCFG();
	}
}
	
my $SaveCRCFG = <<'END_CODE';
	$crcfg .= ArraytoPerl('XMS_Profs');
END_CODE
	
$addon->hook('SaveCRCFG_1', \$SaveCRCFG, -5);

sub XMS_MoveUpDown1 {
NeedCFG();
XMS_MoveUpDown2(\@XMS_Profs, $in{'profname'}, $in{'direction'});
SaveCRCFG();
XMS_Profiles();
}

sub XMS_MoveUpDown2 {
# This is a general purpose sub that moves items in an array up/down by one each time
# Works ONLY with arrays passed by reference

my($arrayref, $object, $direction) = @_;

my @array = @{$arrayref};

my (%sorted, $swap);

	for(my $i=0;$i<@array;$i++){
	$sorted{$array[$i]} = $i;
	}

	CRcough('Invalid input error 1.') unless $sorted{$object} >= 0 && $sorted{$object} <= @array;
	CRcough('Invalid input error 2.') if $direction < 1 || $direction > 2;
	CRcough('This is already the first item.') if $direction == 1 && $sorted{$object} == 0;
	CRcough('This is already the last item.') if $direction == 2 && $sorted{$object} == @array - 1;

	$swap = ($sorted{$object} + 1) if $direction == 2;
	$swap = ($sorted{$object} - 1) if $direction == 1;
	@array[$sorted{$object}, $swap] = @array[$swap, $sorted{$object}];
	
	@{$arrayref} = @array;
}

######################################################################

my $PreHeader = <<'END_CODE';
	eval {
		XMS_LoadProf();

		# Get selected users into a hash
		# Hash format is:
		# $xms_selected_users{SUBMIT_PAGE}->{USER}

		%xms_selected_users = ();

		foreach my $i (@XMS_Profs){
			foreach my $id(split(/\`\|\`/,$XMS_DB{$i}->{'XMS_Users'})){
			$xms_selected_users{$i}->{$id} = 1;
			}
		}
	};
END_CODE

$addon->hook('PreHeader',\$PreHeader, -5);

#######################
# MODIFY NEWS CODE
#######################

sub XMS_ModifyNews_NavBar {
	my @xmst;

	foreach my $i(@XMS_Profs){
		if ((exists $XMS_DB{$i}->{'Enabled'} && $XMS_DB{$i}->{'Enabled'} == 1) && ($xms_selected_users{$i}->{$CurrentUser} || $xms_selected_users{$i}->{'(All)'} || $up > 2)){
			push(@xmst,$addon->link({'action'=>'modify','xMultiSubmitSP'=>$i}).($in{'xMultiSubmitSP'} eq $i?'<b>':'')."$XMS_DB{$i}->{'Name'}</b></a>") if(XMS_CheckPermission($i));
		}
	}

	print "<hr>" . $addon->link({'action'=>'modify','xMultiSubmitSP'=>'all'}).($in{'xMultiSubmitSP'} eq 'all'?'<b>':'')."View All</b></a> Or Sort By Submit Page: ", join(' | ',@xmst). "<hr>";
	
}

my $XMS_ModifyNews_HiddenValue = <<'END_CODE';
	if ($in{'xMultiSubmitSP'} && $in{'xMultiSubmitSP'} ne 'all'){
		print qq~<input type="hidden" name="xMultiSubmitSP" value="$in{'xMultiSubmitSP'}">~;
	}
END_CODE

my $XMS_ModifyNews_Filter1 = <<'END_CODE';
	if ($in{'xMultiSubmitSP'}){
	$Filter = 'SubmitPage';
	}
END_CODE

my $XMS_ModifyNews_Filter2 = <<'END_CODE';
	if ($Filter eq 'SubmitPage'){
		unless ($xMultiSubmitSP eq $in{'xMultiSubmitSP'} || $in{'xMultiSubmitSP'} eq 'all'){
		#next NDLOOP;
		$stoppermnow = 1;
		}
	}
END_CODE

if ($CConfig{'xms_modifynewslayout'} eq 'links'){
$addon->hook('ModifyNews_Filter', \$XMS_ModifyNews_Filter2);
$addon->hook('ModifyNews_Permissions',\$XMS_ModifyNews_Filter1);
$addon->hook('ModifyNews_SearchForms','XMS_ModifyNews_NavBar');
$addon->hook('ModifyNews_StartForm', \$XMS_ModifyNews_HiddenValue, -5);
}

#########################################################################################

sub XMS_CheckPermission {
	my $id = shift;

	# PARAHEAD: Since this sub is standard from NewsCategory version 10-RC6,
	# we only define it if need to and if we do, use the old Category standard.. (2.4.2)
	unless ($Subs{'NewsCategories_CheckPermission'}) {
$Subs{'NewsCategories_CheckPermission'} = <<'END_SUB';
sub NewsCategories_CheckPermission {
	my ($cat) = @_;
	$cat ||= $Category;
	return  ($newscategories{$cat}->{'(AllUsers)'} || # The category is open to all
		($newscategories{$cat}->{'(High)'} && $up == 2) || # The category is open to High levelers
		$newscategories{$cat}->{$CurrentUser} || # This user has been granted permission
		$up == 3);
}
END_SUB
	}

		
	my $userAllowed = 0;
	if($CConfig{'AddonsLoaded'} =~ /cra_ncategory\.pl/){
		foreach my $lockCat(split(/`\|`/,$XMS_DB{$id}->{'LockCats'})) {
			if( ($lockCat eq 'Disabled') || ($lockCat eq 'AllCategories') || (NewsCategories_CheckPermission($lockCat)) ) {
				$userAllowed++;
				last;
			}
		}	
	} else {
		$userAllowed++;
	}
	return $userAllowed;
}

my $HookQuickMenu = <<'END_CODE';
	LoadFunctionList();
	
		&ReadUserDBInfo();
#		my @xmsfunctions = ();
		foreach my $i (reverse(@XMS_Profs)){
			if (exists $XMS_DB{$i}->{'Name'} && $XMS_DB{$i}->{'Enabled'} && $XMS_DB{$i}->{'QuickLink'} && $CConfig{'xms_dissubnews'} ne 'choose' && ($xms_selected_users{$i}->{$CurrentUser} || $xms_selected_users{$i}->{'(All)'} || $up > 2)) {
# PARAHEAD: Added check to see if the current user is allowed to post into this Submit Page depending on the Category (2.4.2)
				push(@AvailableFunctions, ['</a >' . $addon->link({'action'=>'xms-submit','profname'=>$i}) . "$XMS_DB{$i}->{'Name'}</a>", '', ''] ) if(XMS_CheckPermission($i));
#				push(@xmsfunctions, ['</a >' . $addon->link({'action'=>'xms-submit','profname'=>$i}) . "$XMS_DB{$i}->{'Name'}</a>", '', ''] ) if(XMS_CheckPermission($i));
			}
		}

	@funclist = map { $_->[0] =~ s/ /&nbsp;/; PageLink( {'action' => $_->[2]}) . "$_->[0]</a>&nbsp;" } @AvailableFunctions;
#	    @xmsfunctions = map { $_->[0] =~ s/ /&nbsp;/; PageLink( {'action' => $_->[2]}) . "$_->[0]</a>&nbsp;"; } @xmsfunctions;
#		push(@funclist, @xmsfunctions);	
END_CODE

my $HookMainPage = <<'END_CODE';
	{
	&ReadUserDBInfo();

		foreach my $i (reverse(@XMS_Profs)){
			if (exists $XMS_DB{$i}->{'Name'} && ($xms_selected_users{$i}->{$CurrentUser} || $xms_selected_users{$i}->{'(All)'} || $up > 2) && $XMS_DB{$i}->{'MainPage'} && $XMS_DB{$i}->{'Enabled'} && $CConfig{'xms_dissubnews'} ne 'choose'){
# PARAHEAD: Added check to see if the current user is allowed to post into this Submit Page depending on the Category (2.4.2)
				push(@AvailableFunctions, ['</a >' . $addon->link({'action'=>'xms-submit','profname'=>$i}) . "$XMS_DB{$i}->{'Name'}</a>", $XMS_DB{$i}->{'Description'} ? $XMS_DB{$i}->{'Description'} : $CConfig{'xms_nodescmsg'}, ''] ) if(XMS_CheckPermission($i));
			}
		}

	}
END_CODE

my $HookModNewsHeader = <<'END_CODE';
	print $ColCount % 2 ? '<td class="yellowbg">' : '<td class="lightgbg">';
	print '<div align="center"><b>Submit Page</b></div></td>';
	$ColCount++;
END_CODE

my $HookModNewsBody = <<'END_CODE';
	print $ColCount % 2 ? '<td class="navlink"><div align="center">' : '<td class="lightgbg"><div align="center" class="footnote">';
	print qq~$XMS_DB{$::xMultiSubmitSP}->{'Name'}</div></td>~;
	$ColCount++;
END_CODE

if($CConfig{'xms_modifynewslayout'} eq 'column'){
    $addon->hook('ModifyNews_NewColumn_1',\$HookModNewsHeader);
    $addon->hook('ModifyNews_NewColumn_2',\$HookModNewsBody);
}

$addon->hook('EarlyHook','XMS_HookSubNewsDirect') if $in{'action'} eq 'submit' and exists($CConfig{'xms_dissubnews'}) and $CConfig{'xms_dissubnews'} ne 'disabled';
$addon->hook('CRHTMLFoot',\$HookQuickMenu);
$addon->hook('CRHTMLHead',\$HookMainPage);
$addon->hook('CRHTMLHead_UserBar','XMS_HookSubCRHTMLHead_UserBar');
$addon->hook('SaveNews_1','XMS_HookSubNewsSave_1');
$addon->hook('SaveNews_Pre','XMS_CheckRequiredFields');
$addon->hook('ModifyNews_EditSave_PreLoop','XMS_CheckRequiredFields');
$addon->hook('ModifyNews_EditSave_3','XMS_HookSubNewsSave_1');
$addon->hook('ModifyNews_Edit_TopRow','XMS_HookSubModifyNews_Edit_TopRow', 10);

my @XMS_ProfDatFields = qw(XMS_Id XMS_Name XMS_Desc XMS_Fields XMS_EnDisAbled XMS_LockCats XMS_DispMP XMS_DispQM); # DONT EDIT THIS!!
my @XMS_SubmitPages;

$addon->registerMainFunction('xms-submit','XMS_Submit');

$CConfig{'xms_nodescmsg'} = 'No description available for this submit page.' unless $CConfig{'xms_nodescmsg'};
$CConfig{'xms_afteradd'} = 'Profile Listing' unless $CConfig{'xms_afteradd'};

sub XMS_LoadProf {
	%::XMS_DB = ();
	ReadInnerHash('XMS_DB','Prof',\%::XMS_DB);
}

sub XMS_SaveProf {
	WriteInnerHash('XMS_DB','Prof',\%::XMS_DB);
}

sub XMS_LoadFieldOrder {
	%::XMSFieldDB = ();
	ReadInnerHash('XMSFieldDB','XMS_FieldDB',\%::XMSFieldDB);
}

sub XMS_SaveFieldOrder {
	WriteInnerHash('XMSFieldDB','XMS_FieldDB',\%::XMSFieldDB);
}

sub XMS_Admin {
	my @XMS_AdminFunctions = (
	['Settings', 'Change a wide variety of X MultiSubmit settings.', 'xms-settings'],
	['Page Profiles', 'Create, edit, or remove submit page profiles, which control the flavor of submit pages.', 'xms-prof']);
	@XMS_AdminFunctions = reverse(@XMS_AdminFunctions);
	$addon->pageHeader('X MultiSubmit', 1);
	PrintFunctionList(\@XMS_AdminFunctions, 'adminarea', 'action', 'admin');
	$addon->pageFooter();
}

sub XMS_Settings {
	$addon->pageHeader('MultiSubmit Settings',1);
	print StartForm({'action'=>'admin','adminarea'=>'xms-settings-save'});
	print $addon->settingTable('No description message',qq~<input name="nodescmsg" type="text" value="$CConfig{'xms_nodescmsg'}" style="width: 100%" width="100%">~, 'Text displayed in the description area of a submit page with no description.');
	my $options = '';

		foreach my $i('Edit Profile','Profile Listing'){
		$options .= qq~<option value="$i"~.($CConfig{'xms_afteradd'} eq $i?' selected':'').qq~>$i</option>~;
		}

	print $addon->settingTable('After adding profile goto',qq~<select name="afteradd" style="width: 100%" width="100%">$options</select>~, 'After adding a profile, go directly to the edit profile page or back to the profile listing.');
	my $profopt = '<option value="choose"' . ($CConfig{'xms_dissubnews'} eq 'choose' ? ' selected' : '') . '>(Choose a submit page menu)</option>' .
	'<option value="choose_and_links"' . ($CConfig{'xms_dissubnews'} eq 'choose_and_links' ? ' selected' : '') . '>(Choose a submit page menu WITH Main Page/Quick Menu links)</option>';

		foreach my $i(@XMS_Profs){
			if(exists $XMS_DB{$i}->{'Name'}){
			$profopt .= qq~<option value="$i"~ . ($CConfig{'xms_dissubnews'} eq $i ? ' selected' : '') . qq~>$XMS_DB{$i}->{'Name'} (id: $i)</option>~ unless $XMS_DB{$i}->{'Enabled'} eq '0';
			}
		}

	print $addon->settingTable('Direct "Submit News" page to', qq~<select name="dissubnews" style="width: 100%" width="100%"><option value="disabled">(Disabled)</option>$profopt</select>~, 'When you click on Coranto\'s Submit News link you will be directed to this Submit Page/Menu.');
	print $addon->settingTable('"Modify News" layout',qq~<div align=left><input type="radio" name="mnl" value="column"~.($CConfig{'xms_modifynewslayout'} eq 'column'?' checked':'').qq~> Creat a "Submit Page" column on the default Modify News page.<br>
	<input type="radio" name="mnl" value="links"~.($CConfig{'xms_modifynewslayout'} eq 'links'?' checked':'').qq~> List the Submit News pages on the "Modify News" page and have each item on the list link to news items submitted to that Submit News page.<br>
	<input type="radio" name="mnl" value=""~.($CConfig{'xms_modifynewslayout'} eq ''?' checked':'').'> Dont change a thing.</div>','Select how you want the "Modify News" page to look.');

	# PARAHEAD: Added option to sort the submit fields in two different ways (2005-01-11)
	$options = qq~<option value='news'~ . ($CConfig{'xms_fieldsort'} eq 'news' ? ' selected' : '') . qq~>The same as they are sorted at the News Fields page</option>~;
	$options .= qq~<option value='custom'~ . ($CConfig{'xms_fieldsort'} ne 'news' ? ' selected' : '') . qq~>In a customizable order per profile</option>~;
	print $addon->settingTable('Sort the submit fields for the XMS Profiles',qq~<select name="fieldsort" style="width: 100%" width="100%">$options</select>~, 'Sort the fields the exact same way as the fields are displayed at the Field Settings page or choose your own sorting.');

	# PARAHEAD: Added option to allow users to change submit page or not at the Modify News page (2005-09-03)
	$CConfig{'xms_modifysubmitpage'} = 'none' unless(defined($CConfig{'xms_modifysubmitpage'}));
	$options = qq~<option value='admin'~ . ($CConfig{'xms_modifysubmitpage'} eq 'admin' ? ' selected' : '') . qq~>Yes, allow admin to change submit page</option>~;
	$options .= qq~<option value='all'~ . ($CConfig{'xms_modifysubmitpage'} eq 'all' ? ' selected' : '') . qq~>Yes, allow all users to change submit page</option>~;
	$options .= qq~<option value='none'~ . ($CConfig{'xms_modifysubmitpage'} eq 'none' ? ' selected' : '') . qq~>No, disallow all users to change submit page</option>~;
	print $addon->settingTable('Allow modification of submit page for newsitems',qq~<select name="modifysubmitpage" style="width: 100%" width="100%">$options</select>~, 'Are users allowed to change the submit page a newsitem belongs to at the Modify News page.');

	# PARAHEAD: Added support for default assignment of Submit Page if no one is found for a newsitem (2.4.2)
	$options = '';
	foreach my $i(@XMS_Profs){
		if(exists $XMS_DB{$i}->{'Name'}){
			$options .= qq~<option value="$i"~ . ($CConfig{'xms_defprofile'} eq $i ? ' selected' : '') . qq~>$XMS_DB{$i}->{'Name'} (id: $i)</option>~ unless $XMS_DB{$i}->{'Enabled'} eq '0';
		}
	}
	print $addon->settingTable('Choose a default "Submit News" page', qq~<select name="defprofile" style="width: 100%" width="100%">$options</select>~, q~If a newsitem doesn't have a "Submit News" page applied to it, which page should be used when selecting the newsitem at the Modify News page? This setting is only useful if you install the XMS addon on a site where you have already submitted newsitems.~);

	print SubmitButton('Save Settings'),'</form>';
	$addon->pageFooter();
}

sub XMS_Settings_Save {
	&NeedCFG();

	$CConfig{'xms_nodescmsg'} = $in{'nodescmsg'};
	$CConfig{'xms_afteradd'} = $in{'afteradd'};
	$CConfig{'xms_dissubnews'} = $in{'dissubnews'};
	$CConfig{'xms_modifynewslayout'} = $in{'mnl'};
	$CConfig{'xms_fieldsort'} = $in{'fieldsort'};
	$CConfig{'xms_modifysubmitpage'} = $in{'modifysubmitpage'};
	$CConfig{'xms_defprofile'} = $in{'defprofile'};

	#&SaveCConfig();

	$addon->simplePage('Settings Saved',qq~Settings have been saved. Click ~.$addon->link({'action'=>'admin','adminarea'=>'xms-admin'}).'here</a> to go back.');exit;
}

sub XMS_Profiles {
	$addon->pageHeader('MultiSubmit Profiles',1);

	print q~<table width="80%" cellpadding="2" border="0" align="center"><tr><td class="midheader"><div align="center">
	Current X MultiSubmit Profiles</div></td></tr></table><br>~;

	my ($status, $actions);

		foreach my $i (@XMS_Profs){

			if(exists $XMS_DB{$i}->{'Name'}){
			$status = 'Main Page link is <b>'.($XMS_DB{$i}->{'MainPage'} ? 'on':'off').'</b>. Quick Menu link is <b>'.($XMS_DB{$i}->{'QuickLink'} ? 'on':'off').'</b>.';
# Parahead: The selected fields are now sorted numerically based on order (2004-10-05)
			$status .= '<br>Selected Fields: '.(join(', ',split(/\`\|\`/,$XMS_DB{$i}->{'Fields'}))?join(', ',sort { $XMSFieldDB{$i}->{$a} <=> $XMSFieldDB{$i}->{$b} } split(/\`\|\`/,$XMS_DB{$i}->{'Fields'})):'none'); 

				unless ($XMS_DB{$i}->{'Enabled'}){
				$status .= '<br>This profile is <b>Disabled</b>';
				}

			$actions = '['.$addon->link({'action'=>'admin','adminarea'=>'xms-prof-edit','profname'=>$i}).'Edit</a>] '.
			'['.$addon->link({'action'=>'admin','adminarea'=>'xms-prof-endisable','profname'=>$i}).($XMS_DB{$i}->{'Enabled'} eq '0' ? 'Enable':'Disable').'</a>] '.
			'[' . PageLink( {'action' => 'admin', 'adminarea' => 'xms-prof-moveupdown', 'profname' => $i, 'direction' => 1} ) . 'Move Up</a>] '.
			'[' . PageLink( {'action' => 'admin', 'adminarea' => 'xms-prof-moveupdown', 'profname' => $i, 'direction' => 2} ) . 'Move Down</a>] '.
			'['. $addon->link({'action'=>'admin','adminarea'=>'xms-prof-remove','profname'=>$i}).'Delete</a>]';
			print Tricolore(($XMS_DB{$i}->{'Name'}),$status,$actions);
			}

		}

	print MidHeading('Create New Profile'),StartForm({'action'=>'admin','adminarea'=>'xms-prof-add'}),q~
	<table width="80%" border="0" cellspacing="2" cellpadding="2" align="center"><tr><td class="fieldtitle" width="50%" valign="top"><div align="right">Profile Name:</div></td>
	<td width="50%"><input type="text" size="30" name="name" style="width: 100%" width="100%"></td></tr><tr><td colspan="2" class="description">
	<div align="center">X MultiSubmit Profile names are used to identify profiles.</div></td></tr></table><br>~,
	SubmitButton('Create Profile'),'</form>';
	$addon->pageFooter();
}
sub XMS_AddProf {
	NeedCFG();
	my %LoadediO;
	foreach my $i(@fieldDB_internalorder){ $LoadediO{$i} = $i; }

	unless($LoadediO{'xMultiSubmitSP'}){ 
		push(@fieldDB_internalorder,'xMultiSubmitSP');
		XMS_AddCSQLField() if $CConfig{'CorantoSQL_built'} eq 'yes';
		NeedFile('cradmin.pl');
	}

	my $id = int(rand(9999)).time();

		while($XMS_DB{$id}){
		$id = int(rand(9999)).time();
		}

	$XMS_DB{$id}->{'Name'} = $in{'name'};
	$XMS_DB{$id}->{'Enabled'} = 0;
	$XMS_DB{$id}->{'LockCats'} = 'Disabled';
	$XMS_DB{$id}->{'MainPage'} = 1;
	$XMS_DB{$id}->{'QuickLink'} = 1;
	$XMS_DB{$id}->{'XMS_Users'} = '(All)';
	
	XMS_SaveProf();
	$in{'profname'} = $id;
	
	push(@XMS_Profs, $id);
	SaveCRCFG();

	XMS_EditProfile() unless $CConfig{'xms_afteradd'} eq 'Profile Listing';
	XMS_Profiles();
}

sub XMS_EditProfile {
	NeedCFG();
	
	XMS_LoadFieldOrder();

	my $id = $in{'profname'};
	CRcough('You\'ve requested an invalid profile id.') unless $XMS_DB{$id};

	XMS_MoveUpDown('field',$in{'field-move'},$id,$in{'fieldid'}) if $in{'field-move'};
	$addon->pageHeader(qq~X MultiSubmit Settings for "$XMS_DB{$id}->{'Name'}"~,1);
	print StartForm({'action'=>'admin','adminarea'=>'xms-prof-save','profname'=>$id});
	my $profname = $in{'name'}?HTMLescape($in{'name'}):HTMLescape($XMS_DB{$id}->{'Name'});
	print $addon->settingTable('Profile Name',qq~<input name="name" type="text" value="$profname" style="width: 100%" width="100%">~, 'Name of this Page Profile (may appear on main page and/or quick menu).');
	my $profdesc = $in{'desc'}?HTMLescape($in{'desc'}):HTMLescape($XMS_DB{$id}->{'Description'});
	print $addon->settingTable('Profile Description',qq~<input name="desc" type="text" value="$profdesc" style="width: 100%" width="100%">~, 'Description of this Page Profile (may appear on main page).');
	my $profdispmp = (defined $in{'dispmp'})?HTMLescape($in{'dispmp'}):HTMLescape($XMS_DB{$id}->{'MainPage'});
	print $addon->settingTable('Display on Main Page?','<div align=left><input name="dispmp" type="checkbox" value="1"'.($profdispmp ?' checked':'').'></div>', q~Display Page Profile link on the Main Page? Please note that the XMS setting 'Direct "Submit News" page to' may override this option.~);
	my $profdispqm = (defined $in{'dispqm'})?HTMLescape($in{'dispqm'}):HTMLescape($XMS_DB{$id}->{'QuickLink'});
	print $addon->settingTable('Display on Quick Menu?','<div align=left><input name="dispqm" type="checkbox" value="1"'.($profdispqm ?' checked':'').'></div>', q~Display Page Profile link on the Quck Menu? Please note that the XMS setting 'Direct "Submit News" page to' may override this option.~);

	my (%LoadedAddons, %lockcatsel, $categorylocking);

	# PARAHEAD: Improved addon check using regexp (2005-01-18)
#	foreach my $i(split(/~/,$CConfig{'AddonsLoaded'})){ $LoadedAddons{$i} = $i; }
#	if($LoadedAddons{'cra_ncategory.pl'} or $LoadedAddons{'cra_tintinnabulum.pl'}){
	if($CConfig{'AddonsLoaded'} =~ /cra_ncategory\.pl/ or $CConfig{'AddonsLoaded'} =~ /cra_tintinnabulum\.pl/){
		
		$XMS_DB{$id}->{'LockCats'} = $in{'lockcats'} if(defined $in{'lockcats'});
		
		foreach my $i(split(/\`\|\`/,$XMS_DB{$id}->{'LockCats'})){ $lockcatsel{$i} = ' selected'; }
		my $catlockopts = '';

# PARAHEAD: Updated to sort the categories in alphabetical order (2004-10-05)
			foreach my $i(sort { uc $a cmp uc $b } (keys %newscategories)) {
				$CategoryName = $newscategories{$i}->{'FullName'} || $i;
				$catlockopts .= qq~<option value="$i"$lockcatsel{$i}>$CategoryName</option>~ unless $i eq '(default)';
			}

		$categorylocking = qq~<select name="lockcat" size="6" multiple style="width: 100%" width="100%">
		<option value="Disabled"$lockcatsel{'Disabled'}>(Disabled)</option>
		<option value="AllCategories"$lockcatsel{'AllCategories'}>(All Categories)</option>
		<option value="(default)"$lockcatsel{'(default)'}>(Default Category)</option>$catlockopts</select>~;

		print $addon->settingTable('Category Locking',$categorylocking?$categorylocking:'Please install the News Categories addon.',"Allows a category to be statically assigned to a Page Profile. Multiple selections are allowed: to make multiple selections, Windows users hold down CTRL, Mac users hold down Option, most UNIX users hold down CTRL, users of other operating systems see your browser's help. If you do make multiple selections, the user will get to choose which one they want to submit to.");
	}

	print MidHeading('Submit Fields');

	my $orderrow = '';
	my $fieldslisting = '';
	my (%fldchk, @fDb);

	$XMS_DB{$id}->{'Fields'} = $in{'fields'} if(defined $in{'fields'});
	if($CConfig{'xms_fieldsort'} ne 'news') {
# PARAHEAD: Now sorting the checked fields according to the same order as at the Edit Fields page (2004-10-02) 
		foreach my $i(sort { $XMSFieldDB{$id}->{$a} <=> $XMSFieldDB{$id}->{$b} } split(/\`\|\`/,$XMS_DB{$id}->{'Fields'})){ 
			push(@fDb,$i);
			$fldchk{$i} = ' checked';
		}

# PARAHEAD: Now sorting the unchecked fields alphabetically (2004-10-02) 
		foreach my $i( sort {uc $fieldDB{$a}->{'DisplayName'} cmp uc $fieldDB{$b}->{'DisplayName'} } @fieldDB) {
			push(@fDb,$i) unless $fldchk{$i};
		}
		
		$orderrow = '<th align=left>Order</th>';
	} else {
		# Sorting according to custom sort per profile
		foreach my $i(split(/\`\|\`/,$XMS_DB{$id}->{'Fields'})){
			$fldchk{$i} = ' checked';
		}

		@fDb = @fieldDB;
	}

#	$fieldslisting .= qq~<tr><th align=left></th><th align=left>Fieldname</th><th align=left>Order</th></tr>~;
	$fieldslisting .= qq~<tr><th align=left></th><th align=left>Fieldname</th>$orderrow</tr>~;
	foreach my $i(@fDb){
		unless ($i eq 'User' or $i eq 'newsid' or $i eq 'newstime'){
			$fieldslisting .= qq~<tr><td align=left><input type="checkbox" name="field_$i" value="1"$fldchk{$i}></td>~;
			$fieldslisting .= qq~<td>$fieldDB{$i}->{'DisplayName'}</td>~;
			$XMSFieldDB{$id}->{$i} = $in{"XMSOrder_$i"} if(defined $in{"XMSOrder_$i"});
			$fieldslisting .= qq~<td><input type="text" size="2" name="XMSOrder_$i" value="$XMSFieldDB{$id}->{$i}"></td>~ if($fldchk{$i} && ($CConfig{'xms_fieldsort'} ne 'news'));
			$fieldslisting .= qq~</tr>~;
		}
	}

	# PARAHEAD: Only show this message when it is needed (2005-09-03)
	my $orderColumnMsg = ($CConfig{'xms_fieldsort'} eq 'news') ? '':' In the order column, enter a number for each of the fields to control the order they appear on the submit page.';

	print $addon->settingTable('Fields',"<table border=0 cellpadding=1 cellspacing=2 width=100%>$fieldslisting</table>",
		"Check the fields that should be displayed on this submit page.$orderColumnMsg");


	# PARAHEAD: Added custom Subject handling for each Submit Page at the Modify News page (2005-09-03)
	print MidHeading('Modify News Subject');
	my $profsubject = $in{'modifynewssubject'}?$in{'modifynewssubject'}:$XMS_DB{$id}->{'ModifyNewsSubjectRaw'};
    print $addon->settingTable('Style for the Modify News Subject',qq~<textarea name="modifynewssubject" wrap="virtual" style="width: 100%" width="100%" rows="10">$profsubject</textarea>~, 'Specify a custom Subject to use instead of the normal one at the Modify News page. By using normal styletags you can define your own Subject, which can be very handy if this Submit Page uses other (or more) fields than the Subject to uniquly identify it. You can use all the normal styletags, including If/Else-statements. <strong>Leave blank to use the normal Subject.</strong>');
    
	my $profsubjectlength = $in{'mnsubject_length'}?$in{'mnsubject_length'}:$XMS_DB{$id}->{'ModifyNewsSubjectLength'};
    print $addon->settingTable('Maximum Subject Length',qq~<input type="text" name="mnsubject_length" value="$profsubjectlength" style="width: 100%" width="100%">~, 'This field is only useful if you have defined a custom subject above. Specify the prefered maxlenght for the custom subject and if the maxlenght is reached, the subject will be snipped at the next word and three dots appended. <strong>Leave blank to use the default lenght of 45 characters.</strong>');
    
##########
# NEW REQUIRED FIELDS STUFF
##########

	my %RequiredFields;
	
	$XMS_DB{$id}->{'RequiredFields'} = $in{'reqfields'} if($in{'reqfields'});
	foreach my $i(split(/\`\|\`/,$XMS_DB{$id}->{'RequiredFields'})){
		$RequiredFields{$i} = 'selected';
	}

	my $fields_required = qq~<select name="RequiredFields" multiple>~;

# PARAHEAD: Now sorting the required fields according to the field order (2004-10-06) 
	foreach my $i(sort { $XMSFieldDB{$id}->{$a} <=> $XMSFieldDB{$id}->{$b} } split(/\`\|\`/,$XMS_DB{$id}->{'Fields'})){ 
		$fields_required .= qq~<option value="$i" $RequiredFields{$i}>$fieldDB{$i}->{'DisplayName'}</option>~;
	}

	$fields_required .= qq~</select>~;

	print MidHeading('Required Fields');
	print $addon->settingTable('Required Fields',"$fields_required",'Select the fields that must contain user input.');

##########
# END REQUIRED FIELDS STUFF
##########


	{
		&ReadUserDBInfo();

		# Get selected users into a hash
		my %selected_users = ();

		$XMS_DB{$id}->{'XMS_Users'} = $in{'users'} if($in{'users'});
		foreach my $i(split(/\`\|\`/,$XMS_DB{$id}->{'XMS_Users'})){
			$selected_users{$i} = 'selected';
		}

		my $userlist = qq~<select name="XMS_Users" multiple>~;

		$userlist .= qq~<option value="(All)" $selected_users{'(All)'}>(All)</option>~;

		foreach my $i (sort keys %userdata){
			$userlist .= qq~<option value="$i" $selected_users{$i}>$i</option>~;
		}

		$userlist .= qq~</select>~;

		print MidHeading('User Permissions');
		print $addon->settingTable('Users',"$userlist",'Select which users are allowed to post items using this submit page.');
	}

	# HOOK: XMS_EditProfile
	if($Addons{'XMS_EditProfile'}){my $w;foreach $w (@{$Addons{'XMS_EditProfile'}}){my $addon=$w->[2];eval ${$w->[0]};AErr($addon,$@)if $@;};}

	print SubmitButton('Save Settings'), '</form>';
	$addon->pageFooter();exit;
}


# PARAHEAD: Added Subject replacement feature (2005-09-03)
# Modify the Subject handling and add an extra addon hook in the sub ModifyNews
my $XMS_ModifyNewsSubject = << 'END_CODE';
	my $search = q~		if (length($Subject) > 50) {
			print SnipText($Subject, 45);
		}
		elsif (length($Subject) == 0) {
			print SnipText($Text, 45);
		}
		else {
			print $Subject;
		}~;
	my $replace = q~		my $NewsTitle;
		if (length($Subject) > 50) {
				$NewsTitle = SnipText($Subject, 45);
		}
		elsif (length($Subject) == 0) {
				$NewsTitle = SnipText($Text, 45);
		}
		else {
				$NewsTitle = $Subject;
		}

		# HOOK: ModifyNews_TitleColumn
		if($Addons{'ModifyNews_TitleColumn'}){my $w;foreach $w (@{$Addons{'ModifyNews_TitleColumn'}}){my $addon=$w->[2];eval ${$w->[0]};AErr($addon,$@)if $@;};}

		print $NewsTitle;~;
	$::Subs{'ModifyNews'} =~ s/\Q$search/$replace/g;
END_CODE

# Replace the Subject
my $XMS_ModifyNews_TitleColumn = << 'END_CODE';
	if(defined $XMS_DB{$xMultiSubmitSP}->{'ModifyNewsSubject'}) {
		$Subs{"XMSSubject_$xMultiSubmitSP"} = $XMS_DB{$xMultiSubmitSP}->{'ModifyNewsSubject'} unless(defined $Subs{"XMSSubject_$xMultiSubmitSP"});
		$NewsTitle = SnipText(&{"XMSSubject_$xMultiSubmitSP"}, $XMS_DB{$xMultiSubmitSP}->{'ModifyNewsSubjectLength'}?$XMS_DB{$xMultiSubmitSP}->{'ModifyNewsSubjectLength'}:45);
	}
END_CODE

# Modify the Subject handling and add an extra addon hook in the sub ModifyNews
# But only if that hook isn't there since before.
if( ($in{'action'} =~ /modify(-editsave)?$/) && ($::Subs{'ModifyNews'} !~ /HOOK: ModifyNews_TitleColumn/) ) {
	$addon->hook('EarlyHook', \$XMS_ModifyNewsSubject);
}
$addon->hook('ModifyNews_TitleColumn', \$XMS_ModifyNews_TitleColumn);










sub XMS_EditProfile_Save {
	my $addon = shift;

	&XMS_LoadFieldOrder();

	my $id = $in{'profname'};

	my (%prefield, @prefields, @fieldsout, %newfields, @RequiredFields, @XMSProfileErrors, %XMSOrder);

	foreach my $key (keys %in){
		if ($key =~ /^field_(.*)/) {
			push(@fieldsout,$1);
			$newfields{$1} = 1;
		}
	}

	foreach my $i(split(/\`\|\`/,$XMS_DB{$id}->{'Fields'})){
		push(@prefields,$i) if $in{"field_$i"};
		$prefield{$i} = $i;
	}

	foreach my $i(@fieldsout){
		push(@prefields,$i) unless $prefield{$i};
	}

	

	$XMS_DB{$id}->{'Name'} = $in{'name'};
	$XMS_DB{$id}->{'Description'} = $in{'desc'};
	$XMS_DB{$id}->{'MainPage'} = $in{'dispmp'};
	$XMS_DB{$id}->{'QuickLink'} = $in{'dispqm'};
	$XMS_DB{$id}->{'Fields'} = join('`|`',@prefields);

	# PARAHEAD: Remove fields that isn't selected to be included in this XMS profile (2.4.2)
	foreach my $i(split(/\|x\|/,$in{'RequiredFields'})){
		push(@RequiredFields,$i) if $newfields{$i};
	}
	$XMS_DB{$id}->{'RequiredFields'} = join('`|`',@RequiredFields);

	# PARAHEAD: Added support for a custom Subject for each Submit Page at the Modify News page (2005-09-03)
	$XMS_DB{$id}->{'ModifyNewsSubjectRaw'} = $in{'modifynewssubject'};
	$XMS_DB{$id}->{'ModifyNewsSubject'} = '';
	if($XMS_DB{$id}->{'ModifyNewsSubjectRaw'}) {
		my $perlstyle = StyletoPerl("XMSSubject_$id", $XMS_DB{$id}->{'ModifyNewsSubjectRaw'}); 
		eval $perlstyle; 
		if ($@) { 
		    my(@lines, $errorline, $formattedstyle); 
		    foreach $_ (split(/\n/, $perlstyle, 0)) { 
		        push @lines, HTMLescape($_) . "\n"; 
		    } 
		    ($errorline) = $@ =~ /\(eval \d+\) line (\d+)/; 
		    foreach $_ (0 .. $#lines) { 
		        $formattedstyle .= sprintf('%s% 4d: %s', $_ + 1 == $errorline ? '=>' : '  ', $_ + 1, $lines[$_]); 
		    } 
		    push(@XMSProfileErrors, 'The custom subject is invalid and has a syntax error. Check, in particular, that all ifs are properly matched and ended. Perl reported the following error, which may or may not be helpful: ' . "<i>$@</i><br><br><div align='left'><pre>$formattedstyle</pre></div>"); 
		} 
		$XMS_DB{$id}->{'ModifyNewsSubject'} = $perlstyle;
	}
	
	# PARAHEAD: Added check for numeric value in the subject length field (2005-09-05)	
    push(@XMSProfileErrors, 'The length of the subject must be a numeric value') if( $in{'mnsubject_length'} && $in{'mnsubject_length'} !~ m/^\d+$/);
	
	$XMS_DB{$id}->{'ModifyNewsSubjectLength'} = $in{'mnsubject_length'};
	# PARAHEAD: End subject support
	
	
	$in{'XMS_Users'} =~ s/\|x\|/\`\|\`/gi;

# PARAHEAD: Now it is possible to sort either in a custom way or as the fields are displayed at the Edit Fields page. (2005-01-11)	
	if($CConfig{'xms_fieldsort'} ne 'news') {
		my $maxorder = 0;
		foreach my $i (keys %in){
			if ($i =~ /^XMSOrder_(.*)/){
				my $field = $1;
    push(@XMSProfileErrors, "The sorting value for '$field' must be a numeric value") if( $in{$i} && $in{$i} !~ m/^\d+$/);
				$XMSOrder{$i} = $in{$i};				
				$XMSFieldDB{$id}->{$field} = $in{$i};
				delete $newfields{$field};
				$maxorder = $in{$i} if($in{$i} > $maxorder);
			}
		}

# PARAHEAD: Appending new fields to the end of the existing fields in alphabetical order (2004-10-03)
		foreach my $i( sort {uc $fieldDB{$a}->{'DisplayName'} cmp uc $fieldDB{$b}->{'DisplayName'} } keys %newfields) {
			$XMSFieldDB{$id}->{$i} = ++$maxorder;
		}

		# PARAHEAD: Added automatical renumbering (incrementation by 10) for each field (2004-10-02)
		my $n = 0;
		foreach my $i (sort { $XMSFieldDB{$id}->{$a} <=> $XMSFieldDB{$id}->{$b} } @fieldsout) { 
			$XMSFieldDB{$id}->{$i} = ($n += 10); 
		}
	
	} else {
		my $n = 0;
		foreach my $key (@fieldDB) {
			if ($in{"field_$key"}) {
				$XMSFieldDB{$id}->{$key} = ($n += 10);
			}
		}
	}
	
				
		
	if($in{'lockcat'}){
		my @LockCats = split(/\|x\|/,$in{'lockcat'});
		my %LockCat;
		
		foreach my $i(@LockCats){
			$LockCat{$i} = $i;
		}

	    push(@XMSProfileErrors, 'You cannot disable Category Locking <strong>and</strong> select categories at the same time.') if scalar(@LockCats) > 1 and $LockCat{'Disabled'};
	    push(@XMSProfileErrors, 'If you select All Categories you cannot select other categories.') if scalar(@LockCats) > 1 and $LockCat{'AllCategories'};
	    push(@XMSProfileErrors, 'If you select All Categories you cannot select other categories.') if scalar(@LockCats) > 1 and $LockCat{'(All)'};
		$XMS_DB{$id}->{'LockCats'} = join('`|`',@LockCats);
	}

	if ($in{'XMS_Users'}){
	my @Users = split(/\`\|\`/,$in{'XMS_Users'});
	my %Users;

		foreach my $i(@Users){
		$Users{$i} = $i;
		}

		if (scalar(@Users) > 1 && $Users{'(All)'}){
			push(@XMSProfileErrors, 'If you select (All) users, you cannot select other users.');
		}

		$XMS_DB{$id}->{'XMS_Users'} = $in{'XMS_Users'};
	}
	

	# HOOK: XMS_EditProfile_Save
	if($Addons{'XMS_EditProfile_Save'}){my $w;foreach $w (@{$Addons{'XMS_EditProfile_Save'}}){my $addon=$w->[2];eval ${$w->[0]};AErr($addon,$@)if $@;};}

	
	if(@XMSProfileErrors) {
		my $hidden_fields = {'action' => 'admin',
			'adminarea' => 'xms-prof-edit',
			'profname' => $id,
			'name' => "$in{name}",
		 	'desc' => "$in{'desc'}",
		 	'dispmp' => $in{'dispmp'}?1:0,
		 	'dispqm' => $in{'dispqm'}?1:0,
		 	'modifynewssubject' => "$in{modifynewssubject}",
		 	'mnsubject_length' => "$in{'mnsubject_length'}",
		 	'fields' => "$XMS_DB{$id}->{'Fields'}",
		 	'reqfields' => "$XMS_DB{$id}->{'RequiredFields'}",
			'lockcats' => "$XMS_DB{$id}->{'LockCats'}",
			'users' => "$XMS_DB{$id}->{'XMS_Users'}",
			%XMSOrder
		};
		
		my $backButton = StartForm($hidden_fields) . 
			qq~<div align="center"><input type="submit" class="inputsubmit" value="Back To Edit Profile '$XMS_DB{$id}->{'Name'}'"></div></form>~;

			my $errMsgs = '<ul>';
			foreach my $msg (@XMSProfileErrors) {
				$errMsgs .= "<li>$msg</li><br>";
			}
			$errMsgs .= '</ul>';
	    CRcough("$errMsgs$backButton", 1); 
	}
	
		    		
		
	XMS_SaveProf();
	XMS_SaveFieldOrder();

	XMS_Profiles();
	exit;
}

	
sub XMS_EnDisAble {
	my $id = $in{'profname'};
	CRcough('You\'ve requested an invalid profile id.') unless $XMS_DB{$id};

		if ($XMS_DB{$id}->{'Enabled'} == 0){
		$XMS_DB{$id}->{'Enabled'} = 1;
		}
		else {
		$XMS_DB{$id}->{'Enabled'} = 0;
		}

	XMS_SaveProf();
	XMS_Profiles();
}

sub XMS_RemoveProf {
	&NeedCFG();
	
	XMS_LoadFieldOrder();

	my $id = $in{'profname'};
	CRcough('You\'ve requested an invalid profile id.') unless $XMS_DB{$id};
	AreYouSure("Are you sure you want to remove the profile <b>$XMS_DB{$id}->{'Name'}</b>? Deleting a profile ERASES ALL its data.") unless $in{'really'};
	my $count = 0;

	delete $CConfig{"Prof-$id"};
	delete $CConfig{"XMSFieldDB-$id"};
	delete $XMS_DB{$id};
	delete $XMSFieldDB{$id};

	XMS_SaveProf();
	XMS_SaveFieldOrder();
	
	{
		my @newarray = ();
		
		foreach my $profile(@XMS_Profs){
			unless ($profile eq $id){
			push(@newarray, $profile);
			}
		}
		@XMS_Profs = @newarray;
	}
	
	&SaveCRCFG();

	XMS_Profiles();
}

sub XMS_AddCSQLField {
	my ($corantosql_dbh, $sql_add_field);
	$corantosql_dbh = CorantoSQL_connectdb();
	eval {
		$sql_add_field = "ALTER TABLE $CConfig{'CorantoSQL_tblname'} ADD xMultiSubmitSP VARCHAR(255) null\;";
		$corantosql_dbh->do($sql_add_field);
	};
	CRcough("Could not add field xMultiSubmitSP to the cSQL table. Reason: $@") if $@;
	$corantosql_dbh->disconnect();
}

sub XMS_HookSubNewsDirect {
	LoadFunctionList();
	if ($CConfig{'xms_dissubnews'} eq 'choose' or $CConfig{'xms_dissubnews'} eq 'choose_and_links') {

		&ReadUserDBInfo();

		$addon->pageHeader('Choose a submit page');

		foreach my $i (@XMS_Profs){
			if ($XMS_DB{$i}->{'Enabled'} == 1 && exists $XMS_DB{$i}->{'Name'} && ($xms_selected_users{$i}->{$CurrentUser} || $xms_selected_users{$i}->{'(All)'} || $up > 2)){
# PARAHEAD: Added check to see if the current user is allowed to post into this Submit Page depending on the Category (2.4.2)
				push(@XMS_SubmitPages, [$XMS_DB{$i}->{'Name'}, $XMS_DB{$i}->{'Description'} ? $XMS_DB{$i}->{'Description'} : $CConfig{'xms_nodescmsg'}, $i] ) if(XMS_CheckPermission($i));
			}
		}

		@XMS_SubmitPages = reverse(@XMS_SubmitPages);
		PrintFunctionList(\@XMS_SubmitPages, 'profname', 'action', 'xms-submit');
		$addon->pageFooter();
		exit;
	} else {
	  	$in{'profname'} = $CConfig{'xms_dissubnews'};
		XMS_Submit();
		exit;
	}
}

sub XMS_HookSubCRHTMLHead_UserBar {
	print ' | back to ' . $addon->link({'action'=>'admin','adminarea'=>'xms-admin'}) . 'X MultiSubmit</a>' if $in{'action'} eq 'admin' and $in{'adminarea'} =~ /^xms/ and $in{'adminarea'} ne 'xms-admin';
}

sub XMS_HookSubNewsSave_1 {
	my %LoadediO;
	foreach my $i(@fieldDB_internalorder){ $LoadediO{$i} = $i; }
	unless($LoadediO{'xMultiSubmitSP'}){ 
		push(@fieldDB_internalorder,'xMultiSubmitSP');
		XMS_AddCSQLField() if $CConfig{'CorantoSQL_built'} eq 'yes';
		NeedFile('cradmin.pl');
		SaveCRCFG();
	}
	$::xMultiSubmitSP = $in{'xMultiSubmitSP'};
}

sub XMS_HookSubModifyNews_Edit_TopRow {

	# PARAHEAD: Added support for default assignment of Submit Page if no one is found for this newsitem (2.4.2)
	$::xMultiSubmitSP = $CConfig{'xms_defprofile'} unless(defined $::xMultiSubmitSP);
	
	my $id = $::xMultiSubmitSP;

	# Load Field Order hashes
	&XMS_LoadFieldOrder();

	# This is where the sorted fields will be stored
	local %::xms_hash = ();

	# Loop through the field list for this profile

	
	# PARAHEAD: Added support for two different field sorting at the modify news page (2005-02-20)
	if($CConfig{'xms_fieldsort'} eq 'news') {
		# Use the same sorting for the fields as at the News Fields page
		my $n = 1;
		my %XMS_SelectedFields =  ();
		foreach (split(/`\|`/,$XMS_DB{$id}->{'Fields'})) {
			$XMS_SelectedFields{$_} = 1;
		}

		foreach my $i(@fieldDB) {
			if($XMS_SelectedFields{$i}) {
				# Set value in real hash... format: field => order number
				$XMSFieldDB{$id}->{$i} = $n++;
				$xms_hash{$i} = $XMSFieldDB{$id}->{$i};
			}
		}
	} else {
		# Use the custom sorting specified at the XMS Profile page
		foreach my $i(split(/\`\|\`/,$XMS_DB{$id}->{'Fields'})){
		# Set value in real hash... format: field => order number
			$xms_hash{$i} = $XMSFieldDB{$id}->{$i};
		}
	}

	&ReadUserDBInfo();

	@fieldDB = sort XMS_SortSubmitFields (keys (%xms_hash)) if $::xMultiSubmitSP;

	my $submitpageopts;
	foreach my $i (@XMS_Profs) {
		if (exists $XMS_DB{$i}->{'Name'} && ($xms_selected_users{$i}->{$CurrentUser} || $xms_selected_users{$i}->{'(All)'} || $up > 2)){
		$submitpageopts .= qq~<option value="$i"~ . ($::xMultiSubmitSP eq $i ? ' selected' : '') . qq~>$XMS_DB{$i}->{'Name'}</option>~ if $XMS_DB{$i}->{'Enabled'};
		}
	}
	
	if($CConfig{'xms_modifysubmitpage'} eq 'all') {
		print $addon->fieldsTableRow('Submit Page', qq~<select name="xMultiSubmitSP"><option value="">(none)</option>$submitpageopts</select>~);
	} elsif($CConfig{'xms_modifysubmitpage'} eq 'admin' && $up == 3) {
		print $addon->fieldsTableRow('Submit Page', qq~<select name="xMultiSubmitSP"><option value="">(none)</option>$submitpageopts</select>~);
	} else {
		print $addon->fieldsTableRow('Submit Page', qq~$XMS_DB{$::xMultiSubmitSP}->{'Name'}<input name="xMultiSubmitSP" type="hidden" value="$::xMultiSubmitSP">~);
	}
	
}

#######################################

sub XMS_Submit {

	{
	my $id = $in{'profname'};
	&ReadUserDBInfo();

		# Get selected users into a hash
		my %selected_users = ();

		foreach my $i(split(/\`\|\`/,$XMS_DB{$id}->{'XMS_Users'})){
		$selected_users{$i} = 1;
		}

		unless ($selected_users{$CurrentUser} || $selected_users{'(All)'} || $up > 2){
		&CRcough("You do not have permission to access this submit page!");
		}		
	}
	 
my $xms_submit_code = <<'END_CODE';

	my $id = $in{'profname'};

	# Load Profile and Field Order hashes
	&XMS_LoadFieldOrder();

	# This is where the sorted fields will be stored
	local %::xms_hash = ();


	# PARAHEAD: Added support for two different field sorting (2005-01-11)
	if($CConfig{'xms_fieldsort'} eq 'news') {
		# Use the same sorting for the fields as at the News Fields page
		my $n = 1;
		my %XMS_SelectedFields =  ();
		foreach (split(/`\|`/,$XMS_DB{$id}->{'Fields'})) {
			$XMS_SelectedFields{$_} = 1;
		}

		foreach my $i(@fieldDB) {
			if($XMS_SelectedFields{$i}) {
				# Set value in real hash... format: field => order number
				$XMSFieldDB{$id}->{$i} = $n++;
				$xms_hash{$i} = $XMSFieldDB{$id}->{$i};
			}
		}
	} else {
		# Use the custom sorting specified at the XMS Profile page
		foreach my $i(split(/\`\|\`/,$XMS_DB{$id}->{'Fields'})){
		# Set value in real hash... format: field => order number
			$xms_hash{$i} = $XMSFieldDB{$id}->{$i};
		}
	}

	# Now the real hash has been setup.... Start looping as per usual

	foreach $fn (sort XMS_SortSubmitFields (keys (%xms_hash)))
	#print qq~$fn is $xms_hash{$fn}~;

END_CODE

$Subs{DisplaySubForm} =~ s/(NeedCFG\(\);)/my \$profname = \$in{profname};CRcough('You\\'ve requested an invalid profile id.') unless \$XMS_DB{\$profname};$1/;
$Subs{DisplaySubForm} =~ s/\$Messages\{'Section_Submit'\}/\$XMS_DB{\$profname}->{Name}/;
$Subs{DisplaySubForm} =~ s/(\{'action' => 'submitsave')/$1, 'xMultiSubmitSP' => \$profname/;
#$Subs{DisplaySubForm} =~ s!# HOOK: DisplaySubForm_TopRow[\s\S]+?;\}!if(\$Addons{DisplaySubForm_TopRow}){for my \$w (\@{\$Addons{DisplaySubForm_TopRow}}){my \$addon=\$w->[2];if((\$addon->{file} =~ /cra_ncategory\.pl/ or \$addon->{file} =~ /cra_tintinnabulum\.pl/) and \$XMS_DB->{\$profname}->{LockCats} ne 'Disabled' and \$XMS_DB{\$profname}->{LockCats} ne 'AllCategories'){my \@LockCats = split(/\\`\\|\\`/, \$XMS_DB{\$profname}->{LockCats});my \$catopts = join '', map { qq~<option value="\$_">\$_</option>~ } \@LockCats;print FieldsRow('Category', ( \@LockCats > 1 ? qq~<select name="Category"~ . ( \$addon->{file} =~ /cra_tintinnabulum\.pl/ ? ' multiple' : '' ) . qq~>\$catopts</select>~ : qq~\$LockCats[0]<input name="Category" type="hidden" value="\$LockCats[0]">~));}else{eval \${\$w->[0]};AErr(\$addon,\$\@)if \$\@;};}!;
$Subs{DisplaySubForm} =~ s!# HOOK: DisplaySubForm_TopRow[\s\S]+?;\}!if(\$Addons{DisplaySubForm_TopRow}){for my \$w (\@{\$Addons{DisplaySubForm_TopRow}}){my \$addon=\$w->[2];if((\$addon->{file} =~ /cra_ncategory\.pl/ or \$addon->{file} =~ /cra_tintinnabulum\.pl/) and \$::XMS_DB{\$profname}->{LockCats} ne 'Disabled' and \$XMS_DB{\$profname}->{LockCats} ne 'AllCategories'){ XMS_GetCatSelect(\$addon, \$profname, '(default)'); }else{eval \${\$w->[0]};AErr(\$addon,\$\@)if \$\@;};}!;

$Subs{DisplaySubForm} =~ s!foreach \$fn \(\@fieldDB\)!$xms_submit_code!;

#print qq~<!-- $Subs{DisplaySubForm} -->~;

&DisplaySubForm;
}

# PARAHAD: New handling of category at the Submit News and Modify News page (2005-09-03)
# Only the categories that the user has access to (in this Submit Page!) are presented to him.
sub XMS_GetCatSelect {
	# PARAHEAD: Now using $selectd variable, category lost focus at modify news page (Fix in 2.4.1)
	my ($addon, $profname, $selected) = @_;

	my @LockCats = split(/\`\|\`/, $XMS_DB{$profname}->{LockCats});
	
	my ($prevCat, $catopts, @FilterLockCats, $catName);
	for my $cats ( @LockCats ) {
		# PARAHEAD: Now taking into account the change in the NewsCategory addon from build 10. (2.4.2)
		my $xmsCats = $NC_Permission{$cats}?$NC_Permission{$cats}:$newscategories{$cats};
		if ($xmsCats->{'(AllUsers)'} || # The category is open to all
			($xmsCats->{'(High)'} && $up == 2) || # The category is open to High levelers
			$xmsCats->{$CurrentUser} || # This user has been granted permission
			$up == 3) { # User is an admin
			$prevCat = 1 if ($Category eq $cats);
			$catName = $newscategories{$cats}->{'FullName'} || $cats;
			$catopts .= qq~<option value="$cats"~ . ($cats eq $selected ? ' selected' : '') . ">$catName</option>";
			push @FilterLockCats, $cats;
		}
	}

	# Make sure a category the user has selected at submit news is presented at the modify news page
	push (@FilterLockCats, $Category) if($Category && !$prevCat);
		
	if( scalar @FilterLockCats > 1 )
	{
		print FieldsRow('Category', qq~<select name="Category"~ . ( $addon->{file} =~ /cra_tintinnabulum\.pl/ ? ' multiple' : '' ) . qq~>$catopts</select>~);
	} elsif( scalar @FilterLockCats == 1 ) {
		$catName = $newscategories{$FilterLockCats[0]}->{'FullName'} || $FilterLockCats[0];
		print FieldsRow('Category', qq~$catName<input name="Category" type="hidden" value="$FilterLockCats[0]">~);
	} else {
#		$addon->minorError("You are not authorized to any category.");
	}
}

$Subs{ModifyNews_Edit} =~ s!# HOOK: ModifyNews_Edit_TopRow[\s\S]+?;\}!if(\$Addons{ModifyNews_Edit_TopRow}){for my \$w (\@{\$Addons{ModifyNews_Edit_TopRow}}){my \$addon=\$w->[2];if((\$addon->{file} =~ /cra_ncategory\.pl/ or \$addon->{file} =~ /cra_tintinnabulum\.pl/) and \$XMS_DB->{\$profname}->{LockCats} ne 'Disabled' and \$XMS_DB{\$profname}->{LockCats} ne 'AllCategories'){ XMS_GetCatSelect(\$addon, \$xMultiSubmitSP, \$Category); }else{eval \${\$w->[0]};AErr(\$addon,\$\@)if \$\@;};}!;


sub XMS_SortSubmitFields {
   $xms_hash{$a} <=> $xms_hash{$b};
}

#########################################


sub XMS_CheckRequiredFields {
&NeedCFG();

my $id = $in{'xMultiSubmitSP'};
my $cough;

	if ($XMS_DB{$id}->{'RequiredFields'}){
		foreach my $field(split(/\`\|\`/,$XMS_DB{$id}->{'RequiredFields'})){
			if ($in{$field} eq ""){
			$cough .= qq~$fieldDB{$field}->{'DisplayName'}<br>~;
			}
		}

		if ($cough){
		$addon->simplePage("Required Fields", "The following fields are required:<br><br> <b>$cough</b><br>Please go back and try again.");
		exit;
		}
	}
}

########################################
# UPGRADE FROM XMS 1.9x
########################################

sub XMS_AutoUpgrade {
&NeedCFG();
&XMS_LoadProf();
&XMS_LoadFieldOrder();

my @XMS_ProfDatFields = qw(XMS_Id XMS_Name XMS_Desc XMS_Fields XMS_EnDisAbled XMS_LockCats XMS_DispMP XMS_DispQM); # DONT EDIT THIS!!

		foreach my $prof (split(/\|x\|/,$CConfig{'XMS_Prof'})){
		my ($XMS_Id,$XMS_Name,$XMS_Desc,$XMS_Fields,$XMS_EnDisabled,$XMS_LockCats,$XMS_DispMP,$XMS_DispQM) = split(/\!x\!/, $prof);
		#print qq~<p>Id is $XMS_Id</p>~;
		#print qq~<p>Fields are $XMS_Fields</p>~;


		$XMS_DB{$XMS_Id}->{'Name'} = $XMS_Name;
		$XMS_DB{$XMS_Id}->{'Description'} = $XMS_Desc;
		$XMS_DB{$XMS_Id}->{'Fields'} = $XMS_Fields;
		$XMS_DB{$XMS_Id}->{'Enabled'} = $XMS_EnDisabled;
		$XMS_DB{$XMS_Id}->{'LockCats'} = $XMS_LockCats;
		$XMS_DB{$XMS_Id}->{'MainPage'} = $XMS_DispMP;
		$XMS_DB{$XMS_Id}->{'QuickLink'} = $XMS_DispQM;
		$XMS_DB{$XMS_Id}->{'RequiredFields'} = '';

			{
			my $field_number = 1;

				foreach my $field(split(/\`\|\`/,$XMS_Fields)){
				$XMSFieldDB{$XMS_Id}->{$field} = $field_number;
				$field_number++;
				}

			}			
		}

&XMS_SaveProf();
&XMS_SaveFieldOrder();
}

########################################
# XMS CATEGORIES STUFF
########################################

my $EditProfDefinition_1 = <<'END_CODE';
	my %selectedxmscats;
	$newsprofiles{$prof}->{xmscats} = 'AllProfiles' unless $newsprofiles{$prof}->{xmscats};

	foreach my $i (split (/\(delim\)/, $newsprofiles{$prof}->{xmscats})) {
		$selectedxmscats{$i} = 'selected';
		#print qq~<p>$i</p>~;
	}
	my $catselect = '';

	
@XMS_Profs = sort {uc($XMS_DB{$a}->{'Name'}) cmp uc($XMS_DB{$b}->{'Name'})} @XMS_Profs;
	
	foreach my $i (@XMS_Profs) {
		$catselect .= qq~<option value="$i" $selectedxmscats{$i}>$XMS_DB{$i}->{'Name'}</option>~;
	}

	push(@EditProfileSettings,
	['xmscats', 'XMS Profiles', "Only news submited from selected XMS Profiles will be included in this profile. Multiple selections are allowed: to make multiple selections, Windows users hold down CTRL, Mac users hold down Option, most UNIX users hold down CTRL, users of other operating systems see your browser's help.",qq~<select name="xmscats" size="6" multiple><option value="AllProfiles" $selectedxmscats{'AllProfiles'}>(All Profiles)</option>$catselect</select>~]
	);
END_CODE

my $BuildNews_Filtering = <<'END_CODE';
	if (exists $newsprofiles{$i}->{xmscats} && $newsprofiles{$i}->{xmscats} ne ''){
	my (%ProfXMSCats);
		foreach my $j (split (/\(delim\)/, $newsprofiles{$i}->{'xmscats'})) {
		$ProfXMSCats{$j} = 1;
		}
		unless ($ProfXMSCats{$xMultiSubmitSP} || $ProfXMSCats{AllProfiles}) {
		next PROFLOOP;
		}
	}
# PARAHEAD: Now possible to use <Field: XMS_Profile> in a style (2004-10-05)
	$XMS_Profile = $XMS_DB{$xMultiSubmitSP}->{'Name'};
END_CODE


my $BuildNews_Filtered = <<'END_CODE';
# PARAHEAD: Now possible to use <Field: XMS_Profile> in a style used by a profile with different sort (2005-10-16)
	$XMS_Profile = $XMS_DB{$xMultiSubmitSP}->{'Name'};
END_CODE


my $InitActiveProfiles_2 = <<'END_CODE';
		foreach my $i (keys %newsprofiles) {
			if ($i =~ /-headlines$/){
				# so we know it's a headline, so we know we need to add the xmscats
				my $profname = substr ($i, 0, (length $i) - 10);
				$newsprofiles{$i}->{'xmscats'} = $newsprofiles{$profname}->{'xmscats'};
			}
		}
END_CODE

$addon->hook('EditProfDefinition_1', \$EditProfDefinition_1, 3);
$addon->hook('InitActiveProfiles_2', \$InitActiveProfiles_2);
$addon->hook('BuildNews_Filtering', \$BuildNews_Filtering);
$addon->hook('BuildNews_Filtered', \$BuildNews_Filtered);


########################################
# CustomFields page
########################################

# Add an extra addon hook in the sub RemoveNewsField
if ( ($in{'action'} eq 'admin') && ($up == 3) ) {
	NeedFile('cradmin.pl');
	$search = q~AreYouSure~;
	$replace = q~if($Addons{'RemoveNewsField_AreYouSure'}){my $w;foreach $w (@{$Addons{'RemoveNewsField_AreYouSure'}}){my $addon=$w->[2];eval ${$w->[0]};AErr($addon,$@)if $@;};}
	AreYouSure~;
	$::Subs{'RemoveNewsField'} =~ s/\Q$search/$replace/g;

my $RemoveNewsField_AreYouSure = << 'END_CODE';
	my @field_in_xms;
	foreach my $id (@XMS_Profs){
		foreach my $i(split(/\`\|\`/,$XMS_DB{$id}->{'Fields'})){
			push(@field_in_xms, qq~<b>'$XMS_DB{$id}->{'Name'}'</b>~) if($fieldname eq $i);
		}
	}
	
	if(@field_in_xms and !$in{'really'}) {
		my $xms_names = '';
		if(@field_in_xms == 1) {
			$xms_names = " $field_in_xms[0]";
		} elsif(@field_in_xms) {
			my $and_prof = pop @field_in_xms;
			$xms_names = "s " . join(', ',@field_in_xms) . " and " . $and_prof;
		}
		AreYouSure("Are you sure that you want to delete field &quot;$fieldname&quot;?<br>The field is currently in use on the XMS page$xms_names and any data that has been stored in this field will be deleted!") unless($in{'really'});
	}
END_CODE
$addon->hook('RemoveNewsField_AreYouSure', \$RemoveNewsField_AreYouSure);


my $RemoveNewsField_Internal = << 'END_CODE';
	&XMS_LoadFieldOrder();
	
	foreach my $id (@XMS_Profs){
		my @field_in_xms = ();
		foreach my $i(split(/\`\|\`/,$XMS_DB{$id}->{'Fields'})){
			push(@field_in_xms, $i) unless($fieldname eq $i);
			delete $XMSFieldDB{$id}->{$i} if($fieldname eq $i);
		}
		$XMS_DB{$id}->{'Fields'} = join('`|`',@field_in_xms);
	}
		
	&XMS_SaveProf();
	&XMS_SaveFieldOrder();
END_CODE
$addon->hook('RemoveNewsField_Internal', \$RemoveNewsField_Internal);

}





1;
__END__
=head1 X MultiSubmit

=head2 INTRODUCTION

After enabling the addon, you can create custom "submit news" pages, where only the news fields
of your choice are presented. This is done through the 'X Multisubmit' link found at the
Administration page, where you also can change some general settings.

It is possible to specify which categories that a certain submit page should post into, which
fields should be presented to the submitter and which fields should be required to fill out.
You can sort the fields in any order you would like to, either determain the sorting individually
at each XMS Profile or use the same sorting as used at the Edit News Fields overview page. 

=head3 PROFILES

When the addon is enabled a new multiple selection box appears at each Profile Settings
page where you can specify to only include newsitems posted through a specific XMS page.
This option works very much the same as the category option available if you have the
News Categories addon enabled and can to some extent actually replace the need of that addon.

=head3 STYLES

In a Style you can use <Field: XMS_Profile> to present the display name of the XMS Profile
that was used when the newsitem was submitted.

=head2 INSTALLING XMS WHERE OLD NEWS EXISTS

If you install and enable the X MultiSubmit addon in a Coranto installation where you already have
posted a bunch of newsitems you may experience a problem when trying to edit these newsitems.
This is caused by the fact that they wasn't assigned to a Submit Page when submitted, but
there is a remedy. On the XMS Settings page, you have an option labeled
'Choose a default "Submit News" page', which you should do.

I would suggest creating a Submit News page which contains all the newsfields and use that
page as the default Submit News page. Remember to set the 'Allow modification of submit page for
newsitems' setting to an option so that you can alter the submit page and then assign
each newsitem to the desired Submit Page once you edit an old newsitem.

=head2 NOTE TO FUTURE AUTHORS

This addon was first developed by L0rdphi1 but was made Open Source in late 2004
and is now distributed under the GNU General Public License.
This means that it cannot be rewritten or reinterpreted, in whole or in part,
to become part of any commercial or proprietary product or offering. 
Future authors should update the version history (included in the distribution package)
on each upgrade and state which improvement or modification that has been done.

