#! CRADDON 1
#! NAME Weblogs.com Notifier
#! DESCRIPTION Automatically notify weblogs.com when you post a new item!
#! VERSION 1.0

#use strict;
#use vars qw(%newsprofiles);

my $addon = Addon->new('Weblogs.com Notifier');

	eval {
	# Simple way to make it work with ALL versions of coranto
	# Versions with privacy support will work fine
	# And older copies will still work too!
	$addon->isPrivacyCompatible();
	};
	if ($@){}

##########################################################################

my $WeblogsCom_Settings = <<'END_CODE';

	{
		# Check to see if the old weblogs.com addon ( MyEyes ) was previously used by this profile, if so, import its settings!
		if ($newsprofiles{$prof}->{'myeyes_url'} && $newsprofiles{$prof}->{'myeyes_url'}){
		$newsprofiles{$prof}->{'WeblogsCom_URL'} ||= $newsprofiles{$prof}->{'myeyes_url'};
		$newsprofiles{$prof}->{'WeblogsCom_Name'} ||= $newsprofiles{$prof}->{'myeyes_name'};
		}
	
	push(@EditProfileSettings, 
	['draw_line'],
	['heading: Weblogs.Com Notification'],
	['WeblogsCom_Enable', 'Enable', "Assuming you have the below info filled in correctly, whenever you post any news using this profile, it will send a notice to weblogs.com that you have updated your site.", 'yn'],
	['WeblogsCom_URL', 'Page Location', "The full url (<b>http://</b>www.yoursite.com/cheese.html) to the page where the news in this profile will appear."],
	['WeblogsCom_Name', 'Page Name', "The name of this site, as you'd like it to appear on weblogs.com"],);

	}

END_CODE

$addon->hook('EditProfDefinition_2', \$WeblogsCom_Settings, -5);
$addon->hook('EditProfDefinition_PPStaticProfile', \$WeblogsCom_Settings, -5);

############################################################################

sub WeblogsCom_Notify {
&NeedCFG();
&ReadProfileInfo();

eval {
# Place require IO::Socket call here
use IO::Socket qw(:DEFAULT :crlf);
};
if ($@){
$addon->fatalError("A module neccessary to use this addon, IO::Socket, could not be found. Please check with your system administrator about installing the libwww-perl module from cpan.org");
}

	foreach my $profile(sort keys %newsprofiles){
	my $time = time();

		if ($newsprofiles{$profile}->{'WeblogsCom_Enable'}){
		my $url = $newsprofiles{$profile}->{'WeblogsCom_URL'};
		my $name = $newsprofiles{$profile}->{'WeblogsCom_Name'};

		# Ping the server.
		my $response = &WeblogsCom_DoPing($name, $url);
		}

	}
}

sub WeblogsCom_DoPing($$){
my $name = shift;
my $url  = shift;

	if (!$name || !$url){
	return "(-1) : Invalid weblog name or url.  Please set both.";
	}

my $ret = "(-1) : Unknown error.";   # holds our return value

# This is the xml-rpc request
my $pingStr = qq~
	<?xml version="1.0"?>
	<methodCall>
	<methodName>weblogUpdates.ping</methodName>
	<params>
	<param><value>$name</value></param>
	<param><value>$url</value></param>
	</params>
	</methodCall>~;

# Connect to the weblogs server
my $remote = IO::Socket::INET->new(Proto    => "tcp",PeerAddr => "rpc.weblogs.com",PeerPort => "http(80)" );

	if ($remote){
	        $remote->autoflush(1); # No buffering

		# Send the ping
		print $remote "POST /RPC2 HTTP/1.0$CRLF";
		print $remote "User-Agent: HansKellner.com weblogUpdatesPing tool$CRLF";
		print $remote "Host: rcp.weblogs.com$CRLF";
		print $remote "Content-Type: text/xml$CRLF";
		print $remote "Content-length: " . length($pingStr) . "$CRLF$CRLF";
		print $remote $pingStr;

		# Read the response
		my $sockResp = "";

			while (<$remote>){
			$sockResp = $sockResp . $_;
			}

		close $remote; # Close the socket

		# The response is in XML.  Retrieve the return code and message.
		my $retCode = $sockResp;
		my $retMsg  = $sockResp;

		# Strip out the XML up to and after the flerror code.
		$retCode =~ s/.*<boolean>//si;
		$retCode =~ s/<\/boolean>.*//si;

		# Strip out the XML up to and after the message.
		$retMsg =~ s/.*<\/boolean>//si;
		$retMsg =~ s/.*<value>//si;
		$retMsg =~ s/<\/value>.*//si;

		$ret = "($retCode) : $retMsg";
	}
	else {
	$ret = "(-1) : Cannot connect to http daemon on 'rpc.weblogs.com'";
	}

return $ret;
}


$addon->hook('BuildNews_Post', 'WeblogsCom_Notify', -5);

1;