#! CRADDON 1
#! NAME Textile for Coranto
#! DESCRIPTION Adds standard Textile formatting for news fields.
#! VERSION 1.02
#! HOMEPAGE http://www.hestonliebowitz.com/
#! DOC 1

my $addon = Addon->new('Textile For Coranto');

$addon->checkBuild(29); 
if ($crcgiBuild>=32) { $addon->isPrivacyCompatible; }

# Try to include Text::Textile, otherwise throw an error
my $module = "Text::Textile";
eval "use $module";
$addon->minorError("Textile for Coranto could not locate the Text::Textile module. Please make sure you have properly uploaded the module (Text/Textile.pm) into the Coranto script directory.") if ($@);

NeedCFG();

# Register all the admin functions that are used by Textile
$addon->addAdvancedSettingHeading('Textile Settings');

$addon->addAdvancedSetting('textile_markup', 'Select Type of Markup','Textile can output markup in either HTML or XHTML format.', markup_html());

$addon->hook('Build_GetData', 'Textile_Process', 1);
$addon->hook('ViewNews_2', 'Textile_Process', 1);

sub Textile_Process {
	my $textile = new Text::Textile;
	
	#Set the Textile flavor
	if ($CConfig{"textile_markup"} eq "html") {
		$textile->flavor("html");
	}
	else { $textile->flavor("xhtml1"); }
	
	#Loop through all fields. If "useTextile" is set on a field, process it.
	foreach $field (@fieldDB) {
		if ($fieldDB{$field}->{"UseTextile"} == 1) {
			
			#Replace linebreaks with new lines
			my $br = ($CConfig{'XHTMLbr'} == 1)?'<br />':'<br>';
			$$field =~ s/$br/\n/go;
			
			#Actually process the field using Textile
			$$field = $textile->process($$field);
				#print $$field;
		}
	}
}

$addon->hook('NewsFieldEditDef_2', \<<'END_CODE');
	unless ($fieldtype > 2) {
	push(@NFEDef, ['UseTextile', 'Use Textile', 'Do you want to use Textile to process the input from this field?', 'yn']);
	}
END_CODE

sub markup_html {
	return qq~<select name="textile_markup"><option value="html"~ . ( $CConfig{'textile_markup'} eq 'html' ? ' selected' : '' ). qq~>HTML</option><option value="xhtml" ~ . ( $CConfig{'textile_markup'} eq 'xhtml' ? ' selected' : '' ). qq~>XHTML</option></select>~;
}

1;

__END__

=head1 Textile for Coranto

=head2 Introduction

This addon provides Textile processing on any single- or multi-line text field. It supports output in both HTML and XHTML format.

In short, Textile allows you to use very simple notation to acheive complicated formatting. For example, typing, "h1. Main Title" will result in the output, "<h1>Main Title</h1>". Furthermore, Textile automatically encloses paragraphs in <p></p> tags and removes unnecessary linebreaks (<br> or <br />) to give you clean, readable and valid markup as output. You can explore Textile in more detail here: http://www.textism.com/tools/textile/.

This addon does not actually change the news in newsdat.txt. It processes news on the fly when it is built.

=head2 Configuration

Textile for Coranto is designed to be as easy to implement as possible. There is only one main setting, and Textile processing is turned on or off for individual fields on their "Edit Field" page.

=head3 Set Output Type

On the "Change Settings" page, there is a new section called "Textile Settings." Use the setting in this section to set output as either HTML or XHTML. Set this to whatever is appropriate for your use.

=head3 Enable Per Field

When editing a single- or multi-line text field, there is a new setting called "Enable Textile?" This does exactly what it states. If this is set to "Yes," then all news in that particular field will be processed with Textile before being output. This should be pretty straightforward.

IMPORTANT: For Textile to function correctly, "Convert New Lines?" must be set to "Yes" for the field in question. It doesn't matter if "Enable HTML BR?" on the settings page is enabled or not. If "Convert New Lines?" is set to "No" Textile will not work as expected.

=head3 Dependencies

Textile for Coranto relies on the Text::Textile perl module. This module should have been distributed with the addon. Simply copy the "Text" directory from the distribution to your Coranto script directory. If you're reading this, then Text::Textile is probably already installed correctly.

=head2 Feedback

Any questions or comments about this addon should be directed to the Coranto Forums (http://coranto.gweilo.org/), so that everyone can benefit.

This addon was written by Gansos with much support from Parahead. Many thanks go to him for sharing his code and expertise.