#! CRADDON 1

#! NAME QueryFetcher

#! DESCRIPTION Fetch the querystring passed to a shtml-file if using viewnews.cgi from within that shtml-file

#! VERSION 0.2 (Build 3)

#! HOMEPAGE mailto:henrik@parahead.com">E-Mail Author</a>] [<a href="http://www.parahead.com/coranto/

#! DOC 1







# Will compile and work under use strict.

#use strict;



my $addon = Addon->new('QueryFetcher');



$::queryfetcher_build = 3;

$::queryfetcher_version = '0.2';



$addon->checkBuild(29); 

if ($crcgiBuild>=32){ $addon->isPrivacyCompatible; 

} 





my $QueryFetcher_ViewNews_If = <<'END_CODE';

	my ($url, $query_string) = split(/\?/, $ENV{'REQUEST_URI'});



	return unless($query_string && !$ENV{'QUERY_STRING'});



	my @buffer;

	for my $pair ( split /[&;]/, $query_string ) {

		my ($key, $value) = split /=/, $pair, 2;

		push @buffer, [$key, $value];

	}



	undef %in;

	for my $pair (@buffer) {

		my ($name, $value) = ($pair->[0], $pair->[1]);

		$name =~ tr/+/ /;

		$name =~ s/%([a-fA-F0-9]{2})/pack("c", hex($1))/eg;

		$value =~ tr/+/ /;

		$value =~ s/%([a-fA-F0-9]{2})/pack("c", hex($1))/eg;

		exists $in{$name} ? ($in{$name} .= "|x|$value") : ($in{$name} = $value);

	}

	

	

    $in{'tmpl'} = 'queryfetcher' unless(defined($in{'tmpl'}));

    	

	

END_CODE



$addon->hook('ViewNews_If', \$QueryFetcher_ViewNews_If, 10);







1;





__END__



=head1 Query Fetcher



=head2 DESCRIPTION



After enabling the addon, you can place a call to viewnews.cgi in a SHTML-page and pass the parameters you would

like viewnews.cgi to recieve in the call to the SHTML-page. So instead of doing a call like this:

viewnews.cgi?id=<newsid>

you do it like this:

example.shtml?id=<newsid>



The benefit is that you can place other SSI-tags inside of the SHTML-file, which you cant if you would use

the template approach viewnews.cgi normaly uses. The drawback is that you cant use the field <Field: Title>

to put a dynamic title on your output page anymore... Well, you can ofcourse use the field, but presumably

the call to viewnews.cgi within the SHTML-file is not placed in the head-section of your html.





=head2 NOTE



The template queryfetcher.tmpl must be placed in the same folder as your Coranto installation for QueryFetcher to work.



=head2 ABOUT THE AUTHOR



=over



=item *



name: Henrik Ahln aka Parahead



=item *



email: L<mailto:henrik@parahead.com>



=item *



site: L<http://www.parahead.com/coranto/>



=back



=head2 LICENSE AND DISCLAIMER



The addon is provided on an "AS IS" basis, without warranty of any kind, either expressed or implied, including

without limitation, warranties that the addons is free of defects, merchantable, fit for a particular purpose

or non-infringing. The entire risk as to the quality and performance of the addon is with you.

Should the addon prove defective in any respect, you (not the copyright holder) assume the cost of any necessary

servicing, repair or correction. NO USE OF THE ADDON IS AUTHORIZED HEREUNDER EXCEPT UNDER THIS DISCLAIMER.





=head2 VERSION HISTORY



=head3 0.2



=over



=item *



Params sent via the call to the shtml-file is only processed if there are no params given in the direct call to viewnews.cgi



=back



=head3 0.1



=over



=item *



First release



=back



