#! CRADDON 1
#! NAME Prisoner's Dilemma
#! DESCRIPTION Escape &lt;br /&gt; tags in HTML-enabled multi-line fields.
#! VERSION build 2
#! DOC 1

# Will compile & work with the following:
#use strict;
#use vars qw(%Subs %in %CConfig);

my $addon = new Addon(q~Prisoner's Dilemma~);
$addon->checkBuild(20);

my $BRescapeSubmit = << 'END_CODE';
	foreach my $fn (@fieldDB) {
		# Go through the list of fields.
		if ($fieldDB{$fn}->{'Newlines'} && $up > $fieldDB{$fn}->{'SubmitPerm'} && ! $fieldDB{$fn}->{'DisableHTML'}) {
			$in{$fn} =~ s~\G(.*?)(<BRESCAPE>)(.*?)(\Z|</BRESCAPE>)~$1 . $2 . killbr($3) . $4~geis;
			$in{$fn} = duplicatebr($in{$fn});
		}
	}
END_CODE

my $BRunescapeModify = << 'END_CODE';
	foreach my $fn (@fieldDB) {
		# Go through the list of fields.
		if ($fieldDB{$fn}->{'Newlines'} && $up > $fieldDB{$fn}->{'ModifyPerm'} && ! $fieldDB{$fn}->{'DisableHTML'}) {
			$$fn =~ s~\G(.*?)(<BRESCAPE>)(.*?)(\Z|</BRESCAPE>)~$1 . $2 . unkillbr($3) . $4~geis;
			$$fn = patchbr($$fn);
		}
	}
END_CODE



my $BRunescapeModifyPatch = << 'END_CODE';
		if ($fieldDB{$fn}->{'Newlines'} && $up > $fieldDB{$fn}->{'ModifyPerm'} && ! $fieldDB{$fn}->{'DisableHTML'}) {
			$fcode =~ s~\G(.*?)(<textarea(.*?)>)(.*?)(\Z|</textarea>)~$1 . $2 . unpatchbr($4) . $5~geis;
		}
END_CODE





my $BRescapeModifySave = << 'END_CODE';
	foreach my $fn (@fieldDB) {
		# Go through the list of fields.
		if ($fieldDB{$fn}->{'Newlines'} && $up > $fieldDB{$fn}->{'ModifyPerm'} && ! $fieldDB{$fn}->{'DisableHTML'}) {
			$in{$fn} =~ s~\G(.*?)(<BRESCAPE>)(.*?)(\Z|</BRESCAPE>)~$1 . $2 . killbr($3) . $4~geis;
			$in{$fn} = duplicatebr($in{$fn});
		}
	}
END_CODE



my $BRremoveBeforeBuild = << 'END_CODE';
	foreach my $fn (@fieldDB) {
		# Go through the list of fields.
		if ($fieldDB{$fn}->{'Newlines'} && $up > $fieldDB{$fn}->{'ModifyPerm'} && ! $fieldDB{$fn}->{'DisableHTML'}) {
			${$fn} =~ s~<ebr[\s/]*>~~gi;
			${$fn} =~ s~<pdbr[\s/]*>~~gi;
			${$fn} =~ s~<[/]*brescape>~~gi;
		}
	}
END_CODE



$Subs{killbr} = << 'END_SUB';
sub killbr {
	( $_ = $_[0] ) =~ s~\n~<ebr />~gi;
	return $_;
}
END_SUB



$Subs{unkillbr} = << 'END_SUB';
sub unkillbr {
	( $_ = $_[0] ) =~ s~<ebr[\s/]*>~\n~gi;
	return $_;
}
END_SUB


$Subs{duplicatebr} = << 'END_SUB';
sub duplicatebr {
	( $_ = $_[0] ) =~ s~<br>~<br><pdbr />~gi;
	return $_;
}
END_SUB


$Subs{patchbr} = << 'END_SUB';
sub patchbr {
	( $_ = $_[0] ) =~ s~<br[\s/]*><pdbr[\s/]*>~\|pdbr\|~gi;
	return $_;
}
END_SUB



$Subs{unpatchbr} = << 'END_SUB';
sub unpatchbr {
	( $_ = $_[0] ) =~ s~\|pdbr\|~<br>~gi;
	return $_;
}
END_SUB



$addon->hook('SaveNews_Pre', \$BRescapeSubmit, 10);
$addon->hook('ModifyNews_Edit_TopRow', \$BRunescapeModify, 10);
$addon->hook('ModifyNews_Edit_Fields', \$BRunescapeModifyPatch, 10);
$addon->hook('ModifyNews_EditSave_Permissions', \$BRescapeModifySave, 10);
$addon->hook('Build_GetData', \$BRremoveBeforeBuild, 10);



1;

__END__

=head1 Prisoner's Dilemma

=head2 SETUP

After enabling the addon, you may submit or modify news,
using <BRESCAPE> and </BRESCAPE> in any HTML-enabled multi-line field,
where desired. Any text in between the opening and closing BRESCAPE tags
will NOT be terminated with a <br> tag (or <br /> if XHTML BR-tags are enabled
at the General Settings page).

Any <br> tags you manually insert in the multi-line field will stay unchanged
in the generated output and you do not lose them when entering the Modify News page.
The output from Coranto is cleaned from all Prisoner's Dilemma tags that
may have been placed in the multi-line fields, to ensure you get a valid HTML output.

=head2 ABOUT THE AUTHORS

Original Author of Prisoner's Dilemma:

=over 4

=item *

Darya Misse aka plushpuffin

=item *

Site: http://www.wwddfd.com/

=back

Current Author (build 2):

=over 4

=item *

Henrik Ahln aka Parahead

=item *

Site: http://www.parahead.com/coranto/

=back

=head2 LICENSE AND DISCLAIMER

This addon is distributed under the GPL license which can be found at http://www.gnu.org/licenses/gpl.html

=head2 VERSION HISTORY

=head3 Build 2 by Parahead (2005-01-20)

=over 

=item *

Fixed so that br-tags are preserved within the textarea at the Modify News page

=item *

Removed all Prisoner's Dilemma tags in the actual output from Coranto

=back

=head3 Build 1 by plushpuffin (2000-12-12)

=over

=item *

First release

=back
