#! CRADDON 1
#! NAME Private Messenger
#! DESCRIPTION Allows users to send messages to each other.
#! VERSION 1.01
#! HOMEPAGE http://www.l0rdphi1.com/coranto

package Addon::Messenger;
use strict;

my $addon = Addon->new('Private Messenger');

$Addon::Messenger::BUILD = 2;
$Addon::Messenger::VERSION = '1.01';

$addon->checkBuild(32);
$addon->isPrivacyCompatible;

for my $pm ( split /\!x\!/, $::CConfig{'pms'} )
{
	my ($id, $mode, $time, $to, $from, $subject, $text) = split /\~x\~/, $pm;
	$::pms{$id} = { 'mode' => $mode, 'tyme' => $time, 'to' => $to, 'from' => $from, 'subject' => $subject, 'text' => $text }
}

$addon->addMainFunction('Private Messages','Read or write messages to other users.','pm-mm');
$addon->registerMainFunction('pm-mm','pm_mm');
$::Subs{pm_mm} = <<'END_SUB';
sub pm_mm
{
	my $addon = shift;

	$addon->pageHeader('Private Messages');
	print '<center>'.$addon->link({ 'action' => 'pm-compose' }).'Compose a new message</a><br></center><p>';	

	print
		'<table width="98%" align="center" border="1" cellpadding="3" cellspacing="2">' .
		q~<tr>
				<th>~.$addon->link({ 'action' => 'pm-mm' }).q~Date</a></th>
				<th>~.$addon->link({ 'action' => 'pm-mm', 'sort' => 'from' }).q~From</a></th>
				<th>~.$addon->link({ 'action' => 'pm-mm', 'sort' => 'subject' }).q~Subject</a></th>
				<th>Options</th>
			</tr>~;

	# set sort var
	my $sort_key = $in{'sort'} ? $in{'sort'} : 'tyme';

	my $msgcnt = 0;
	for my $pm ( sort { $pms{$b}->{$sort_key} cmp $pms{$a}->{$sort_key} } keys %pms )
	{
		my $pmd = $pms{$pm};
		if ( $pmd->{'mode'} =~ /^(0|1)$/ && $pmd->{'to'} eq $CurrentUser )
		{
			print '<tr> <td align="center">'.GetTheDate_Internal($pmd->{'tyme'}).'</td>'
				.qq~<td align="center">$pmd->{'from'}</td>~
				.qq~<td align="center">$pmd->{'subject'}~.( $pmd->{'mode'} == 0 ? '*' : '' ).'</td>'
				.'<td align="center">['.$addon->link({ 'action' => 'pm-read', 'id' => $pm }).'Read</a>] ['.$addon->link({ 'action' => 'pm-delete', 'id' => $pm }).'Delete</a>]</td> </tr>';
			$msgcnt++;
		}
	}

	if ( $msgcnt == 0 )
	{
		print '<tr> <td align="center" colspan="4"><i>No messages</i></td> </tr>';
	}

	print '</table><p> * = Unread';

	$addon->pageFooter;
}
END_SUB

$addon->registerMainFunction('pm-read','pm_read');
$::Subs{'pm_read'} = <<'END_SUB';
sub pm_read {
	my $addon = shift;

	CRcough('No such private message exists!') unless $pms{$in{'id'}};

	if ( $pms{$in{'id'}}->{'mode'} == 0 ) {
		$pms{$in{'id'}}->{'mode'} = 1;
	}

	&pm_save;

	$addon->pageHeader("Reading: '$pms{$in{'id'}}->{'subject'}'");

	my $formatted_msg;
	(my $msg = $pms{$in{'id'}}->{'text'}) =~ s/\n/<br>/g;
	for my $i ( split /\n/,$pms{$in{'id'}}->{'text'} ) {
		$formatted_msg .= "> $i\n";
	}
	print
		$addon->form({'action' => 'pm-compose', 'to' => $pms{$in{id}}->{from}, 'subject' => "Re: $pms{$in{id}}->{subject}", 'text' => "\n\n\n$formatted_msg"}, ' name="read"'),
		$addon->fieldsTable,
		$addon->fieldsTableRow('Sent', GetTheDate_Internal($pms{$in{id}}->{tyme})),
		$addon->fieldsTableRow('From', qq~$pms{$in{id}}->{from} [<a href="javascript:document.read.submit()">Reply</a>]~),
		$addon->fieldsTableRow('To', $pms{$in{id}}->{to}),
		$addon->fieldsTableRow('Subject', $pms{$in{id}}->{subject}),
		$addon->fieldsTableRow('Message', $msg),
		'</table></form><br>';

	$addon->pageFooter;
}
END_SUB

$addon->registerMainFunction('pm-compose','pm_compose');
$::Subs{pm_compose} = <<'END_SUB';
sub pm_compose {
	my $addon = shift;
	$addon->pageHeader('Compose Private Message');
	$in{text} =~ s/\r//g if $in{text};
	print
		$addon->form({'action' => 'pm-send'}),
		$addon->fieldsTable,
		$addon->fieldsTableRow('Date', GetTheDate_Internal(time)),
		$addon->fieldsTableRow('From', $CurrentUser),
		$addon->fieldsTableRow('To', '<select name="to" multiple>' . join('', map { '<option' . ( $in{to} eq $_ ? ' selected' : '' ) . ">$_</option>" } keys %userdata) . '</select>'),
		$addon->fieldsTableRow('Subject', '<input type="text" size="45" name="subject" value="' . ( $in{subject} ? $in{subject} : '' ) . '">'),
		$addon->fieldsTableRow('Message', '<textarea name="text" rows="15" cols="60" wrap="virtual">' . ( $in{text} ? $in{text} : '' ) . '</textarea>'),
		'</table><br>',
		$addon->submitButton('Send'),
		'</form>';
	$addon->pageFooter;
}
END_SUB

$addon->registerMainFunction('pm-send','pm_send');
$::Subs{'pm_send'} = <<'END_SUB';
sub pm_send
{
	my $addon = shift;

	CRcough('Please enter a subject of three or more characters.') unless length $in{'subject'} > 2;
	
	my %array_to = split /\|x\|/, $in{'to'};

	# iterate users we are sending the message to
	for my $user_to (%array_to)
	{

		# get next id
		my $id = 0;
		while ($pms{$id})
		{
			$id++;
		}

		$pms{$id} = { 'mode' => 0, 'tyme' => time, 'to' => $user_to, 'from' => $CurrentUser, 'subject' => $in{'subject'}, 'text' => $in{'text'} };

	}

	&pm_save;

	$addon->pageHeader('Private Message Sent!');
	print "<center>Message successfully sent to ".join(', ',%array_to)."!<p>".$addon->link({ 'action' => 'pm-mm' }).'Your Private Messages</a></center><p>';
	$addon->pageFooter;
}
END_SUB

$addon->registerMainFunction('pm-delete','pm_delete');
$::Subs{'pm_delete'} = <<'END_SUB';
sub pm_delete
{
	my $addon = shift;

	CRcough('No such private message exists!') unless $pms{$in{id}};
	CRcough('You do not have permission to delete the message you chose to delete!') unless $pms{$in{id}}->{to} eq $CurrentUser or $up == 3;

	pm_confirm($addon, "Are you really sure you want to delete the private message entitled '$pms{$in{'id'}}->{'subject'}'?");

	delete $pms{$in{'id'}};
	&pm_save;

	pm_mm($addon);
}
END_SUB

$::Subs{'pm_save'} = <<'END_SUB';
sub pm_save
{
	my @tmp;
	while (my ($pm, $pmd) = each %pms) {
		push @tmp, join '~x~', $pm, $pmd->{mode}, $pmd->{tyme}, $pmd->{to}, $pmd->{from}, $pmd->{subject}, $pmd->{text};
	}
	$CConfig{'pms'} = join '!x!', @tmp;
}
END_SUB

$::Subs{'pm_confirm'} = <<'END_SUB';
sub pm_confirm
{
	my ($addon, $message) = @_;

	unless ($in{really})
	{
		$addon->pageHeader('Confirm Action');
		print qq~<table width="80%" border="0" align="center" class="confirm"><tr><td><div align="center">$message</div></td></tr></table><br>~;

		my %in2;
		while ( my ($key,$value) = each %in )
		{
			$in2{$key} = $value unless $key eq 'session' || $key eq 'x';
		}

		print $addon->form(\%in2)
			.q~<div align="center"><input type="submit" name="really" value="Yes, I'm sure"></div></form>~;
		$addon->pageFooter;

		exit;
	}
}
END_SUB

$addon->hook('CRHTMLHead_Message',\<<'END_CODE',-5);

	my $yhm = 0;
	while ( my ($pm, $pmd) = each %pms )
	{
		if ( $pmd->{mode} == 0 && $pmd->{to} eq $CurrentUser )
		{
			$yhm++;
		}
	}

	if ( $yhm > 0 )
	{
		print PageLink({ 'action' => 'pm-mm' })."<center>You have $yhm new message".( $yhm > 1 ? 's' : '' ).'</a></center><p>';
	}

END_CODE

1;