#! CRADDON 1
#! NAME Multipart
#! DESCRIPTION The ultimate upload solution.
#! VERSION 1.59 (Build 25)
#! HOMEPAGE http://www.l0rdphi1.com/coranto
#! DOC 1

# Will compile and work under use strict.
#use strict;

my $addon = Addon->new('Multipart');
$addon->addProfileType('Multipart');

$::multipart_build = 25;
$::multipart_version = '1.59';

$addon->checkBuild(33);
$addon->isPrivacyCompatible;

$::CConfig{multipart_upload_boxes} ||= 3;
# PARAHEAD: Corrected a bug making the Icons option always being set to "Yes" (1.56)
$::CConfig{multipart_icons} = 1 unless(defined($::CConfig{multipart_icons}));
$::CConfig{multipart_icons_src} ||= 'multipart_icons';
$::CConfig{multipart_icons_path} ||= 'multipart_icons';
$::CConfig{multipart_tree_mode} ||= 2;
$addon->addAdvancedSettingHeading('Multipart Settings');
$addon->addAdvancedSetting('multipart_upload_boxes', 'Upload Boxes', 'Number of upload boxes you want on the Upload Manager.');
$addon->addAdvancedSetting('multipart_icons', 'Icons', 'Do you want to have an icon (based on file extension) next to file names?', 'yn');
$addon->addAdvancedSetting('multipart_icons_src', 'Icon Directory', "<b>HTTP</b> path to the directory you have uploaded Multipart's file icons to. No trailing slash. Leave blank if you have icons turned off.");
$addon->addAdvancedSetting('multipart_icons_path', 'Icon Path', "<b>Absolute</b> path to the above directory. No trailing slash. Leave blank if you have icons turned off.");
$addon->addAdvancedSetting('multipart_tree_mode', 'File Tree', 'How do you want the file tree displayed?',  '<div align="left"><input type="radio" name="multipart_tree_mode" value="1"' . ($::CConfig{multipart_tree_mode} == 1 ? ' checked' : '') . '> Display profiles as folders where you click on them to view contents.<br> <input type="radio" name="multipart_tree_mode" value="2"' . ($::CConfig{multipart_tree_mode} == 2 ? ' checked' : '') . '> Display all profiles and contents below upload boxes.</div>');
$addon->addAdvancedSetting('multipart_netpbm', 'NetPBM Path', 'Enter the absolute path to the directory containing NetPBM. No trailing slash. Leave blank if you do not need automatic thumbnail creation.');

$addon->addMainFunction('Upload Manager', 'Upload or delete a file or view the list of uploaded files.', 'multipart-upload');
$addon->registerMainFunction('multipart-upload', 'multipart_upload');
$::Subs{multipart_upload} = <<'END_CODE';
sub multipart_upload {
	my $addon = shift;
	my ($profiles, $files);
	while (my ($prof, $val) = each %newsprofiles) {
		if ($val->{enabled} == 1 and $val->{type} eq 'Multipart') {
			$profiles .= "<option>$prof</option>" if (grep(/\A\Q$CurrentUser\E\Z/, split /\(delim\)/, $newsprofiles{$prof}->{perm_upload}) or ($userdata{$CurrentUser}->{UserLevel} >= 2 and grep(/\A\(High Level Users\)\Z/, split /\(delim\)/, $newsprofiles{$prof}->{perm_upload})) or $newsprofiles{$prof}->{perm_upload} eq '(Everyone)');
			if ($CConfig{multipart_tree_mode} == 1) {
				$files .= '<center>' . ( $CConfig{multipart_icons} ? qq~<img src="$CConfig{multipart_icons_src}/dir.gif" border="0" align="middle">  ~ : '' ) . $addon->link({'action' => 'multipart-tree', 'prof' => $prof}) . qq~$prof</a></center>~;
			}
			elsif ($CConfig{multipart_tree_mode} == 2) {
# PARAHEAD: Changed so the directory content is sorted before printed out (1.56)				
				my @sortedfiles;
				opendir DIR, $val->{path};
				while ($file = readdir DIR) {
					if ($file !~ /\A\.\.?\Z/) {
						push @sortedfiles, $file;
					}
				}
				closedir DIR;

				@sortedfiles = sort {uc($a) cmp uc($b)} @sortedfiles;
				my $counter = 0;
				my $totalfiles = scalar @sortedfiles;
				$files .= $addon->heading("Files in $prof");
				$files .= '<table border="0">';
# PARAHEAD: Bugfix, had forgotten this one... (1.57)
				my $looptr = 0;
				while ($looptr == 0) {
					$files .= '<tr>';
					for (my $i = 0; $i < $val->{columns}; $i++) {
						if($counter < $totalfiles)
						{
							$file = $sortedfiles[$counter++];
							(my $ext = $file) =~ s/^\A.+\.(.+)\Z/\l$1/;
							if ($file !~ /\./) {
								$ext = 'dir';
							}
							elsif (!-e "$CConfig{multipart_icons_path}/$ext.gif") {
								$ext = 'unknown';
							}
							if($ext eq 'dir')
							{
								$files .= '<td width="10%" valign="middle" align="center">' . ( $CConfig{multipart_icons} ? qq~<img src="$CConfig{multipart_icons_src}/$ext.gif" align="middle"> ~ : '' ) . qq~<font face="geneva, verdana" size="1">~ . $addon->link({'action' => 'multipart-tree', 'prof' => $prof, 'subdir' => $file}) . qq~$file</a></font></td>~;
							}
							else
							{
								$files .= '<td width="10%" valign="middle" align="center">' . ( $CConfig{multipart_icons} ? qq~<img src="$CConfig{multipart_icons_src}/$ext.gif" align="middle"> ~ : '' ) . qq~<font face="geneva, verdana" size="1"><a href="$newsprofiles{$prof}->{http_path}/$file" target="_blank">$file</a>~ . ( (grep(/^\Q$CurrentUser\E$/, split /\(delim\)/, $val->{perm_delete}) or ($userdata{$CurrentUser}->{UserLevel} >= 2 and grep(/^\(High Level Users\)$/, split /\(delim\)/, $val->{perm_delete})) or $val->{perm_delete} eq '(Everyone)') ? ' [' . $addon->link({'action' => 'multipart-delete', 'from' => $prof, 'who' => $file}) . 'x</a>]' : '' ) . '</font></td>';
							}
						}
						else {
							$looptr = 1;
						}
					}
					$files .= '</tr>';
				}
				$files .= '</table>';
			}
		}
	}
	CRcough('Uh-oh! No Multipart profiles could be found! This means one of two things, either none exist, or permissions are set so that you do not have access to any.') if not $profiles;
	$addon->pageHeader('Upload Manager');
	print $addon->form({'action' => 'multipart-process'}, 'enctype="multipart/form-data"');
	for (my $i = 1; $i <= $CConfig{multipart_upload_boxes}; $i++) {
		print
			$addon->heading("File $i"),
			$addon->settingTable('File', qq~<input type="file" name="file$i">~, 'Choose the file you want to upload.'),
			$addon->settingTable('Profile', qq~<select name="profile$i">$profiles</select>~, 'Choose the profile you want to upload to.');
	}
	print $addon->submitButton('Upload') . '</form>';
	if ($CConfig{multipart_tree_mode} == 1) {
		print $addon->heading('File Tree') . $files;
	}
	elsif ($CConfig{multipart_tree_mode} == 2) {
		print $files;
	}
	$addon->pageFooter;
}
END_CODE

$addon->registerMainFunction('multipart-tree', 'multipart_tree');
$::Subs{multipart_tree} = <<'END_CODE';
sub multipart_tree {
	my $addon = shift;

	my $dir = $newsprofiles{$in{prof}}->{path};
	my $subdir = $in{subdir} ? "$in{subdir}/" : '';
# PARAHEAD: Changed so the directory content is sorted before printed out (1.56)				
	my @sortedfiles;
	opendir DIR, "$dir/$subdir";
	while($file = readdir DIR) {
		if ($file !~ /\A\.\.?\Z/) {
			push @sortedfiles, $file;
		}
	}
	closedir DIR;
	
	@sortedfiles = sort {uc($a) cmp uc($b)} @sortedfiles;
	my $counter = 0;
	my $totalfiles = scalar @sortedfiles;

	my $visualdir = $in{subdir} ? "$in{prof}/$in{subdir}" : $in{prof};
	$addon->pageHeader($visualdir);
	
	print '<table border="0">';
	my $looptr = 0;
	while ($looptr == 0) {
		print '<tr>';
		for (my $i = 0; $i < $newsprofiles{$in{prof}}->{columns}; $i++) {
			if($counter < $totalfiles)
			{
				$file = $sortedfiles[$counter++];
				(my $ext = $file) =~ s/\A.+\.(.+)\Z/\l$1/;
				if ($file !~ /\./) {
					$ext = 'dir';
				}
				elsif (not -e "$CConfig{multipart_icons_path}/$ext.gif") {
					$ext = 'unknown';
				}
				if($ext eq 'dir')
				{
					print '<td width="10%" valign="middle" align="center">' . ( $CConfig{multipart_icons} ? qq~<img src="$CConfig{multipart_icons_src}/$ext.gif" align="middle"> ~ : '' ) . qq~<font face="geneva, verdana" size="1">~ . $addon->link({'action' => 'multipart-tree', 'prof' => $in{prof}, 'subdir' => "$subdir$file"}) . qq~$file</a></font></td>~;
				}
				else
				{
					print '<td width="10%" valign="middle" align="center">' . ( $CConfig{multipart_icons} ? qq~<img src="$CConfig{multipart_icons_src}/$ext.gif" align="middle"> ~ : '' ) . qq~<font face="geneva, verdana" size="1"><a href="$newsprofiles{$in{prof}}->{http_path}/$subdir$file" target="_blank">$file</a>~ . ( (grep(/^\Q$CurrentUser\E$/, split /\(delim\)/, $newsprofiles{$in{prof}}->{perm_delete}) or ($userdata{$CurrentUser}->{UserLevel} >= 2 and grep(/^\(High Level Users\)$/, split /\(delim\)/, $newsprofiles{$in{prof}}->{perm_delete})) or $newsprofiles{$in{prof}}->{perm_delete} eq '(Everyone)') ? ' [' . $addon->link({'action' => 'multipart-delete', 'from' => $in{prof}, 'who' => "$subdir$file"}) . 'x</a>]' : '' ) . '</font></td>';
				}
			}
			else {
				$looptr = 1;
			}
		}
		print '</tr>';
	}	
	
	print '</table>';
	

	my $subdirlinks	= $addon->link({'action' => 'multipart-tree', 'prof' => $in{prof}}) . qq~$in{prof}</a>~;
	my @subdirs = split /\//, $subdir;
	my $totsubdir = '';
	foreach $subdir(@subdirs)
	{
		$totsubdir .= "$subdir/";
		$subdirlinks .= qq~ / ~ . $addon->link({'action' => 'multipart-tree', 'prof' => $in{prof}, 'subdir' => $totsubdir}) . qq~$subdir</a>~;
	}	
	print qq~<table width="100%" border="0" cellspacing="0" cellpadding="0"><tr><td><BR>
	<table width="80%" border="0" cellspacing="0" cellpadding="2" align="center" class="yellowbg">
					<tr><td><div align="center" class="miniheader">~
					. $addon->link({'action' => 'multipart-upload'}) . qq~Upload Manager</a> / ~
					. $subdirlinks . qq~
					</div></td></tr>
				</table>
		</td></tr></table>~;
	
	$addon->pageFooter;
}
END_CODE

$addon->registerMainFunction('multipart-process', 'multipart_process');
$::Subs{multipart_process} = <<'END_CODE';
sub multipart_process {
	my $addon = shift;
	my @erra;
	for (my $i = 1; $i <= $CConfig{multipart_upload_boxes}; $i++) {
		if ($newsprofiles{$in{"profile$i"}} and $in{"file$i"}) {
			my $prof = $in{"profile$i"};
			(my $fn = $in{"file$i"}) =~ s!^.*(\\|\/)!!;
			unless (grep(/\A\Q$CurrentUser\E\Z/, split /\(delim\)/, $newsprofiles{$prof}->{perm_upload}) or ($userdata{$CurrentUser}->{UserLevel} >= 2 and grep(/\A\(High Level Users\)\Z/, split /\(delim\)/, $newsprofiles{$prof}->{perm_upload})) or $newsprofiles{$prof}->{perm_upload} eq '(Everyone)') {
				push @erra, "$fn: You do not have permission to upload files to the profile '$prof'";
			}
    	    if ($newsprofiles{$prof}->{max_bytes} and length $multipart_data{$in{"file$i"}} > $newsprofiles{$prof}->{max_bytes}) { 
       	    push @erra, "$fn: Request to receive too much data. Maximum is $newsprofiles{$prof}->{max_bytes} bytes."; 
      	    } 
      	    if (!$newsprofiles{$prof}->{perm_overwrite} && -e "$newsprofiles{$prof}->{path}/$fn") { 
      	      push @erra, "$fn: The file you're trying to upload already exists at the destination you specified."; 
     	    }
			my @exts = split / /, $newsprofiles{$prof}->{ext_types};
			(my $ext = $fn) =~ s/\A.+\.(.+)\Z/$1/;
			if ($newsprofiles{$prof}->{ext_mode} == 1 and not grep /\A\Q$ext\E\Z/, @exts) {
				push @erra, "$fn: Invalid file extension'$ext'; Valid extensions include: " . join ', ', @exts;
			}
			if ($newsprofiles{$prof}->{ext_mode} == 2 and grep /\A\Q$ext\E\Z/, @exts) {
				push @erra, "$fn: Invalid file extension '$ext'; Invalid extensions include: " . join ', ', @exts;
			}
			unless (grep /\A\Q$fn\E/, @erra) {
				open FH, ">$newsprofiles{$prof}->{path}/$fn" or (push @erra, "$fn: $!");
				binmode FH;
				print FH $multipart_data{$in{"file$i"}};
				close FH;
				push @uped, qq~$fn (~ . (stat "$newsprofiles{$prof}->{path}/$fn")[7] . qq~ bytes) to $in{"profile$i"}~ unless grep /\A\Q$fn\E/, @erra;
			}
		}
	}
	
	$addon->pageHeader('Job Done!');
	print "Could not upload: <ul>" . join('', map { qq~<li>$_</li>~ } @erra) . '</ul>' if(@erra > 0);
	print "Successfully uploaded: <ul>" . join('', map { qq~<li>$_</li>~ } @uped) . '</ul>' if(@uped > 0);
	print 'Return to the ' . $addon->link({'action' => 'multipart-upload'}) . 'Upload Manager</a>.';
	$addon->pageFooter;
}
END_CODE

$addon->registerMainFunction('multipart-delete', 'multipart_delete');
$::Subs{multipart_delete} = <<'END_CODE';
sub multipart_delete {
	my $addon = shift;
	unless ($in{confirmed}) {
		$addon->pageHeader('Confirm');
		my %in_conf = %in;
# PARAHEAD: Minor bugfix, the session was not removed from the in hash (1.59)
		delete $in_conf{x};
		delete $in_conf{session};
		print $addon->form(\%in_conf);
		print qq~Are you sure you want to delete '$newsprofiles{$in{from}}->{path}/$in{who}'?<center><br><input type="submit" name="confirmed" value="Yes"></center></form>~;
		$addon->pageFooter;
		exit;
	}
	unless (grep(/\A\Q$CurrentUser\E\Z/, split /\(delim\)/, $newsprofiles{$in{from}}->{perm_delete}) or ($userdata{$CurrentUser}->{UserLevel} >= 2 and grep(/^\(High Level Users\)$/, split /\(delim\)/, $newsprofiles{$in{from}}->{perm_delete})) or $newsprofiles{$in{from}}->{perm_delete} eq '(Everyone)') {
		push @erra, "$in{who}: You do not have permission to delete files from the profile '$in{from}'";
	}
	unless (grep /\A$in{who}/, @erra) {
		unlink "$newsprofiles{$in{from}}->{path}/$in{who}" or (push @erra, "$in{who}: $!");
		push @deld, "$in{who} from $in{from}" unless grep /\A$in{who}/, @erra;
	}
	$addon->pageHeader('Job Done!');
	print "Could not delete: <ul>" . join('', map { qq~<li>$_</li>~ } @erra) . '</ul>' if @erra > 0;
	print "Successfully deleted: <ul>" . join('', map { qq~<li>$_</li>~ } @deld) . '</ul>' if @deld > 0;
	print 'Return to the ' . $addon->link({'action' => 'multipart-upload'}) . 'Upload Manager</a>.';
	$addon->pageFooter;
}
END_CODE




$addon->hook('ProfileList_NewType_Status', \<<'END_CODE');
if ($newsprofiles{$i}->{type} eq 'Multipart') {
	$status .= 'Files ';
	if ($newsprofiles{$i}->{max_bytes}) {
		$status .= "smaller than <b>$newsprofiles{$i}->{max_bytes} bytes</b> ";
	}
	else {
		$status .= 'any size ';
	}
	if ($newsprofiles{$i}->{ext_types}) {
		$status .= $newsprofiles{$i}->{ext_mode} == 1 ? 'with' : 'without';
		my @exts = split / /, $newsprofiles{$i}->{ext_types};
		$status .= ' the extension' . (@exts > 1 ? 's' : '');
		$status .= ' <b>' . join(', ', @exts) . ' </b> ';
	}
	else {
		$status .= 'with <b>any extensions</b> ';
	}
	$status .= "are uploaded to <b>$newsprofiles{$i}->{path}</b>. ";
	$status .= "Profile type: <b>$newsprofiles{$i}->{type}</b>. " if @ProfileTypes;
}
END_CODE

$addon->hook('AddProfile_NewType', \<<'END_CODE');
if ($proftype eq 'Multipart') {
	$newsprofiles{$prof} = {
		'type' => 'Multipart',
		'enabled' => 0,
		'path' => $CConfig{htmlfile_path},
		'max_bytes' => 131072,
		'ext_mode' => 0,
		'columns' => 6
	};
}
END_CODE

$addon->hook('ProfileList_NewType_Functions', \<<'END_CODE');
if ($newsprofiles{$i}->{type} eq 'Multipart') {
	$actions .= '[' . PageLink({'action' => 'admin', 'adminarea' => 'multipart-profile-edit', 'profname' => $i}) . 'Edit Profile Settings</a>] ';
}
END_CODE

$addon->registerAdminFunction('multipart-profile-edit', 'multipart_profile_edit');
$::Subs{multipart_profile_edit} = <<'END_CODE';
sub multipart_profile_edit {
	my $prof = $in{profname};
	CRHTMLHead("Multipart Settings for '$prof'", 1);
	print StartForm({'action' => 'admin', 'adminarea' => 'multipart-profile-edit-save', 'profname' => $prof} );
	SettingsEngine_Display(multipart_profile_definition($prof), $newsprofiles{$prof});
	print SubmitButton('Save Settings') . '</form>';
	&CRHTMLFoot;
}
END_CODE

$addon->registerAdminFunction('multipart-profile-edit-save', 'multipart_profile_edit_save');
$::Subs{multipart_profile_edit_save} = <<'END_CODE';
sub multipart_profile_edit_save {
	my $prof = $in{profname};
	CRdie("Invalid profile information") unless $prof and $newsprofiles{$prof};
	if ($newsprofiles{$prof}->{type} eq 'Multipart') {
		# HOOK: EditProfileSave
		if($Addons{EditProfileSave}){for my $i (@{$Addons{EditProfileSave}}){my $addon=$i->[2];eval ${$i->[0]};AErr($addon,$@)if $@;};}
		CRcough("Invalid maximum bytes. Only numbers are valid.") if $in{max_bytes} =~ /[^0-9]/;
		CRcough("Invalid number of columns. Must be a number greater then one.") if $in{columns} =~ /[^0-9]/ or $in{columns} < 1;
		if ($in{ext_mode} > 0) {
			CRcough("You didn't enter any extensions to allow/disallow.") unless $in{ext_types};
			CRcough("Invalid file extensions. Only numbers, letters, and underscores are allowed.") if $in{ext_types} =~ /[^a-zA-Z0-9_ ]/;
		}
		CRcough('Tell me, why would you select everyone AND other users?') if ($in{perm_upload} =~ /\(Everyone\)/ and split(/\|x\|/, $in{perm_upload}) > 1) or ($in{perm_delete} =~ /\(Everyone\)/ and split(/\|x\|/, $in{perm_delete}) > 1);
		
		# PARAHEAD: Now checking if a path has been specified (1.56)
		CRcough("You have not specified a path") unless $in{path};
		
		# PARAHEAD: Verify the path and ask if it should be created if it doesnt exist (1.56)
		if (!-d $in{path}) {
			if (-e $in{path}) {
				CRcough("The specified path exist but is not a directory, please verify this!"); 
			} else {	
				NeedFile('cradmin.pl');
				AreYouSure("<strong>$in{path}</strong><BR>The specified path does not exist, create it?") unless $in{'really'};
# PARAHEAD: Changed from using mkdir to mkpath since it can create more than one level at a time (1.57)
				Multipart_MakePath($in{path}, 1);
			}
		}
		
		SettingsEngine_Save(multipart_profile_definition($prof), $newsprofiles{$prof});
		&WriteProfileInfo;
		SettingsConfirm(PageLink({'action' => 'admin', 'adminarea' => 'profilelist'}) . 'Back to Edit Profiles</a>.');
	}
}
END_CODE

$::Subs{multipart_profile_definition} = <<'END_CODE';
sub multipart_profile_definition {
	my $prof = shift;
	my $ext_modes = { 'Allow all file extensions' => 0, 'Allow only the ones below' => 1, 'Disallow only the ones below' => 2 };
	return [
		['heading: Multipart Upload Manager Profile Settings'],
		['path', 'File Path', 'The absolute path to the directory in which files will be uploaded, with no trailing slash.'],
		['http_path', 'HTTP Path', 'The http path to the above directory, with no trailing slash.'],
		['max_bytes', 'Maximum Bytes', 'Maximum size of files that can be uploaded using this field, in bytes. Leave blank to allow any size.'],
		['columns', 'List Columns', 'Number of columns you want used when listing files in the Upload Manager.'],
		['ext_mode', 'Extension Mode', 'Choose the mode you want to use for file extensions.', '<select name="ext_mode">' . join('', map { qq~<option value="$ext_modes->{$_}" ~ . ( $ext_modes->{$_} == $newsprofiles{$prof}->{ext_mode} ? 'selected' : '' ) . ">$_</option>" } keys %$ext_modes) . '</select>'],
		['ext_types', 'File Extensions', 'If you chose "Allow only the ones below" or "Disallow only the ones below" above, please enter the extensions here. Leave blank if you chose "Allow all file extensions." <b>Seperate with spaces</b>. Do NOT use a . (period) in the extensions. Example: zip exe html'],
		['perm_upload', 'Upload Permissions', 'Who can upload files to this profile?', '<select name="perm_upload" size="8" multiple>' . join('', map { my $key = $_;$key =~ s/(\(|\))/\\$1/g; qq~<option ~ . ( grep(/^$key$/, split /\(delim\)/, $newsprofiles{$prof}->{perm_upload}) ? 'selected' : '' ) . ">$_</option>" } '(Everyone)', '(High Level Users)', sort keys % userdata) . '</select>'],
		['perm_delete', 'Delete Permissions', 'Who can delete files from this profile?', '<select name="perm_delete" size="8" multiple>' . join('', map { my $key = $_;$key =~ s/(\(|\))/\\$1/g; qq~<option ~ . ( grep(/^$key$/, split /\(delim\)/, $newsprofiles{$prof}->{perm_delete}) ? 'selected' : '' ) . ">$_</option>" } '(Everyone)', '(High Level Users)', sort keys % userdata) . '</select>'],
		['perm_overwrite', 'Overwrite if file exists', 'Controls if files should be overwritten when uploading a file that already exists on the server.', 'yn']
	];
}
END_CODE

$addon->hook('NewsFieldEditDef', \<<'END_CODE');
my %ext_modes = ( 'Allow all file extensions' => 0, 'Allow only the ones below' => 1, 'Disallow only the ones below' => 2 );
my %upload_modes = ('Pure Upload Field' => 1, 'Dropdown box with files from Upload Path' => 2, 'Combination of Dropdown Box and Upload Field' => 3 );
if ($fieldtype == 6) {
	



	push @NFEDef,
		['path', 'Upload Path', q~Absolute path to where you want this field to upload files. Can include &lt;Field: whatever&gt; tags. No trailing slash.<BR>NOTE: If one of the "Dropdown Box"-modes are selected under the 'Upload Field Mode'-setting below, this field indicates where the Dropdown Box get its files from~],
		['http', 'Upload Directory', 'HTTP path to the above directory. No trailing slash. Can include <Field: whatever> tags'],
		['ext_mode', 'Extension Mode', 'Choose the the mode you want to use for file extensions.', '<select name="ext_mode">' . join('', map { qq~<option value="$ext_modes{$_}" ~ . ( $ext_modes{$_} == $fieldDB{$in{fieldname}}->{ext_mode} ? 'selected' : '' ) . ">$_</option>" } keys %ext_modes) . '</select>'],
		['ext_types', 'File Extensions', 'If you chose "Allow only the ones below" or "Disallow only the ones below" above, please enter the extensions here. Leave blank if you chose "Allow all file extensions." <b>Seperate with spaces</b>. Do NOT use a . (period) in the extensions. Example: zip exe html'],
# PARAHEAD: Removed the selectbox_loader option, replaced by upload_mode (1.59)
#		['selectbox_loader', 'Enable selectbox uploading', 'If you choose Yes (On) then you will have the option to upload a new file even when the upload field is presented as a dropdown selectbox.', 'yn'],
		['upload_mode', 'Specify Upload Field mode', q~If you choose 'Pure Upload Field' you will simply have an upload field at the submit page. The 'Dropdown Box' mode presents the files located in the Upload Path (specified above) on the server. The third mode is a combination of the two previous modes and it will present a Dropdown box but it will also be possible to upload new files to the Upload Path folder.~, '<select name="upload_mode">' . join('', map { qq~<option value="$upload_modes{$_}" ~ . ( $upload_modes{$_} == $fieldDB{$in{fieldname}}->{upload_mode} ? 'selected' : '' ) . ">$_</option>" } sort {$upload_modes{$a} <=> $upload_modes{$b}} keys %upload_modes) . '</select>'],

		['heading: Upload Field Mode'],
		['descrip: <center>These settings are only useful if you have selected one of the modes above which lets you upload new files.</center>'],
		['draw_line'],
# PARAHEAD: Added perm_overwrite (1.56)
		['perm_overwrite', 'Overwrite if file exists', 'Controls if files should be overwritten when uploading a file that already exists on the server.', 'yn'],
		['size', 'Max File Size', 'Maximum size of files that can be uploaded using this field in bytes. Leave blank to allow any size.'],
		
		['heading: Image Functions'],
		['images', 'Enable Image Functions', "Enabling the image functions means that you will be able to see a small preview of the image at the Submit News page or create a thumbnail of the uploaded image. Please refer to the thumbnail section below for further options if you choose to enable this function.", 'yn'],
		
		['heading: Thumbnail Settings'],
		['descrip: <center>The following thumbnail settings are only useful if you have enabled Image Functions for this field above.</center>'],
		['draw_line'],
		['thumbs', 'Create Thumbnail', q~Create thumbnails for uploaded images? Ignore if image functions are turned off or if you don't have NetPBM installed on the server.~, 'yn'],
		['thumb_path', 'Thumbnail Path', 'Absolute path to the directory where you would like Thumbnails created. Leave blank to use the same path as the full-sized image. Can include <Field: whatever> tags'],
		['thumb_http', 'Thumbnail Directory', 'HTTP path to the above directory. No trailing slash. Leave blank if the above field is blank. Can include <Field: whatever> tags'],
		['thumb_fn', 'Thumbnail Filename', 'Enter the format you would like thumbnail files created in.<p>&lt;FileName&gt; will return the original filename without extension<br>&lt;FileExt&gt; is the original file extension<p>A good choice would be: &lt;FileName&gt;-thumb.&lt;FileExt&gt;<br>Leave blank if thumbnail creation is turned off.'],
		['thumb_w', 'Default thumbnail width', 'Default width for the thumbnail to be created. Leave blank if thumbnail creation is turned off.'],
		['thumb_h', 'Default thumbnail height', 'Default height for the thumbnail to be created. Leave blank if thumbnail creation is turned off.'],
		['thumb_static_wh', 'Lock width and height', "Set this to Yes if you would like to lock the thumbnail size to the above dimensions. If set to No there will be an option when submitting the newsitem to alter these values. Ignore if thumbnail creation is turned off.", 'yn'],
# PARAHEAD: Added thumb_maintain_ar (1.56)
		['thumb_maintain_ar', 'Always maintain aspect ratio', "If set to Yes, the entered width and height specifies a bounding box and the input image is scaled to the largest size that fits within the box, while preserving its aspect ratio. If set to No there will be an option when submitting the newsitem to maintain the aspect ratio or not. Ignore if thumbnail creation is turned off.", 'yn'],
# PARAHEAD: Added thumb_stretch (code provided by bozoka45) (1.58)
		['thumb_stretch', 'Stretch thumbnail to Default', "This is used when an image that is smaller than the default thumbnail height and width is uploaded. If set to Yes, then the thumbnail will be stretched to the default thumbnail height and width that you have specified. If set to no, then the thumbnail will just be a copy of the image. Ignore if thumbnail creation is turned off.", 'yn']
		;
#	}
}
END_CODE


$addon->hook('AddNewsField_Internal', \<<'END_CODE');
if ($fieldtype == 6) {
	$fieldDB{$fieldname}->{path} = $CConfig{htmlfile_path};
	$fieldDB{$fieldname}->{size} = 131072;
	$fieldDB{$fieldname}->{ext_mode} = 0;
}
END_CODE











# Removes all unwanted characters (1.57)
$Subs{Multipart_KillChars} = << 'END_SUB';
sub Multipart_KillChars {
	$_ = $_[0];
	$_ =~ s/[^A-Za-z0-9\-\.]+//g;
	return $_;
}
END_SUB

# Construct the path to a file, create it as well if the create field is set to true.
# The original sub can be found in Maginot, Courtesy of plushpuffin
# This sub was added in version 1.57 due to problem with using mkdir as reported in the forum
# http://coranto.gweilo.org/forum/viewtopic.php?t=6488&start=30
$Subs{Multipart_MakePath} = << 'END_SUB';
use File::Path;
sub Multipart_MakePath {
	my ($dirpath, $create) = @_;
	return unless $dirpath;
	$dirpath =~ s~/[^/]+/\.\.~/~g;
	$dirpath =~ s/<TextField\: ([^\s\>\{\[]+)>/'%^' . HTMLtoText(${$1}) . '%%'/ge;
	$dirpath =~ s/<TextField\: ([^\s\>\{]+)\{[\'\"]([^\s\>\}\'\"]+)[\'\"]\}>/'%^' . HTMLtoText(${$1}{$2}) . '%%'/ge;
	$dirpath =~ s/<TextField\: ([^\s\>\[]+)\[(\d+)\]>/'%^' . HTMLtoText(${$1}[$2]) . '%%'/ge;
	$dirpath =~ s/<Field\: ([^\s\>\{\[]+)>/\%\^${$1}\%\%/g;
	$dirpath =~ s/<Field\: ([^\s\>\{]+)\{[\'\"]([^\s\>\}\'\"]+)[\'\"]\}>/\%\^${$1}{$2}\%\%/g;
	$dirpath =~ s/<Field\: ([^\s\>\[]+)\[(\d+)\]>/\%\^${$1}[$2]\%\%/g;
	$dirpath =~ s~/\.\.(/|\Z)~$1~g;		# no dot-dot allowed.
	$dirpath =~ s~/\.(/|\Z)~$1~g;		# just get rid of single-dot.
	$dirpath =~ s~[\"\<\>\?\\\*\|]~,~g;
	$dirpath =~ s~\%\^(.*?)\%\%~&Multipart_KillChars($1)~ge;
	if($create && !(-e $dirpath))
	{
		eval { mkpath($dirpath, 0, 0777) };
		if ($@) {
			CRcough("The specified path ($dirpath) could not be created: $@"); 
		}
	}
	return $dirpath;
}
END_SUB



# PARAHEAD: Separated this from the sub multipart_save_fields (1.56)
$addon->hook('SaveNews_1', 'multipart_savenews');
sub multipart_savenews {
	my $addon = shift;
	my @errors = multipart_save_fields();
	if (@errors > 0) {
		$addon->pageHeader('Error whilst uploading');
		print "Could not upload: <ul>" . join('', map { qq~<li>$_</li>~ } @errors) . '</ul><p>The news entry has <b>not</b> been posted.<p>';
		$addon->pageFooter;
		exit;
	}
}


# PARAHEAD: Now possible to have an upload field at the modify news page as well (1.56)
$addon->hook('ModifyNews_EditSave_3', 'multipart_savenews');
sub multipart_savenews {
	my $addon = shift;
	my @errors = multipart_save_fields();
	if (@errors > 0) {
		$addon->pageHeader('Error whilst uploading');
		print "Could not upload: <ul>" . join('', map { qq~<li>$_</li>~ } @errors) . '</ul><p>The news entry has <b>not</b> been posted.<p>';
		$addon->pageFooter;
		exit;
	}
}


# Some new subs to fetch the the size of an image (bozoka45, 2005-09-17)
# Returns two params ($width, $height)
sub multipart_imgsize {
	local($file)= @_;
	my ($width, $height);
  
	#first try to open the file
	if( !open(STREAM, "<$file") ){
		print "Can't open IMG $file"; 
	} else {
		if ($file =~ /.jpg/i || $file =~ /.jpeg/i) {
			($width, $height) = &multipart_jpegsize(STREAM);
		} elsif($file =~ /.gif/i) {
			($width, $height) = &multipart_gifsize(STREAM);
		} elsif($file =~ /.png/i) {
			($width, $height) = &multipart_pngsize(STREAM);
		} else {
			print "$file is not gif, jpeg or png (or has stupid name)";
		}
		close(STREAM);
	}
	return ($width, $height);
}

sub multipart_gifsize {
	local($GIF) = @_;
	read($GIF, $type, 6); 
	my ($width, $height);
	if(!($type =~ /GIF8[7,9]a/) || 
		!(read($GIF, $s, 4) == 4) ){
		print "Invalid or Corrupted GIF"; 
	} else {
		($a,$b,$c,$d)=unpack("C"x4,$s);
		$width = $b<<8|$a;
		$height = $d<<8|$c;
	}
	return ($width, $height);
}

sub multipart_pngsize {
	local($PNG) = @_;
	local($head) = "";
	local($x) = -1;
	local($y) = -1;

	if(read( $PNG, $head, 8 ) == 8 &&
		$head eq "\x89\x50\x4e\x47\x0d\x0a\x1a\x0a" &&
		read($PNG, $head, 4) == 4 &&
		read($PNG, $head, 4) == 4 &&
		$head eq "IHDR" &&
		read($PNG, $head, 8) == 8 ){
		($x,$y)=unpack("I"x2,$head);
	} else {				
		print "Hmmm... Doesn't look like an $PNG file";
	}
	return ($x, $y);
}

sub multipart_jpegsize {
	local($JPEG) = @_;
	local($done)=0;
	my ($width, $height);
	
	read($JPEG, $c1, 1); read($JPEG, $c2, 1);
	if( !((ord($c1) == 0xFF) && (ord($c2) == 0xD8))){
		print "This is not a JPEG!";
		$done=1;
	}
	
	while (ord($ch) != 0xDA && !$done) {
		# Find next marker (JPEG markers begin with 0xFF)
		# This can hang the program!!
		while (ord($ch) != 0xFF) {  read($JPEG, $ch, 1); }
		# JPEG markers can be padded with unlimited 0xFF's
		while (ord($ch) == 0xFF) { read($JPEG, $ch, 1); }
		# Now, $ch contains the value of the marker.
		if ((ord($ch) >= 0xC0) && (ord($ch) <= 0xC3)) {
			read ($JPEG, $junk, 3); read($JPEG, $s, 4);
			($a,$b,$c,$d)=unpack("C"x4,$s);
			$height = $a<<8|$b;
			$width = $c<<8|$d;
			$done=1;
		} else {
			# We **MUST** skip variables, since FF's within variable names are
			# NOT valid JPEG markers
			read ($JPEG, $s, 2); 
			($c1, $c2) = unpack("C"x2,$s); 
			$length = $c1<<8|$c2;
			if( ($length < 2) ){
				print "Erroneous JPEG marker length";
				$done=1;
			} else {
				read($JPEG, $junk, $length-2);
			}
		}
	}
	return ($width, $height);
}




#$addon->hook('SaveNews_1', \<<'END_CODE');

# PARAHEAD: Made this into a sub since it is now used from more than one place (1.56)
###$::Subs{multipart_save_fields} = <<'END_CODE';
sub multipart_save_fields {
	my (@erra, @upload);
	for my $i (@fieldDB) {
		if ( ($up > $fieldDB{$i}->{SubmitPerm}) and (defined $multipart_data{$in{$i}} || defined $multipart_data{$in{"modify$i"}}) ) {
			if(defined $multipart_data{$in{"modify$i"}})
			{
				$in{$i} = $in{"modify$i"};
				$multipart_data{$in{$i}} = $multipart_data{$in{"modify$i"}};
			}
			(my $fn = $in{$i}) =~ s!\A.*(\\|\/)!!;
			if ($fieldDB{$i}->{size} and length $multipart_data{$in{$i}} > $fieldDB{$i}->{size}) {
				push @erra, "$i ($fn): Request to receive too much data. Maximum is $fieldDB{$i}->{size} bytes.";
			}
			my @exts = split / /, $fieldDB{$i}->{ext_types};
			(my $ext = $fn) =~ s/\A.+\.(.+)\Z/$1/;
			if ($fieldDB{$i}->{ext_mode} == 1 and not grep /\A\Q$ext\E\Z/, @exts) {
				push @erra, "$i ($fn): Invalid file extension '$ext'; Valid extensions include: " . join ', ', @exts;
			}
			if ($fieldDB{$i}->{ext_mode} == 2 and grep /\A\Q$ext\E\Z/, @exts) {
				push @erra, "$i ($fn): Invalid file extension '$ext'; Invalid extensions include: " . join ', ', @exts;
			}
			my @convm;
			if ($fieldDB{$i}->{thumbs}) {
				if ($ext =~ /\A(jpg|jpeg)\Z/i) {
					@convm = qw(jpegtopnm ppmtojpeg);
				}
				# PARAHEAD: Added some more thumbnail creation option as suggested by user "jeter" (1.55)
	            elsif ($ext =~ /\A(tif|tiff)\Z/i) { 
	                @convm = qw(tifftopnm ppmtojpeg); 
	            } 
	            elsif ($ext =~ /\A(bmp)\Z/i) { 
	                @convm = qw(bmptopnm ppmtojpeg); 
	            } 
	            elsif ($ext =~ /\A(gif)\Z/i) { 
	                @convm = qw(giftopnm ppmtojpeg); 
	            } 
	            elsif ($ext =~ /\A(png)\Z/i) { 
	                @convm = qw(pngtopnm ppmtojpeg); 
	            }
	            # PARAHEAD: End adding thumbnail creation
	  			else {
					push @erra, "$i ($fn): Cannot create thumbnails from '$ext' files.";
				}
			}
			unless (grep /\A\Q$i\E/, @erra) {
				my %dat = ( 'field' => $i, 'file' => $fn, 'ext' => $ext );
				if ($fieldDB{$i}->{thumbs}) {
					$dat{thumbc} = \@convm;
				}
				push @upload, \%dat;
			}
		}
	}
	if (@erra > 0) {
# PARAHEAD: Now working as a sub instead and returning errorarray (1.56)
#		$addon->pageHeader('Error whilst uploading');
#		print "Could not upload: <ul>" . join('', map { qq~<li>$_</li>~ } @erra) . '</ul><p>The news entry has <b>not</b> been posted.<p>';
#		$addon->pageFooter;
#		exit;
		return @erra;
	}
	
# PARAHEAD: Added a call to BasicDateVars so that time-field can be used when creating the path as well (1.56)
	BasicDateVars($newstime);
# PARAHEAD: Added a call to InitUserFieldVars so that userfields can be used when creating the path as well (1.58)
	InitUserFieldVars();
	my @erra2;
	for my $i (@upload) {
# PARAHEAD: Changed from using mkdir to calling the generic Multipart_MakePath sub instead (1.57)
		my $tpath = Multipart_MakePath($fieldDB{$i->{field}}->{path}, 1);
		my $ttpat = Multipart_MakePath($fieldDB{$i->{field}}->{thumb_path}, 1);

# PARAHEAD: Added option to overwrite or not if file already exists on server (1.56)
		if (!$fieldDB{$i->{field}}->{perm_overwrite} && -e "$tpath/$i->{file}") { 
			my $http = Multipart_MakePath($fieldDB{$i->{field}}->{http});
#			(my $http = $fieldDB{$i->{field}}->{http}) =~ s/<Field: (\w+)>/$$1/gi;
			push @erra2, qq~<A HREF="$http/$i->{file}" target="_blank">$tpath/$i->{file}</A>: The file you're trying to upload already exists at the destination you specified.~; 
		}
	    else
	    {     	
			open MPFH, ">$tpath/$i->{file}" or (push @erra2, "$i->{field} ($i->{file}): Couldn't create final file at dir '$tpath': $!");
			binmode MPFH;
			print MPFH $multipart_data{$in{$i->{field}}};
			close MPFH;
			if ($i->{thumbc}) {
				(my $fn_no_ext = $i->{file}) =~ s/\A(.+)\..+\Z/$1/;
				(my $tf = $fieldDB{$i->{field}}->{thumb_fn}) =~ s/<FileName>/$fn_no_ext/g;
				$tf =~ s/<FileExt>/$i->{ext}/g;

				my $size_x = ($fieldDB{$i->{field}}->{thumb_static_wh}) ? $fieldDB{$i->{field}}->{thumb_w} : $in{"thumbw$i->{field}"};
				my $size_y = ($fieldDB{$i->{field}}->{thumb_static_wh}) ? $fieldDB{$i->{field}}->{thumb_h} : $in{"thumbh$i->{field}"};

				# Fetching demension of original image (bozoka45, 2005-09-17)
				my ($img_height, $img_width) = &multipart_imgsize("$tpath/$i->{file}");

				# Should we stretch the thumbnail to the size of the original image (bozoka45, 2005-09-17)
# PARAHEAD: Changed from || to && instead for checking if the image fits inside the 'box' (1.59)
				if ( ($img_height < $size_y && $img_width < $size_x) && $fieldDB{$i->{field}}->{thumb_stretch} == 0 ) {
					use File::Copy;
					copy("$tpath/$i->{file}", ( $ttpat || $tpath ) . "/$tf") or die "Thumbnail cannot be copied.";
				} else {
				
					open MPCT, "| $CConfig{multipart_netpbm}/$i->{thumbc}->[0] $tpath/$i->{file} >$tpath/$i->{file}.temp.1.ppm" or (push @erra2, "$i->{field} ($i->{file}): Couldn't create temporary ppm file: $!");
					close MPCT;
				
# PARAHEAD: Now supporting width/height and either preserving aspect ratio or not (1.56)
					my $resizer = '';
					if( ($fieldDB{$i->{field}}->{thumb_maintain_ar} || $in{"maintain$i->{field}"}) && $size_x && $size_y) 
					{
						$resizer = "-xysize $size_x $size_y ";
					}
					else
					{
						$resizer .= "-xsize $size_x " if($size_x);
						$resizer .= "-ysize $size_y " if($size_y);
					}
					open MPCU, "| $CConfig{multipart_netpbm}/pnmscale $resizer $tpath/$i->{file}.temp.1.ppm >$tpath/$i->{file}.temp.2.ppm" or (push @erra2, "$i->{field} ($i->{file}): Couldn't resize ppm file: $!");
#					open CU, "| $CConfig{multipart_netpbm}/pnmscale -xysize " . ( $fieldDB{$i->{field}}->{thumb_static_wh} ? "$fieldDB{$i->{field}}->{thumb_w} $fieldDB{$i->{field}}->{thumb_h}" : qq~$in{"thumbw$i->{field}"} $in{"thumbh$i->{field}"}~ ) . " $tpath/$i->{file}.temp.1.ppm >$tpath/$i->{file}.temp.2.ppm" or (push @erra2, "$i->{field} ($i->{file}): Couldn't resize ppm file: $!");
					close MPCU;
				
					open MPCV, "| $CConfig{multipart_netpbm}/$i->{thumbc}->[1] $tpath/$i->{file}.temp.2.ppm >" . ( $ttpat || $tpath ) . "/$tf" or (push @erra2, "$i->{field} ($i->{file}): Couldn't create final thumbnail file: $!");
					close MPCV;
					unlink "$tpath/$i->{file}.temp.1.ppm";
					unlink "$tpath/$i->{file}.temp.2.ppm";
				}
			}
			${$i->{field}} = $i->{file};
		}
	}
# PARAHEAD: Now working as a sub instead and returning errorarray (1.56)
#	if (@erra2 > 0) {
#		$addon->pageHeader('Error whilst uploading');
#		print "Could not upload: <ul>" . join('', map { qq~<li>$_</li>~ } @erra2) . '</ul><p>The news entry has <b>not</b> been posted.<p>';
#		$addon->pageFooter;
#		exit;
#	}
	return @erra2;
}
#END_CODE

$addon->hook('Multipart_SaveField', \<<'END_CODE');
if ($fieldDB{$field}->{FieldType} == 6) {
	CRcough('Invalid maximum bytes. Only numbers are valid.') if $in{size} =~ /[^0-9]/;
	if ($in{ext_mode} > 0) {
		CRcough("You didn't enter any extensions to allow/disallow.") unless $in{ext_types};
		CRcough('Invalid file extensions. Only numbers, letters, and underscores are allowed.') if $in{ext_types} =~ /[^a-zA-Z0-9_ ]/;
	}
}
END_CODE

$addon->hook('StyletoPerl', \<<'END_CODE');
    $style =~ s!<FilePath: (\w+)>!~;(my \$final_http = \$fieldDB{'$1'}->{http}) =~ s/<Field: (\\w+)>/\$\$1/gi;\$newshtml .= "\$final_http/\$$1";\$newshtml .= qq~!g;
#    $style =~ s!<FileSize: (\w+)>!~;(my \$final_path = \$fieldDB{'$1'}->{path}) =~ s/<Field: (\\w+)>/\$\$1/gi;\$newshtml .= "$1: \$$1" . int((stat("\$final_path/\$$1"))[7]/1024);\$newshtml .= qq~!g;
    $style =~ s!<FileSize: (\w+)>!~;\$newshtml .= &Multipart_FetchSize('$1');\$newshtml .= qq~!g;
    $style =~ s!<ThumbPath: (\w+)>!~;(my \$ext = \$$1) =~ s/^.+\\.(.+)\$/\$1/;(my \$fn_no_ext = \$$1) =~ s/^(.+)\\..+\$/\$1/;(my \$tf = \$fieldDB{'$1'}->{thumb_fn}) =~ s/<FileName>/\$fn_no_ext/g;\$tf =~ s/<FileExt>/\$ext/g;my \$final_thumb_http;if (\$fieldDB{'$1'}->{thumb_http}) {(\$final_thumb_http = \$fieldDB{'$1'}->{thumb_http}) =~ s/<Field: (\\w+)>/\$\$1/gi;}(my \$final_http = \$fieldDB{'$1'}->{http}) =~ s/<Field: (\\w+)>/\$\$1/gi;\$newshtml .= \$fieldDB{'$1'}->{thumb_http} ? "\$final_thumb_http/\$tf" : "\$final_http/\$tf";\$newshtml .= qq~!g;
END_CODE

sub Multipart_FetchSize {
	my ($field) = @_;
# PARAHEAD: Changed to use the generic path sub instead (1.57)
	my $final_path = Multipart_MakePath($fieldDB{$field}->{path});
	my $response = $$field?int((stat("$final_path/$$field"))[7]/1024):'';
	return $response;
}


$addon->hook('EditNewsStyles_Edit', \<<'END_CODE');
	$msg .= qq~<p><b>Multipart fields:</b><br>
	<b>&lt;FilePath: [UPLOAD_FIELD]&gt;</b> Replace '[UPLOAD_FIELD]' with the name of the File Upload field you want to print the http path to. Example: &lt;img src="&lt;FilePath: CustomField_My_Upload_Image_Field&gt;"&gt;<br>
	<b>&lt;FileSize: [UPLOAD_FIELD]&gt;</b> Replace '[UPLOAD_FIELD]' with the name of the File Upload field you want to print the size in Kb for. Example: &lt;img src="&lt;FileSize: CustomField_My_Upload_Image_Field&gt;"&gt;<br>
	<b>&lt;ThumbPath: [UPLOAD_FIELD]&gt;</b> Replace '[UPLOAD_FIELD]' with the name of the File Upload fields thumbnail directory you want to print the http path to. Example: &lt;img src="&lt;ThumbPath: CustomField_My_Upload_Image_Field&gt;"&gt;<br>~;
END_CODE

$addon->hook('Multipart_DisplayField', \<<'END_CODE');

	$fcode = '';
# PARAHEAD: Added a call to InitUserFieldVars so that userfields can be used when creating the path as well (1.58)
	InitUserFieldVars();

	# Should we present an Dropdown box?
	if ($fieldDB{$fn}->{upload_mode} > 1) {
			
		if(!$Category && $CConfig{AddonsLoaded} =~ /(cra_xmultisubmit\.pl)/) {
			my @LockCats = split(/\`\|\`/, $XMS_DB{$profname}->{LockCats});
			$Category = $LockCats[0];
		}
# PARAHEAD: Changed to use the generic path sub instead (1.57)
		$fieldDB{$fn}->{path} = Multipart_MakePath($fieldDB{$fn}->{path});
		$fieldDB{$fn}->{http} = Multipart_MakePath($fieldDB{$fn}->{http});
			
# PARAHEAD: Added alphabetical sorting of files (1.56)
		my @sortedfiles;
# PARAHEAD: Added optional upload field... (1.56)
		$fcode .= qq~Upload a new file: <input type="file" name="modify$fn"><br>~ if($fieldDB{$fn}->{upload_mode} == 3);
		$fcode .= qq~<select name="$fn"><option value="">No File</option>~;

		opendir DIR, $fieldDB{$fn}->{path};
		while ($_ = readdir DIR) {
			next if $_ =~ /\A\.\.?\Z/; 
			(my $ext = $_) =~ s/\A.+\.(.+)\Z/$1/;
			my @exts = split / /, $fieldDB{$fn}->{ext_types};
			next if $fieldDB{$fn}->{ext_mode} == 1 and not grep /\A\Q$ext\E\Z/, @exts;
			next if $fieldDB{$fn}->{ext_mode} == 2 and grep /\A\Q$ext\E\Z/, @exts;
# PARAHEAD: for later sorting (1.56)
			push @sortedfiles, $_;
		}
		closedir DIR;
			
# PARAHEAD: Added foreach loop for alphabetical sorting (1.56)
		foreach my $file(sort {uc($a) cmp uc($b)} @sortedfiles)
		{
			$fcode .= qq~<option value="$file">$file</option>~;
		}
		$fcode .= '</select> ';

		if($fieldDB{$fn}->{images}) {
            #added the following code here to re-add url path to pics ONLY if "select images" type box is used. this was nessesary after stripping file path from 'value' in select box (notice added argument)
			my $maintain = ($fieldDB{$fn}->{thumb_maintain_ar} || !$fieldDB{$fn}->{thumbs}) ? '1' : "document.submitnews.maintain$fn.checked";
            $fcode .= qq~<input type="button" value="(Re-)Generate Preview~ . ( $fieldDB{$fn}->{thumbs} ? 'of Thumbnail' : '' ) . qq~" name="genimgprvw$fn" style="font-size: 10px" onclick="spawn_preview(0, '$fn', '$fieldDB{$fn}->{http}/', document.submitnews.$fn.value, $maintain~;
		}
	}
	else {
		$fcode = qq~<input type="file" name="$fn">~;
		if($fieldDB{$fn}->{images}) {
            #added this slightly modded code here avoid picture URL data being added to the field when uploading a file, only mod was a comma to null extra argument in modded "spawn_preview" javascript function
			my $maintain = ($fieldDB{$fn}->{thumb_maintain_ar} || !$fieldDB{$fn}->{thumbs}) ? '1' : "document.submitnews.maintain$fn.checked";
            $fcode .= qq~<input type="button" value="(Re-)Generate Preview~ . ( $fieldDB{$fn}->{thumbs} ? 'of Thumbnail' : '' ) . qq~" name="genimgprvw$fn" style="font-size: 10px" onclick="spawn_preview(0, '$fn', 'file:', document.submitnews.$fn.value, $maintain~;
		}
	}
	
	if($fieldDB{$fn}->{images}) {
		if($fieldDB{$fn}->{thumbs}) {
# PARAHEAD: Added support for aspect ratio on/off (1.56)
			my $tmpfcode = '';
			if ($fieldDB{$fn}->{thumb_static_wh}) {
				$fcode .= qq~, $fieldDB{$fn}->{thumb_w}, $fieldDB{$fn}->{thumb_h})">~;
			}
			else {
				$fcode .= qq~, document.submitnews.thumbw$fn.value, document.submitnews.thumbh$fn.value)">~;
				$tmpfcode .= qq~Thumbnail width: <input size="2" name="thumbw$fn" value="$fieldDB{$fn}->{thumb_w}"> height: <input size="2" name="thumbh$fn" value="$fieldDB{$fn}->{thumb_h}">~;
			}
			if (!$fieldDB{$fn}->{thumb_maintain_ar}) {
				$tmpfcode .= ($tmpfcode ? qq~ Maintain~ : qq~Maintain thumbnail~) . qq~ aspect ratio <input type="checkbox" name="maintain$fn" value="1" checked>~;
			}
			$fcode .= qq~<br>$tmpfcode~ if $tmpfcode;
		}
		else {
			# Default Preview size
			$fcode .= qq~, 100, 100)">~;
		}
		
		$fcode .= qq~<br><div id="imgprvw$fn">&nbsp;</div><script language="javascript">spawn_preview(0, '$fn');</script>~;
	}
END_CODE


# PARAHEAD: This sub returns only the *link* and not the <A> part as the original core PageLink sub (1.56)
my $msURL;
$::Subs{multipart_PageLink} = <<'END_CODE';
sub multipart_PageLink {
	my ($url, $key, $val);
	my ($params) = @_;
	while (($key, $val) = each %$params) {
		$url .= '&amp;' . URLescape($key) . '=' . URLescape($val) if $key;
	}
	$msURL ||= "$scripturl?session=$CurrentSession&amp;x=$AntiCache";
	return qq~$msURL$url~;
}
END_CODE


# PARAHEAD: Changed so this is now a sub since it will be used in more than one place (1.56)
#$addon->hook('DisplaySubForm_FormStart', \<<'END_CODE');
$addon->hook('DisplaySubForm_FormStart', 'multipart_spawn_preview');
#tweaked javascript 'spawn_preview" function below to add a new argument for path and file.  The old argument was only URL, which doesn't work since I stripped the full URL out of the 'value' statement
$::Subs{multipart_spawn_preview} = <<'END_CODE';
sub multipart_spawn_preview {
print qq~
<script language="javascript">

var images = new Array();

function spawn_preview_loaded() {
//alert("OK!");
	this.bLoaded = true;
	var mp = this.multipart;
	spawn_preview(1, mp[0], mp[1], mp[2], mp[3], mp[4], mp[5]);
}

function spawn_preview(imgloaded, fn, path, file, ar, w, h) {
//alert("spawn imgloaded= " + imgloaded + ", fn=" + fn + ", ar=" + ar + ", w=" + w + ", h=" + h);

	var ul = eval("document.submitnews.modify" + fn);
	if( (typeof ul == "object") && (ul.value != '') ) {path='file:///'; file = ul.value; }
	
	if (file) {
		// PARAHEAD: Added support for aspect ratio (1.56)
//alert("ar: " + ar + ", w: " + w + ", h: " + h);		

		var key = path + file;
		if((typeof images[key]) == "object"){
			imgloaded = 1;
		} else {
			images[key] = new Image();
		    images[key].src = path + file;
	    }

   		if(ar || !(w && h)) {
			if(imgloaded != 1) {
				images[key] = new Image();
			    images[key].src = path + file;
				images[key].multipart = [fn, path, file, ar, w, h];
				images[key].onload = spawn_preview_loaded;
				return;
	    	}
			var ratiox = w?w/images[key].width:100;
			var ratioy = h?h/images[key].height:100;
			if(ratiox < ratioy) {
				h = Math.floor(ratiox * images[key].height);
			} else if (ratioy < ratiox) {
				w = Math.floor(ratioy * images[key].width);
			}
//alert("corrected width/height w=" + w + ", h=" + h);
		}
		html = '<img src="' + path + file + '" width="' + w + '" height="' + h + '">';
	}
	else {
		html = 'No image available...';
	}
	if (document.all) {
		eval('imgprvw' + fn).innerHTML = html;
	}
	//PARAHEAD: Added support for getElementById which should work in all newer browsers... (1.55)
    else if (document.getElementById) {
    	eval(document.getElementById('imgprvw' + fn)).innerHTML = html;
	}
	/*else if (document.layers) {
		document.eval('imgprvw' + fn).document.write(html);
		document.eval('imgprvw' + fn).document.close();
	}*/
	else {
		alert('Get IE 4+. NS Support is coming soon...');
	}
}

</script>~;
}
END_CODE

$addon->hook('EditFieldDB_1', \<<'END_CODE');
if ($fieldDB{$i}->{FieldType} == 6) {
	$info .= 'File Upload';
}
END_CODE

$addon->hook('EditFieldDB_2', \<<'END_CODE');
	$fieldtypes .= qq~<option value="6">File Upload</option>~;
END_CODE

$addon->hook('DisplaySubForm_Fields', \<<'END_CODE');
if ($fieldDB{$fn}->{FieldType} == 6){
	if($Addons{Multipart_DisplayField}){for my $w (@{$Addons{Multipart_DisplayField}}){my $addon=$w->[2];eval ${$w->[0]};AErr($addon,$@)if $@;};}
}
END_CODE

$addon->hook('NewsFieldEditSave_1', \<<'END_CODE');
if($Addons{Multipart_SaveField}){for my $w (@{$Addons{Multipart_SaveField}}){my $addon=$w->[2];eval ${$w->[0]};AErr($addon,$@)if $@;};}
END_CODE



$addon->hook('ModifyNews_Edit_PreLoop', 'multipart_spawn_preview');

$addon->hook('ModifyNews_Edit_Fields', \<<'END_CODE');

if ($fieldDB{$fn}->{FieldType} == 6){
# PARAHEAD: Added array for alphabetical sorting of files (1.56)
	my @sortedfiles;
	$fcode = '';
# PARAHEAD: Added a call to InitUserFieldVars so that userfields can be used when creating the path as well (1.58)
	InitUserFieldVars();
	
#	if ($fieldDB{$fn}->{images}) {
		#if ($fieldDB{$fn}->{images} == 2) {   
        #Had to kill the "== 2" above to make script not distingish between upload and select type fields
# PARAHEAD: Added optional upload field... (1.56)
			$fcode .= qq~Upload a new file: <input type="file" name="modify$fn"><br>~ if($fieldDB{$fn}->{upload_mode} != 2);
            $fcode .= qq~<select name="$fn"><option value="">No File</option>~;
            
            #PARAHEAD: The two lines below are for fetching the absolute paths
# PARAHEAD: Changed to use the generic path sub instead (1.57)
            $fieldDB{$fn}->{path} = Multipart_MakePath($fieldDB{$fn}->{path});
            $fieldDB{$fn}->{http} = Multipart_MakePath($fieldDB{$fn}->{http});
#PARAHEAD: Added the two lines below for backward compability with older Multipart-installations
            my @tmpfiles = split /\//, $$fn;
            $$fn = pop @tmpfiles;
            
			opendir DIR, $fieldDB{$fn}->{path};
			while ($_ = readdir DIR) {
				next if $_ =~ /\A\.\.?\Z/; 
				(my $ext = $_) =~ s/\A.+\.(.+)\Z/$1/;
				my @exts = split / /, $fieldDB{$fn}->{ext_types};
				next if $fieldDB{$fn}->{ext_mode} == 1 and not grep /\A\Q$ext\E\Z/, @exts;
				next if $fieldDB{$fn}->{ext_mode} == 2 and grep /\A\Q$ext\E\Z/, @exts;
# PARAHEAD: for later sorting (1.56)
				push @sortedfiles, $_;
                
			}
			closedir DIR;
			
# PARAHEAD: Added foreach loop for alphabetical sorting (1.56)
			foreach my $file(sort {uc($a) cmp uc($b)} @sortedfiles)
			{
					if ($file eq $$fn) {
						$fcode .= qq~<option value="$file" selected="selected">$file</option>\n~;
					}
					else {
           				$fcode .= qq~<option value="$file">$file</option>\n~;
					}
			}			
			$fcode .= '</select> ';
			
		if ($fieldDB{$fn}->{images}) {
			my $maintain = ($fieldDB{$fn}->{thumb_maintain_ar} || !$fieldDB{$fn}->{thumbs}) ? '1' : "document.submitnews.maintain$fn.checked";
			$fcode .= qq~<input type="button" value="(Re-)Generate Preview~ . ( $fieldDB{$fn}->{thumbs} ? 'of Thumbnail' : '' ) . qq~" name="genimgprvw$fn" style="font-size: 10px" onclick="spawn_preview(0, '$fn', '$fieldDB{$fn}->{http}/', document.submitnews.$fn.value, $maintain~;
		if ($fieldDB{$fn}->{thumbs}) {
# PARAHEAD: Added support for aspect ratio on/off (1.56)
			my $tmpfcode = '';
			if ($fieldDB{$fn}->{thumb_static_wh}) {
				$fcode .= qq~, $fieldDB{$fn}->{thumb_w}, $fieldDB{$fn}->{thumb_h})">~;
			}
			else {
				$fcode .= qq~, document.submitnews.thumbw$fn.value, document.submitnews.thumbh$fn.value)">~;
				$tmpfcode .= qq~Thumbnail width: <input size="2" name="thumbw$fn" value="$fieldDB{$fn}->{thumb_w}"> height: <input size="2" name="thumbh$fn" value="$fieldDB{$fn}->{thumb_h}">~;
			}
			if (!$fieldDB{$fn}->{thumb_maintain_ar}) {
				$tmpfcode .= ($tmpfcode ? qq~ Maintain~ : qq~Maintain thumbnail~) . qq~ aspect ratio <input type="checkbox" name="maintain$fn" value="1" checked>~;
			}
			$fcode .= qq~<br>$tmpfcode~ if $tmpfcode;
		}
		else {
			$fcode .= qq~, 100, 100)">~;
		}
		$fcode .= qq~<br><div id="imgprvw$fn">&nbsp;</div><script language="javascript">document.submitnews.genimgprvw$fn.click()</script>~;
	}
}
END_CODE


#PARAHEAD: Added this code to pad on the http-path again when saving a modified news
#$addon->hook('ModifyNews_EditSave_2', \<<'END_CODE');
#if ($fieldDB{$fn}->{images} == 2) {
#    $$fn = "$fieldDB{$fn}->{http}/$$fn";
#}
#END_CODE



$::Subs{multipart_insert} = <<'END_CODE';
sub multipart_insert {
return <<'END_INS';
sub ReadForm {
	$multipart_running = 1;
# PARAHEAD: Used to correctly handle plus/space characters later on (Multipart 1.57)
	my $multipart_form = 0;
	binmode STDIN;
	binmode STDOUT;
	binmode STDERR;
	my @buffer;
	if ($ENV{REQUEST_METHOD} =~ /^(GET|HEAD)$/) {
		for my $pair ( split /[&;]/, $ENV{QUERY_STRING} ) {
			my ($key, $value) = split /=/, $pair, 2;
			push @buffer, [$key, $value];
		}
	}
	elsif ($ENV{REQUEST_METHOD} eq 'POST') {
		my $buffer;
		if ((my $received = read(STDIN, $buffer, $ENV{CONTENT_LENGTH})) != $ENV{CONTENT_LENGTH}) {
			CRcough("Short read: wanted $ENV{CONTENT_LENGTH}, but unfortunately got $received");
		}
		if ($ENV{CONTENT_TYPE} =~ m|^multipart/form-data|) { # Begin multipart
			$multipart_form = 1;
			my ($boundary) = $ENV{CONTENT_TYPE} =~ /boundary=\"?([^\";,]+)\"?/;
			CRcough("Couldn't find boundary. This is usually caused by a bug server-side.") unless $boundary;
			$boundary = "--$boundary";
			for my $i (grep /^\s*Content-Disposition:/i, split /$boundary/, $buffer) {
				my @data = split("\r\n\r\n", substr($i, 0, length($i) - 2));
				my $headers = shift @data;
				my %header;
				while ($headers =~ /([-\w!\#$%&\'*+.^_\`|{}~]+):"?(.+)"?/xmgo) {
					my ($name, $value) = ($1, $2);
					$name =~ s/\b(\w)/\u$1/g;
					$header{$name} = $value;
				}
				my ($key) = $header{'Content-Disposition'} =~ / name="?([^\";]*)"?/;
				my $value = join "\r\n\r\n", @data;
				# POSSIBLE BUG ALERT: Netscape does not escape quotation marks in file names?
				my ($filename) = $header{'Content-Disposition'} =~ / filename="?([^\"]*)"?/;
				#$filename =~ s!\\!/!g;
				$filename =~ s~[^\w\d \-_:/\\\.]~~g;
				if ($filename) {
					$::multipart_data{$filename} = $value;
					push @buffer, [$key, $filename];
				}
				else {
					push @buffer, [$key, $value];
				}
			}
		} # End multipart
		else {
			for my $pair ( split /&/, $buffer ) {
				my ($key, $value) = split /=/, $pair, 2;
				push @buffer, [$key, $value];
			}
		}
		# Append the query-string to the buffer? Only uncomment the below lines if you know what you're doing.
		#for my $pair ( split /[&;]/, $ENV{QUERY_STRING} ) {
		#	my ($key, $value) = split /=/, $pair;
		#	push @buffer, [$key, $value];
		#}
	}
	else {
	  	CRcough("Unknown request method used: $ENV{REQUEST_METHOD}");
	}
	undef %in;
	for my $pair (@buffer) {
		my ($name, $value) = ($pair->[0], $pair->[1]);
		$name =~ tr/+/ / unless($multipart_form);
		$name =~ s/%([a-fA-F0-9]{2})/pack("c", hex($1))/eg;
		$value =~ tr/+/ / unless($multipart_form);
		$value =~ s/%([a-fA-F0-9]{2})/pack("c", hex($1))/eg;
# PARAHEAD: Added newline translation as suggested from the forum to reflect core change (Multipart 1.56)
		# Translate OS-specific newline chars into Perl's logical one 
		$name =~ s/\015?\012/\n/gi;
		$value =~ s/\015?\012/\n/gi;
		exists $in{$name} ? ($in{$name} .= "|x|$value") : ($in{$name} = $value);
	}
}
END_INS
}
END_CODE

$addon->hook('EarlyHook', \<<'END_CODE', 10);
if (defined $CConfig{multipart_netpbm} && !-e $CConfig{multipart_netpbm}) {
	undef $CConfig{multipart_netpbm};
	CRcough('Your path to NetPBM is invalid. Please correct your NetPBM path in Change Settings.');
}
if ($in{action} eq 'admin' && $up == 3) {
	NeedFile('cradmin.pl');
	$Subs{NewsFieldEdit} =~ s/('newsfieldeditsave'})/$1, 'name="editfield"'/;
}
$Subs{DisplaySubForm} =~ s~(name="submitnews")~enctype="multipart/form-data" $1~;
# PARAHEAD: Added this so that the modify news page is also a multipart type (1.56)
$Subs{ModifyNews_Edit} =~ s~(name="submitnews")~enctype="multipart/form-data" $1~;
unless ($CConfig{multipart_setup} =~ /^successful: (\d+)$/ && $1 == $multipart_build && $CConfig{multipart_crb} == $crcgiBuild && $multipart_running) {
	eval <<'	END_SETUP';
	print qq~<!doctype html public "-//W3C//DTD HTML 4.0 Transitional//EN">
	<html><head><title>Multipart Setup</title></head>
	<body><center><form action="$scripturl" method="post">~;
	print "Preparing to setup the Coranto addon Multipart version $multipart_version (build $multipart_build) for Coranto $crcgiVer (build $crcgiBuild).<br><br>";
	my $build;
	if ($CConfig{multipart_setup}) {
		($build = $CConfig{multipart_setup}) =~ s/^successful: (\d+)$/$1/;
		print "You perviously setup Multipart build $build, switching to upgrade mode.<br><br>";
	}
	unless ($up == 3) {
		print '<b>Error:</b> You must be an administrator to setup this addon.<br><br>';
		exit;
	}
	my $files = (defined $build and $build < 8) ? ['crcore.pl', 'crlib.pl'] : ['crlib.pl'];
	print "Setup must patch <b>" . join(' and ', @$files) . '</b> (please <b>chmod ' . ( @$files > 1 ? 'them' : 'it' ) . q~ 0777</b>, if needed) for Multipart to run properly.<br><br><b>Upon pressing 'Patch Coranto' if you are prompted with a Coranto Login screen you MUST tell Coranto to REMEMBER YOUR LOGIN INFORMATION!!</b><br><br><input type="submit" name="patch" value="Patch Coranto"~;
	if ($in{patch}) {
		my ($read_err, $write_err);
		print ' disabled><br><br>';
		for my $fn (@$files) {
			# read it...
			print "Opening $fn for reading... ";
			open FH, "$CConfig{admin_path}/$fn" or ($read_err = $!);
			my $fd = join '', <FH>;
			close FH;
			if ($read_err) {
				print "<b>$read_err</b><br><br>";
				exit;
			}
			print 'successful.<br><br>';
			# patch it...
			if ($fn eq 'crcore.pl') {
				$fd =~ s/# START: MULTIPART INSERT[\s\S]+?# END: MULTIPART INSERT/ReadForm\(\);/;
			}
			elsif ($fn eq 'crlib.pl') {
				$fd =~ s/sub\s*ReadForm[\s\S]+?\{[\s\S]+?\$value\);[\s\S]{0,5}?\}[\s\S]{0,5}?\}/&multipart_insert/e;
			}
			# write it...
			print "Opening to $fn for writing... ";
			open FH, ">$CConfig{admin_path}/$fn" or ($write_err = $!);
			print FH $fd;
			close FH;
			if ($write_err) {
				print "<b>$write_err</b><br><br>";
				exit;
			}
			print 'successful.<br><br>';
		}
		# Upgrade paths to the new format
		if ($CConfig{multipart_src}) {
			$CConfig{multipart_icons_src} = $CConfig{multipart_src};
			$CConfig{multipart_icons_path} = $CConfig{multipart_src};
			delete $CConfig{multipart_src};
		}


		# Patching Multipart fields to the new upload_mode setting (1.59)
		NeedCFG();
		my @updatedFields;
		foreach my $fn (@fieldDB) {
			if( ($fieldDB{$fn}->{FieldType} == 6) && !defined $fieldDB{$fn}->{upload_mode}) {
				push @updatedFields, $fn;
				$fieldDB{$fn}->{upload_mode} = 1 if ($fieldDB{$fn}->{images} == 1);
				$fieldDB{$fn}->{upload_mode} = 2 if (!$fieldDB{$fn}->{images} == 2);
				$fieldDB{$fn}->{upload_mode} = 3 if ($fieldDB{$fn}->{images} && $fieldDB{$fn}->{selectbox_loader});
				$fieldDB{$fn}->{images} = 1 if ($fieldDB{$fn}->{images});
				delete $fieldDB{$fn}->{selectbox_loader};
				NeedFile('cradmin.pl');				
				SettingsEngine_Save(NewsFieldEditDef($fieldDB{$fn}->{'FieldType'}), $fieldDB{$fn});
			}
		}
		if(@updatedFields) {
			print "Updating the following Multipart fields to new format:<ul>" . join('', map { qq~<li>$_</li>~ } @updatedFields) . '</ul>';
			SaveCRCFG();
		}
		
		
		$CConfig{multipart_setup} = "successful: $multipart_build";
		$CConfig{multipart_crb} = $crcgiBuild;
		print qq~Setup of Multipart version $multipart_version (build $multipart_build) has completed successfully!<br><br><input type="button" value="Return to Coranto" onclick="document.location='$scripturl';"~;
	}
	print '></form></center></body></html>';
	exit;
	END_SETUP
}
END_CODE

1;
__END__

=head1 Multipart

=head2 INTRODUCTION

This addon allowes you to upload any type of file through the Coranto interface.
It is possible to do this either when submitting newsitems by using a special
File Upload field, which you create at the normal Coranto News Field management page.
The uploaded file will then be 'tied' to the newsitem and you will be able to use
it in your Styles.
The second approach is to use the Upload Manager with which you can upload files
independent of a newsitem.
The Upload Manager relies on Multipart Profiles created at the normal Coranto Profile
management page.
For both the File Upload Field and the Multipart Profile it is possible to specify which
type of files are allowed to being uploaded, size restriction and a destination folder
for the uploaded file.

The File Upload Field also contains special features for handling images, so that you
can create thumbnails by using the third party package NetPBM, more about this below.  

=head2 INSTALLATION

The distribution package for this addon contained two readme-files, check those out.

=head2 MAIN SETTINGS

Under the normal Change Settings page there is a Multipart header with a couple
of settings. Most of these settings are releated to the apperance and functionality
of the Upload Manager, stuff like how many upload boxes to show, the file tree view,
and so on. There also is a field where you should enter the absolutue path to NetPBM
if you would like to use the thumbnail feature available in the File Upload field.

=head3 NetPBM

NetPBM is a third party package which can be obtained at L<http://netpbm.sourceforge.net/>.
If you are using a webhotel the chance are that NetPBM is already installed, check with
your host to get the aboslute path of the folder in which NetPBM recides. If you do need
to get hold of a precompiled package of NetPBM you can find links at the link above, but
a small tip if you dont find your decired plattform would be to see if it may be included
in the Gallery script, also available at Sourcefourge at L<http://gallery.sourceforge.net/>

If you do run into problems with NetPBM please do a search in the forum at CTUS
(L<http://coranto.gweilo.org/forum/> to see if the topic has been covered before. 

=head2 UPLOAD MANAGER

You find the Upload Manager through the quicklinks at the bottom of the Coranto
Main Page. Before using the Upload Manager you need to create one or more Multipart Profiles,
which is done under the normal Profile Management page, just enter the Profile name and
choose 'Multipart' as the Profile Type in the dropdown.

Once you have created a Multipart Profile you click on the 'Edit Profile Settings' for that
profile where you have a bunch of settings like maximum file size, extensions to allow, upload
and delete permissions for user and so on. They all have help texts on that page so you should
be OK.

If you click on the Upload Manager link and get a message about Multipart cant find any Multipart
Profiles, you probably havent created any. A normal user can recieve this message as well,
but then it can be caused by the privelegies for the Multipart Profiles are set to disallow
him access.

=head2 FILE UPLOAD FIELD

With Multipart you can create a new type of field called 'File Upload' which lets
you upload files together with a newsitem at submission time. The settings page
includes a bunch of settings which is more or less self-explainatory, there are some
that needs a little more information.

The 'Upload Path' and 'Upload Directory' can contain custom fields and even date/time fields if you
like. This can come in handy if would like to create a folder structure based on the newsitems year
and month submission in order not to get a really large base directory with all submitted images.
Another thing this can be used for is if you want to create a image gallery with different sub-folders.
Then you can create a drowdown box with the available sub-folders (like animals, house, people) and
then use this Custom Field in the path so the image is placed in the correct subfolder when submitting
the newsitem.


The "Specify Upload Field mode" has three options which are explained in more detail below,
the default being the "Pure Upload Field".

=over

=item *

The B<Pure Upload Field> - Makes the File Upload field work as a normal upload
field where you have a browse-button so you can choose the file to upload from your
local machine.

=item *

The B<Dropdown box with files from Upload Path> - When this mode is selected the Upload Field
isn't really an upload field, but instead the files within the Upload Path are presented in
a dropdown box for the user to choose from.

=item *

The B<Combination of Dropdown Box and Upload Field> - Just what it says, both a dropdown box
and an Upload Field is presented, letting the user either choose an already uploaded file
or upload a new one to that destination folder.

=back

If you choose to enable the Image Function for a File Upload field you will have a 'Preview'-button
available at the Submit- and Modify News pages. When the image function is enabled, you can also
specify som additional thumbnail settings. The thumbnail creation requires you to have NetPBM
installed on your server. What to enter for each of those thumbnail settings should be quite obvious
and they also contains help text which explains the use of each specific setting.

=head2 STYLETAGS

Multipart gives you some new styletags to play with in your Styles, they are:

=over

=item *

<B<FilePath:> CustomField_X> The http path to the specific file in the File Upload field and current newsitem.

=item *

<B<FileSize:> CustomField_X> The file size in Kb of the specific file in the File Upload field and current newsitem.

=item *

<B<ThumbPath:> CustomField_X> The File Upload fields thumbnail you want to print the http path to. Only usefull if the 'Image Function' is enabled for the File Upload field.

=back

=head3 TROUBLESHOOTING

=over

=item *

Size of thumbnails are 0 Kb - This was a problem before when Multipart only could create thumbnails for JPG files or if
the filename included spaces. This should have been solved in this release, but if you do
encounter it, please make a detailed report in the Coranto Forum at CTUS (L<http://coranto.gweilo.org/>).

=item *

Clicking on the Upload Manager link produces a message about Multipart Profiles are missing - You
probably havent created any Multipart Profiles then? Check the section above about the Upload Manager.
A normal user can recieve this message as well, but then it can be caused by the privelegies for
the Multipart Profiles are set to disallow him access.

=item *

I use a File Upload field in my style to present an image, but if the user doesnt provide an image, I get
a broken image, what should I do? - Use the If-statement available in Coranto Styles to check if the field
contains a value, like <If: Field: CustomField_X><img src="<FilePath: CustomField_X"></If> 

=item *

I have a File Upload field with the Image Function set to the 'Select Image'-type and then the thumbnails
arent created! - Yes, I know, this is a known issue and I will deal with it in feature versions.

=item *

My problem isnt covered here? - Please perform  a search in the forum at CTUS
(L<http://coranto.gweilo.org/forum/> to see if the topic has been covered before.
If not, make a detailed post about your problem in the forum. 

=back



	                   