#! CRADDON 1
#! NAME Moveit!
#! DESCRIPTION No more problems with backup and server transfers! Moveit! makes (periodically and silently, automatic or manual) a backup copy of all Coranto essential files. it can also (if required) apply the due changes for an easier server trasfer (local->remote, remote->local or remote->remote) or mirroring. 
#! VERSION alfa build 1
#! DOC 1
#! HOMEPAGE mailto:cerberos76@yahoo.com">E-Mail Author</a>] [<a href="

# Files considered essential
# ==============================
# (i.e from these files plus a fresh coranto installation 
# you can rebuilt eveything as before):
# nsettings.cgi, crcfg.dat, cruser.pl, cruser.pl, newsdat.txt
# plus all the template files

my $addon = new Addon('Moveit');
$addon->checkBuild(28);
$addon->registerAdminFunction('moveit_parameters', 'moveit_parameters');
$addon->registerAdminFunction('moveit_saveparameters', 'moveit_saveparameters');
$addon->registerAdminFunction('moveit_main', 'moveit_main');
$addon->addAdminFunction('MoveIt!', 'Advanced backup and site transfer', 'moveit_parameters');


# moveit_parameters: Display Moveit and Parameters Selection Screen.
$Subs{'moveit_parameters'} = << 'END_SUB';
sub moveit_parameters {
	my $addon = shift;
	$addon->pageHeader('MoveIt! Parameters', 1);
       
      #from here to the end of the sub, it is guestpost additions 
   print $addon->heading("Parameter selection for MoveIt!");
   print $addon->descParagraph("These parameters allow you to set your Moveit addon as an advanced backup for all the essential files, or as a site transfer utility!");
   
  print $addon->form({'action' => 'admin', 'adminarea' => 'moveit_saveparameters'});
 
      my $moveit_modein=1;
      if ( $CConfig{'moveit_modein'} ne ""){
         $moveit_modein =  $CConfig{'moveit_modein'} ;}
      my $checked_str="";
      print qq~<div align="center"> ~; 
      print qq~<table width=50% style="border: 2px solid blue";><tr><td align=middle>Moveit! Mode:</td></tr><tr><td> ~; 

      ($moveit_modein == 1) ? ($checked_str="CHECKED") : ($checked_str=""); 
      print qq~<input type="radio" name="modein" value="1" $checked_str>Advanced backup<br> ~;

      ($moveit_modein == 2) ? ($checked_str="CHECKED") : ($checked_str=""); 
       print qq~<input type="radio" name="modein" value="2" $checked_str>Remote -> Localhost Transfer<br>~;
    
      ($moveit_modein == 3) ? ($checked_str="CHECKED") : ($checked_str=""); 
       print qq~<input type="radio" name="modein" value="3" $checked_str>Localhost -> Remote Transfer<br>~;
       
      ($moveit_modein == 4) ? ($checked_str="CHECKED") : ($checked_str="");
       print qq~<input type="radio" name="modein" value="4" $checked_str>Remote -> Remote Transfer<br>~;
 
     print qq~</td></tr></table></div><br><br> ~; 

    print $addon->heading("Advanced Parameters for Moveit!");

     my $movetime_initial="604800";
      if ( $CConfig{'moveit_movetime'} ne ""){
         $movetime_initial =  $CConfig{'moveit_movetime'} ;}
     my $movetime_str="<input type=\"text\" name=\"moveit_movetime\" value=\"$movetime_initial\" size=\"35\">";
    print $addon->settingTable("Frequency of backup/transfer", $movetime_str, "Insert the frequency of your backup or file transfers in seconds. As a guide, 1 day = 86400s ; 2 days = 172800s; 7 days = 604800s, 30 days = 2592000s. <br>Example: 604800");

    my $dstback_initial="$CConfig{'htmlfile_path'}/moveit"; 
      if ( $CConfig{'moveit_dstback'} ne ""){
         $dstback_initial=  $CConfig{'moveit_dstback'} ;}
      my $dstback_str="<input type=\"text\" name=\"moveit_dstback\" size=\"35\" value=\"$dstback_initial\">"; 
      print $addon->settingTable("Destination Path directory for the backup repository", $dstback_str, "Put the destinatinon path directory for your backup or transfer files. All backup/moveit files will be put inside this directory. Leave the suggested path (the coranto html path nd subdirectory moveit) if you are not sure. <br>Example: /users/myname/html/coranto");

    my $dsturl_initial="$CConfig{'SiteLink'}"; 
      if ( $CConfig{'moveit_dsturl'} ne ""){
         $dsturl_initial=  $CConfig{'moveit_dsturl'} ;}
      my $dsturl_str="<input type=\"text\" name=\"moveit_dsturl\" size=\"35\" value=\"$dsturl_initial\">"; 
      print $addon->settingTable("(New) URL of your site", $dsturl_str, "Put the URL (in the form http://www.mysite.com) of your NEW site (the one where you want to move your files into). Put http://localhost if you are moving from remote to localhost for local testing. [parameter only useful if you are tranferring files, not used for backup]<br>Example: /users/myname/html/coranto");

      my $crtpath_initial="$CConfig{'admin_path'}"; 
      if ( $CConfig{'moveit_crtpath'} ne ""){
         $crtpath_initial=  $CConfig{'moveit_crtpath'} ;}
      my $crtpath="<input type=\"text\" name=\"moveit_crtpath\" size=\"40\" value=\"$crtpath_initial\">"; 
      print $addon->settingTable("Current Path to the Coranto User files", $crtpath, "Put the path to the cruser.pl . Leave the suggested path (the coranto path) if you have used the standard installation or if you are not sure. <br>Example: /users/myname/cgi-bin/coranto");

      my $nsetpath_initial="$CConfig{'admin_path'}"; 
      if ( $CConfig{'moveit_nsetpath'} ne ""){
         $nsetpath_initial=  $CConfig{'moveit_nsetpath'} ;}
      my $nsetpath="<input type=\"text\" name=\"moveit_nsetpath\" size=\"40\" value=\"$nsetpath_initial\">"; 
      print $addon->settingTable("Current Path to the Coranto configuration files", $nsetpath, "Put the path to the nsettings.cgi, crcfg.dat. Leave the suggested path (the coranto path) if you have used the standard installation or if you are not sure. <br>Example: /users/myname/cgi-bin/coranto");

      my $newspath_initial="$CConfig{'htmlfile_path'}"; 
      if ( $CConfig{'moveit_newspath'} ne ""){
         $newspath_initial=  $CConfig{'moveit_newspath'} ;}
      my $newspath="<input type=\"text\" name=\"moveit_newspath\" size=\"40\" value=\"$newspath_initial\">"; 
      print $addon->settingTable("Current Path to the Coranto newsdat.txt file", $newspath, "Put the path to the newsdat.txt. Leave the suggested path if you have used the standard installation or if you are not sure. <br>Example: /users/myname/html/coranto/news");

      my $tmplpath_initial="$CConfig{'admin_path'}"; 
      if ( $CConfig{'moveit_tmplpath'} ne ""){
         $tmplpath_initial=  $CConfig{'moveit_tmplpath'} ;}
      my $tmplpath="<input type=\"text\" name=\"moveit_tmplpath\" size=\"40\" value=\"$tmplpath_initial\">"; 
      print $addon->settingTable("Current Path to the template (.tmpl) files", $tmplpath, "Put the path to the template files you use in your styled for Coranto. Leave the suggested path (the coranto path) if you have placed the .tmpl file in the coranto cgi-bin directoty as suggested in the readme instructions. <br>Example: /users/myname/cgi-bin/coranto");

      my $profpath_initial="$CConfig{'htmlfile_path'}"; 
      if ( $CConfig{'moveit_profpath'} ne ""){
         $profpath_initial=  $CConfig{'moveit_profpath'} ;}
      my $profpath="<input type=\"text\" name=\"moveit_profpath\" size=\"40\" value=\"$profpath_initial\">"; 
      print $addon->settingTable("Current Path to the (common) Root of all your Coranto Profiles", $profpath, "Put the path to the root of your profile files. For example if your profile 'review' file sits in d:/users/root/crt/reviews_dir/review.txt and your profile 'books' file sits in d:/users/root/crt/books_dir/books.txt, then enter here d:/users/root/crt (the common root to both) Leave the suggested path if you have used the same path as for standard news or if you are not sure. <br>Example: /users/myname/html/coranto/news");

    my $dstcrtpath_initial="C:/Sambar5/cgi-bin/coranto";
    if ($moveit_modein == 2) { $dstcrtpath_initial="C:/Sambar5/cgi-bin/coranto" ;}
    if (($moveit_modein == 3) || ($moveit_modein == 4))  { $dstcrtpath_initial="/users/myname/cgi-bin/coranto" ;}
    if ( $CConfig{'moveit_dstcrtpath'} ne ""){
         $dstcrtpath_initial=  $CConfig{'moveit_dstcrtpath'} ;}
      my $dstcrtpath="<input type=\"text\" name=\"moveit_dstcrtpath\" size=\"40\" value=\"$dstcrtpath_initial\">"; 
      print $addon->settingTable("Destination Path to the Coranto User files", $dstcrtpath, "Put the destinatinon path for the cruser.pl . Adjust it starting from the suggested path (a possible coranto path) if you are not sure. [parameter only useful if you are tranferring files, not used for backup]<br>Example: /users/myname/cgi-bin/coranto");

    my $dstnsetpath_initial="C:/Sambar5/cgi-bin/coranto"; 
    if ($moveit_modein == 2) { $dstnsetpath_initial="C:/Sambar5/cgi-bin/coranto" ;}
    if (($moveit_modein == 3) || ($moveit_modein == 4))  { $dstnsetpath_initial="/users/myname/cgi-bin/coranto" ;}
    if ( $CConfig{'moveit_dstnsetpath'} ne ""){
         $dstnsetpath_initial=  $CConfig{'moveit_dstnsetpath'} ;}
      my $dstnsetpath="<input type=\"text\" name=\"moveit_dstnsetpath\" size=\"40\" value=\"$dstnsetpath_initial\">"; 
      print $addon->settingTable("Destination Path to the Coranto configuration files", $dstnsetpath, "Put the destination path for the nsettings.cgi, crcfg.dat. Adjust it starting from the suggested path (a possible coranto path) if you are not sure. [parameter only useful if you are tranferring files, not used for backup]<br>Example: /users/myname/cgi-bin/coranto");

     my $dstnewspath_initial="C:/Sambar5/cgi-bin/coranto/news"; 
     if ($moveit_modein == 2) { $dstnewspath_initial="C:/Sambar5/cgi-bin/coranto/news" ;}
     if (($moveit_modein == 3) || ($moveit_modein == 4)) { $dstnewspath_initial="/users/myname/cgi-bin/coranto/news" ;}
      if ( $CConfig{'moveit_dstnewspath'} ne ""){
         $dstnewspath_initial=  $CConfig{'moveit_dstnewspath'} ;}
      my $dstnewspath="<input type=\"text\" name=\"moveit_dstnewspath\" size=\"40\" value=\"$dstnewspath_initial\">"; 
      print $addon->settingTable("Destination Path to the Coranto newsdat.txt file", $dstnewspath, "Put the destination path for the (backup or transfer) newsdat.txt. Adjust it starting from the suggested path (a possible newsdat path) if you are not sure. [parameter only useful if you are tranferring files, not used for backup]<br>Example: /users/myname/html/coranto/news");

      my $dsttmplpath_initial="C:/Sambar5/cgi-bin/coranto";  
     if ($moveit_modein == 2) { $dsttmplpath_initial="C:/Sambar5/cgi-bin/coranto" ;}
     if (($moveit_modein == 3) || ($moveit_modein == 4)) { $dsttmplpath_initial="/users/myname/cgi-bin/coranto" ;}
      if ( $CConfig{'moveit_dsttmplpath'} ne ""){
         $dsttmplpath_initial=  $CConfig{'moveit_dsttmplpath'} ;}
      my $dsttmplpath="<input type=\"text\" name=\"moveit_dsttmplpath\" size=\"40\" value=\"$dsttmplpath_initial\">"; 
      print $addon->settingTable("Destination Path to the template (.tmpl) files", $dsttmplpath, "Put the destination path to the template files you use in your styled for Coranto. Adjust it starting from the suggested path (a possible standard path for the template files) if you are not sure. [parameter only useful if you are tranferring files, not used for backup]<br>Example: /users/myname/cgi-bin/coranto");

    my $dstprofpath_initial="C:/Sambar5/html/coranto";  
     if ($moveit_modein == 2) { $dstprofpath_initial="C:/Sambar5/html/coranto" ;}
     if (($moveit_modein == 3) || ($moveit_modein == 4)) { $dstprofpath_initial="/users/myname/html/coranto" ;}
      if ( $CConfig{'moveit_dstprofpath'} ne ""){
         $dstprofpath_initial=  $CConfig{'moveit_pdstrofpath'} ;}
      my $dstprofpath="<input type=\"text\" name=\"moveit_dstprofpath\" size=\"40\" value=\"$dstprofpath_initial\">"; 
      print $addon->settingTable("Destination Path to the (common) Root of all your Coranto Profiles", $dstprofpath, "Put the path to the root of your profile files (as in the NEW server where you transfer files). For example if your profile 'review' file will sit in d:/users25/root/crt/myreviewsexcellent/review.txt and your profile 'books' file will sit in d:/users25/root/crt/books_newdir/books.txt, then enter here d:/users25/root/crt (the common root to both)  Leave the suggested path if you have used the same path as for standard news or if you are not sure. <br>Example: /users/myname/html/coranto/news");

         print $addon->submitButton("Save Settings");
	   print qq~ </form></center><br><br>~;

   #next backup
   if ($CConfig{'moveit_lastbackup'}) {
   my $nextbackuptime=$CConfig{'moveit_lastbackup'}+$CConfig{'moveit_movetime'};
   my $difftime=0; # difference [hours] local time-server time
   my ($sec_bk,$min_bk,$hour_bk,$mday_bk,$mon_bk,$year_bk,$wday_bk)=(localtime($nextbackuptime + (3600*$difftime)))[0..6];
   $year_bk += 1900; my $mon_okbk=$mon_bk+1;
   my $date_bk = "$mday_bk-$mon_okbk-$year_bk";
   my $time_bk = "$hour_bk:$min_bk:$sec_bk";
      print qq~<div align="center"> ~; 
      print qq~Your next scheduled backup will be on $date_bk at $time_bk <br>[dd-mm-yyyy, hh:mm:ss] ~; 
      print qq~</div><br> ~; 
      }

      #user is in a hurry... do it immediately
  if ($userdata{$CurrentUser}->{'UserLevel'} > 2) {
        if ($CConfig{'moveit_savedparam'}) {
       print $addon->form({'action' => 'admin', 'adminarea' => 'moveit_main'});
    
      print qq~<div align="center"> ~; 
      print qq~<table width=70% style="border: 2px solid red";><tr><td align=middle>Moveit! Do Backup/Transfer NOW:</td></tr><tr><td> ~; 
      print qq~I simply want a backup or transfer NOW. <br>I have already saved the above parameters and I am happy with them.
But in addition to the background backup/transfer as scheduled, I also want one NOW [Note: if you have not yet saved the parameters or if you have just changed them, please save them BEFORE forcing the backup]<br>~;
     print qq~</td></tr>~; 
     print qq~<tr><td align=middle><input type="hidden" name="doitnow" value="5"><input type="submit" name="submit" value="Backup/transfer NOW"></td></tr>~;
     #print $addon->submitButton("Backup/transfer NOW");
     print qq~</table></div></form></center><br>~;
     }#if saved parameters
   }#if admin

     $addon->pageFooter();
}
END_SUB


# moveit_saveparameters: Saves Moveit! parameters in Coranto config space.
$Subs{'moveit_saveparameters'} = << 'END_SUB';
sub moveit_saveparameters {
  my $addon = shift;

#save parameters not needing checks
$CConfig{'moveit_movetime'} = $in{'moveit_movetime'};
$CConfig{'moveit_dstback'} = $in{'moveit_dstback'};
$CConfig{'moveit_dsturl'} = $in{'moveit_dsturl'};

$CConfig{'moveit_crtpath'} = $in{'moveit_crtpath'};
$CConfig{'moveit_nsetpath'} = $in{'moveit_nsetpath'};
$CConfig{'moveit_tmplpath'}  = $in{'moveit_tmplpath'};
$CConfig{'moveit_newspath'} = $in{'moveit_newspath'};
$CConfig{'moveit_profpath'} = $in{'moveit_profpath'};
$CConfig{'moveit_dstcrtpath'} = $in{'moveit_dstcrtpath'};
$CConfig{'moveit_dstnsetpath'} = $in{'moveit_dstnsetpath'};
$CConfig{'moveit_dsttmplpath'}  = $in{'moveit_dsttmplpath'};
$CConfig{'moveit_dstnewspath'} = $in{'moveit_dstnewspath'};
$CConfig{'moveit_dstprofpath'} = $in{'moveit_dstprofpath'};
$CConfig{'moveit_savedparam'}=1;
$CConfig{'moveit_doitnow'}=0;

#then do checks on this
 if ($in{'modein'}) {
    $CConfig{'moveit_modein'} = $in{'modein'};
 } 
 else { $addon->simplePage("MoveIt! Error", 'There is a problem setting the mode of operation for Moveit!.  Please go back and try again or press' . $addon->link({'action' => 'admin', 'adminarea' => 'moveit_parameters'}) . 'Back to MoveIt!</a>.', 1);
 return;
 }

 # if it is all ok, let's be happy
$addon->simplePage("Moveit! Parameters saved", 'The parameters were successfully saved, according to your request <br>'. $addon->link({'action' => 'admin', 'adminarea' => 'moveit_parameters'}) . ' Back to MoveIt!</a>.', 1);
}
END_SUB



#========    MAIN Backup/transfer function     =========
# moveit_main:  Moveit! MAIN Backup/transfer function
$Subs{'moveit_main'} = << 'END_SUB';
sub moveit_main {
my $addon = shift;

my $CurrentTime = time;
#internal backup time variables
#time of last backup [s]
my $MI_lastbackup=$CurrentTime;
if ( $CConfig{'moveit_lastbackup'} ne ""){
   $MI_lastbackup =  $CConfig{'moveit_lastbackup'} ;}

#when to backup next [s]
my $MI_movetime=604800;
if ( $CConfig{'moveit_movetime'} ne ""){
   $MI_movetime =  $CConfig{'moveit_movetime'} ;}

# force do backup now?
if ($in{'doitnow'}==5){$CConfig{'moveit_doitnow'}=1;}
$MI_doitnow = $CConfig{'moveit_doitnow'};

if (($MI_doitnow)||(($CurrentTime - $MI_lastbackup) > $MI_movetime)) {
 
 # It's time for backup/move
 #=======    Other  Parameters    =====================

#where to put backup files
my $MI_TransfDir= $CConfig{'moveit_dstback'};

#parameters used inside the files....
#inside sources 
my $MI_crtpath= $CConfig{'moveit_crtpath'};
my $MI_nsetpath= $CConfig{'moveit_nsetpath'};
my $MI_newspath= $CConfig{'moveit_newspath'};
my $MI_tmplpath= $CConfig{'moveit_tmplpath'};
my $MI_profpath= $CConfig{'moveit_profpath'};
my $MI_url= $CConfig{'SiteLink'};

#inside destinations
my $MI_dstcrtpath= $CConfig{'moveit_dstcrtpath'};
my $MI_dstnsetpath= $CConfig{'moveit_dstnsetpath'};
my $MI_dstnewspath= $CConfig{'moveit_dstnewspath'};
my $MI_dsttmplpath= $CConfig{'moveit_dsttmplpath'};
my $MI_dstprofpath= $CConfig{'moveit_dstprofpath'};
my $MI_dsturl= $CConfig{'moveit_dsturl'};

#Coranto paths
$MI_AdminDir=$CConfig{'admin_path'};
$MI_htmlDir=$CConfig{'htmlfile_path'};

my $file;
if (!(-d $MI_TransfDir)){
  mkdir($MI_TransfDir,777);
}

#======= Essential files to move/backup ==============
# Coranto files
my $nsettings_file="nsettings.cgi";
my $crcfg_file="crcfg.dat";
my $newsdat_file="newsdat.txt";
my $nsettings_full="$MI_nsetpath/$nsettings_file";
my $crcfg_full="$MI_nsetpath/$crcfg_file";
my $newsdat_full="$MI_newspath/$newsdat_file";
# User functions
my $cruser_file="cruser.pl";
my $cruser_full="$MI_crtpath/$cruser_file";

# User templates
 opendir (DIR, "$MI_tmplpath") or die "Directory not existent.";
 @dirdata = readdir(DIR);
 closedir (DIR);
 # put .tmpl files in an array
 @tmplfiles = grep(/tmpl/,@dirdata);
 @fullpathtmpl = @tmplfiles ;
 @fullpathtmpl = map($_= "$MI_tmplpath/".$_,@fullpathtmpl);
#=================================================

#======= collect full list of files to move together
push (@files_move,$nsettings_file,$crcfg_file,$newsdat_file,$cruser_file);
@totfile_move= (@files_move, @tmplfiles);

push (@full_move,$nsettings_full,$crcfg_full,$newsdat_full,$cruser_full);
@totfull_move= (@full_move, @fullpathtmpl);
#=================================================

@hashfile{@totfile_move} = @totfull_move;
#while (($k, $v) = each %hashfile) {print "\n$k=>\n$v \n"};

 #========  now copy the files in $MI_TransfDir
 while (($file, $fullpath) = each %hashfile)
 {
  # open (FILEIN,"<$fullpath");
  my $FILEIN = $addon->open($fullpath);
  my @in=<$FILEIN>;
  close $FILEIN;
  
  if ($CConfig{'moveit_modein'}>1){ #change paths/URLs
   my $str_orig1="$MI_crtpath"; my $str_chang1="$MI_dstcrtpath";
   my $str_orig2="$MI_nsetpath"; my $str_chang2="$MI_dstnsetpath";
   my $str_orig3="$MI_newspath"; my $str_chang3="$MI_dstnewspath";
   my $str_orig4="$MI_tmplpath"; my $str_chang4="$MI_dsttmplpath";
   my $str_orig5="$MI_profpath"; my $str_chang5="$MI_dstprofpath";
   my $str_orig6="$MI_url"; my $str_chang6="$MI_dsturl";

   grep (($_=~ s/$str_orig1/$str_chang1/g)&& 0, @in);
   grep (($_=~ s/$str_orig2/$str_chang2/g)&& 0, @in);
   grep (($_=~ s/$str_orig3/$str_chang3/g)&& 0, @in);
   grep (($_=~ s/$str_orig4/$str_chang4/g)&& 0, @in);
   grep (($_=~ s/$str_orig5/$str_chang5/g)&& 0, @in);
   grep (($_=~ s/$str_orig6/$str_chang6/g)&& 0, @in);
  }
  
  my $newfilename=$MI_TransfDir."/".$file;
  #open (FILEOUT,">$newfilename");
  my $FILEOUT = $addon->open(">".$newfilename);
  print $FILEOUT join('', @in);
  close ($FILEOUT);

 }#end while (for all files..)

#======= record backup/transfer time	
$CConfig{'moveit_lastbackup'} = $CurrentTime;

# ============       logging      =======================
#===== count number of files to move 
my $tot_files=@totfile_move-1;
my $tmplcount= @tmplfiles - 1;
my $crt_files=$tot_files-$tmplcount;
#===== what date and time is it? 
my $difftime=0; # difference [hours] local time-server time
my ($sec,$min,$hour,$mday,$mon,$year,$wday)=(localtime(time + (3600*$difftime)))[0..6];
$year += 1900; my $mon_ok=$mon+1;
my $date_now = "$mday-$mon_ok-$year";
my $time_now = "$hour:$min:$sec";
#Date ++ Time of last Backup/Transfer: [dd-mm-yyyy]++[hh:mm:ss]
my $logstring = "$date_now ++ $time_now ;; Files: $tot_files total ($tmplcount templates) ;; Mode: $CConfig{'moveit_modein'}\n";
#===== write to log file
my $logfilename=$MI_TransfDir."/log.txt"; my $FILEOUT;
if (-e $logfilename){ $FILEOUT = $addon->open(">>".$logfilename);}
 else {$FILEOUT = $addon->open(">" .$logfilename);}
print $FILEOUT $logstring;
close ($FILEOUT);

# ========0 result if coming from force backup now
if ($CConfig{'moveit_doitnow'}==1){
   $addon->simplePage("Moveit! Backup ok", "The backup/transfer has been done immediately according to your request.<br><br>Log Details [Date [dd-mm-yyyy] ++ Time of last Backup/Transfer [hh:mm:ss];; Files  ;; Mode]: <br>$logstring<br><br>". $addon->link({'action' => 'admin', 'adminarea' => 'moveit_parameters'}) . ' Back to MoveIt!</a>.', 1);
 }

 #reset the force backupnow flag
 $CConfig{'moveit_doitnow'}=0;
 }#end if backup time

}#end sub
END_SUB
#=======================================================

#if you want it to check only when you submit
#$addon->hook('EditNewsdat_Finish', "moveit_main");
#to check the backuptime on every login
$addon->hook('MainPage', "moveit_main");

1;

__END__

=head1 Moveit!

=head2 DESCRIPTION & USAGE

As an advanced backup utility, MoveIt! periodically makes a copy of Coranto essential files (nsettings.cgi, crcfg.dat, cruser.pl, newsdat.txt, plus your template files) in a particular directory you can set. With those files you can rebuild your site in no time from a fresh copy of Coranto (in case it is needed!).
Optionally Moveit! can also be used as an help to move your files between servers. In fact it can apply the due changes for an easier server trasfer (local->remote, remote->local or remote->remote) or mirroring of sites.

When the addon is enabled it will work autonomously in the background and do all the work for you (it is activated only if someone logs in Coranto though...). So, provided you login often enough, you will always have a secure backup of ALL needed files.
This addon will make an additional copy of your main files, so the space requirements will go up, as you will always have two copies (or more if you also use other backup addons) of the essential files. No slowdown of operation should be noticed.
This is the only method to provide security and absolutely a must for any serious webmaster.


=head2 CONFIGURATION

Go in the Administration window for MoveIt and fill in the parameters associated with the backup or transfer. You will see:

=item *

Moveit! Mode: one of the following four options:  Advanced backup, Remote -> Localhost Transfer, Localhost -> Remote Transfer, Remote Transfer. The advanced Backup will take care of automatically backing up your files in the directory you choose at time intervals set by you.
The other three modes help you when transferring files between different servers. 
as an example here are some possible uses of the transfer mode:
- if you wish to setup a Coranto on your local PC before transferring it on your customers's servers, or on your remote host; 
- if you wish to debug a particular configuration on your local PC; 
- if you wish to move and periodically synchronise different installations of Coranto kept on different machines (as your main server and a backup server).
- if you wish to "install" Coranto for your mates locally on your PC, and then have files ready to copy on their servers.
[Note that Moveit! is NOT an FTP utility; it simply prepares the files for you all in  single directory. But then you still have to move them where they are useful]
- to enable a cron backup from the server to your local machine on a single (and smaller) directory.

=item *

Frequency of backup/transfer: How many seconds will pass betwenn consecutive backups or transfers. Typically you will want a backup every day (86400s) orevery week (604800s). But depending on how important is your data and how worried are you, you might set this up even every hour (3600s) or whatever else you prefer.

=item *

Destination Path directory for the backup repository. This is where the back-up/transfer files will be saved periodically. Leave the suggested initial value if you don't know or don't care.

=item *

(New) URL of your site. This is the URL of the new link to your site. (this will replace the SiteLink parameter in the backup/transfer files). 
[only useful if you are tranferring files, not used for backup]

=item *

The next set of parameters are the paths in your current installation:
1. Current Path to the Coranto User files. 
2. Current Path to the Coranto configuration files. 
3. Current Path to the Coranto newsdat.txt file
4. Current Path to the template (.tmpl) files
5. Current Path to the root directory of your profiles
These are respectively: the path to the cruser.pl, the path to the nsettings.cgi and crcfg.dat, the path to the newsdat.txt file, the path to your template files and the path to the common root of your progfile files. If you did not change anything in the standard installation, 1.,2. and 4. will all be the same (your coranto cgi-bin directory). The addon already gives you very good guesses, so you should not change them unless you have changes things on your setup.

=item *

Then you have the corresponding 5 destination paths, for User files, configuration files, newsdat.txt database and tmpl files. These are the corresponding values of the five parameters in your current configuration, but as they will appear in your new server. 
These will be used during the file preparation for your transfer (as they might be used inside the files themselves).
[only useful if you are tranferring files, not used for backup]

=head2 How to use the backups

Backups are usually there for security reasons. So normally, you would not want to use them at all... But if (for any reason and it might happen every so often) you lose or get a corrupted file for any of your fundamental Coranto files (nsettings.cgi, crcfg.dat, cruser.pl, newsdat.txt, plus your template files), you can:
- replace the given file with the copy you find in the backup directory
- If you were not satisfied with your coranto set-up, you can even install a fresh Coranto and then substitute all the files contained in the backup with their corrispective in the Coranto new installation.

=head2 Note of warning

Be warned that you are at risk until this addon is in alfa. This addon will access important files of your Coranto filesystem (even if the eventual modifications are only done on the copies).
If you are not confortable with this, please use this addon on a backup system until you trust it fully (and eventual bugs are ironed out). Please report ANY problem that this addon is causing.

=head2 Note on Profiles

[this ONLY applies to the transfer modes, NOT to the Advanced Backup]
This alfa 1 will assume that all profiles are branching from a common root in your file system. This will be true in most of the installations. But if you have different settings, then some of the paths will not be automatically translated in the new transfer files.
We suggest you to have a common root from which to branch different directories for your profiles. It is much cleaner for your site. But if you keep different profiles in completly different roots (or different servers), then you will have to do some manual editing of your configuration files for a full transfer.

=head2 The author of this addon

The author of this addon is: cerberos76 (email: cerberos76@yahoo.com). 
The two reasons for this addon are: security (help in backups) and transfer functionality (to allow remote preparation of files for someoneelse and synchronisation between servers).
