#! CRADDON 1
#! NAME Field Helper
#! DESCRIPTION Allows you to add a help link to each news field so you can provide special intructions on filling out that field. Version 1.0 by AeroSoul. Version 1.1 by Gansos Version 1.2 PirateElf
#! VERSION 1.2
#! DOC 1

my $addon = new Addon('Field Helper');
$addon->registerMainFunction('FieldHelper','FieldHelper');

my $EditFieldHelper = <<'END CODE';
push(@NFEDef, ['FieldHelper', 'Field Helper', 'Add help/instructions that the users will be able to see when filling out this field. Leave empty to disable.']);
END CODE

my $DisplayFieldHelper = <<'END CODE';
$fieldDB{$fn}->{'DisplayName'} .= qq~ (<a style="cursor:hand;" href="" onclick="window.open('$scripturl?session=$CurrentSession\&x=$AntiCache\&action=FieldHelper\&helpfield=$fn','Help','width=250,height=150,'); return false;">?</a>)~ if ($fieldDB{$fn}->{'FieldHelper'});
END CODE

my $FieldHelperReminder = <<'END CODE';
print qq~<div class="fieldtitle" align="center">$CConfig{'FieldHelperReminder'}</div><br>~ if ($CConfig{'FieldHelperReminder'});
END CODE

my $FieldHelperSettings = <<'END CODE';
$addon->addAdvancedSettingHeading('Field Helper');
$addon->addAdvancedSetting('FieldHelperReminder','Reminder','You can also set a standard message to appear at the top of the submit and modify news pages. The purpose of this message is to inform the users of the help links (eg: If you have any questions about any of the fields, click on the help link "(?)" next to the name of the field). HTML is allowed. Leave empty to disable.');
$addon->addAdvancedSetting('FieldHelperStyle','Style','http:// path to css style sheet for the field helper. No trailing slash /');
$addon->addAdvancedSetting('FieldHelperCss','Css','Alternatively you can use custom css code here if you would rather not use a style sheet. <br>*Do not use a custom Style sheet AND custom css!',qq~<textarea rows=\"6\" name="FieldHelperCss"cols="60" wrap="off">$CConfig{'FieldHelperCss'}</textarea>~);
END CODE

$addon->hook(DisplaySubForm_FormStart,\$FieldHelperReminder);
$addon->hook(ModifyNews_Edit_PreLoop,\$FieldHelperReminder);
$addon->hook(DisplaySubForm_Fields,\$DisplayFieldHelper);
$addon->hook(ModifyNews_Edit_Fields,\$DisplayFieldHelper);
$addon->hook(NewsFieldEditDef_2,\$EditFieldHelper);
$addon->hook(AdvSettings,\$FieldHelperSettings);

$Subs{'FieldHelper'} = <<'END SUB';
sub FieldHelper {
NeedCFG();
my $field = $fieldDB{$in{'helpfield'}}->{'DisplayName'};
my $fieldhelp = $fieldDB{$in{'helpfield'}}->{'FieldHelper'};
$fieldhelp =~ s/</&lt;/g;
$fieldhelp =~ s/>/&gt;/g;
$fieldhelp =~ s/"/&quot;/g;
	$fhstyle = ' ';
	$fhcss = ' ';

if ($::CConfig{'FieldHelperStyle'})
{
	$fhstyle = $CConfig{'FieldHelperStyle'};
print qq~<html>\n<head>\n<title>Help: $field</title>\n$Messages{'ContentType'}\n<link rel='stylesheet'
type='text/css' href='$fhstyle'>   </head>\n<body><div style="position:absolute; top: 4; left: 3px; right: 3px;">$fieldhelp</div><div style="position:absolute; top: 130; right: 3px;"><a href="" onclick="window.close()" style="cursor:hand;">Close Window</a></div>\n</body>\n</html>~;

}
elsif ($::CConfig{'FieldHelperCss'})
{
	$fhcss = $CConfig{'FieldHelperCss'};
print qq~<html>\n<head>\n<title>Help: $field</title>\n$Messages{'ContentType'}\n
	<style type='text/css'>$fhcss</style>\n
</head>\n<body><div>$fieldhelp</div><div style="position:absolute; top: 130; right: 3px;"><a href="" onclick="window.close()" style="cursor:hand;">Close Window</a></div>\n</body>\n</html>~;
}
else
{
print qq~<html>\n<head>\n<title>Help: $field</title>\n$Messages{'ContentType'}\n<style type='text/css'>body {
	font-family: Arial, Helvetica, sans-serif; font-size: 15px; background-color: #FFEFD1;} a { color: #CC3300; text-decoration: none } a:hover { text-decoration: underline }</style></head>\n<body><div>$fieldhelp</div><div style="position:absolute; top: 130; right: 3px;"><a href="" onclick="window.close()" style="cursor:hand;">Close Window</a></div>\n</body>\n</html>~;
}
}

END SUB

1;

__END__

=head1 Field Helper

To use, simply go to "Edit News Fields" from the Administration menu, and choose (edit) the field for which you want to add FieldHelper. You will see a new field where you can enter a description of the news field. Repeat the process for other fields if desired.

When you go to the submit news page, there will be a question mark (?) next to each field name that has help. Clicking on the question mark will spawn a pop-up window with the field's help text that you entered earlier. In some browsers, you may need to turn off pop-up blockers for this to work. Safari and Firefox do not appear to block FieldHelper windows with their pop-up blockers turned on, however.

There are three additional settings located in the Administration area. To access them, go to "Change Settings" from the Administration menu, and scroll down to the Field Helper settings area.

In the settings area, you can set a standard message to appear at the top of the submit and modify news pages to inform users of the help links. You can also change the style sheet of the FieldHelper pop-us to match your Coranto theme or you may enter any valid CSS style codes.
