#! CRADDON 1
#! NAME FaceLift
#! DESCRIPTION Updates Coranto's administration interface.
#! VERSION 3.2 (Modified For RW)
#! HOMEPAGE http://www.sumaleth.com/coranto/
#! DOC 1

# Addon by Rowan 'Sumaleth' Crawford / SEVERLY MODIFIED BY DARKELF


NeedFile('cradmin.pl');

my $addon = new Addon('FaceLift');

$addon->isPrivacyCompatible; 
$addon->addAdvancedSettingHeading('Facelift Settings');
$addon->addAdvancedSetting('fac_lift', 'Enable Facelift', 'Do you wish to globally enable facelift?', 'yn');

###
# add select box hook 
##
$addon->hook('EditUserInfo',\<<'END_CODE');
	$selected = $userdata{$CurrentUser}->{'EnableFacelift'};
	print FieldsRow("Enable&nbsp;Facelift?",
	q~<select name="EnableFacelift">
			<option value="Yes"~.( $selected eq 'Yes' ? ' selected' : '' ).q~>Yes (On)</option>
			<option value="No"~.( $selected eq 'No' ? ' selected' : '' ).q~>No (Off)</option>
		</select>~	
	);

END_CODE

#
###
# save select box hook
##

$addon->hook('EditUserInfoSave_2',\<<'END_CODE');
	$userdata{$username}->{'EnableFacelift'} = $in{'EnableFacelift'};
END_CODE

if (($CConfig{'AddonsLoaded'} =~ /shutdown/) && ($CConfig{SuperAdmin} ne $CurrentUser))
{
}
else {
   if ($::userdata{$CurrentUser}->{'EnableFacelift'} eq 'No')
{
}
  elsif ($::CConfig{'fac_lift'} == 1 || $::userdata{$CurrentUser}->{'EnableFacelift'} eq 'Yes')

{
$CConfig{'LinkBarPosition'} = 0 if !$CConfig{'LinkBarPosition'};
$CConfig{'LinkBarAddon'} = 1 if !$CConfig{'LinkBarAddon'};

$addon->registerAdminFunction('editprofileheadlines','EditProfileHeadlines');
$addon->registerAdminFunction('editprofileheadlinessave','EditProfileHeadlinesSave');


## Modified coranto.cgi subroutines
*CRHTMLHead = \&CRHTMLHeadFL;
*CRHTMLFoot = \&CRHTMLFootFL;
## Modified crcore.pl subroutines
*MidHeading = \&MidHeadingFL;
*MidParagraph = \&MidParagraphFL;
*LoadFunctionList = \&LoadFunctionListFL;
*StartFieldsTable = \&StartFieldsTableFL;

#################################
#################################
## NEW SUBROUTINES
#################################
#################################
$::Subs{'EditProfileHeadlines'} = <<'END_CODE';
sub EditProfileHeadlines {
	my $prof = $in{'profname'};
	CRHTMLHead("Headlines Settings for &quot;$prof&quot;",1);
	print StartForm( {'profname' => $prof, 'action' => 'admin', 'adminarea' => 'editprofileheadlinessave'} );
	SettingsEngine_Display(LoadHeadlinesSettings($prof), $newsprofiles{$prof});
	print q~<table align="center" width="80%" border="0">
		<tr><td class="confirm"><div align="center"><input type="submit" value="Save Settings">
		</div></td></tr></table></form>~;
	CRHTMLFoot();
}
END_CODE
$::Subs{'EditProfileHeadlinesSave'} = <<'END_CODE';
sub EditProfileHeadlinesSave {
	my $prof = $in{'profname'};
	CRdie("Invalid profile information") unless ($prof && $newsprofiles{$prof});
	$newsprofiles{$prof}->{'ForceFullBuild'} = 1;
	SettingsEngine_Save(LoadHeadlinesSettings($prof), $newsprofiles{$prof});
	if (!$newsprofiles{$prof}->{'headlines'}) {
		$newsprofiles{"$prof-headlines"} = {'enabled' => 0};
	}
	WriteProfileInfo();
	SettingsConfirm(PageLink({'action' => 'admin', 'adminarea' => 'profilelist'}) . 'Back to Edit Profiles</a>.');
}
END_CODE
$::Subs{'LoadHeadlinesSettings'} = <<'END_CODE';
sub LoadHeadlinesSettings {
	my $prof = shift;
	
	my @ProfileHeadlinesSettings = (
	['heading: Headlines Settings'],
	['headlines', 'Enable Headlines', "<ul><li>This option creates a file called <i>" . ($prof eq 'news' ? 'headlines.txt' : "$prof-headlines.txt") . "</i> that contains the same news items as this profile, but it uses a different <b>Style</b>.<li>Headline Styles generally use only the <i>&lt;Field: Headline&gt;</i> and <i>&lt;Field: Date&gt;</i> tags.<li>This is a simple method of generating headlines for a Profile, but you can also create a separate Profile just for the purpose of making headlines. The only difference between <i>news</i> and <i>headlines</i> is the <b>Style</b> used.", 'yn'],
	['headline-style', 'Headlines Style', "<ul><li>The Style used for generating the headlines.<li>Only necessary if headlines are enabled.", GetStyleSelect()],
	['headline-number', 'Number of Headlines', "<ul><li>The maximum number of headlines.<li><b>Leave blank</b> to create headlines for all items included in this profile."],
	);
	# HOOK: LoadArchivingSettings
	if($Addons{'LoadHeadlinesSettings'}){my $w;foreach $w (@{$Addons{'LoadArchivingSettings'}}){my $addon=$w->[2];eval ${$w->[0]};AErr($addon,$@)if $@;};}
	return \@ProfileHeadlinesSettings;
}
END_CODE

$::Subs{'Triaddons'} = <<'END_CODE';
sub Triaddons {
    ## These are just to neaten up the new Addon Manager.
    my $null;
    ($_[1], $null) = split (/<br>written by/, $_[1]);
    ($_[1], $null) = split (/<br><iframe/, $_[1]);

    $_[1] =~ s/<br>//;
    $_[1] =~ s/E-Mail Author/E-Mail/;
    $_[0] =~ s/Modify News: User Column/User Column/gi;
    $_[0] =~ s/ /&nbsp;/gi;
    $_[0] =~ s/-/&nbsp;/gi;
	return qq~
        <table width="80%" cellpadding="1" cellspacing="0" align="center" class="darkgbg"><tr><td>
        <table width="100%" cellpadding="0" cellspacing="0" align="center" border="0" class="whitebg"><tr>
        <td class="fieldtitle" width=180>$_[3]&nbsp;&nbsp;$_[0]&nbsp;</td><td class="description">
        $_[1]</td></tr></table></td></tr>
        <tr><td class="whitebg"><div style="font-size: 5px; padding: 0px;">&nbsp;</div></td></tr></table>~;
}
END_CODE
$::Subs{'Triprofiles'} = <<'END_CODE';
sub Triprofiles {
    $_[0] =~ s/ /&nbsp;/gi;
    $_[0] =~ s/-/&nbsp;/gi;
	return qq~
        <table width="80%" cellpadding="1" cellspacing="0" align="center" class="darkgbg"><tr><td>
        <table width="100%" cellpadding="4" cellspacing="0" align="center" border="0" class="whitebg"><tr>
        <td class="fieldtitle" width=180>$_[3]&nbsp;&nbsp;$_[0]&nbsp;</td><td class="description">
        <span class="descriptiondarker">&nbsp;&nbsp;$_[1]</span><br>&nbsp;&nbsp;$_[2]</td></tr></table></td></tr>
        <tr><td class="whitebg"><div style="font-size: 5px; padding: 0px;">&nbsp;</div></td></tr></table>~;
}
END_CODE
$::Subs{'Trifields'} = <<'END_CODE';
sub Trifields {
    $_[0] =~ s/CustomField_/<font size=-2><\/b>CustomField_<b><\/font>/;
    $_[0] =~ s/ /&nbsp;/gi;
    $_[0] =~ s/CustomField_/<span style="font-size:11px">CustomField_<\/span>/;
    $_[1] =~ s/CustomField_/<span style="font-size:11px">CustomField_<\/span>/;
    ## Clean up NewsCat/Tintinabulum
    $_[2] =~ s/Edit Permissions/Edit/;
    $_[2] =~ s/Delete/Del/;
    $_[2] =~ s/\] \[/\]&nbsp;\[/;
    $_[1] =~ s/This category is available to all users./Available to\: <b>all users<\/b>/;
    $_[1] =~ s/This category is available to/Available to/;
    ## Changes for 'Low' screen resolutions
    $_[1] =~ s/ &middot; /<br>&nbsp;&nbsp;/ if ($CConfig{'ScreenRes'} > 1);
    $_[2] =~ s/\]&nbsp;\[/\]<br>\[/gi if ($CConfig{'ScreenRes'} > 1);
    my $positioning;
    if ($_[3]) {
        $positioning = qq~<td align=center width=10 class="description">$_[3]</td>~;
    }
	return qq~
        <table width="80%" cellpadding="1" cellspacing="0" align="center" class="darkgbg"><tr><td>
        <table width="100%" cellpadding="4" cellspacing="0" align="center" border="0" class="whitebg"><tr>
        <td class="fieldtitle" width=180><div align="left">$_[0]</div></td>
        <td class="footnote" width=56><div align="center">$_[2]</div></td>
        <td class="description">&nbsp;&nbsp;$_[1]</td>$positioning</tr></table></td></tr>
        <tr><td style="background-color:#ffffff"></td></tr></table>~;
}
END_CODE
$::Subs{'LoadLinkBarList'} = <<'END_CODE';
sub LoadLinkBarList {
	@LinkBarFunctions = (
        ['Header', 'Coranto']);
	push(@LinkBarFunctions, [$Messages{'Linkbar_MainPage'}, 'action', 'mainpage', 'yy']);
	unless ($CurrentUser =~ /^guest/ || $up == 1)  {}

    if (($CConfig{'xms_dissubnews'} eq 'choose_and_links') && ($CConfig{'AddonsLoaded'} =~ /xmultisubmit/)) {
        if ((!$CConfig{'LinkBarAdmin'}) && ($up == 3)) {
            push(@LinkBarFunctions, [$Messages{'Linkbar_Administration'}, 'action', 'admin', 'yy']);}
        if (!($CConfig{'LinkBarAddons'}) && ($up == 3) && ($Addons) && (!$CConfig{'LinkBarAdmin'})) {
            push(@LinkBarFunctions, [$Messages{'Linkbar_Addons'}, 'adminarea', 'addonmanager', 'yy', 'action', 'admin']);}
    }
	unless ($CurrentUser =~ /^guest/ && $up == 1) {
        push(@LinkBarFunctions, [$Messages{'Linkbar_UserProfile'}, 'action', 'edituserinfo', 'xx']);}
if (($CConfig{'AddonsLoaded'} =~ /multipart/)) {
	push(@LinkBarFunctions, [$Messages{'Linkbar_Upload'}, 'action', 'multipart-upload', 'yy']);
}
else { }
 if (($CConfig{'AddonsLoaded'} =~ /pm/)) {
    push(@LinkBarFunctions, [$Messages{'Linkbar_PM'}, 'action', 'pm-mm', 'yy']);
}
else { }
 if (($CConfig{'AddonsLoaded'} =~ /faq/)) {
	push(@LinkBarFunctions, [$Messages{'Linkbar_FAQ'}, 'action', 'faq', 'yy']);
}
else { }
	push(@LinkBarFunctions, [$Messages{'Linkbar_LogOut'}, 'action', 'logout', 'yy']);

    ## News Link-Bar
    push(@LinkBarFunctions, ['Header', 'News']);

    ## Rearrange the menu a bit if XMS is active.
    if (($CConfig{'xms_dissubnews'}) && ($CConfig{'AddonsLoaded'} =~ /xmultisubmit/)) {
    	foreach $i (@XMS_Profs) {
			if ($XMS_DB{$i}->{'QuickLink'}) {
				my $name = $XMS_DB{$i}->{'Name'};
				$name =~ s/ /&nbsp;/g;
				push(@LinkBarFunctions, [$name, 'profname', $i, 'yy', 'action', 'xms-submit'] );
			}
    	}
		unless ($CConfig{'xms_dissubnews'} eq "disabled") {
    		push(@LinkBarFunctions, ['Submit&nbsp;News', 'action', 'submit', 'xx']);
		}
    	unless ($CurrentUser =~ /^guest/ && $up == 1) {
     		push(@LinkBarFunctions, ['Modify&nbsp;News', 'action', 'modify', 'yy']);}
    	push(@LinkBarFunctions, ['Build&nbsp;News', 'action', 'generate', 'yy']);
    } else {
        if ((!$CConfig{'LinkBarAdmin'}) && ($up == 3)) {
            push(@LinkBarFunctions, [$Messages{'Linkbar_Administration'}, 'action', 'admin', 'yy']);}
        if (!($CConfig{'LinkBarAddons'}) && ($up == 3) && ($Addons) && (!$CConfig{'LinkBarAdmin'})) {
            push(@LinkBarFunctions, [$Messages{'Linkbar_Addons'}, 'adminarea', 'addonmanager', 'yy', 'action', 'admin']);}
    	push(@LinkBarFunctions, [$Messages{'Linkbar_Submit'}, 'action', 'submit', 'xx']);
    	unless ($CurrentUser =~ /^guest/ && $up == 1) {
     		push(@LinkBarFunctions, [$Messages{'Linkbar_Modify'}, 'action', 'modify', 'yy']);}
    	push(@LinkBarFunctions, [$Messages{'Linkbar_Build'}, 'action', 'generate', 'yy']);
    }


    ## Administration link-Bar
    if (($CConfig{'LinkBarAdmin'}) && ($up == 3)) {
        push(@LinkBarFunctions, ['Header', 'Administration']);
        if (!($CConfig{'LinkBarAddons'}) && ($up == 3) && ($Addons)) {
			push(@LinkBarFunctions, [$Messages{'Linkbar_Addons'}, 'adminarea', 'addonmanager', 'yy', 'action', 'admin']);
		}
		push(@LinkBarFunctions, [$Messages{'Linkbar_Profiles'}, 'adminarea', 'profilelist', 'xx', 'action', 'admin']);
		push(@LinkBarFunctions, [$Messages{'Linkbar_Styles'}, 'adminarea', 'nstyle', 'yy', 'action', 'admin']);
        if ($CConfig{'AddonsLoaded'} =~ /tintinnabulum/) {
            push(@LinkBarFunctions, [$Messages{'Linkbar_Tintinnabulum'}, 'adminarea', 'tintinnabulum-main', 'yy', 'action', 'admin']);
        } elsif ($CConfig{'AddonsLoaded'} =~ /ncategory/) {
            push(@LinkBarFunctions, [$Messages{'Linkbar_Categories'}, 'adminarea', 'newscatmain', 'yy', 'action', 'admin']);
		}
		push(@LinkBarFunctions, [$Messages{'Linkbar_NewsFields'}, 'adminarea', 'editfielddb', 'yy', 'action', 'admin']);
		push(@LinkBarFunctions, [$Messages{'Linkbar_UserFields'}, 'adminarea', 'edituserdb', 'yy', 'action', 'admin']);
		push(@LinkBarFunctions, [$Messages{'Linkbar_Users'}, 'adminarea', 'editusers', 'yy', 'action', 'admin']);
		push(@LinkBarFunctions, [$Messages{'Linkbar_FlBuild'}, 'adminarea', 'fullbuild', 'yy', 'action', 'admin']);
         push(@LinkBarFunctions, [$Messages{'Linkbar_Settings'}, 'adminarea', 'settings', 'yy', 'action', 'admin']);
        push(@LinkBarFunctions, [$Messages{'Linkbar_Administration'}, 'action', 'admin', 'yy']);
	}

    ## Addons link-Bar
    if (($CConfig{'LinkBarAddons'}) && ($up == 3) && ($Addons)) {
        push(@LinkBarFunctions, ['Header', 'Addons']);
        push(@LinkBarFunctions, [$Messages{'Linkbar_Addons'}, 'adminarea', 'addonmanager', 'yy', 'action', 'admin']);
        push(@LinkBarFunctions, GetAddonAvailableFunctions());
        push(@LinkBarFunctions, ['admintools']);
    	unless ($CurrentUser =~ /^guest/ || $up == 1) {
            push(@LinkBarFunctions, GetAddonAdminFunctions());}
    }
	@LinkBarFunctions = reverse(@LinkBarFunctions);
}
END_CODE
$::Subs{'PrintLinkBar'} = <<'END_CODE';
sub PrintLinkBar {
    $_[0] =~ s/ /&nbsp;/g;
	my $list = shift;
    my ($tablechecker, $addonchecker, $nowadmintools, $admintoolschecker);
	$i = (@$list - 1);

    if ($CConfig{'LinkBarPosition'} > 0) {
        print qq~<table style="width:90%;" border="0" cellspacing="0" cellpadding="2" align="center" class="redbg"><tr><td>~ if ($CConfig{'ScreenRes'} > 0);
        print qq~<table style="width:70%;" border="0" cellspacing="0" cellpadding="2" align="center" class="redbg"><tr><td>~ if ($CConfig{'ScreenRes'} == 0);
        print qq~<table width="100%" border="0" cellspacing="0" cellpadding="4" class="navlink">~;
    
    	while ($i >= 0) {
            if ($$list[$i]->[0] eq 'Header') {
                print qq~</td></tr>~ if ($tablechecker);
                print qq~<tr><td width=100 class="menuheader">$$list[$i]->[1]</td><td width=10 class="menulinks">&nbsp;</td><td class="menulinks">~;
                $tablechecker = 0;  
            } elsif ($$list[$i]->[0] eq 'admintools') {
                $nowadmintools = 1;
            } elsif ($$list[$i]->[3]) {
                my $addonname = $$list[$i]->[0];
                $addonname =~ s/ //i;
                print qq~ &middot; ~ if (($tablechecker) && ($$list[$i]->[3] eq 'yy'));
                print qq~ :: ~ if (($tablechecker) && ($$list[$i]->[3] eq 'xx'));
                print PageLink({$$list[$i]->[1] => $$list[$i]->[2], $$list[$i]->[4] => $$list[$i]->[5]});
                print qq~$addonname</a>~;
                $tablechecker = 1;            
            } elsif ($nowadmintools) {
                if (($$list[$i]->[0] ne "News Categories") && ($$list[$i]->[0] ne "Tintinnabulum")) {
                    my $addonname = $$list[$i]->[0];
                    $addonname =~ s/ //i;
                    print qq~ &middot; ~ if ($admintoolschecker);
                    print qq~ :: ~ if !($admintoolschecker);
                    print PageLink({'adminarea' => $$list[$i]->[2], 'action' => 'admin'});
                    print qq~$addonname</a>~;
                    $admintoolschecker = 1;
                }
            } else {
                my $addonname = $$list[$i]->[0];
                $addonname =~ s/ //i;
                print qq~ &middot; ~ if ($addonchecker);
                print qq~ :: ~ if !($addonchecker);
                print PageLink({'action' => $$list[$i]->[2], '' => ''});
                print qq~$addonname</a>~;
                $addonchecker = 1;
            }
    		$i -= 1;
    	}
        print qq~</td></tr></table></td></tr></table><br>~;

    } else {

        print '<div style="position:fixed; left:5px; top:98px; width:120px;">' if ($CConfig{'LinkBarFixed'});
        print qq~
            <table border="0" cellspacing="0" cellpadding="4" align="center" class="redbg"><tr><td>
            <table width="100%" border="0" cellspacing="0" cellpadding="4" class="navlink">~;
    	while ($i >= 0) {
            if ($$list[$i]->[0] eq 'Header') {
                print qq~<tr><td width=100% class="menuheader2">$$list[$i]->[1]</td></tr><tr><td>~;
                $tablechecker = 0;  
            } elsif ($$list[$i]->[0] eq 'admintools') {
                $nowadmintools = 1;
            } elsif ($$list[$i]->[3]) {
                $$list[$i]->[0] =~ s/Addons/AddonManager/ if ($$list[$i]->[0] eq 'Addons');
                $$list[$i]->[0] =~ s/Admin/AdminManager/ if ($$list[$i]->[0] eq 'Admin');
                print qq~<br>~ if ($tablechecker);
                print qq~&nbsp;&middot;&nbsp;~ . PageLink({$$list[$i]->[1] => $$list[$i]->[2], $$list[$i]->[4] => $$list[$i]->[5]});
                $$list[$i]->[0] =~ s/ /&nbsp;/g;
                print qq~$$list[$i]->[0]</a>~;
                $tablechecker = 1;            
            } elsif ($nowadmintools) {
                if (($$list[$i]->[0] ne "News Categories") && ($$list[$i]->[0] ne "Tintinnabulum")) {
                    print qq~<br>~ if ($tablechecker);
                    print qq~&nbsp;&middot;&nbsp;~;
                    print PageLink({'adminarea' => $$list[$i]->[2], 'action' => 'admin'});
                    print qq~$$list[$i]->[0]</a>~;
                    $tablechecker = 1;            
                }
            } else {
                my $addonname = $$list[$i]->[0];
                $addonname =~ s/ //g;
                print qq~<br>~ if ($tablechecker);
                print qq~&nbsp;&middot;&nbsp;~;
                print PageLink({'action' => $$list[$i]->[2], '' => ''});
                print qq~$addonname</a>~;
                $tablechecker = 1;            
            }
    		$i -= 1;
    	}
        print qq~</td></tr></table></td></tr></table><br>~;
        print '</div>' if ($CConfig{'LinkBarFixed'});
    }
}
END_CODE



#################################
#################################
## MODIFIED CRCORE.PL SUBROUTINES
#################################
#################################
sub MidHeadingFL {
    my ($break1, $break2, $totop);
    $totop = qq~<td width=1%><a href="#top" style="text-decoration:none"><b>&uarr;</b></a><a href="#bot" style="text-decoration:none"><b>&darr;</b></a></td>~ if (!$CConfig{'LinkBarFixed'});
    $break1 = '<br>' if !($_[1]);
    $break2 = '<br>' if ($_[0] eq "Create New Category");
	return $break2 . qq~<table width="80%" cellpadding="2" border="0" align="center">
        <tr><td class="midheader"><div align="center">$_[0]</div></td>~ . $totop . qq~</tr></table>~ . $break1;
}
sub MidParagraphFL {
	return qq~<table width="80%" cellpadding="2" border="0" align="center" class="description"><tr><td>
        <div style="margin-left: 10px; margin-right: 10px;" align="~ . ($_[1] ? 'left' : 'center') . qq~">
    	$_[0]</div></td></tr></table><br>~;
}
sub LoadFunctionListFL {
	@AvailableFunctions = (
		[$Messages{'Admin_Submit'}, $Messages{'Desc_Submit'}, 'submit'],
		[$Messages{'Admin_Build'}, $Messages{'Desc_Build'}, 'generate']);
	unless ($CurrentUser =~ /^guest/ && $up == 1) {
 		push(@AvailableFunctions, [$Messages{'Admin_Modify'}, $Messages{'Desc_Modify'} . ' ' . ( $up == 1 ? $Messages{'Desc_Modify_Std'} : $Messages{'Desc_Modify_High'} ), 'modify']);}
    push(@AvailableFunctions,['SmallBreak']);
	if ($up == 3) {
		push(@AvailableFunctions, [$Messages{'Admin_Administration'}, $Messages{'Desc_Administration'}, 'admin']);}
	unless ($CurrentUser =~ /^guest/ && $up == 1) {
        push(@AvailableFunctions, [$Messages{'Admin_UserInfo'}, $Messages{'Desc_UserInfo'}, 'edituserinfo']);}
	push(@AvailableFunctions, [$Messages{'Admin_LogOut'}, $Messages{'Desc_LogOut'}, 'logout']);
	my @AvailableFunctionsTemp = (GetAddonAvailableFunctions()) if $Addons;
    push(@AvailableFunctions,['SmallBreak']) if @AvailableFunctionsTemp;
    push(@AvailableFunctions, @AvailableFunctionsTemp);
	@AvailableFunctions = reverse(@AvailableFunctions);
}	
sub StartFieldsTableFL {
	return q~<table width="80%" align="center" border="0" cellpadding="3" cellspacing="2">~;
}
######################################################
$::Subs{'SettingsTable'} = <<'END_CODE';
sub SettingsTable {
    my $description = $_[2];
    my $title = $_[0];
       $title =~ s/ /&nbsp;/gi;
    my $break = '<br>';
    $break = ''  if (($_[0] =~ "<nobr>") ||
                    ($title =~ "Previous Page Link Code") ||
                    ($title =~ "Next Page Link Code") ||
                    ($title =~ "News Items Per Page") ||
                    ($title =~ "Name For Output Files") ||
                    ($title =~ "Link-Bar Above The News") ||
                    ($title =~ "Direct Page Links Code"));
    if ($description) {
        $description = qq~<ul><li>$description~ if (($description !~ '<li>') && ($description));
        $description = qq~<tr><td colspan=3 class="description">$description</td></tr>~;
    } else {
        $description = '';
    }
    if (($title =~ "Previous Page Link Code") ||
        ($title =~ "Previous Page No-Link Code") ||
        ($title =~ "Next Page Link Code") ||
        ($title =~ "Next Page No-Link Code") ||
        ($title =~ "Current Page Link Code") ||
        ($title =~ "Link-Bar Style Code") ||
        ($title =~ "Page Links") ||
        ($title =~ "Pages With No News") ||
        ($title =~ "Current Page") ||
        ($title =~ "Direct Page Links Code")) {
        $_[1] =~ s/<\/td><\/tr><tr><td colspan=2 align=center>//;
    	return qq~
            <table width=80% border=0 cellspacing=2 cellpadding=2 align="center"><tr>
            <td class="fieldtitle" width=50%><div align="center">$title</div></td></tr>
            <tr><td><div align="center">$_[1]</div></td></tr>$description</table>$break~;
    } else {
    	return qq~
            <table width=80% border=0 cellspacing=2 cellpadding=2 align="center"><tr><td class="fieldtitle" width=50%>
            <div align="right">$title</div></td><td width=2%></td><td>$_[1]</td></tr>$description</table>$break~;
    }
}
END_CODE
#$::Subs{'Tricolore'} = <<'END_CODE';
#sub Tricolore {
#	return Trifields(@_);   
#}
#END_CODE
$::Subs{'PrintFunctionList'} = <<'END_CODE';
sub PrintFunctionList {
	my $list = shift;
	my $actionparam = shift;
	my $extrakey = shift;
	my $extravalue = shift;
    my ($tablechecker, $xmschecker);
    LoadAdminFunctionListFL() unless ($adminfunctionsloaded);
	$i = (@$list - 1);
    print qq~<table width="80%" border="0" cellspacing="2" cellpadding="2" align="center"><tr><td>~;
	while ($i >= 0) {
        if ($$list[$i]->[0] eq 'Header') {
            print qq~<tr><td>&nbsp;</td></tr>~ if ($tablechecker);
            print qq~<tr><td colspan=2><div width=100% class="midheader" align=center>$$list[$i]->[1]:</div></td></tr>~;
            $tablechecker = 1;  
        } elsif ($$list[$i]->[0] eq 'Break') {
            print qq~<tr><td>&nbsp;</td></tr>~;
        } elsif ($$list[$i]->[0] eq 'SmallBreak') {
            print qq~<tr><td></td></tr><tr><td></td></tr><tr><td></td></tr>~;
        } else {
            my $nonbreakingtitle = $$list[$i]->[0];
            $nonbreakingtitle =~ s/ /&nbsp;/gi if ($nonbreakingtitle !~ /session/);   # For XMS
            if (($xmschecker) && !($nonbreakingtitle =~ /session/)) {                 # For XMS (adds a spacer)
                print qq~<tr><td></td></tr><tr><td></td></tr><tr><td></td></tr>~;
                $xmschecker = '';
            }
            print q~<tr><td><div class="fieldtitle" style="text-align: right">&nbsp;~;
            print PageLink({$actionparam => $$list[$i]->[2], $extrakey => $extravalue});
            print qq~$nonbreakingtitle</a>&nbsp;</div></td><td class="description">&nbsp;$$list[$i]->[1]</td><tr>~;
            $xmschecker = 1 if ($nonbreakingtitle =~ /session/);                      # For XMS
        }
		$i -= 1;
	}
    print qq~</table><br>~;
}
END_CODE



##################################
##################################
## MODIFIED CRADMIN.PL SUBROUTINES
##################################
##################################

$::Subs{'EditUsers'} =~ s/print MidHeading\('Create New User'\);/print '<br>' . MidHeading\('Create New User', 1\);/;
$::Subs{'EditUsers'} =~ s/User &quot;\$i&quot; last logged in on/Last&nbsp;login:<b>/;
$::Subs{'EditUsers'} =~ s/\. User level/<\/b> &middot; User&nbsp;level/;
$::Subs{'EditUsers'} =~ s/print Tricolore/print Triprofiles/;
$::Subs{'EditUsers'} =~ s/Delete User<\/a>/Delete<\/a>/;
$::Subs{'EditUsers'} =~ s/Delete User<\/a>/Delete<\/a>/;
$::Subs{'EditUsers'} =~ s/Edit User Info<\/a>/Edit<\/a>/;
$::Subs{'EditUsers'} =~ s/'Enable User' : 'Disable User'/'Enable' : 'Disable'/;
$::Subs{'EditUsers'} =~ s/\$actions = '\[' \./\$actions = '<\/b>\[' \./;

$::Subs{'EditNewsStyles_Edit'} = <<'END_CODE';
sub EditNewsStyles_Edit {
	NeedCFG();
	ReadUserDBInfo();
	my $style = $in{'stylename'};
	CRcough("That style doesn't exist.") unless $NewsStyles{$style};
	my $styleraw = HTMLescape($NewsStyles{$style}->{'RawStyle'});
	CRHTMLHead("Edit Style $NewsStyles{$style}->{'FullName'}");
	my $standardmsg = qq~
        <ul><li>Styles create the HTML code for a single news item.
        <li>The only diffence between <i>headlines</i> and <i>teasers</i> and <i>regular news etc</i> is which <b>tags</b> and <b>fields</b> are included in the Style.
        <li>You can include a <i>whole range</i> of Coranto variables/fields into your Style using this format: <b>&lt;Field:&nbsp;{FieldName}&gt;</b> or <b>&lt;Field:&nbsp;{variablename}&gt;</b>.
        <li>A list of basic <i>FieldName</i> options are included in the panel to the right - for example, use <b>&lt;Field:&nbsp;Text&gt;</b> to insert the text of the news item.
        <li>A more indepth examination of Styles can be found in the Help links.~;
	my @fields = @fieldDB;
	push(@fields, 'User', 'Date');
	push(@fields, 'Category') if $EnableCategories;
	push(@fields, map {"UserField_$_"} keys %userDB);
	@fields = sort (@fields);
	my $fieldlist = join('<br>', @fields);
    my $timelist = qq~year<br>TwoDigitYear<br>Month_Name<br>Month_Day<br>Month_Number<br>TwoDigitMonth<br>Weekday<br>Day<br>TwoDigitDay<br>Hour<br>TwoDigitHour<br>Minute<br>Second<br>AMPM<br>Time_Zone~;
    my $msg;
	# HOOK: EditNewsStyles_Edit
	if($Addons{'EditNewsStyles_Edit'}){my $w;foreach $w (@{$Addons{'EditNewsStyles_Edit'}}){my $addon=$w->[2];eval ${$w->[0]};AErr($addon,$@)if $@;};}
    ## Handle Maginot Line if it has jumped in here.
	print MidParagraph($standardmsg, 1);
    if ($msg) {
        print MidHeading('Addon Fields:', 1);
	    print MidParagraph($msg, 1),
    }
	print StartForm({'action' => 'admin', 'adminarea' => 'nstyle-editsave', 'stylename' => $style});
    print qq~
        <table><tr><td class="description" width=100%>
        <div align="center"><input type="submit" value="Save Changes"></div></td></tr><tr><td valign=top>
        <div align="center"><textarea name="styleraw" rows="24" cols="60" style="width: 100%" wrap="VIRTUAL">$styleraw</textarea></div></td><td rowspan=2 valign=top>
        <div style="margin-left: 10px; margin-right: 10px; font-size: 14px;"><u><b>FIELDS</b></u></div>
        <div style="margin-left: 10px; margin-right: 10px; font-size: 12px; font-weight: none;">$fieldlist</div>
        <div style="margin-left: 10px; margin-right: 10px; margin-top: 5px; font-size: 14px;"><u><b>DATE/TIME</b></u></div>
        <div style="margin-left: 10px; margin-right: 10px; font-size: 12px; font-weight: none;">$timelist</div>
        </td></tr><tr><td class="description">
        <div align="center"><input type="submit" value="Save Changes"></div></td></tr></table></form>~;
	CRHTMLFoot(1);
}
END_CODE

$::Subs{'SettingsEngine_Display'} =~ s/print MidParagraph\(\$1, 1\)/print MidParagraph\(\$1, 0\)/i;
$::Subs{'SettingsEngine_Display'} =~ s/input type="text" size="30" name="/input type="text" size="50" name="/i;

$::Subs{'EditProfDefinition'} = <<'END_CODE';
sub EditProfDefinition {
	my $prof = shift;
	my %DisplayLinkOptions = (
		'0' => 'No link',
		'1' => 'Link pointing to Official Site',
		'2' => 'Link pointing to Unofficial Site',
		'3' => 'Text without link'
	);
	
    $newsprofiles{$prof}->{'filepath'} = $CConfig{'htmlfile_path'} unless ($newsprofiles{$prof}->{'filepath'});

	my @EditProfileSettings = (
	['heading: File Settings'],
	['textfile', 'File Name', "The <i>name</i> and <i>extension</i> for the file this profile will generate (example: <i>$prof.txt</i>)."],
	['filepath', 'Build Location', qq~<ul><li>The <i>absolute path</i> (<b>not</b> URL) to the directory where you would like the news files to be generated.<li>Do not use a trailing slash.~],
	['heading: Build Options'],
	['style', 'Build Style', qq~<ul><li>The Style used to generate the news for this Profile.~, GetStyleSelect()],
	['anchors', 'Anchor Tags', qq~Automatically creates <i>&lt;a name="..."&gt;</i> tags for each news item, allowing links directly to each news item.~, 'yn'],
	['tmplfile', 'HTML Template', qq~<ul><li>Templates allow Coranto to build <i>complete</i> web-viewable pages rather than just building just the news items.<li>Templates are useful if your server doesn't support <b>SSI</b> or <b>PHP</b> includes.<li>Templates are HTML files located in your Coranto directory.~, GetTMPLSelect(1)],
	['tmpltitle', 'HTML File Title', qq~<ul><li>If a <i>Template</i> is being used, this will appear in the page <i>Title</i> at the top of the web browser.~],
	['DisplayLink', 'Display Coranto Link', qq~Adds a <i>Powered by <a href="javascript: void()">Coranto</a></i> link below the news.~, '<select name="DisplayLink">' . join('', map { qq~<option value="$_"~ . ( $newsprofiles{$prof}->{'DisplayLink'} == $_ ? ' selected' : '' ) . qq~>$DisplayLinkOptions{$_}</option>~ } keys % DisplayLinkOptions) . '</select>'],
	['heading: Filtering Options']);
	# Addons: don't assume that you're on the Edit Profile screen for a Standard profile here!
	# New profile types should also incorporate this hook; this is the place to add news-selecting options,
	# like a category selection box. DO NOT add HTML-specific things here; the file being generated may not
	# be HTML!
	# HOOK: EditProfDefinition_1
	if($Addons{'EditProfDefinition_1'}){my $w;foreach $w (@{$Addons{'EditProfDefinition_1'}}){my $addon=$w->[2];eval ${$w->[0]};AErr($addon,$@)if $@;};}
	push(@EditProfileSettings, 
	['filtsub', 'Sort Order', qq~<ul><li>The order news items are presented in.<li>Sorting Order is performed before the filter options below.~, GetSortOrders() ],
	['numfilter', 'Filter By Number', qq~<ul><li>The maximum number of news items that will be included in this profile.<li>For instance, if set to 10, then the 11th-onwards will not be included.<li><b>Leave blank</b> to include <i>all</i> news items in this Profile.~],
	['agefilter', 'Filter By Day', qq~<ul><li>The number of days from which to include news.<li>For instance, if set to 3, only news from the last three days will be included.<li><b>Leave blank</b> to include <i>all</i> news items in this Profile.~],
	['skipfilter', 'Skip News Items', qq~<ul><li>The number of news items to skip over.<li>For instance, if set to 5, the 6th news item will be the first one included.<li><b>Leave blank</b> to include <i>all</i> news items in this Profile.~],
	['skipdays', 'Skip Days', qq~<ul><li>The number of days to skip over.<li>For instance, if you set this to 3, the first item in this profile will be the first item over 3 days old.<li><b>Leave blank</b> if you do not want to skip over any days.~],
	['draw_line'],
		);
	# HOOK: EditProfDefinition_2
	if($Addons{'EditProfDefinition_2'}){my $w;foreach $w (@{$Addons{'EditProfDefinition_2'}}){my $addon=$w->[2];eval ${$w->[0]};AErr($addon,$@)if $@;};}
	return \@EditProfileSettings;
}
END_CODE
$::Subs{'MainProfileList'} = <<'END_CODE';
sub MainProfileList {
	CRHTMLHead('Edit News Profiles',1);

	# HOOK: ProfileList_1
	if($Addons{'ProfileList_1'}){my $w;foreach $w (@{$Addons{'ProfileList_1'}}){my $addon=$w->[2];eval ${$w->[0]};AErr($addon,$@)if $@;};}

	print q~
	<table width="80%" cellpadding="2" border="0" align="center"><tr><td class="midheader"><div align="center">Current Profiles
	</div></td></tr></table><br>~;

	# HOOK: ProfileList_2
	if($Addons{'ProfileList_2'}){my $w;foreach $w (@{$Addons{'ProfileList_2'}}){my $addon=$w->[2];eval ${$w->[0]};AErr($addon,$@)if $@;};}

	my ($status, $actions, @ProfileTypes, $toggler);
	if ($Addons) {
		@ProfileTypes = GetAddonProfileTypes();
	}
	PROFLOOP: foreach $i (sort keys %newsprofiles) {
		next PROFLOOP if $i =~ /[^\w\d_]/;
        my ($toggler, $actions, $status, $headlinesstatus, $archstatus, $profilestatus);

        $profilestatus = ($newsprofiles{$i}->{'enabled'}) ? 'Edit' : '<strike>Edit</strike>';
        $archstatus = ($newsprofiles{$i}->{'archive'}) ? 'Archiving' : '<strike>Archiving</strike>';
        $headlinesstatus = ($newsprofiles{$i}->{'headlines'}) ? 'Headlines' : '<strike>Headlines</strike>';

		# HOOK: ProfileList_3
		if($Addons{'ProfileList_3'}){my $w;foreach $w (@{$Addons{'ProfileList_3'}}){my $addon=$w->[2];eval ${$w->[0]};AErr($addon,$@)if $@;};}

			my $DisplayName;

			###############
			# New profile display name feature!
			###############

			if (exists $newsprofiles{$i}->{'DisplayName'}){
			$DisplayName = $newsprofiles{$i}->{'DisplayName'};
			}
			else {
			$DisplayName = $i;
			}

			#############
			# END
			#############
	

		if ($newsprofiles{$i}->{'enabled'}) {
			if ($newsprofiles{$i}->{'type'} eq 'Standard') {
 				if (!$newsprofiles{$i}->{'agefilter'} && !$newsprofiles{$i}->{'numfilter'}) {
					$status .= 'Filtering:&nbsp;<b>none</b> ';
				}
				else {
					$status .= 'Filtering:&nbsp;';
					if ($newsprofiles{$i}->{'agefilter'}) {
						$status .= "<b>$newsprofiles{$i}->{'agefilter'}&nbsp;days</b> ";
						$status .= '&nbsp;/&nbsp;' if ($newsprofiles{$i}->{'numfilter'});
					}
					if ($newsprofiles{$i}->{'numfilter'}) {
						$status .= "<b>$newsprofiles{$i}->{'numfilter'}&nbsp;item" . ($newsprofiles{$i}->{'numfilter'} == 1 ? '' : 's') . '</b> ';
					}
				}

				if ($newsprofiles{$i}->{'skipdays'}){
					$status .= qq~Items must be older than <b>$newsprofiles{$i}->{'skipdays'}</b> days.<br>~;
				}
				if ($newsprofiles{$i}->{'skipfilter'}){
					$status .= qq~This profile is set to skip the first <b>$newsprofiles{$i}->{'skipfilter'}</b> items.<br>~;
				}

				$status = 'Type:&nbsp;<b>Standard</b>&nbsp;&middot;&nbsp;' .  $status;
				# HOOK: ProfileList_Standard_Status
				if($Addons{'ProfileList_Standard_Status'}){my $w;foreach $w (@{$Addons{'ProfileList_Standard_Status'}}){my $addon=$w->[2];eval ${$w->[0]};AErr($addon,$@)if $@;};}
			}
			else {
				# HOOK: ProfileList_NewType_Status
				if($Addons{'ProfileList_NewType_Status'}){my $w;foreach $w (@{$Addons{'ProfileList_NewType_Status'}}){my $addon=$w->[2];eval ${$w->[0]};AErr($addon,$@)if $@;};}

                ## Tidy up Maginot Line
                if ($newsprofiles{$i}->{'type'} =~ /Maginot/) {
                    $status = qq~Type: <b>$newsprofiles{$i}->{'type'}</b> &middot; ~;

                    if (($newsprofiles{$i}->{'type'} eq 'Maginot Static Split') || ($newsprofiles{$i}->{'type'} eq 'Maginot Static')) {
        				if (!$newsprofiles{$i}->{'agefilter'} && !$newsprofiles{$i}->{'numfilter'}) {
        					$status .= qq~Filtering:&nbsp;<b>none</b> ~;
        				}
        				else {
        					$status .= 'Filtering: ';
        					if ($newsprofiles{$i}->{'agefilter'}) {
        						$status .= "<b>$newsprofiles{$i}->{'agefilter'}&nbsp;days</b> ";
        						$status .= '&nbsp;/&nbsp;' if ($newsprofiles{$i}->{'numfilter'});
        					}
        					if ($newsprofiles{$i}->{'numfilter'}) {
        						$status .= "<b>$newsprofiles{$i}->{'numfilter'}&nbsp;item" . ($newsprofiles{$i}->{'numfilter'} == 1 ? '' : 's') . '</b> ';
        					}
    				    }
                    } elsif ($newsprofiles{$i}->{'type'} eq 'Maginot Sliced') {
                        $status .= qq~Slice&nbsp;Field:&nbsp;<b>$newsprofiles{$i}->{'ppstaticfield'}</b>~;
                    } elsif ($newsprofiles{$i}->{'type'} eq 'Maginot Sliced Index') {
                        $status .= qq~Index&nbsp;for&nbsp;Profile:&nbsp;<b>$newsprofiles{$i}->{'ppsliceprofile'}</b>~;
                    }
                }
			}
		} else {
			$status = "Profile:&nbsp;<b>disabled</b>";
			$status .= "&nbsp;&middot;&nbsp;Type:&nbsp;<b>$newsprofiles{$i}->{'type'}</b>";  #if @ProfileTypes
		}
        my $link = PageLink({'action' => 'admin', 'adminarea' => 'profileenabletoggle', 'profname' => $i});
        $link =~ s/<a href="//i;
        $link =~ s/" >//gi;
        $toggler .= qq~<input name="addoncheck" type="checkbox" onClick="location=('~ . $link . qq~');" ~;
        $toggler .= ($newsprofiles{$i}->{'enabled'}) ? 'checked>' : '>';
		if ($newsprofiles{$i}->{'type'} eq 'Standard') {
			$actions .= '[' .
		 	PageLink( {'action' => 'admin', 'adminarea' => 'editprofilegeneral', 'profname' => $i} ) . $profilestatus . '</a>]&nbsp;[' .
		 	PageLink( {'action' => 'admin', 'adminarea' => 'editprofileheadlines', 'profname' => $i} ) . $headlinesstatus . '</a>]&nbsp;[' .
			PageLink( {'action' => 'admin', 'adminarea' => 'editprofilearc', 'profname' => $i} ) . $archstatus . '</a>]&nbsp;';
			# HOOK: ProfileList_Standard_Functions
			if($Addons{'ProfileList_Standard_Functions'}){my $w;foreach $w (@{$Addons{'ProfileList_Standard_Functions'}}){my $addon=$w->[2];eval ${$w->[0]};AErr($addon,$@)if $@;};}
		}
		else {
			# HOOK: ProfileList_NewType_Functions
			if($Addons{'ProfileList_NewType_Functions'}){my $w;foreach $w (@{$Addons{'ProfileList_NewType_Functions'}}){my $addon=$w->[2];eval ${$w->[0]};AErr($addon,$@)if $@;};}

            ## Tidy up Maginot Line
            if ($newsprofiles{$i}->{'type'} =~ /Maginot/) {
                $actions =~ s/Edit Maginot Static Settings/Edit/;
                $actions =~ s/Edit Maginot Static Split Settings/Edit/;
                $actions =~ s/Edit Maginot Sliced Settings/Edit/;
                $actions =~ s/Edit Maginot Sliced Index Settings/Edit/;
            }
		}
		$actions .= '[' . PageLink( {'action' => 'admin', 'adminarea' => 'removeprofile', 'profname' => $i} ) . 
			'Delete</a>]' unless ($i eq 'news');
		#$actions .= ' [' .
		 	PageLink( {'action' => 'admin', 'adminarea' => 'profiles_moveupdown', 'profname' => $i, 'direction' => 1} ) . 'Move Up</a>] [' .
			PageLink( {'action' => 'admin', 'adminarea' => 'profiles_moveupdown', 'profname' => $i, 'direction' => 2} ) . 'Move Down</a>] ';

		#if (exists $newsprofiles{$i}->{'DisplayName'}){
		#	$status .= qq~<br><b>Internal Name:</b> $i~;
		#}
		#print Tricolore( ($newsprofiles{$i}->{'enabled'} ? $DisplayName : "$DisplayName (disabled)"), $status, $actions);
		print Triprofiles( ($newsprofiles{$i}->{'enabled'} ? $i : "<strike>$i</strike>"), $status, $actions, $toggler);
	}
    print '<br>';
    print StartForm({'action' => 'admin', 'adminarea' => 'addprofile'});
	print MidHeading('Create New Profile', 1);
	print MidParagraph('<ul><li>Profile names may only contain <i>letters</i>, <i>numbers</i>, and <i>underscores</i> (_).<li>Use of lowercase letters is recommended to avoid confusion.<li>After creating a profile, you <i>must</i> <b>enable</b> and <b>edit</b> it.', 1);
    print q~
	<table width="80%" border="0" cellspacing="2" cellpadding="2" align="center"><tr><td class="fieldtitle" width="50%" valign="top"><div align="right">Profile Name:</div></td>
	<td width="50%"><input type="text" size="30" name="profname"></td></tr>
	~;
	if (@ProfileTypes) {
		print q~ <tr><td class="fieldtitle" width="50%" valign="top"><div align="right">Profile Type:</div></td>
		<td width="50%"><select name="proftype"><option value="Standard" selected>Standard</option>~;
		foreach $i (@ProfileTypes) {
			print qq~<option value="$i">$i</option>~;
		}
		print '</select></td></tr>';
	}
	print q~</table><br>~;
    print SubmitButton('Create Profile'), '</form>';
	CRHTMLFoot();
}
END_CODE

$::Subs{'DateSettings'} =~ s/<tr><td><div align="center"><input/<tr><td class="description"><div align="center"><input/gi;
$::Subs{'DateSettings'} =~ s/\. q~<table width="80%"/\. q~<\/td><td width=20>&nbsp;<\/td><td valign=top><div><b><u>FIELDS<\/u><\/b><br>year<br>TwoDigitYear<br>Month_Name<br>Month_Day<br>Month_Number<br>TwoDigitMonth<br>Weekday<br>Day<br>TwoDigitDay<br>Hour<br>TwoDigitHour<br>Minute<br>Second<br>AMPM<br>Time_Zone<\/div><\/td><\/tr><\/table>~\. q~<table width="80%"/gi;
$::Subs{'DateSettings'} =~ s/<table.*actually\)\.<\/div><\/td><\/tr><\/table><br>/<table align="center" cellpadding=0 cellspacing=0><tr><td>/is;
$::Subs{'DateSettings'} =~ s/return qq~<table.*<\/table><br>/
    return qq~<table align="center" class="lightgbg" cellpadding="4" cellspacing="0"><tr><td class="fieldtitle">
    <div align="center">\$_\[0\]<\/div><\/td><\/tr><tr><td class="description">
    <div align="center"><textarea name="\$_\[1\]" rows="3" cols="55" wrap="VIRTUAL">~ \. HTMLescape\(\$CConfig\{\$_\[1\]\}\) \. qq~<\/textarea><\/div><\/td><\/tr>
    <tr><td class="description"><div align="center">Example of current format: <b>~ \. \$_\[2\] \. q~<\/b><\/div><\/td><\/tr><\/table><br>/si;

$::Subs{'LoadDateTimeSettings'} = <<'END_CODE';
sub LoadDateTimeSettings {
	my $saving = shift;
	InitGTD('<Field: Hour>:<Field: Minute>:<Field: Second> <Field: AMPM>, <Field: Month_Name> <Field: Day>', 'GetFullDisplayTime');
	@DateTimeSettings = (
	['heading: Time Options'],
	['12HourClock', $Messages{'DateTime_24Title'}, $Messages{'DateTime_24'}, 
		[ ['1', '12 Hour (AM/PM)'], ['0', '24 Hour'] ] ],
	['Standard_Time_Zone', $Messages{'DateTime_ZoneTitle'}, $Messages{'DateTime_Zone'}],
	['Daylight_Time_Zone', $Messages{'DateTime_DLSZoneTitle'}, $Messages{'DateTime_DLSZone'}],
	['TimeOffset', $Messages{'DateTime_OffsetTitle'}, $Messages{'DateTime_Offset'} . '<b>' . GetFullDisplayTime($CurrentTime) . '</b>'],
    );
	# HOOK: LoadDateTime
	if($Addons{'LoadDateTime'}){my $w;foreach $w (@{$Addons{'LoadDateTime'}}){my $addon=$w->[2];eval ${$w->[0]};AErr($addon,$@)if $@;};}
	push(@DateTimeSettings, ['heading: Date Formats']);
	push(@DateTimeSettings, ['descrip: ' . $Messages{'DateTime_FormatsDesc'}]);
	push(@DateTimeSettings, ['DateFormat'], ['InternalDateFormat'], ['ArchiveDateFormat_Weekly'], ['ArchiveDateFormat_Monthly'], ['ArchiveDateFormat_Daily']) if $saving;
	return \@DateTimeSettings;
}
END_CODE
$::Subs{'AddonManager'} = <<'END_CODE';
sub AddonManager {
	my $afi = OpenAddons();
	my ($i, %AddonsLoaded, $list, @summ);
	CRHTMLHead('Addon Manager', 1);

	unless($CConfig{'AddonsLoaded'}){
	ReadConfigInfo();
	}
	my @AddonsLoaded = split(/~/, $CConfig{'AddonsLoaded'});
	foreach $i (@AddonsLoaded) {
		$AddonsLoaded{$i} = 1;
	}
	my @alist = keys %$afi;
	if (@alist) {
		@alist = sort {uc($$afi{$a}->{'NAME'}) cmp uc($$afi{$b}->{'NAME'})} @alist;
		foreach $i (@alist) {
			my $en = 1 if $AddonsLoaded{"cra_$i.pl"};
			my $name = $$afi{$i}->{'NAME'};
			my ($description, $toggler, $action);
			if ($en) {
                my $link = PageLink({'action' => 'admin', 'adminarea' => 'addondisable', 'addon' => $i});
                $link =~ s/<a href="//i;
                $link =~ s/" >//gi;
                $toggler .= qq~<input name="addoncheck" type="checkbox" onClick="location=('~ . $link . qq~');" checked>~;
				push(@summ, qq~<a href="#add_$i"><b>$$afi{$i}->{'NAME'}</b></a>~);
			} else {
                $name = '<strike>' . $name . '</strike>';
                my $link = PageLink({'action' => 'admin', 'adminarea' => 'addonenable', 'addon' => $i});
                $link =~ s/<a href="//i;
                $link =~ s/" >//gi;
                $toggler .= qq~<input name="addoncheck" type="checkbox" onClick="location=('~ . $link . qq~');">~;
				push(@summ, qq~<a href="#add_$i">$$afi{$i}->{'NAME'}</a>~);}
			if ($$afi{$i}->{'DOC'}) {
				$action .= '&nbsp;[' . PageLink({'action' => 'admin', 'adminarea' => 'addondoc', 'addon' => $i}, q~target="_blank"~) . 'Docs</a>]<br>';}
			if ($$afi{$i}->{'HOMEPAGE'}) {
				$action .= qq~&nbsp;[<a href="$$afi{$i}->{'HOMEPAGE'}" target="_blank">WebSite</a>]~;}

            $action = ' &middot;'. $action if ($action);
			$description .= qq~&nbsp;<b>cra_$i.pl</b> (<b>$$afi{$i}->{'VERSION'}</b>)~;
			$description =~ s/ /&nbsp;/gi;
            $description = qq~<span class="descriptiondarker">&nbsp;$description~ . $action . qq~</span><br>~;
			$description .= qq~<div style="margin-top:2px; margin-bottom:0px; margin-left:18px">$$afi{$i}->{'DESCRIPTION'}</div>~;

			$list .= qq~<a name="add_$i"></a>~ . Triaddons($name, $description, $action , $toggler);
		}
	}
	else {
		print '<div align="center"><h3>No addons found.</h3></div>';
	}
	print q~<table width="70%" cellpadding="4" align="center" border="0"><tr><td class="footnote"><div align="center">Addons Found: ~
		. join(' &middot; ', @summ) . q~</div></td></tr></table>~ . $list;
	CRHTMLFoot(1);
	exit;
}
END_CODE
$::Subs{'AdvancedSettingsLoad'} = <<'END_CODE';
sub AdvancedSettingsLoad {
    # This sub is now used for Addon Settings.
	# HOOK: AdvSettings
	if($Addons{'AdvSettings'}){my $w;foreach $w (@{$Addons{'AdvSettings'}}){my $addon=$w->[2];eval ${$w->[0]};AErr($addon,$@)if $@;};}
	my @AdvancedSettings;
	push(@AdvancedSettings, GetAddonAdvancedSettings()) if $Addons;
	return \@AdvancedSettings;
}
END_CODE

$::Subs{'ChangeSettings'} =~ s/qq~\<table align\="center".*\<\/table\>\<br\>~\,/'<hr><br>';/;
$::Subs{'ChangeSettings'} =~ s/MidHeading\('Advanced Settings'\);//;
$::Subs{'ChangeSettings'} =~ s/CRHTMLFoot\(\)/CRHTMLFoot\(1\)/;

$::Subs{'ChangeSettingsLoad'} = <<'END_CODE';
sub ChangeSettingsLoad {
	my @ChangeSettings = (
	['heading: ' . $Messages{'ChangeSettings_HeadingPath'}],
	['admin_path', $Messages{'ChangeSettings_ProgramPathTitle'}, $Messages{'ChangeSettings_ProgramPath'}],
	['sql_enabled', 'Enable SQL', 'Do you want to allow Coranto to work with SQL-based addons such as CorantoSQL', yn],
	['heading: ' . $Messages{'ChangeSettings_HeadingInterface'}],
	['Modify_ItemsPerPage', $Messages{'ChangeSettings_ModifyPerPageTitle'}, $Messages{'ChangeSettings_ModifyPerPage'}],
	['SiteTitle', $Messages{'ChangeSettings_SiteNameTitle'}, $Messages{'ChangeSettings_SiteName'}],
	['SiteLink', $Messages{'ChangeSettings_SiteURLTitle'}, $Messages{'ChangeSettings_SiteURL'}],
	['ModifyEditLink','Modify News Link','Do you want the Modify News Edit link to open in the current window, instead of a new one?', yn],
	['ScreenRes', 'Screen Resolution', '<ul><li>This setting changes the layout Coranto slightly depending on your screen resolution:<br><b>High</b> - The default setting. Good for screen resolutions of 1152x864 or higher.<br><b>Medium</b> - This setting removes the padding of the main tables. Good for 1024x768.<br><b>Low</b> - Breaks some settings over two lines. Good for resolutions below 1152x864.', [ ['0', 'High'], ['1', 'Medium'], ['2', 'Low'] ]],
    );
	if ($CConfig{'SuperAdmin'} eq $CurrentUser or (not $CConfig{'SuperAdmin'} and $up == 3)) {
		push(@ChangeSettings,
            ['heading: Administration / Privacy'],
			['SuperAdmin', 'Super Administrator', "<ul><li>Choose who the <i>Super Administrator</i> should be.<li>Since you can see this box you are either the current Super Admin or there isn't a Super Admin set.", , '<select name="SuperAdmin">' . join('', map { qq~<option~ . ( $CConfig{'SuperAdmin'} eq $_ ? ' selected' : '' ) . qq~>$_</option>~ if $userdata{$_}->{'UserLevel'} == 3 } keys % userdata) . '</select>'],
			['PublicOrPrivate', 'Public or Private', "<ul><li>Set this to <b>Public</b> if you would like to have a version check image on the main page, be notified of new releases of Coranto, enable links to the Coranto website and documentation, or allow all addons to work regardless of their privacy status.<li>Set this to <b>Private</b> if you are running Coranto on a private network with no connection to the Internet, or if you would like the highest level of privacy available.<li>Note that on the <b>Private</b> setting, you will find links to our server and documentation hosted there are disabled, and you will not be able to use addons which haven't been certified as compliant with your privacy setting by their authors.", '<select name="PublicOrPrivate" onchange="pvtoggle(document.cs)"><option value="1"' . ( $CConfig{'PublicOrPrivate'} == 1 ? ' selected' : '' ) . '>Public</option><option value="0"' . ( $CConfig{'PublicOrPrivate'} == 0 ? ' selected' : '' ) . '>Private</option></select>'],
			['VersionChecking', 'Version Check Image', "Set this to 'Yes' if you would like an image to be displayed on the main page indicating the current version number.", 'yn'],
			['UrgentNotification', 'Urgent Notification', "<ul><li>If the <i>Version Check Image</i> option is set to <b>Yes</b>: set this to <b>Yes</b> if you would like us to keep track of your e-mail so we can notify you of  important news (bug fixes, new releases, exploits etc). <li>Your email will not be sold or disclosed to a third party, nor will it be publicly viewable or used for any purpose than those previously mentioned.", 'yn']
		);
	}
	push(@ChangeSettings, ['heading: Link-Bar Settings'],
	['LinkBarPosition', $Messages{'ChangeSettings_LinkBarPositionTitle'}, $Messages{'ChangeSettings_LinkBarPosition'}, [ ['0', 'Vertical/Left'], ['1', 'Horizontal/Automatic'], ['2', 'Horizontal/Above & Below'], ['3', 'Horizontal/Only Above'], ['4', 'Horizontal/Only Below'] ]],
	['LinkBarFixed', 'Fixed Link-Bar', '<ul><li>Fixes the link-bar to the viewport so it remains stationary when scrolling the window.<li>This option <i>only</i> works on the latest versions of <b>Mozilla</b>/<b>Netscape</b>/<b>Opera</b>. It currently <i>will not</i> work in <b>Internet Explorer</b>.', yn],
	['LinkBarAdmin', $Messages{'ChangeSettings_LinkBarAdminTitle'}, $Messages{'ChangeSettings_LinkBarAdmin'}, [ ['1', 'Yes (on)'], ['0', 'No (Off)'] ]],
	['LinkBarAddons', $Messages{'ChangeSettings_LinkBarAddonsTitle'}, $Messages{'ChangeSettings_LinkBarAddons'}, [ ['1', 'Yes (on)'], ['0', 'No (Off)'] ]],

	['heading: ' . $Messages{'ChangeSettings_HeadingBuild'}],
	['htmlfile_path', $Messages{'ChangeSettings_NewsPathTitle'}, $Messages{'ChangeSettings_NewsPath'}],
	['AutoBuild_Submit', $Messages{'ChangeSettings_BuildSubmitTitle'}, $Messages{'ChangeSettings_BuildSubmit'}, 'yn'],
	['AutoBuild_Modify', $Messages{'ChangeSettings_BuildModifyTitle'}, $Messages{'ChangeSettings_BuildModify'}, 'yn'],
	['AutoLinkURL', $Messages{'ChangeSettings_LinkURLsTitle'}, $Messages{'ChangeSettings_LinkURLs'}, 'yn'],
	['XHTMLbr', 'Enable XHTML BR', "If set to <b>Yes</b>, newlines in news posts will be replaced with &lt;br /&gt;, instead of the usual &lt;br&gt;.", 'yn'],

	['heading: ' . $Messages{'ChangeSettings_HeadingArchive'}],
	['archive_path', $Messages{'ChangeSettings_ArchivePathTitle'}, $Messages{'ChangeSettings_ArchivePath'}],
	['ArcHtmlExt', $Messages{'ChangeSettings_ArchiveExtTitle'}, $Messages{'ChangeSettings_ArchiveExt'}]
    );

	push(@ChangeSettings, ['heading: Debug Options'],
	['showconfig', 'Show Config', 'Do you want to allow you to display the configuration when debugging? This can be a security risk, so be careful. If not sure, set it to <b>No</b>', yn],
	['shownewsdat', 'Show Newsdat.txt', 'Do you want to allow you to display the contents of newsdat.txt when debugging? This can be a security risk, so be careful. If not sure, set it to <b>No</b>', yn]);
	
	return \@ChangeSettings;
}
END_CODE

$::Subs{'EditFieldDB'} =~ s/print MidParagraph\("News fields are.*modifying news\."\);//is;
$::Subs{'EditFieldDB'} =~ s/my (\$info, \$actions, \$arrows)/my (\$info, \$actions)/;
$::Subs{'EditFieldDB'} =~ s/Display Name:/Display:/;
$::Subs{'EditFieldDB'} =~ s/Field Type:/&middot; Type:/;
$::Subs{'EditFieldDB'} =~ s/'Single-Line Text Field'/'Single-Line&nbsp;Text'/;
$::Subs{'EditFieldDB'} =~ s/'Multi-Line Text Field'/'Multi-Line&nbsp;Text'/;
$::Subs{'EditFieldDB'} =~ s/'Drop-Down Box'/'Drop-Down'/;
$::Subs{'EditFieldDB'} =~ s/'Radio Button'/'Radio&nbsp;Buttons'/;
$::Subs{'EditFieldDB'} =~ s/\$actions = '';/\$actions = '\[' \. PageLink\(\{'action' => 'admin', 'adminarea' => 'newsfieldedit', 'fieldname' => \$i\}\) \. 'Edit<\/a>\]';/;
$::Subs{'EditFieldDB'} =~ s/print StartForm\(\{'action' => 'admin', 'adminarea' => 'changefieldtype', 'fieldname' => \$i\}\);//;
$::Subs{'EditFieldDB'} =~ s/print Tricolore\(\$i, \$info, \$actions\);//;
$::Subs{'EditFieldDB'} =~ s/print '<\/form>';//;
$::Subs{'EditFieldDB'} =~ s/'Delete<\/a>.*'Edit<\/a>]';/
            'Delete<\/a>\]';\}
        \$arrows = qq~<style>
                        \.smallarrows \{font-family: courier; font-size: 14px; text-decoration: none;\}
                        \.bigarrows  \{font-family: courier; font-size: 18px; text-decoration: none;\}
                        \.arrowhighlight a:hover \{text-decoration: underline overline;\}
                    <\/style><span class="arrowhighlight">~ \.
                    PageLink\(\{'action' => 'admin', 'adminarea' => 'newsfieldupdown', 'fieldname' => \$i, 'updown' => '1'\}\) \.
                    qq~<span class="bigarrows">&uarr;~ \.
                    PageLink\(\{'action' => 'admin', 'adminarea' => 'newsfieldupdown', 'fieldname' => \$i, 'updown' => '2'\}\) \.
                    qq~<span class="bigarrows">&darr;~;
		print Trifields\(\$i, \$info, \$actions, \$arrows\);/is;
$::Subs{'EditFieldDB'} =~ s/print MidHeading\('Create New News Field'\);/print '<br>';/;
$::Subs{'EditFieldDB'} =~ s/print MidParagraph\('Enter both.*or modifying news.'\);/
    print MidHeading\('Create New News Field', 1\);
    print MidParagraph\('<ul><li>The <i>Internal Name<\/i> is the name used in Style tags\. \(eg\. <i>&lt;Field: CustomField_myfield&gt;<\/i>\)<li>The <i>Internal Name<\/i> may contain only <i>letters<\/i>, <i>numbers<\/i>, and <i>underscores<\/i>, and will always begin with &quot;CustomField_&quot;\.<li>The <i>Display Name<\/i> is the title shown when submitting or modifying news\.', 1\);/is;
$::Subs{'EditFieldDB'} =~ s/CRHTMLFoot\(\)/CRHTMLFoot\(1\)/;

$::Subs{'EditNewsStyles_Main'} =~ s/This style is empty\./(Empty Style)/;
$::Subs{'EditNewsStyles_Main'} =~ s/This style is used by all archives\./Used&nbsp;by: <b>all&nbsp;archives<\/b>/;
$::Subs{'EditNewsStyles_Main'} =~ s/This style is currently used by <b>no<\/b> profiles\./Used&nbsp;by: <b>no profiles<\/b>/;
$::Subs{'EditNewsStyles_Main'} =~ s/This style is currently used by profile <b>\$profs\[0\]<\/b>\./Used&nbsp;by&nbsp;profile: <b>\$profs\[0\]<\/b>/;
$::Subs{'EditNewsStyles_Main'} =~ s/This style is currently used by profiles: /Used&nbsp;by&nbsp;profiles: /;
$::Subs{'EditNewsStyles_Main'} =~ s/join\(', ', map/join\(' &middot; ', map/;
$::Subs{'EditNewsStyles_Main'} =~ s/\$act \.= ' \['/\$act \.= '&nbsp;\['/;
$::Subs{'EditNewsStyles_Main'} =~ s/'Delete<\/a>\]'/'Del<\/a>\]'/;
$::Subs{'EditNewsStyles_Main'} =~ s/Tricolore/Trifields/;
$::Subs{'EditNewsStyles_Main'} =~ s/print MidHeading\('Create New/print '<br>' . MidHeading\('Create New/;
$::Subs{'EditNewsStyles_Main'} =~ s/print '<\/table><div align="center"><input type="submit" value="Create Style"><\/div>/print '<tr><td class="description" colspan=2><div align="center"><input type="submit" value="Create Style"><\/div><\/td><\/tr><\/table>/;
$::Subs{'EditNewsStyles_Main'} =~ s/CRHTMLFoot\(\)/CRHTMLFoot\(1\)/;

sub LoadAdminFunctionListFL {
	@AdminFunctions = (['Header', 'Coranto Configuration'],
	['Coranto Settings', 'Coranto configuration.', 'settings'],
	['Users', 'Manage users and administration permissions.', 'editusers'],
	['Date/Time', 'Change settings involving times, like time zones and date formats.', 'datesettings'],
	['Full Rebuild', 'Force a <i>full</i> build of news. Coranto usually builds only changed files.', 'fullbuild'],
    ['Header', 'News-Building Configuration'],
	['Profiles', 'Profiles build news from the database (<i>eg. News, Headlines, Teasers</i>).', 'profilelist'],
	['Styles', 'Styles define the <i>appearance</i> and <i>content</i> of your news.', 'nstyle'],
	['News Fields', 'News Fields hold <i>elements</i> of News (<i>eg. News, Date, Subject</i>).', 'editfielddb'],
	['User Fields', 'User Fields hold <i>elements</i> of User information (eg. <i>Name, ICQ, WWW</i>).', 'edituserdb'],
    ['Header', 'Addons'],
	['Addon Manager', 'Enable, disable, and view information about installed addons.', 'addonmanager']);
	push(@AdminFunctions, GetAddonAdminFunctions()) if $Addons;
	@AdminFunctions = reverse(@AdminFunctions);
    $adminfunctionsloaded = 1;
}



###################################
###################################
## MODIFIED CORANTO.CGI SUBROUTINES
###################################
###################################
sub CRHTMLHeadFL {
	unless ($HTMLHeaderPrinted) {
	my ($title, $adminnav) = @_;
	$title =~ s/</&lt;/g;
	$title =~ s/>/&gt;/g;
	$title =~ s/"/&quot;/g;
	print qq~
	<html><head><title>Coranto: $title</title>	$Messages{'ContentType'}
	~;
	print PrintCSSFL();
	# HOOK: CRHTMLHead_Head
	if($Addons{'CRHTMLHead_Head'}){my $w;foreach $w (@{$Addons{'CRHTMLHead_Head'}}){my $addon=$w->[2];eval ${$w->[0]};AErr($addon,$@)if $@;};}
	print '</head><body link="#D00000" vlink="#D00000" alink="#D00000" class="bodybg">';
    print '<a name="top">' if (($title ne "Submit News") && ($title ne "Edit News Item")); ### Fix WebWriter conflict.
    print '<div style="position:fixed; padding-bottom:0px; top:0px; width:100%;" class="bodybg">' if (($CConfig{'LinkBarFixed'}) && ($CConfig{'LinkBarPosition'} =~ /[123]/));
	# HOOK: CRHTMLHead
	if($Addons{'CRHTMLHead'}){my $w;foreach $w (@{$Addons{'CRHTMLHead'}}){my $addon=$w->[2];eval ${$w->[0]};AErr($addon,$@)if $@;};}

    print qq~<table width="95%" border="0" cellpadding="0" align="center" cellspacing="0"><tr><td>~;
    print qq~<div class="topinfo">$Messages{'LoggedIn'} <b>$CurrentUser</b>.</div>~ if ($CurrentUser);
    print qq~</td><td align=right><div class="topinfo">~;
    if ($CConfig{'PublicOrPrivate'}) {
        if ($CConfig{'SiteTitle'}) {
            print qq~<a href="$CConfig{'SiteLink'}" target="_blank">$CConfig{'SiteTitle'}</a>~ if ($CConfig{'SiteLink'});
            print qq~$CConfig{'SiteTitle'}~ if !($CConfig{'SiteLink'});
            print qq~ &middot ~;}
        print qq~<a href="http://coranto.org/" target="_blank">Coranto (v$crcgiVer~  . ( $crcgiRC ? " RC-$crcgiRC" : '' ) . qq~)</a>~;
    }
	# HOOK: CRHTMLHead_UserBar
	if($Addons{'CRHTMLHead_UserBar'}){my $w;foreach $w (@{$Addons{'CRHTMLHead_UserBar'}}){my $addon=$w->[2];eval ${$w->[0]};AErr($addon,$@)if $@;};}
    print qq~</div></td></tr></table><br>~;
    require 'crlang.pl';

    if (($CConfig{'LinkBarPosition'} eq '') || ($CConfig{'LinkBarPosition'} =~ /^[123]$/)) {
        LoadLinkBarList();
    	PrintLinkBar(\@LinkBarFunctions);
    }
    print '</div>' if (($CConfig{'LinkBarFixed'}) || ($CConfig{'LinkBarPosition'} =~ /^[123]$/));

    print qq~
        <table width="95%" border="0" cellpadding="2" align="center" cellspacing="2"><tr><td colspan="2" class="darkgbg">
        <table width=100% border="0" cellspacing="0" cellpadding="2" class="redbg"><tr><td>
        <div align="center" class="largeheader">$title</div></td></tr></table></td></tr></table><br>~;

	# HOOK: CRHTMLHead_Message
	if($Addons{'CRHTMLHead_Message'}){my $w;foreach $w (@{$Addons{'CRHTMLHead_Message'}}){my $addon=$w->[2];eval ${$w->[0]};AErr($addon,$@)if $@;};}

    if ($CConfig{'LinkBarPosition'} == 0) {
        print qq~<table cellspacing=0 cellpadding=0><tr><td valign=top>~ if (!$CConfig{'LinkBarFixed'});
        LoadLinkBarList();
    	PrintLinkBar(\@LinkBarFunctions);
        print '</td><td width=100% valign=top>' if (!$CConfig{'LinkBarFixed'});
        print '<div style="margin-left:116px;">' if ($CConfig{'LinkBarFixed'});
        print qq~
            <table style="width:99%" border="0" cellspacing="0" cellpadding="4" class="redbg" align="center"><tr><td>
            <table width="100%" border="0" cellspacing="0" cellpadding="6" class="whitebg" align="center"><tr><td>~;
    } else {
        my $padder = ($CConfig{'LinkBarAdmin'} * 26) + ($CConfig{'LinkBarAddons'} * 26) + 40 if (($CConfig{'LinkBarFixed'}) && ($CConfig{'LinkBarPosition'} =~ /^[123]$/));
        print '<div style="padding-top:' . $padder . 'px;">' if (($CConfig{'LinkBarFixed'}) && ($CConfig{'LinkBarPosition'} =~ /^[123]$/));
        my $padder = ($CConfig{'LinkBarAdmin'} * 26) + ($CConfig{'LinkBarAddons'} * 26) + 60 if (($CConfig{'LinkBarFixed'}) && ($CConfig{'LinkBarPosition'} =~ /[24]/));
        print '<div style="padding-bottom:' . $padder . 'px;">' if (($CConfig{'LinkBarFixed'}) && ($CConfig{'LinkBarPosition'} =~ /[24]/));
    	print qq~
        	<table width="95%" border="0" cellspacing="0" cellpadding="4" class="redbg" align="center"><tr><td>
            <table width="100%" border="0" cellspacing="0" cellpadding="6" class="whitebg" align="center"><tr><td>~;
    }
	$HTMLHeaderPrinted = 1;
	} # end unless $HTMLHeaderPrinted
}

sub CRHTMLFootFL {
    my $bottommenu = shift;
	print '<a name="bot"></td></tr></table></td></tr></table><br>';
    print '</div>' if ($CConfig{'LinkBarFixed'});

    if (($CConfig{'LinkBarPosition'} == 0) && ($CConfig{'LinkBarFixed'})) {
        print qq~</td></tr></table>~;
    }
    if (($CConfig{'LinkBarPosition'} =~ /[24]/) || (($bottommenu) && ($CConfig{'LinkBarPosition'} == 1) && (!$CConfig{'LinkBarFixed'}))) {
        print '<div style="position:fixed; padding-top:10px; bottom:0px; width:100%;" class="bodybg">' if (($CConfig{'LinkBarFixed'}) && ($CConfig{'LinkBarPosition'} =~ /[24]/));
        LoadLinkBarList();
	    PrintLinkBar(\@LinkBarFunctions);
        print '</div>' if (($CConfig{'LinkBarFixed'}) && ($CConfig{'LinkBarPosition'} =~ /[24]/));
    }
	# HOOK: CRHTMLFoot_2
	if($Addons{'CRHTMLFoot_2'}){my $w;foreach $w (@{$Addons{'CRHTMLFoot_2'}}){my $addon=$w->[2];eval ${$w->[0]};AErr($addon,$@)if $@;};}
	print '</body></html>';
}

sub PrintCSSFL {
	unless($CConfig{'HeadCSS'}){
		&ReadConfigInfo();
	}
	my $css = $CConfig{'HeadCSS'};
    my $faceliftcss;

	# HOOK: PrintCSS
	if($Addons{'PrintCSS'}){my $w;foreach $w (@{$Addons{'PrintCSS'}}){my $addon=$w->[2];eval ${$w->[0]};AErr($addon,$@)if $@;};}

    ############
    ## THEMES ##
    ############
    ## FaceLift has five more CSS classes than standard Coranto, so this
    ## section adds the missing classes if they aren't present in the current Theme.
    if ($css !~ /descriptiondarker/) {
        my ($null, $temp, $color);

        ## Rather than just use hard-coded colors for these extra fields,
        ## the following code tries to calculate suitable colors
        ## based on the current theme. (waaay experimental)

        ## If the colors it creates aren't to taste, just add the following
        ## five classes to the Theme that you use:

        # .topinfo { font-size: 13px; background-color: #FFDC8E}
        # .menuheader { border-bottom:1px solid #FFCC33; border-right:1px solid #FFCC33; text-align:right; font-weight:bold; background-color: #F8EFBF}
        # .menuheader2 { border-bottom:1px solid #FFCC33; border-top:1px solid #FFCC33; text-align:left; font-weight:bold; background-color: #F8EFBF}
        # .menulinks { border-bottom:1px solid #FFCC33; text-align:left; background-color: #FFF8CA}
        # .descriptiondarker { width:100%; background-color: #F6EFC1}
    
        ## Use a brighter version of 'bgcolor' for the top information bar.
        ($null, $temp) = split(/.bodybg/, $css);
        ($null, $temp) = split(/background-color/, $temp);
        ($null, $temp) = split(/#/, $temp);
        ($color, $null) = split(/;/, $temp);
        ($color, $null) = split(/}/, $color);
        my ($vala, $valb, $valc);
        $temp = (hex substr($color, 0, 2)) + 9;
        $vala = '0' if ($temp < 16);
        $vala .= ($temp <= 255) ? sprintf("%x", $temp) : 'FF';
        $temp = (hex substr($color, 2, 2)) + 9;
        $valb = '0' if ($temp < 16);
        $valb .= ($temp <= 255) ? sprintf("%x", $temp) : 'FF';
        $temp = (hex substr($color, 4, 2)) + 9;
        $valc = '0' if ($temp < 16);
        $valc .= ($temp <= 255) ? sprintf("%x", $temp) : 'FF';
        my $newbgcolor = $vala . $valb . $valc;

        ## Use a darker version of 'description' for the addon/profile descriptions.
        ($null, $temp) = split(/.description/, $css);
        ($null, $temp) = split(/background-color/, $temp);
        ($null, $temp) = split(/#/, $temp);
        ($color, $null) = split(/;/, $temp);
        ($color, $null) = split(/}/, $color);
        my ($vala, $valb, $valc);
        $temp = (hex substr($color, 0, 2)) - 9;
        $vala = '0' if ($temp < 16);
        $vala .= ($temp >= 0) ? sprintf("%x", $temp) : '0';
        $temp = (hex substr($color, 2, 2)) - 9;
        $valb = '0' if ($temp < 16);
        $valb .= ($temp >= 0) ? sprintf("%x", $temp) : '0';
        $temp = (hex substr($color, 4, 2)) - 9;
        $valc = '0' if ($temp < 16);
        $valc .= ($temp >= 0) ? sprintf("%x", $temp) : '0';
        my $newdescription = $vala . $valb . $valc;

        my $yellow;
        if ($Addons{'PrintCSS'}) {
            ## Use a brighter version of 'redbg' for the menu separators.
            ($null, $temp) = split(/.redbg/, $css);
            ($null, $temp) = split(/background-color/, $temp);
            ($null, $temp) = split(/#/, $temp);
            ($color, $null) = split(/;/, $temp);
            ($color, $null) = split(/}/, $color);
            my ($vala, $valb, $valc);
            $temp = (hex substr($color, 0, 2)) + 100;
            $vala = '0' if ($temp < 16);
            $vala .= ($temp <= 255) ? sprintf("%x", $temp) : 'FF';
            $temp = (hex substr($color, 2, 2)) + 100;
            $valb = '0' if ($temp < 16);
            $valb .= ($temp <= 255) ? sprintf("%x", $temp) : 'FF';
            $temp = (hex substr($color, 4, 2)) + 100;
            $valc = '0' if ($temp < 16);
            $valc .= ($temp <= 255) ? sprintf("%x", $temp) : 'FF';
            $yellow = $vala . $valb . $valc;
        } else {
            ## Use #FFCC33 if we're not using Themes. I couldn't find an easy way
            ## to calculate this color that worked well for the default Coranto
            ## style as well as all the addons.
             $yellow = 'FFCC33';
        }

        ## Use 'yellowbg' for the menu link backgrounds.
        ($null, $temp) = split(/.yellowbg/, $css);
        ($null, $temp) = split(/background-color/, $temp);
        ($null, $temp) = split(/#/, $temp);
        ($color, $null) = split(/;/, $temp);
        ($color, $null) = split(/}/, $color);
        my $yellowbg = $color;

        ## Use a darker 'yellowbg' for the menu header backgrounds.
        my ($vala, $valb, $valc);
        $temp = (hex substr($color, 0, 2)) - 7;
        $vala = '0' if ($temp < 16);
        $vala .= ($temp >= 0) ? sprintf("%x", $temp) : '0';
        $temp = (hex substr($color, 2, 2)) - 9;
        $valb = '0' if ($temp < 16);
        $valb .= ($temp >= 0) ? sprintf("%x", $temp) : '0';
        $temp = (hex substr($color, 4, 2)) - 11;
        $valc = '0' if ($temp < 16);
        $valc .= ($temp >= 0) ? sprintf("%x", $temp) : '0';
        my $newyellow = $vala . $valb . $valc;

        ## And now add the FaceLift styles using the calculated colors.
        $faceliftcss = qq~
            .topinfo { font-family: Arial, Helvetica, sans-serif; font-size: 13px; background-color: #~ . $newbgcolor . qq~}
            .menuheader { font-family: Arial, Helvetica, sans-serif; border-bottom:1px solid #~ . $yellow . qq~; border-right:1px solid #~ . $yellow . qq~; text-align:right; font-weight:bold; background-color: #~ . $newyellow . qq~}
            .menuheader2 { font-family: Arial, Helvetica, sans-serif; border-bottom:1px solid #~ . $yellow . qq~; border-top:1px solid #~ . $yellow . qq~; text-align:left; font-weight:bold; background-color: #~ . $newyellow . qq~}
            .menulinks { font-family: Arial, Helvetica, sans-serif; border-bottom:1px solid #~ . $yellow . qq~; text-align:left; background-color: #~ . $yellowbg . qq~}
            .descriptiondarker { width:100%; background-color: #~ . $newdescription . qq~}~;
        $faceliftcss .= qq~table {width:100%}~ if ($CConfig{'ScreenRes'} > 0);
    }
    return qq~
    <style type="text/css">
        <!--
        $css
        $faceliftcss
        -->
    </style>~;
}

## Additional crlang.pl elements. $crlangVersion increased to 2 since this
## new version includes a lot more fields.
$crlangVersion = 2;

%Messages2 = (
## Linkbar messages.
'Linkbar_MainPage' => q~Main~,
'Linkbar_Settings' => q~Settings~,
'Linkbar_Upload' => q~Uploader~,
'Linkbar_Addons' => q~Addons~,
'Linkbar_Submit' => q~Submit News~,
'Linkbar_Build' => q~Build News~,
'Linkbar_Modify' => q~Modify News~,
'Linkbar_UserProfile' => q~Your Prefs~,
'Linkbar_PM' => q~Private Messages~,
'Linkbar_FAQ' => q~Faq/Help~,
'Linkbar_LogOut' => q~Log Out~,
'Linkbar_Administration' => q~more...~,
'Linkbar_Profiles' => q~Profiles~,
'Linkbar_Styles' => q~Styles~,
'Linkbar_NewsFields' => q~News Fields~,
'Linkbar_Categories' => q~Categories~,
'Linkbar_Tintinnabulum' => q~Categories~,
'Linkbar_Users' => q~Users~,
'Linkbar_FlBuild' => q~Full Rebuild~,
'Linkbar_UserFields' => q~User&nbsp;Fields~,

## Misc interface messages.
'Section_MainPage' => q~Main Page~,
'Section_HelpPage' => q~Help/Documentation~,
'Section_Submit' => q~Submit News~,
'Section_Modify' => q~Modify News~,
'Section_Build' => q~Build News~,
'Section_UserInfo' => q~User Info~,
'Section_LogOut' => q~Log Out~,

## Messages for the Administration and Main pages.
'Admin_Administration' => q~Administration~,
'Admin_Submit' => q~Submit News~,
'Admin_Build' => q~Build News~,
'Admin_Modify' => q~Modify News~,
'Admin_UserInfo' => q~Your Prefs~,
'Admin_Addons' => q~Addons~,
'Admin_Profiles' => q~Profiles~,
'Admin_Styles' => q~Styles~,
'Admin_NewsFields' => q~News Fields~,
'Admin_Categories' => q~Categories~,
'Admin_LogOut' => q~Log Out~,

## Some modified description messages.
'Desc_Administration' => q~Configure Coranto and change all available settings.~,
'Desc_Modify_High' => q~~,
'Desc_Modify_Std' => q~~,
'Desc_Build' => q~Generate HTML files from the database.~,
'Desc_LogOut' => q~Log out of Coranto.~,

## Date and Time messages.
'DateTime_24Title' => q~12/24 Hour Clock~,
'DateTime_24' => q~Choose between 12 hour (AM/PM) and 24 hour clocks.~,
'DateTime_ZoneTitle' => q~Time Zone~,
'DateTime_Zone' => q~Your time zone. Any name or abbreviation is acceptable -- this is for display purposes only.~,
'DateTime_DLSZoneTitle' => q~Daylight Savings Time Zone~,
'DateTime_DLSZone' => q~As above, but during Daylight Savings Time.~,
'DateTime_OffsetTitle' => q~Server Time Offset~,
'DateTime_Offset' => qq~
    <ul><li>The number of hours difference between you and your server. 
    <li>Changing this setting will not affect existing news items; only new items will have an adjusted time. 
    <li>The server's current time is: ~,
'DateTime_FormatsDesc' => '<ul><li>The following settings allow you to configure how dates &amp; times appear.<li>To insert a component of the date or time, use <i>&lt;Field: Name&gt;</i> where <i>Name</i> a Field from the panel to the right.<li>The tags are case-sensitive, so <i>&lt;Field: Day&gt;</i> will work but <i>&lt;field: day&gt;</i> wont. The space after : is required.',

## Messages for the ChangeSettings page.
'ChangeSettings_LinkBarPositionTitle' => q~Link-Bar Positioning~,
'ChangeSettings_LinkBarPosition' => q~<ul><li>Will determine the placement of the link-bar.<li><i>Automatic</i> will selectively add a link-bar below the content on certain pages.~,
'ChangeSettings_LinkBarAdminTitle' => q~Admin Options On Link-Bar~,
'ChangeSettings_LinkBarAdmin' => q~<ul><li>Will add an <i>Administration</i> line to the link-bar.~,
'ChangeSettings_LinkBarAddonsTitle' => q~Addons On Link-Bar~,
'ChangeSettings_LinkBarAddons' => q~<ul><li>Will add an <i>Addon</i> line to the link-bar.<li>Only Addons with <i>Main</i> administration pages will be included.~,
'ChangeSettings_HeadingPath' => q~Coranto Settings~,
'ChangeSettings_HeadingInterface' => q~Interface Options~,
'ChangeSettings_HeadingBuild' => q~Build-News Settings~,
'ChangeSettings_HeadingArchive' => q~Archive Defaults~,
'ChangeSettings_ModifyPerPageTitle' => qq~Items Per Modify-News Page~,
'ChangeSettings_ModifyPerPage' => qq~<ul><li>The number of news items that are displayed on each Modify News page.~,
'ChangeSettings_SiteNameTitle' => qq~Your Site Name~,
'ChangeSettings_SiteName' => qq~<ul><li>(optional) The name of your site.<li>Adds the name to the top/right of each Coranto page.~,
'ChangeSettings_SiteURLTitle' => qq~Your Site URL~,
'ChangeSettings_SiteURL' => qq~<ul><li>(optional) Turns the Site Name into a handy link to your web site.~,
'ChangeSettings_ArchiveExtTitle' => qq~Archive HTML File Extension~,
'ChangeSettings_ArchiveExt' => qq~<ul><li>The extension that will be given to to archive HTML files.<li>No period, just the extension (eg. html, shtml).~,
'ChangeSettings_BuildSubmitTitle' => qq~Automatically Build News on <i>Submit</i>~,
'ChangeSettings_BuildSubmit' => qq~<ul><li>Will automatically re-<i>build</i> the news when you submit a new news item.<li>This means new news is immediately visible on your site after being added.~,
'ChangeSettings_BuildModifyTitle' => qq~Automatically Build News on <i>Modify</i>~,
'ChangeSettings_BuildModify' => qq~<ul><li>Will automatically re-<i>build</i> the news when you edit a news item.<li>This means news changes will be immediately visible on your site.~,
'ChangeSettings_LinkURLsTitle' => qq~Automatically Link URLs~,
'ChangeSettings_LinkURLs' => qq~<ul><li>Converts <b>http://</b> URLs into <b>&lt;a href=""&gt;</b>HTML links<b>&lt;/a&gt;</b>.~,
'ChangeSettings_ProgramPathTitle' => qq~Program Files Path~,
'ChangeSettings_ProgramPath' => qq~
    <ul><li>The <i>absolute path</i> (<b>not</b> URL) to the Coranto program files.
    <li>Use forward slashes (/), even on Windows systems.
    <li>Do not include a trailing slash.~,
'ChangeSettings_NewsPathTitle' => qq~Default News-Files Path~,
'ChangeSettings_NewsPath' => qq~
    <ul><li>The <i>absolute path</i> (<b>not</b> URL) to where you want your news generated.
    <li>Use forward slashes (/), even on Windows systems.
    <li>Do not include a trailing slash.
    <li>This path should point <i>outside</i> of a cgi-bin/ directory (if you have one). 
    <li>The directory must be world-writable. (chmod 777 or 755 depending on the server)~,
'ChangeSettings_ArchivePathTitle' => qq~Archive Files Path~,
'ChangeSettings_ArchivePath' => qq~
    <ul><li>The <i>absolute path</i> (<b>not</b> URL) to where you want your archived news generated.
    <li>The same rules apply as for <b>News Files Path</b>.~,
);

%Messages = (%Messages, %Messages2);

}
}



1;

__END__

=head1 FaceLift

=begin html

FaceLift gives Coranto's administrative interface a significant <i>nip and tuck</i>. It changes the menu, the layout and arrangement of tools, and also tweaks a lot of the tool documentation -- all with the aim of making it a lot easier to use. Just enable it and see.
<p>
FaceLift adds new options to 'Settings' which allow you to tweak some of the new interface settings.

=end html

=head2 COMPATIBILITY ISSUES

=begin html

<b>FaceLift and Coranto versions</b>:
<br>
<ul>
This version of FaceLift is designed to work <u>specifically</u> with <b>Coranto v1.22 (build 37)</b>.
<p>
It is generally not recommended that you use this version of FaceLift on any other build/version of Coranto. However, if you want to use it with another version of Coranto and you don't mind risking the loss of Coranto features/settings (usually not a big deal) then you can edit these lines at the top of cra_facelift.pl to match the version of Coranto you wish to use it with:
<p>
<textarea rows=2 cols=80 wrap=off>
$addon->checkBuild(37);
if (($::crcgiBuild != 37) || ($crcgiVer != '1.22') || ($crcgiRC != 0)) {</textarea>
</ul>
<p>
Remember, <i>if you upgrade Coranto then <b>FaceLift</b> should be upgraded to the matching version (if one exists).</i>
<p>

<b>FaceLift and Coranto <u>Themes</u></b>:
<br>
<ul>
FaceLift uses <i>five new CSS classes</i>. In order to work with all existing Coranto <i>Themes</i> (via the <i>Chameleon</i> or <i>Froggy</i> addons), FaceLift actually looks at the theme being used and attempts to calculate suitable colors for the new classes.
<p>
It does a pretty good job, but if the colors it chooses aren't to your taste you can just add the following classes to your <i>theme</i>:
<p>
<textarea rows=6 cols=80 wrap=off>
&nbsp;&nbsp;.topinfo { font-family: Arial, Helvetica, sans-serif; font-size: 13px; background-color: #FFDC8E}<br>
&nbsp;&nbsp;.menuheader { font-family: Arial, Helvetica, sans-serif; border-bottom:1px solid #FFCC33; border-right:1px solid #FFCC33; text-align:right; font-weight:bold; background-color: #F8EFBF}<br>
&nbsp;&nbsp;.menuheader2 { font-family: Arial, Helvetica, sans-serif; border-bottom:1px solid #FFCC33; border-top:1px solid #FFCC33; text-align:left; font-weight:bold; background-color: #F8EFBF}<br>
&nbsp;&nbsp;.menulinks { font-family: Arial, Helvetica, sans-serif; border-bottom:1px solid #FFCC33; text-align:left; background-color: #FFF8CA}<br>
&nbsp;&nbsp;.descriptiondarker { width:100%; background-color: #F6EFC1}<br>
</textarea>
<p>
</ul>

<b>FaceLift and Web Browser compatibility</b>:<br>
<br>
<ul>
FaceLift does not work with Netscape 4.7x.
</ul>

=end html

=head2 ABOUT FACELIFT

=begin html

<ul>
<li>Addon by: Rowan 'Sumaleth' Crawford
<li>Email: sumaleth@sumaleth.com
<li>Web Sites:
    <ul>
    <li><a href="http://www.sumaleth.com/coranto" target="_blank">My Coranto Addons</a>
    <li><a href="http://www.liquefyr.com/" target="_blank">Liquefyr</a> <small>(a powerful PHP-based CMS script)</small>
    <li><a href="http://www.liquenox.net/" target="_blank">Liquenox Web Hosting</a>
    <li><a href="http://www.sumaleth.com/" target="_blank">Book Reviews</a>
    <li><a href="http://www.sumaleth.com/links/" target="_blank">Art Links Archive</a>
    <li><a href="http://www.superdeformedmegafun.com/" target="_blank">Caricatures</a>
    </ul>
</ul>
FaceLift Versions:
<ul>
<li><b>3.1</b>
    <ul>
    <li>This 3.1 version of FaceLift works specifically with Coranto 1.22.1 (build 37). This version is also the first that will work correctly with 'X Multi-Submit' version 2.0 and up (and it will no longer work with pre-2.0 versions of XMS). 
    </ul>
<li><b>3.0</b>
    <ul>
    <li>This 3.0 version of FaceLift works specifically with Coranto 1.22 (build 37).
    </ul>
<li><b>2.3</b>
    <ul>
    <li>This 2.3 version of FaceLift works specifically with Coranto 1.02.
    </ul>
<li><b>2.2</b>
    <ul>
    <li>This version of FaceLift works specifically with Coranto 1.01.
    <li>This is the first version compliant with the Coranto 1.01 privacy settings and will not display any external links if privacy is enabled.
    </ul>
<li><b>2.14</b>
    <ul>
    <li>Tweaked interface formatting.
    </ul>
<li><b>2.13</b>
    <ul>
    <li>Added a missing addon hook back into the CRHTMLHead sub. This means addons like <b>Also Logged In</b> will work again.
    </ul>
<li><b>2.12</b>
    <ul>
    <li>Fixed a conflict with WebWriter.
    </ul>
<li><b>2.1</b>
    <ul>
    <li>This version works with Coranto 1.0.
    <li>Should no longer produce a version error with ViewNews.
    <li>Minor tweaks.
    </ul>
<li><b>2.01</b>
    <ul>
    <li>Added the upgrade stuff back to the Main Page. Probably shouldn't have taken it out. 
    </ul>
<li><b>2.0</b>
    <ul>
    <li><b>FaceLift now requires <u>Coranto build 30rc2</u>.</b>
    <li>FaceLift has been re-formatted to use far fewer server resources.
    <li>For browsers that support <i>position:fixed</i>, the link-bar can now be locked to either the top or bottom of the screen, or to the left.
    <li>If link-bar <i>locking</i> isn't used, navigation arrows are now added to various pages to offer instant jumping to either the top or bottom of the page.
    <li>Edit Users has been reworked.
    </ul>
<li><b>1.7</b>
    <ul>
    <li>Adds the option of a vertical link-bar. Tis way cool.
    <li>Also adds some options for screen-resolution-dependant tweaks. These options (in 'Coranto Settings') change the layout here and there. The default is set for high screen resolutions (1152x864 and up), so these alternate options are designed for lower resolutions.
    </ul>
<li><b>1.6.6</b>
    <ul>
    <li>Fixes a bug with Profile build paths.
    </ul>
<li><b>1.6.5</b>
    <ul>
    <li>It now includes the extra Field options added by XSquash (dropdown fields etc).
    <li>Field re-ordering has been reinstated.
    <li>Fixed non-breaking-spaces for Mozilla.
    </ul>
<li><b>1.6</b>
    <ul>
    <li>The main Profile page has been rearranged considerably. Headlines are now separated from the regular news options (much like Archiving), and room has been made for similar adodns which also create their own news files such as MultiPage and AlphabetPages.
    <li>The main Profile page now also integrates Maginot Line much better.
    <li>The Profile settings page has been rearranged and grouped more logically.
    <li>The main pages for Fields, Styles and Categories have been worked over.
    <li>Lots of small tweaks.
    </ul>
<li><b>1.5</b>
    <ul>
    <li>FaceLift is now more integrated with XMS (if the XMultiSubmit addon is being used).
    </ul>
<li><b>1.4</b>
    <ul>
    <li>Re-worked the addons interface.
    <li>Added toggles to the profiles interface.
    <li>Tweaked main page and administration layouts.
    <li>Small bug fixes.
    </ul>
<li><b>1.3</b>
    <ul>
    <li>FaceLift now works with Themes.
    <li>The positioning of the link-bar is now configurable in <i>Settings</i>.
    <li>The Addon line on the link-bar now includes addons that hook into the Administration page.
    <li>FaceLift now handles user levels correctly.
    <li>Now works with the addon 'Net Link'.
    <li>Minor interface tweaks and bug fixes.
    <li>Added two more help links.
    </ul>
<li><b>1.2</b>
    <ul>
    <li>Stopped FaceLift incorrectly appearing in the Administration Tools list.
    </ul>
<li><b>1.1</b>
    <ul>
    <li>The link-bar now has configurable lines for <b>Admin</b> and </b>Addons</b>.
    <li>Added support for 'E-Mail Author' to the Addon Manager.
    </ul>
<li><b>1.0</b>
    <ul>
    <li>Initial release.
    </ul>
</ul>

=end html
