#! CRADDON 1
#! NAME ezStats
#! DESCRIPTION View all sorts of info and stats by user or category.
#! VERSION 0.94
#! HOMEPAGE mailto:aero-soul@rogers.com">E-Mail Author</a>] [<a href="http://www.eatsleepcode.ca/
#! DOC 1

# Email author link by agnst

my $addon = new Addon('ezStats');
$addon->checkBuild(29);
$ezStats_Version = '0.94';

$addon->addAdminFunction('ezStats','View all sorts of info and stats by user or category.','ezStats');
$addon->registerAdminFunction(ezStats,ezStats_Main);
$addon->registerAdminFunction(ezStats_UserStats,ezStats_UserStats);
$addon->registerAdminFunction(ezStats_User,ezStats_User);
$addon->registerAdminFunction(ezStats_CategoryStats,ezStats_CategoryStats);
$addon->registerAdminFunction(ezStats_Category,ezStats_Category);
$addon->registerAdminFunction(ezStats_OverallStats,ezStats_OverallStats);
$addon->registerAdminFunction(ezStats_Info,ezStats_Info);
$addon->registerAdminFunction(ezStats_UserInfo,ezStats_UserInfo);
$addon->registerAdminFunction(ezStats_CategoryInfo,ezStats_CategoryInfo);
$addon->registerAdminFunction(ezStats_OverallInfo,ezStats_OverallInfo);
$addon->hook(CRHTMLHead_Head,ezStats_IPTrack);

sub ezStats_Main {
	push(@ezStats_MainFunctions,['Info','View help and information.', 'ezStats_Info']);
	push(@ezStats_MainFunctions,['Overall Stats','View general statistics.', 'ezStats_OverallStats']);
	push(@ezStats_MainFunctions,['Category Stats','View statistics by category.','ezStats_CategoryStats']);
	push(@ezStats_MainFunctions,['User Stats','View statistics by user.', 'ezStats_UserStats']);
	ezStats_Header('Main',1);
	PrintFunctionList(\@ezStats_MainFunctions,'adminarea','action','admin');
	print $addon->link({'action'=>'admin','adminarea'=>'ezStats_User','ezAction'=>$CurrentUser}) . q~
	view your stats</a>
	~;
	ezStats_Footer(1);
}

sub ezStats_UserStats {
	NeedCFG();
	$ezStats_TotalUserCount = 0;
	if ($in{'ezAction'}) {
		$ezStats_ViewType = $in{'ezAction'};
		if ($ezStats_ViewType eq 'admin') {
			$ezStats_ViewTypeNum = 3;
		} elsif ($ezStats_ViewType eq 'high') {
			$ezStats_ViewTypeNum = 2;
		} elsif ($ezStats_ViewType eq 'standard') {
			$ezStats_ViewTypeNum = 1;
		} else {
			$ezStats_ViewTypeNum = 4;
		}
	} else {
		$ezStats_ViewType = 'all';
		$ezStats_ViewTypeNum = 4;
	}
	foreach $i (sort keys %userdata) {
		$ezStats_TotalUserCount++ if (($ezStats_ViewTypeNum == $userdata{$i}->{'UserLevel'}) or ($ezStats_ViewTypeNum == 4));
	}
	if ($ezStats_TotalUserCount > 0) {
		ezStats_ReadNewsdat();
		foreach $i (@ezStats_NewsdatContents) {
			&SplitDataFile($i);
			next unless ($userdata{$User});
			$ezStats_PostCount{$User}++ if (($ezStats_ViewTypeNum == $userdata{$User}->{'UserLevel'}) or ($ezStats_ViewTypeNum == 4));
		}
	}
	ezStats_Header('User Stats',2.1);
	print qq~
	curently viewing <b>$ezStats_ViewType</b> users ($ezStats_TotalUserCount)<br><br>
	<table width="100%" cellpadding="2" cellspading="0">
	<tr><td width="5%" align="center" valign="top" class="lightgbg">
	<b>#</b>
	</td><td width="30%" align="center" valign="top" class="lightgbg">
	<b>User</b>
	</td><td width="15%" align="center" valign="top" class="lightgbg">
	<b>Level</b>
	</td><td width="15%" align="center" valign="top" class="lightgbg">
	<b>Status</b>
	</td><td width="12%" align="center" valign="top" class="lightgbg">
	<b>Posts</b>
	</td><td width="18%" align="center" valign="top" class="lightgbg">
	<b>View Stats</b>
	</td></tr>
	~;
	if ($ezStats_TotalUserCount > 0) {
		foreach $i (sort keys %userdata) {
			next unless (($ezStats_ViewTypeNum == $userdata{$i}->{'UserLevel'}) or ($ezStats_ViewTypeNum == 4));
			$ezStats_UserCount++;
			$ezStats_PostCount = 0;
			$ezStats_PostCount += $ezStats_PostCount{$i};
			if ($userdata{$i}->{'DisableUser'}) {
				$ezStats_Status = 'disabled';
			} else {
				$ezStats_Status = 'enabled';
			}
			if ($userdata{$i}->{'UserLevel'} == 3) {
				$ezStats_UserLevel = 'admin';
			} elsif ($userdata{$i}->{'UserLevel'} == 2) {
				$ezStats_UserLevel = 'high';
			} else {
				$ezStats_UserLevel = 'standard';
			}
			print qq~
			<tr><td width="5%" align="center" valign="top" class="yellowbg">
			<div class="footnote">$ezStats_UserCount</div>
			</td><td width="30%" align="center" valign="top" class="yellowbg">
			<div class="footnote">$i</div>
			</td><td width="15%" align="center" valign="top" class="yellowbg">
			<div class="footnote">$ezStats_UserLevel</div>
			</td><td width="15%" align="center" valign="top" class="yellowbg">
			<div class="footnote">$ezStats_Status</div>
			</td><td width="12%" align="center" valign="top" class="yellowbg">
			<div class="footnote">$ezStats_PostCount</div>
			</td><td width="18%" align="center" valign="top" class="yellowbg">
			<div class="footnote">
			~ . $addon->link({'action'=>'admin','adminarea'=>'ezStats_User','ezAction'=>$i}) . q~
			view stats</a></div>
			</td></tr>
			~;
		}
	} else {
		print q~
		<tr><td width="100%" align="center" valign="top" colspan="6" class="yellowbg">
		<div class="footnote">(n/a)</div>
		</td></tr>
		~;
	}
	print q~
	</table>
	~;
	ezStats_Footer(2);
}

sub ezStats_User {
	$ezStats_UserStats = $in{'ezAction'};
	if ($userdata{$ezStats_UserStats}) {
		ReadUserDBInfo();
		NeedCFG();
		$ezStats_TotalPostCount = 0;
		if ((-e "$CConfig{'admin_path'}/viewnews.cgi") or (-e 'viewnews.cgi')) {
			$ezStats_View = 1;
			$ezStats_ViewURL = 'viewnews.cgi';
		} elsif ((-e "$CConfig{'admin_path'}/viewnews.pl") or (-e 'viewnews.pl')) {
			$ezStats_View = 1;
			$ezStats_ViewURL = 'viewnews.pl';
		}
		ezStats_ReadNewsdat();
		foreach $i (@ezStats_NewsdatContents) {
			&SplitDataFile($i);
			$ezStats_TotalPostCount++;
			next unless ($User eq $ezStats_UserStats);
			unless ($ezStats_FirstPost) {
				$ezStats_FirstPost = $newstime;
				if ($ezStats_View) {
					$ezStats_ViewFirstPost = qq~
					(<a href="$ezStats_ViewURL?id=$newsid" target="_blank">view post</a>)
					~;
				} else {
					$ezStats_ViewFirstPost = '(view post)';
				}
			}
			$ezStats_PostCount++;
			if ($newstime > $ezStats_LatestPost) {
				$ezStats_LatestPost = $newstime;
				if ($ezStats_View) {
					$ezStats_ViewLatestPost = qq~
					(<a href="$ezStats_ViewURL?id=$newsid" target="_blank">view post</a>)
					~;
				} else {
					$ezStats_ViewLatestPost = '(view post)';
				}
			}
			if ($ezStats_FirstPost > $newstime) {
				$ezStats_FirstPost = $newstime;
				if ($ezStats_View) {
					$ezStats_ViewFirstPost = qq~
					(<a href="$ezStats_ViewURL?id=$newsid" target="_blank">view post</a>)
					~;
				} else {
					$ezStats_ViewFirstPost = '(view post)';
				}
			}
		}
		$ezStats_UserData = $userdata{$ezStats_UserStats};
		if ($ezStats_UserData->{'UserLevel'} == 3) {
			$ezStats_UserLevel = 'administrator (3)';
		} elsif ($ezStats_UserData->{'UserLevel'} == 2) {
			$ezStats_UserLevel = 'high (2)';
		} else {
			$ezStats_UserLevel = 'standard (1)';
		}
		if ($ezStats_UserData->{'DisableUser'}) {
			$ezStats_UserStatus = 'disabled';
		} else {
			$ezStats_UserStatus = 'enabled';
		}
		if ($ezStats_UserData->{'LastLogin'}) {
			if ($CConfig{'TimeOffset'}) {
				$ezStats_LastLogin = lc(GetTheDate_Internal($ezStats_UserData->{'LastLogin'} + (3600 * $CConfig{'TimeOffset'})));
			} else {
				$ezStats_LastLogin = lc(GetTheDate_Internal($ezStats_UserData->{'LastLogin'}));
			}
		} else {
			$ezStats_LastLogin = '(never)';
		}
		if ($ezStats_LatestPost) {
			if ($CConfig{'TimeOffset'}) {
				$ezStats_LatestPost = lc(GetTheDate_Internal($ezStats_LatestPost + (3600 * $CConfig{'TimeOffset'})));
			} else {
				$ezStats_LatestPost = lc(GetTheDate_Internal($ezStats_LatestPost));
			}
		} else {
			$ezStats_LatestPost = '(n/a)';
		}
		if ($ezStats_FirstPost) {
			if ($CConfig{'TimeOffset'}) {
				$ezStats_FirstPost = lc(GetTheDate_Internal($ezStats_FirstPost + (3600 * $CConfig{'TimeOffset'})));
			} else {
				$ezStats_FirstPost = lc(GetTheDate_Internal($ezStats_FirstPost));
			}
		} else {
			$ezStats_FirstPost = '(n/a)';
		}
		@ezStats_UserIPs = split(/\|x\|/,$CConfig{'ezStats_UserIPs'});
		foreach $i (@ezStats_UserIPs) {
			($ezStats_IPName,$ezStats_IPValue) = split(/~/,$i);
			next unless($ezStats_IPName eq $ezStats_UserStats);
			$ezStats_UserIP = $ezStats_IPValue;
		}
		$ezStats_UserIP = '(n/a)' if (($ezStats_UserIP eq '0.0.0.0') or !($ezStats_UserIP));
		$ezStats_PostCount = 0 unless ($ezStats_PostCount);
		if ($ezStats_TotalPostCount) {
			$ezStats_PostPercent = sprintf("%.1f",$ezStats_PostCount / $ezStats_TotalPostCount * 100);
		} else {
			$ezStats_PostPercent = '0.0';
		}
		ezStats_Header("User: $ezStats_UserStats",2.2);
		print qq~
		<table width="80%" cellpadding="2" cellspading="0" align="center">
		<tr><td width="100%" align="center" colspan="2" class="lightgbg">
		<b>Stats for user: $ezStats_UserStats</b>
		</td></tr>
		<tr><td width="40%" align="right" valign="top" class="yellowbg">
		<div class="footnote">User Level:</div>
		</td><td width="60%" valign="top" class="yellowbg">
		<div class="footnote">$ezStats_UserLevel</div>
		</td></tr>
		<tr><td width="40%" align="right" valign="top" class="yellowbg">
		<div class="footnote">User Status:</div>
		</td><td width="60%" valign="top" class="yellowbg">
		<div class="footnote">$ezStats_UserStatus</div>
		</td></tr>
		<tr><td width="40%" align="right" valign="top" class="yellowbg">
		<div class="footnote">Last Login:</div>
		</td><td width="60%" valign="top" class="yellowbg">
		<div class="footnote">$ezStats_LastLogin</div>
		</td></tr>
		<tr><td width="40%" align="right" valign="top" class="yellowbg">
		<div class="footnote">Latest Post:</div>
		</td><td width="60%" valign="top" class="yellowbg">
		<div class="footnote">$ezStats_LatestPost $ezStats_ViewLatestPost</div>
		</td></tr>
		<tr><td width="40%" align="right" valign="top" class="yellowbg">
		<div class="footnote">First Post:</div>
		</td><td width="60%" valign="top" class="yellowbg">
		<div class="footnote">$ezStats_FirstPost $ezStats_ViewFirstPost</div>
		</td></tr>
		<tr><td width="40%" align="right" valign="top" class="yellowbg">
		<div class="footnote">User IP:</div>
		</td><td width="60%" valign="top" class="yellowbg">
		<div class="footnote">$ezStats_UserIP</div>
		</td></tr>
		<tr><td width="40%" align="right" valign="top" class="yellowbg">
		<div class="footnote">Post Count:</div>
		</td><td width="60%" valign="top" class="yellowbg">
		<div class="footnote">$ezStats_PostCount (total: $ezStats_TotalPostCount)</div>
		</td></tr>
		<tr><td width="40%" align="right" valign="top" class="yellowbg">
		<div class="footnote">Post Percent:</div>
		</td><td width="60%" valign="top" class="yellowbg">
		<div class="footnote">$ezStats_PostPercent%</div>
		</td></tr>
		</table><br><br>
		<table width="80%" cellpadding="2" cellspading="0" align="center">
		<tr><td width="100%" align="center" colspan="2" class="lightgbg">
		<b>Profile for user: $ezStats_UserStats</b>
		</td></tr>
		~;
		foreach $i (sort keys %userDB) {
			$ezStats_UserProfile = $userdata{$ezStats_UserStats}->{$i};
			$ezStats_UserProfile = '(not specified)' unless ($ezStats_UserProfile);
			unless ($userDB{$i}->{'EnableHTML'}) {
				$ezStats_UserProfile = unHTMLescape($ezStats_UserProfile);
			}
			$ezStats_UserProfile = HTMLescape($ezStats_UserProfile);
			print qq~
			<tr><td width="40%" align="right" valign="top" class="yellowbg">
			<div class="footnote">$i:</div>
			</td><td width="60%" valign="top" class="yellowbg">
			<div class="footnote">$ezStats_UserProfile</div>
			</td></tr>
			~;
			$ezStats_ProfileCount++;
		}
		unless ($ezStats_ProfileCount) {
			print q~
			<tr><td width="100%" align="center" valign="top" colspan="2" class="yellowbg">
			<div class="footnote">(n/a)</div>
			</td></tr>
			~;
		}
		print qq~
		</table><br><br>
		<table width="80%" cellpadding="2" cellspading="0" align="center">
		<tr><td width="100%" align="center" colspan="3" class="lightgbg">
		<b>All posts by user: $ezStats_UserStats</b>
		</td></tr>
		<tr><td width="30%" align="center" valign="top" class="yellowbg">
		<div class="footnote"><b>Date</b></div>
		</td><td width="45%" align="center" valign="top" class="yellowbg">
		<div class="footnote"><b>Subject</b></div>
		</td><td width="25%" align="center" valign="top" class="yellowbg">
		<div class="footnote"><b>View Post</b></div>
		</td></tr>
		~;
		if ($ezStats_PostCount == 0) {
			print q~
			<tr><td width="100%" align="center" valign="top" colspan="3" class="yellowbg">
			<div class="footnote">(n/a)</div>
			</td></tr>
			~;
		} else {
			foreach $i (@ezStats_NewsdatContents) {
				&SplitDataFile($i);
				next unless ($User eq $ezStats_UserStats);
				if ($CConfig{'TimeOffset'}) {
					$ezStats_PostDate = lc(GetTheDate_Internal($newstime + (3600 * $CConfig{'TimeOffset'})));
				} else {
					$ezStats_PostDate = lc(GetTheDate_Internal($newstime));
				}
				if (length($Subject) == 0) {
					$Subject = SnipText($Text,40);
					$Subject = '(n/a)' unless ($Subject);
				} else {
					$Subject = SnipText($Subject,40);
					$Subject .= '...' if (length($Subject) >= 40);
				}
				print qq~
				<tr><td width="30%" align="center" valign="top" class="yellowbg">
				<div class="footnote">$ezStats_PostDate</div>
				</td><td width="45%" align="center" valign="top" class="yellowbg">
				<div class="footnote">$Subject</div>
				</td><td width="25%" align="center" valign="top" class="yellowbg">
				<div class="footnote">
				~;
				if ($ezStats_View) {
					print qq~
					<a href="$ezStats_ViewURL?id=$newsid" target="_blank">view post</a>
					~;
				} else {
					print q~
					view post
					~;
				}
				print q~
				</div>
				</td></tr>
				~;
			}
		}
		print q~
		</table>
		~;
	} else {
		ezStats_Error('The user does not exist.');
	}
	ezStats_Footer(3.1);
}

sub ezStats_CategoryStats {
	if ($EnableCategories) {
		NeedCFG();
		foreach $i (sort keys %newscategories) {
			$ezStats_TotalCategoryCount++;
		}
		if ($ezStats_TotalCategoryCount > 0) {
			ezStats_ReadNewsdat();
			foreach $i (@ezStats_NewsdatContents) {
				&SplitDataFile($i);
				$Category =~ s/\n//;
				$ezStats_CategoryPostCount{$Category}++;
			}
		}
		ezStats_Header('Category Stats');
		print qq~
		curently viewing all categories ($ezStats_TotalCategoryCount)<br><br>
		<table width="100%" cellpadding="2" cellspading="0">
		<tr><td width="5%" align="center" valign="top" class="lightgbg">
		<b>#</b>
		</td><td width="60%" align="center" valign="top" class="lightgbg">
		<b>Category</b>
		</td><td width="12%" align="center" valign="top" class="lightgbg">
		<b>Posts</b>
		</td><td width="18%" align="center" valign="top" class="lightgbg">
		<b>View Stats</b>
		</td></tr>
		~;
		if ($ezStats_TotalCategoryCount > 0) {
			foreach $i (sort keys %newscategories) {
				$ezStats_CategoryCount++;
				$ezStats_CategoryPostCount = 0;
				$ezStats_CategoryPostCount += $ezStats_CategoryPostCount{$i};
				print qq~
				<tr><td width="5%" align="center" valign="top" class="yellowbg">
				<div class="footnote">$ezStats_CategoryCount</div>
				</td><td width="60%" align="center" valign="top" class="yellowbg">
				<div class="footnote">$i</div>
				</td><td width="12%" align="center" valign="top" class="yellowbg">
				<div class="footnote">$ezStats_CategoryPostCount</div>
				</td><td width="18%" align="center" valign="top" class="yellowbg">
				<div class="footnote">
				~ . $addon->link({'action'=>'admin','adminarea'=>'ezStats_Category','ezAction'=>$i}) . q~
				view stats</a></div>
				</td></tr>
				~;
			}
		} else {
			print q~
			<tr><td width="100%" align="center" valign="top" colspan="4" class="yellowbg">
			<div class="footnote">(n/a)</div>
			</td></tr>
			~;
		}
		print q~
		</table>
		~;
	} else {
		ezStats_Error('Categories are not enabled.');
	}
	ezStats_Footer(2);
}

sub ezStats_Category {
	$ezStats_CategoryStats = $in{'ezAction'};
	if ($EnableCategories) {
		if ($newscategories{$ezStats_CategoryStats}) {
			NeedCFG();
			$ezStats_TotalPostCount = 0;
			if ((-e "$CConfig{'admin_path'}/viewnews.cgi") or (-e 'viewnews.cgi')) {
				$ezStats_View = 1;
				$ezStats_ViewURL = 'viewnews.cgi';
			} elsif ((-e "$CConfig{'admin_path'}/viewnews.pl") or (-e 'viewnews.pl')) {
				$ezStats_View = 1;
				$ezStats_ViewURL = 'viewnews.pl';
			}
			ezStats_ReadNewsdat();
			foreach $i (@ezStats_NewsdatContents) {
				&SplitDataFile($i);
				$Category =~ s/\n//;
				$ezStats_TotalPostCount++;
				next unless ($Category eq $ezStats_CategoryStats);
				unless ($ezStats_FirstPostOn) {
					$ezStats_FirstPostOn = $newstime;
					$ezStats_FirstPostBy = $User;
					if ($ezStats_View) {
						$ezStats_ViewFirstPost = qq~
						(<a href="$ezStats_ViewURL?id=$newsid" target="_blank">view post</a>)
						~;
					} else {
						$ezStats_ViewFirstPost = q~
						(view post)
						~;
					}
					if ($userdata{$ezStats_FirstPostBy}) {
						foreach $j (sort keys %userdata) {
							next unless ($j eq $ezStats_FirstPostBy);
							$ezStats_ViewFirstUserStats = '(' . $addon->link({'action'=>'admin','adminarea'=>'ezStats_User','ezAction'=>$j}) . 'view user stats</a>)';
						}
					} else {
						$ezStats_ViewFirstUserStats = q~
						(view user stats)
						~;
					}
				}
				$ezStats_UserPostCount{$User}++;
				$ezStats_PostCount++;
				if ($newstime > $ezStats_LatestPostOn) {
					$ezStats_LatestPostOn = $newstime;
					$ezStats_LatestPostBy = $User;
					if ($ezStats_View) {
						$ezStats_ViewLatestPost = qq~
						(<a href="$ezStats_ViewURL?id=$newsid" target="_blank">view post</a>)
						~;
					} else {
						$ezStats_ViewLatestPost = q~
						(view post)
						~;
					}
					if ($userdata{$ezStats_LatestPostBy}) {
						foreach $j (sort keys %userdata) {
							next unless ($j eq $ezStats_LatestPostBy);
							$ezStats_ViewLatestUserStats = '(' . $addon->link({'action'=>'admin','adminarea'=>'ezStats_User','ezAction'=>$j}) . 'view user stats</a>)';
						}
					} else {
						$ezStats_ViewLatestUserStats = q~
						(view user stats)
						~;
					}
				}
				if ($ezStats_FirstPostOn > $newstime) {
					$ezStats_FirstPostOn = $newstime;
					$ezStats_FirstPostBy = $User;
					if ($ezStats_View) {
						$ezStats_ViewFirstPost = qq~
						(<a href="$ezStats_ViewURL?id=$newsid" target="_blank">view post</a>)
						~;
					} else {
						$ezStats_ViewFirstPost = q~
						(view post)
						~;
					}
					if ($userdata{$ezStats_FirstPostBy}) {
						foreach $j (sort keys %userdata) {
							next unless ($j eq $ezStats_FirstPostBy);
							$ezStats_ViewFirstUserStats = '(' . $addon->link({'action'=>'admin','adminarea'=>'ezStats_User','ezAction'=>$j}) . 'view user stats</a>)';
						}
					} else {
						$ezStats_ViewFirstUserStats = q~
						(view user stats)
						~;
					}
				}
			}
			if ($ezStats_LatestPostOn) {
				if ($CConfig{'TimeOffset'}) {
					$ezStats_LatestPostOn = lc(GetTheDate_Internal($ezStats_LatestPostOn + (3600 * $CConfig{'TimeOffset'})));
				} else {
					$ezStats_LatestPostOn = lc(GetTheDate_Internal($ezStats_LatestPostOn));
				}
			} else {
				$ezStats_LatestPostOn = '(n/a)';
			}
			if ($ezStats_FirstPostOn) {
				if ($CConfig{'TimeOffset'}) {
					$ezStats_FirstPostOn = lc(GetTheDate_Internal($ezStats_FirstPostOn + (3600 * $CConfig{'TimeOffset'})));
				} else {
					$ezStats_FirstPostOn = lc(GetTheDate_Internal($ezStats_FirstPostOn));
				}
			} else {
				$ezStats_FirstPostOn = '(n/a)';
			}
			$ezStats_FirstPostBy = '(n/a)' unless ($ezStats_FirstPostBy);
			$ezStats_LatestPostBy = '(n/a)' unless ($ezStats_LatestPostBy);
			$ezStats_PostCount = 0 unless ($ezStats_PostCount);
			if ($ezStats_TotalPostCount) {
				$ezStats_PostPercent = sprintf("%.1f",$ezStats_PostCount / $ezStats_TotalPostCount * 100);
			} else {
				$ezStats_PostPercent = '0.0';
			}
			$ezStats_CategoryData = $newscategories{$ezStats_CategoryStats};
			if ($ezStats_CategoryData->{'(AllUsers)'}) {
				foreach $i (sort keys %userdata) {
					$ezStats_AllowedPermission{$i} = 1;
				}
			} elsif ($ezStats_CategoryData->{'(High)'}) {
				foreach $i (sort keys %userdata) {
					if (($userdata{$i}->{'UserLevel'} > 1) or ($ezStats_CategoryData->{$i})) {
						$ezStats_AllowedPermission{$i} = 1;
					}
				}
			} else {
				foreach $i (sort keys %userdata) {
					if ($ezStats_CategoryData->{$i}) {
						$ezStats_AllowedPermission{$i} = 1;
					}
				}
			}
			foreach $i (sort keys %newsprofiles) {
				foreach $j (@{$newsprofiles{$i}->{'cats'}}) {
					if (($j eq $ezStats_CategoryStats) or ($j eq 'AllCategories')) {
						$ezStats_Profile{$i} = 1;
					}
				}
			}
			ezStats_Header("Category: $ezStats_CategoryStats",3.1);
			print qq~
			<table width="80%" cellpadding="2" cellspading="0" align="center">
			<tr><td width="100%" align="center" colspan="2" class="lightgbg">
			<b>Stats for category: $ezStats_CategoryStats</b>
			</td></tr>
			<tr><td width="40%" align="right" valign="top" class="yellowbg">
			<div class="footnote">Latest Post On:</div>
			</td><td width="60%" valign="top" class="yellowbg">
			<div class="footnote">$ezStats_LatestPostOn $ezStats_ViewLatestPost</div>
			</td></tr>
			<tr><td width="40%" align="right" valign="top" class="yellowbg">
			<div class="footnote">Latest Post By:</div>
			</td><td width="60%" valign="top" class="yellowbg">
			<div class="footnote">$ezStats_LatestPostBy $ezStats_ViewLatestUserStats</div>
			</td></tr>
			<tr><td width="40%" align="right" valign="top" class="yellowbg">
			<div class="footnote">First Post On:</div>
			</td><td width="60%" valign="top" class="yellowbg">
			<div class="footnote">$ezStats_FirstPostOn $ezStats_ViewFirstPost</div>
			</td></tr>
			<tr><td width="40%" align="right" valign="top" class="yellowbg">
			<div class="footnote">First Post by:</div>
			</td><td width="60%" valign="top" class="yellowbg">
			<div class="footnote">$ezStats_FirstPostBy $ezStats_ViewFirstUserStats</div>
			</td></tr>
			<tr><td width="40%" align="right" valign="top" class="yellowbg">
			<div class="footnote">Post Count:</div>
			</td><td width="60%" valign="top" class="yellowbg">
			<div class="footnote">$ezStats_PostCount (total: $ezStats_TotalPostCount)</div>
			</td></tr>
			<tr><td width="40%" align="right" valign="top" class="yellowbg">
			<div class="footnote">Total Posts:</div>
			</td><td width="60%" valign="top" class="yellowbg">
			<div class="footnote">$ezStats_PostPercent%</div>
			</td></tr>
			</table><br><br>
			<table width="80%" cellpadding="2" cellspading="0" align="center">
			<tr><td width="100%" align="center" colspan="2" class="lightgbg">
			<b>Permissions for category: $ezStats_CategoryStats</b>
			</td></tr>
			~;
			foreach $i (sort keys %userdata) {
				print qq~
				<tr><td width="40%" align="right" valign="top" class="yellowbg">
				<div class="footnote">$i:</div>
				</td><td width="60%" valign="top" class="yellowbg">
				~;
				if ($ezStats_AllowedPermission{$i}) {
					print q~
					<div class="footnote">allowed</div>
					~;
				} else {
					print q~
					<div class="footnote">not allowed</div>
					~;
				}
				print q~
				</td></tr>
				~;
			}
			print qq~
			</table><br><br>
			<table width="80%" cellpadding="2" cellspading="0" align="center">
			<tr><td width="100%" align="center" colspan="2" class="lightgbg">
			<b>Profiles using category: $ezStats_CategoryStats</b>
			</td></tr>
			~;
			foreach $i (sort keys %newsprofiles) {
				print qq~
				<tr><td width="40%" align="right" valign="top" class="yellowbg">
				<div class="footnote">$i:</div>
				</td><td width="60%" valign="top" class="yellowbg">
				~;
				if ($ezStats_Profile{$i}) {
					print q~
					<div class="footnote">using this category</div>
					~;
				} else {
					print q~
					<div class="footnote">not using this category</div>
					~;
				}
				print q~
				</td></tr>
				~;
			}
			print qq~
			</table><br><br>
			<table width="80%" cellpadding="2" cellspading="0" align="center">
			<tr><td width="100%" align="center" colspan="3" class="lightgbg">
			<b>All posts in category: $ezStats_CategoryStats</b>
			</td></tr>
			<tr><td width="30%" align="center" valign="top" class="yellowbg">
			<div class="footnote"><b>Date</b></div>
			</td><td width="45%" align="center" valign="top" class="yellowbg">
			<div class="footnote"><b>Subject</b></div>
			</td><td width="25%" align="center" valign="top" class="yellowbg">
			<div class="footnote"><b>View Post</b></div>
			</td></tr>
			~;
			if ($ezStats_PostCount == 0) {
				print q~
				<tr><td width="100%" align="center" valign="top" colspan="3" class="yellowbg">
				<div class="footnote">(n/a)</div>
				</td></tr>
				~;
			} else {
				foreach $i (@ezStats_NewsdatContents) {
					&SplitDataFile($i);
					$Category =~ s/\n//;
					next unless ($Category eq $ezStats_CategoryStats);
					if ($CConfig{'TimeOffset'}) {
						$ezStats_PostDate = lc(GetTheDate_Internal($newstime + (3600 * $CConfig{'TimeOffset'})));
					} else {
						$ezStats_PostDate = lc(GetTheDate_Internal($newstime));
					}
					if (length($Subject) == 0) {
						$Subject = SnipText($Text,40);
						$Subject = '(n/a)' unless ($Subject);
					} else {
						$Subject = SnipText($Subject,40);
						$Subject .= '...' if (length($Subject) >= 40);
					}
					print qq~
					<tr><td width="30%" align="center" valign="top" class="yellowbg">
					<div class="footnote">$ezStats_PostDate</div>
					</td><td width="45%" align="center" valign="top" class="yellowbg">
					<div class="footnote">$Subject</div>
					</td><td width="25%" align="center" valign="top" class="yellowbg">
					<div class="footnote">
					~;
					if ($ezStats_View) {
						print qq~
						<a href="$ezStats_ViewURL?id=$newsid" target="_blank">view post</a>
						~;
					} else {
						print q~
						view post
						~;
					}
					print q~
					</div>
					</td></tr>
					~;
				}
			}
			print qq~
			</table><br><br>
			<table width="80%" cellpadding="2" cellspading="0" align="center">
			<tr><td width="100%" align="center" colspan="2" class="lightgbg">
			<b>User posts in category: $ezStats_CategoryStats</b>
			</td></tr>
			~;
			foreach $i (sort keys %userdata) {
				$ezStats_UserPostCount{$i} = 0 unless ($ezStats_UserPostCount{$i});
				$ezStats_TruePosts += $ezStats_UserPostCount{$i};
				if ($ezStats_PostCount == 0) {
					$ezStats_UserPostPercent = 0;
				} else {
					$ezStats_UserPostPercent = sprintf("%.0f",$ezStats_UserPostCount{$i} / $ezStats_PostCount * 100);
				}
				print qq~
				<tr><td width="40%" align="right" valign="top" class="yellowbg">
				<div class="footnote">$i ($ezStats_UserPostCount{$i})</div>
				</td><td width="60%" valign="top" class="yellowbg">
				<table width="$ezStats_UserPostPercent%" cellpadding="1" cellspacing="0">
				<tr><td class="darkgbg">
				<table width="100%" cellpadding="0" cellspacing="0">
				<tr><td class="lightgbg">
				<div class="footnote" style="height:100%">
				</td></tr>
				</table>
				</td></tr>
				</table>
				</td></tr>
				~;
			}
			unless ($ezStats_TruePosts == $ezStats_PostCount) {
				$ezStats_TruePostCount = $ezStats_PostCount - $ezStats_TruePosts;
				$ezStats_TruePostPercent = sprintf("%.0f",$ezStats_TruePostCount / $ezStats_PostCount * 100);
				print qq~
				<tr><td width="40%" align="right" valign="top" class="yellowbg">
				<div class="footnote">(deleted users) ($ezStats_TruePostCount)</div>
				</td><td width="60%" valign="top" class="yellowbg">
				<table width="$ezStats_TruePostPercent%" cellpadding="1" cellspacing="0">
				<tr><td class="darkgbg">
				<table width="100%" cellpadding="0" cellspacing="0">
				<tr><td class="lightgbg">
				<div class="footnote" style="height:100%">
				</td></tr>
				</table>
				</td></tr>
				</table>
				</td></tr>
				~;
			}
			print q~
			</table>
			~;
		} else {
			ezStats_Error('The category does not exist.');
		}
	} else {
		ezStats_Error('Categories are not enabled.');
	}
	ezStats_Footer(3.2);
}

sub ezStats_OverallStats {
	ReadUserDBInfo();
	NeedCFG();
	if ((-e "$CConfig{'admin_path'}/viewnews.cgi") or (-e 'viewnews.cgi')) {
		$ezStats_View = 1;
		$ezStats_ViewURL = 'viewnews.cgi';
	} elsif ((-e "$CConfig{'admin_path'}/viewnews.pl") or (-e 'viewnews.pl')) {
		$ezStats_View = 1;
		$ezStats_ViewURL = 'viewnews.pl';
	}
	$ezStats_TotalPosts = 0;
	$ezStats_TotalCategories = 0;
	$ezStats_TotalProfiles = 0;
	$ezStats_TotalFields = 0;
	$ezStats_TotalUserFields = 0;
	$ezStats_TruePosts = 0;
	ezStats_ReadNewsdat();
	foreach $i (@ezStats_NewsdatContents) {
		&SplitDataFile($i);
		unless ($ezStats_FirstPostOn) {
			$ezStats_FirstPostOn = $newstime;
			$ezStats_FirstPostBy = $User;
			if ($ezStats_View) {
				$ezStats_ViewFirstPost = qq~
				(<a href="$ezStats_ViewURL?id=$newsid" target="_blank">view post</a>)
				~;
			} else {
				$ezStats_ViewFirstPost = q~
				(view post)
				~;
			}
			if ($userdata{$ezStats_FirstPostBy}) {
				foreach $j (sort keys %userdata) {
					next unless ($j eq $ezStats_FirstPostBy);
					$ezStats_ViewFirstUserStats = '(' . $addon->link({'action'=>'admin','adminarea'=>'ezStats_User','ezAction'=>$j}) . 'view user stats</a>)';
				}
			} else {
				$ezStats_ViewFirstUserStats = q~
				(view user stats)
				~;
			}
		}
		$ezStats_UserPostCount{$User}++;
		$ezStats_TotalPosts++;
		if ($ezStats_LatestPostOn < $newstime) {
			$ezStats_LatestPostOn = $newstime;
			$ezStats_LatestPostBy = $User;
			if ($ezStats_View) {
				$ezStats_ViewLatestPost = qq~
				(<a href="$ezStats_ViewURL?id=$newsid" target="_blank">view post</a>)
				~;
			} else {
				$ezStats_ViewLatestPost = q~
				(view post)
				~;
			}
			if ($userdata{$ezStats_LatestPostBy}) {
				foreach $j (sort keys %userdata) {
					next unless ($j eq $ezStats_LatestPostBy);
					$ezStats_ViewLatestUserStats = '(' . $addon->link({'action'=>'admin','adminarea'=>'ezStats_User','ezAction'=>$j}) . 'view user stats</a>)';
				}
			} else {
				$ezStats_ViewLatestUserStats = q~
				(view user stats)
				~;
			}
		}
		if ($ezStats_FirstPostOn > $newstime) {
			$ezStats_FirstPostOn = $newstime;
			$ezStats_FirstPostBy = $User;
			if ($ezStats_View) {
				$ezStats_ViewFirstPost = qq~
				(<a href="$ezStats_ViewURL?id=$newsid" target="_blank">view post</a>)
				~;
			} else {
				$ezStats_ViewFirstPost = q~
				(view post)
				~;
			}
			if ($userdata{$ezStats_FirstPostBy}) {
				foreach $j (sort keys %userdata) {
					next unless ($j eq $ezStats_FirstPostBy);
					$ezStats_ViewFirstUserStats = '(' . $addon->link({'action'=>'admin','adminarea'=>'ezStats_User','ezAction'=>$j}) . 'view user stats</a>)';
				}
			} else {
				$ezStats_ViewFirstUserStats = q~
				(view user stats)
				~;
			}
		}
	}
	$ezStats_TotalUsers++ foreach (keys %userdata);
	$ezStats_TotalCategories++ foreach (keys %newscategories);
	$ezStats_TotalProfiles++ foreach (keys %newsprofiles);
	$ezStats_TotalFields++ foreach (keys %fieldDB);
	$ezStats_TotalUserFields++ foreach (keys %userDB);
	if ($ezStats_FirstPostOn) {
		if ($CConfig{'TimeOffset'}) {
			$ezStats_FirstPostOn = lc(GetTheDate_Internal($ezStats_FirstPostOn + (3600 * $CConfig{'TimeOffset'})));
		} else {
			$ezStats_FirstPostOn = lc(GetTheDate_Internal($ezStats_FirstPostOn));
		}
	} else {
		$ezStats_FirstPostOn = '(n/a)';
	}
	$ezStats_FirstPostBy = '(n/a)' unless ($ezStats_FirstPostBy);
	if ($ezStats_LatestPostOn) {
		if ($CConfig{'TimeOffset'}) {
			$ezStats_LatestPostOn = lc(GetTheDate_Internal($ezStats_LatestPostOn + (3600 * $CConfig{'TimeOffset'})));
		} else {
			$ezStats_LatestPostOn = lc(GetTheDate_Internal($ezStats_LatestPostOn));
		}
	} else {
		$ezStats_LatestPostOn = '(n/a)';
	}
	$ezStats_LatestPostBy = '(n/a)' unless ($ezStats_LatestPostBy);
	$CorantoVersion =~ s/_/ /;
	$ezStats_ScriptLocation = GetDirInfo();
	$ezStats_ScriptLocation =~ s/\\/\//g;
	ezStats_Header('Overall Stats');
	print qq~
	<table width="80%" cellpadding="2" cellspading="0" align="center">
	<tr><td width="100%" align="center" colspan="2" class="lightgbg">
	<b>Overall Stats</b>
	</td></tr>
	<tr><td width="40%" align="right" valign="top" class="yellowbg">
	<div class="footnote">Total Posts:</div>
	</td><td width="60%" valign="top" class="yellowbg">
	<div class="footnote">$ezStats_TotalPosts</div>
	</td></tr>
	<tr><td width="40%" align="right" valign="top" class="yellowbg">
	<div class="footnote">Total Users:</div>
	</td><td width="60%" valign="top" class="yellowbg">
	<div class="footnote">$ezStats_TotalUsers</div>
	</td></tr>
	<tr><td width="40%" align="right" valign="top" class="yellowbg">
	<div class="footnote">Total Categories:</div>
	</td><td width="60%" valign="top" class="yellowbg">
	<div class="footnote">$ezStats_TotalCategories</div>
	</td></tr>
	<tr><td width="40%" align="right" valign="top" class="yellowbg">
	<div class="footnote">Total Profiles:</div>
	</td><td width="60%" valign="top" class="yellowbg">
	<div class="footnote">$ezStats_TotalProfiles</div>
	</td></tr>
	<tr><td width="40%" align="right" valign="top" class="yellowbg">
	<div class="footnote">Total Fields:</div>
	</td><td width="60%" valign="top" class="yellowbg">
	<div class="footnote">$ezStats_TotalFields</div>
	</td></tr>
	<tr><td width="40%" align="right" valign="top" class="yellowbg">
	<div class="footnote">Total User Fields:</div>
	</td><td width="60%" valign="top" class="yellowbg">
	<div class="footnote">$ezStats_TotalUserFields</div>
	</td></tr>
	<tr><td width="40%" align="right" valign="top" class="yellowbg">
	<div class="footnote">Latest Post On:</div>
	</td><td width="60%" valign="top" class="yellowbg">
	<div class="footnote">$ezStats_LatestPostOn $ezStats_ViewLatestPost</div>
	</td></tr>
	<tr><td width="40%" align="right" valign="top" class="yellowbg">
	<div class="footnote">Latest Post By:</div>
	</td><td width="60%" valign="top" class="yellowbg">
	<div class="footnote">$ezStats_LatestPostBy $ezStats_ViewLatestUserStats</div>
	</td></tr>
	<tr><td width="40%" align="right" valign="top" class="yellowbg">
	<div class="footnote">First Post On:</div>
	</td><td width="60%" valign="top" class="yellowbg">
	<div class="footnote">$ezStats_FirstPostOn $ezStats_ViewFirstPost</div>
	</td></tr>
	<tr><td width="40%" align="right" valign="top" class="yellowbg">
	<div class="footnote">First Post By:</div>
	</td><td width="60%" valign="top" class="yellowbg">
	<div class="footnote">$ezStats_FirstPostBy $ezStats_ViewFirstUserStats</div>
	</td></tr>
	</table><br><br>
	<table width="80%" cellpadding="2" cellspading="0" align="center">
	<tr><td width="100%" align="center" colspan="2" class="lightgbg">
	<b>Overall User Posts</b>
	</td></tr>
	~;
	foreach $i (sort keys %userdata) {
		$ezStats_UserPostCount{$i} = 0 unless ($ezStats_UserPostCount{$i});
		$ezStats_TruePosts += $ezStats_UserPostCount{$i};
		if ($ezStats_TotalPosts == 0) {
			$ezStats_UserPostPercent = 0;
		} else {
			$ezStats_UserPostPercent = sprintf("%.0f",$ezStats_UserPostCount{$i} / $ezStats_TotalPosts * 100);
		}
		print qq~
		<tr><td width="40%" align="right" valign="top" class="yellowbg">
		<div class="footnote">$i ($ezStats_UserPostCount{$i})</div>
		</td><td width="60%" valign="top" class="yellowbg">
		<table width="$ezStats_UserPostPercent%" cellpadding="1" cellspacing="0">
		<tr><td class="darkgbg">
		<table width="100%" cellpadding="0" cellspacing="0">
		<tr><td class="lightgbg">
		<div class="footnote" style="height:100%">
		</td></tr>
		</table>
		</td></tr>
		</table>
		</td></tr>
		~;
	}
	unless ($ezStats_TruePosts == $ezStats_TotalPosts) {
		$ezStats_TruePostCount = $ezStats_TotalPosts - $ezStats_TruePosts;
		$ezStats_TruePostPercent = sprintf("%.0f",$ezStats_TruePostCount / $ezStats_TotalPosts * 100);
		print qq~
		<tr><td width="40%" align="right" valign="top" class="yellowbg">
		<div class="footnote">(deleted users) ($ezStats_TruePostCount)</div>
		</td><td width="60%" valign="top" class="yellowbg">
		<table width="$ezStats_TruePostPercent%" cellpadding="1" cellspacing="0">
		<tr><td class="darkgbg">
		<table width="100%" cellpadding="0" cellspacing="0">
		<tr><td class="lightgbg">
		<div class="footnote" style="height:100%">
		</td></tr>
		</table>
		</td></tr>
		</table>
		</td></tr>
		~;
	}
	print q~
	</table>
	~;
	ezStats_Footer(2);
}

sub ezStats_Info {
	ezStats_Header('Info',4.1);
	print qq~
	<table width="80%" cellpadding="2" cellspading="0" align="center">
	<tr><td width="100%" align="center" colspan="2" class="lightgbg">
	<b>General Info</b>
	</td></tr>
	<tr><td width="40%" align="right" valign="top" class="yellowbg">
	<div class="footnote">Addon Name:</div>
	</td><td width="60%" valign="top" class="yellowbg">
	<div class="footnote">ezStats</div>
	</td></tr>
	<tr><td width="40%" align="right" valign="top" class="yellowbg">
	<div class="footnote">Addon Version:</div>
	</td><td width="60%" valign="top" class="yellowbg">
	<div class="footnote">$ezStats_Version</div>
	</td></tr>
	<tr><td width="40%" align="right" valign="top" class="yellowbg">
	<div class="footnote">Addon Description:</div>
	</td><td width="60%" valign="top" class="yellowbg">
	<div class="footnote">View all sorts of info and stats by user or category.</div>
	</td></tr>
	<tr><td width="40%" align="right" valign="top" class="yellowbg">
	<div class="footnote">Addon Site:</div>
	</td><td width="60%" valign="top" class="yellowbg">
	<div class="footnote"><a href="http://www.eatsleepcode.ca/\~factory/coranto" target="_blank">http://www.eatsleepcode.ca/\~factory/coranto</a></div>
	</td></tr>
	<tr><td width="40%" align="right" valign="top" class="yellowbg">
	<div class="footnote">Release Date:</div>
	</td><td width="60%" valign="top" class="yellowbg">
	<div class="footnote">Wednesday, July 10, 2002</div>
	</td></tr>
	<tr><td width="40%" align="right" valign="top" class="yellowbg">
	<div class="footnote">Download Mirror:</div>
	</td><td width="60%" valign="top" class="yellowbg">
	<div class="footnote"><a href="http://coranto.sardonica.net" target="_blank">http://coranto.sardonica.net</a></div>
	</td></tr>
	<tr><td width="40%" align="right" valign="top" class="yellowbg">
	<div class="footnote">Developer Name:</div>
	</td><td width="60%" valign="top" class="yellowbg">
	<div class="footnote">AeroSoul</div>
	</td></tr>
	<tr><td width="40%" align="right" valign="top" class="yellowbg">
	<div class="footnote">Developer Email:</div>
	</td><td width="60%" valign="top" class="yellowbg">
	<div class="footnote"><a href="mailto:aero-soul\@rogers.com">aero-soul\@rogers.com</a></div>
	</td></tr>
	<tr><td width="40%" align="right" valign="top" class="yellowbg">
	<div class="footnote">Developer Site:</div>
	</td><td width="60%" valign="top" class="yellowbg">
	<div class="footnote"><a href="http://www.eatsleepcode.ca" target="_blank">http://www.eatsleepcode.ca</a></div>
	</td></tr>
	<tr><td width="40%" align="right" valign="top" class="yellowbg">
	<div class="footnote">Developer Comments:</div>
	</td><td width="60%" valign="top" class="yellowbg">
	<div class="footnote">cheers go out to: kriko, john and all the people on the coranto forums. please report all bugs/comments/suggestions to the <a href="http://www.amphibianweb.com/coranto/forum" target="_blank">official coranto forum</a> or the <a href="http://csql.sardonica.net/vbullet" target="_blank">temporary coranto forum</a>. external (SSI & JS), style, and SQL support coming soon. aight.</div>
	</td></tr>
	</table>
	~;
	ezStats_Footer(2);
}

sub ezStats_UserInfo {
	ezStats_Header('Info: User',4.1);
	$ezStats_QA{'Can I manually change the IP address that is displayed for my account?'} = 'No. Well yes, but it\'s not very easy. And even if you succeed, the IP address will be reset to the correct one, next time you use coranto.';
	$ezStats_QA{'Can I view stats on deleted users?'} = 'No, because when a user is deleted, all the information about the user gets deleted as well, but the actual posts themselves don\'t. It is often better to disable a user instead; the user is not able to use coranto, but the information stays accessible.';
	$ezStats_QA{'How do I edit my posts or profile?'} = 'At the bottom of the page, in the navigation menu, click on "Modify News" (' . $addon->link({'action'=>'modify'}) . 'shortcut</a>) if you want to modify your posts, or click on "User Info" (' . $addon->link({'action'=>'edituserinfo'}) . 'shortcut</a>) if you want to modify your profile.';
	$ezStats_QA{'Why do I get an error why I try to view a post?'} = 'Probably because viewnews is not setup correctly. Make sure the path to Perl in the file is correct and the permissions are right. Refer to the coranto <a href="http://www.amphibianweb.com/coranto/setup.html" target="_blank">setup page</a> for more information.';
	$ezStats_QA{'Why does it say "(n/a)" for the user\'s IP address?'} = 'The user\'s IP gets logged whenever he/she uses coranto from the point of installing ezStats; you cannot view a user\'s IP until he/she has logged in after installing ezStats.';
	$ezStats_QA{'Why does it say the user has no posts, even though the user has made some posts?'} = 'Did you delete those posts? That\'s why. The post count varies according to the posts in the file "newsdat.txt" (or your CorantoSQL database), and when a post is deleted from the file, the post count adjusts itself accordingly.';
	$ezStats_QA{'Why is the "view post" text not a link?'} = 'This suggests that "viewnews.cgi" is not in the same directory as the core coranto files. You should move it back or re-download the <a href="http://csql.sardonica.net/viewnews_fixed.zip" target="_blank">fixed</a> version (recommended) or the <a href="http://www.amphibianweb.com/coranto/download/corantobeta.zip" target="_blank">original</a> version.';
	print q~
	<div align="left"><ul>
	~;
	foreach $i (sort keys %ezStats_QA) {
		$ezStats_QuestionNum++;
		print qq~
		<b>$ezStats_QuestionNum</b>. <a href="#ezStats_Anchor$ezStats_QuestionNum">$i</a><br>
		~;
	}
	print q~
	</ul></div><br>
	~;
	$ezStats_QuestionNum = 0;
	foreach $i (sort keys %ezStats_QA) {
		$ezStats_QuestionNum++;
		print qq~
		<p align="justify">
		<a name="ezStats_Anchor$ezStats_QuestionNum"><b>$ezStats_QuestionNum. $i</b></a> (<a href="#">top</a>)<br>
		$ezStats_QA{$i}
		</p>
		~;
	}
	ezStats_Footer(3.3);
}

sub ezStats_CategoryInfo {
	$ezStats_EditCategoryLink = ' (' . $addon->link({'action'=>'admin','adminarea'=>'newscatmain'}) . 'shortcut</a>)' if ($CConfig{'AddonsLoaded'} =~ /cra_ncategory.pl/);
	ezStats_Header('Info: Category',4.1);
	$ezStats_QA{'Why does it say that the news categories addon is not installed?'} = 'Because it\'s not installed, and you must have the news categories addon installed to view stats on news categories. You can download the addon <a href="http://www.amphibianweb.com/coranto/download/cra_ncategory.zip" target="_blank">here</a>.';
	$ezStats_QA{'Why has the number of posts in the "default" category increased, without new posts?'} = 'This is because you deleted another category and the posts from it automatically went to the "default" category, instead of being deleted along with the category.';
	$ezStats_QA{'Why is the "view post" text not a link?'} = 'This suggests that "viewnews.cgi" is not in the same directory as the core coranto files. You should move it back or re-download the <a href="http://csql.sardonica.net/viewnews_fixed.zip" target="_blank">fixed</a> version (recommended) or the <a href="http://www.amphibianweb.com/coranto/download/corantobeta.zip" target="_blank">original</a> version.';
	$ezStats_QA{'Why is the "view user stats" text not a link?'} = 'The user has been delete, and you cannot view stats on a user that has been deleted.';
	$ezStats_QA{'Why do I get an error why I try to view a post?'} = 'Probably because viewnews is not setup correctly. Make sure the path to Perl in the file is correct and the permissions are right. Refer to the coranto <a href="http://www.amphibianweb.com/coranto/setup.html" target="_blank">setup page</a> for more information.';
	$ezStats_QA{'How do I edit category permissions?'} = qq~Click on "Administration" in the navigation bar below, then click on the "News Categories" link, find the category you wish to edit permissions for, and click "Edit Permissions"$ezStats_EditCategoryLink.~;
	$ezStats_QA{'How do I choose which profiles use the category?'} = 'Click on "Administration" in the navigation bar below, then click on the "Manage Profiles" link, find the profile you wish to use with the category and click "Edit General Settings" (' . $addon->link({'action'=>'admin','adminarea'=>'profilelist'}) . 'shortcut</a>).';
	print q~
	<div align="left"><ul>
	~;
	foreach $i (sort keys %ezStats_QA) {
		$ezStats_QuestionNum++;
		print qq~
		<b>$ezStats_QuestionNum</b>. <a href="#ezStats_Anchor$ezStats_QuestionNum">$i</a><br>
		~;
	}
	print q~
	</ul></div><br>
	~;
	$ezStats_QuestionNum = 0;
	foreach $i (sort keys %ezStats_QA) {
		$ezStats_QuestionNum++;
		print qq~
		<p align="justify">
		<a name="ezStats_Anchor$ezStats_QuestionNum"><b>$ezStats_QuestionNum. $i</b></a> (<a href="#">top</a>)<br>
		$ezStats_QA{$i}
		</p>
		~;
	}
	ezStats_Footer(3.3);
}

sub ezStats_OverallInfo {
	$ezStats_QA{'Why is the "view post" text not a link?'} = 'This suggests that "viewnews.cgi" is not in the same directory as the core coranto files. You should move it back or re-download the <a href="http://csql.sardonica.net/viewnews_fixed.zip" target="_blank">fixed</a> version (recommended) or the <a href="http://www.amphibianweb.com/coranto/download/corantobeta.zip" target="_blank">original</a> version.';
	$ezStats_QA{'Why is the "view user stats" text not a link?'} = 'The user has been delete, and you cannot view stats on a user that has been deleted.';
	$ezStats_QA{'Why do I get an error why I try to view a post?'} = 'Probably because viewnews is not setup correctly. Make sure the path to Perl in the file is correct and the permissions are right. Refer to the coranto <a href="http://www.amphibianweb.com/coranto/setup.html" target="_blank">setup page</a> for more information.';
	ezStats_Header('Info: Category',4.1);
	print q~
	<div align="left"><ul>
	~;
	foreach $i (sort keys %ezStats_QA) {
		$ezStats_QuestionNum++;
		print qq~
		<b>$ezStats_QuestionNum</b>. <a href="#ezStats_Anchor$ezStats_QuestionNum">$i</a><br>
		~;
	}
	print q~
	</ul></div><br>
	~;
	$ezStats_QuestionNum = 0;
	foreach $i (sort keys %ezStats_QA) {
		$ezStats_QuestionNum++;
		print qq~
		<p align="justify">
		<a name="ezStats_Anchor$ezStats_QuestionNum"><b>$ezStats_QuestionNum. $i</b></a> (<a href="#">top</a>)<br>
		$ezStats_QA{$i}
		</p>
		~;
	}
	ezStats_Footer(3.3);
}

sub ezStats_IPTrack {
	@ezStats_UserIPs = split(/\|x\|/,$CConfig{'ezStats_UserIPs'});
	foreach $i (@ezStats_UserIPs) {
		($ezStats_IPName,$ezStats_IPValue) = split(/~/,$i);
		$ezStats_IP{$ezStats_IPName} = $ezStats_IPValue;
	}
	if ($ezStats_IP{$CurrentUser} ne $ENV{'REMOTE_ADDR'}) {
		$ezStats_IP{$CurrentUser} = $ENV{'REMOTE_ADDR'};
		foreach $i (sort keys %userdata) {
			$ezStats_IP{$i} = '0.0.0.0' unless $ezStats_IP{$i};
			push(@ezStats_IPList,"$i~$ezStats_IP{$i}");
		}
		$CConfig{'ezStats_UserIPs'} = join('|x|',@ezStats_IPList);
	}
}

sub ezStats_Header {
	($ezStats_HeaderTitle,$ezStats_HeaderType) = @_;
	$addon->pageHeader("ezStats - $ezStats_HeaderTitle");
	print q~
	<table width="80%" cellpadding="2" cellspacing="0" align="center">
	<tr><td width="100%" align="center" class="footnote">
	~;
	if ($ezStats_HeaderType == 1) {
		print $addon->heading("Welcome to ezStats, $CurrentUser.");
	} elsif ($ezStats_HeaderType == 2.1) {
		$ezStats_Level3UserCount = 0;
		$ezStats_Level2UserCount = 0;
		$ezStats_Level1UserCount = 0;
		$ezStats_AllLevelUserCount = 0;
		foreach $i (sort keys %userdata) {
			if ($userdata{$i}->{'UserLevel'} == 3) {
				$ezStats_Level3UserCount++;
			} elsif ($userdata{$i}->{'UserLevel'} == 2) {
				$ezStats_Level2UserCount++;
			} elsif ($userdata{$i}->{'UserLevel'} == 1) {
				$ezStats_Level1UserCount++;
			}
			$ezStats_AllLevelUserCount++;
		}
		print qq~$ezStats_AllLevelUserCount
		view stats for:<br>
		[
		~ . $addon->link({'action'=>'admin','adminarea'=>'ezStats_UserStats','ezAction'=>'all'}) . qq~
		<b>all</b> ($ezStats_AllLevelUserCount users)</a>
		] - [
		~ . $addon->link({'action'=>'admin','adminarea'=>'ezStats_UserStats','ezAction'=>'admin'}) . qq~
		<b>admin</b> ($ezStats_Level3UserCount users)</a>
		] - [
		~ . $addon->link({'action'=>'admin','adminarea'=>'ezStats_UserStats','ezAction'=>'high'}) . qq~
		<b>high</b> ($ezStats_Level2UserCount users)</a>
		] - [
		~ . $addon->link({'action'=>'admin','adminarea'=>'ezStats_UserStats','ezAction'=>'standard'}) . qq~
		<b>standard</b> ($ezStats_Level1UserCount users)</a>
		]
		~;
	} elsif ($ezStats_HeaderType == 2.2) {
		if ($ENV{'HTTP_USER_AGENT'} =~ /MSIE/) {
			$ezStats_QuickStatsSpecialLink = $addon->link({'action'=>'admin','adminarea'=>'ezStats_User','ezAction'=>$ezStats_UserStats});
			$ezStats_QuickStatsSpecialLink =~ s/<a href="//;
			$ezStats_QuickStatsSpecialLink =~ s/(">|" >)//;
			print qq~
			<form name="quickstats">
			<select name="quickstats" size="1" onchange="window.location=document.quickstats.quickstats.value">
			<option value="$ezStats_QuickStatsSpecialLink">QuickStats...</option>
			~;
			foreach $i (sort keys %userdata) {
				$ezStats_QuickStatsCount++;
				next if ($i eq $ezStats_UserStats);
				$ezStats_QuickStatsLink = $addon->link({'action'=>'admin','adminarea'=>'ezStats_User','ezAction'=>$i});
				$ezStats_QuickStatsLink =~ s/<a href="//;
				$ezStats_QuickStatsLink =~ s/(">|" >)//;
				print qq~
				<option value="$ezStats_QuickStatsLink">$i</option>
				~;
			}
			if ($ezStats_QuickStatsCount == 1) {
				print qq~
				<option value="$ezStats_QuickStatsSpecialLink">(none)</option>
				~;
			}
			print q~
			</select>
			<input type="button" value="Go!" onclick="getstats()">
			</form>
			~;
		} else {
			print q~
			To view the QuickStats navigation menu you need <a href="http://www.microsoft.com/windows/ie" target="_blank">MS Internet Explorer</a>
			~;
		}
	} elsif ($ezStats_HeaderType == 3.1) {
		if ($ENV{'HTTP_USER_AGENT'} =~ /MSIE/) {
			$ezStats_QuickStatsSpecialLink = $addon->link({'action'=>'admin','adminarea'=>'ezStats_Category','ezAction'=>$ezStats_CategoryStats});
			$ezStats_QuickStatsSpecialLink =~ s/<a href="//;
			$ezStats_QuickStatsSpecialLink =~ s/(">|" >)//;
			print qq~
			<form name="quickstats">
			<select name="quickstats" size="1" onchange="window.location=document.quickstats.quickstats.value">
			<option value="$ezStats_QuickStatsSpecialLink">QuickStats...</option>
			~;
			foreach $i (sort keys %newscategories) {
				$ezStats_QuickStatsCount++;
				next if ($i eq $ezStats_CategoryStats);
				$ezStats_QuickStatsLink = $addon->link({'action'=>'admin','adminarea'=>'ezStats_Category','ezAction'=>$i});
				$ezStats_QuickStatsLink =~ s/<a href="//;
				$ezStats_QuickStatsLink =~ s/(">|" >)//;
				print qq~
				<option value="$ezStats_QuickStatsLink">$i</option>
				~;
			}
			if ($ezStats_QuickStatsCount == 1) {
				print qq~
				<option value="$ezStats_QuickStatsSpecialLink">(none)</option>
				~;
			}
			print q~
			</select>
			<input type="button" value="Go!" onclick="getstats()">
			</form>
			~;
		} else {
			print q~
			To view the QuickStats navigation menu you need <a href="http://www.microsoft.com/windows/ie" target="_blank">MS Internet Explorer</a>
			~;
		}
	} elsif ($ezStats_HeaderType == 4.1) {
		print q~
		Please select which area you would like to get more information on:
		<br><br> [
		~ . $addon->link({'action'=>'admin','adminarea'=>'ezStats_UserInfo'}) . q~
		user info</a> ] - [
		~ . $addon->link({'action'=>'admin','adminarea'=>'ezStats_CategoryInfo'}) . q~
		category info</a> ] - [
		~ . $addon->link({'action'=>'admin','adminarea'=>'ezStats_OverallInfo'}) . qq~
		overall info</a> ]
		~;
	}
	print q~
	<hr noshade size="1" class="darkgbg">
	~;
}

sub ezStats_Footer {
	$ezStats_FooterType = shift;
	print q~
	<hr noshade size="1" class="darkgbg">
	~;
	if ($ezStats_FooterType == 1) {
		print qq~
		currently using version $ezStats_Version
		~;
	} elsif ($ezStats_FooterType == 2) {
		print q~
		back to
		~ . $addon->link({'action'=>'admin','adminarea'=>'ezStats'}) . q~
		main</a>
		~;
	} elsif ($ezStats_FooterType == 3.1) {
		print q~
		back to
		~ . $addon->link({'action'=>'admin','adminarea'=>'ezStats'}) . q~
		main</a> |
		~ . $addon->link({'action'=>'admin','adminarea'=>'ezStats_UserStats'}) . q~
		user stats</a>
		~;
	} elsif ($ezStats_FooterType == 3.2) {
		print q~
		back to
		~ . $addon->link({'action'=>'admin','adminarea'=>'ezStats'}) . q~
		main</a> |
		~ . $addon->link({'action'=>'admin','adminarea'=>'ezStats_CategoryStats'}) . q~
		category stats</a>
		~;
	} elsif ($ezStats_FooterType == 3.3) {
		print q~
		back to
		~ . $addon->link({'action'=>'admin','adminarea'=>'ezStats'}) . q~
		main</a> |
		~ . $addon->link({'action'=>'admin','adminarea'=>'ezStats_Info'}) . q~
		info</a>
		~;
	}
	print q~
	</td></tr>
	</table>
	~;
	$addon->pageFooter();
}

sub ezStats_ReadNewsdat {
	if ($CConfig{'AddonsLoaded'} =~ /cra_crsql.pl/) {
		$corantosql_dbh = CorantoSQL_connectdb();
		$query = "SELECT * FROM $CConfig{'CorantoSQL_tblname'}";
		$sth = $corantosql_dbh->prepare($query);
		$sth->execute();
		while ($corantosql_ref = $sth->fetchrow_hashref()) {
			@csqldata = ();
			GetSQLFields();
			foreach $i (@fieldDB_internalorder) {
				push(@csqldata,$$i);
			}
			push(@ezStats_NewsdatContents,join('``x',@csqldata));
		}
	} else {
		$ezStats_OpenFile = $addon->open("$CConfig{'htmlfile_path'}/newsdat.txt");
		@ezStats_NewsdatContents = <$ezStats_OpenFile>;
		close($ezStats_OpenFile);
	}
}

sub ezStats_Error {
	$esStats_Error = shift;
	ezStats_Header('Error');
	print qq~
	<b>Error</b>
	<br><br>
	$esStats_Error
	~;
}

1;

__END__

=pod

=head1 Please refer to the built in documentation!

=head1 I<(access it from the ezStats main menu on the Coranto Admin page)>

=cut