#! CRADDON 1
#! NAME QuickLinks
#! DESCRIPTION Allows you to quickly insert links into your news.
#! VERSION 1.01

my $addon = new Addon('QuickLinks');
$addon->registerAdminFunction('QuickLinks_Save','QuickLinks_Save');
$addon->registerAdminFunction('QuickLinks','QuickLinks');
$addon->addAdminFunction('Edit QuickLinks','Edit QuickLinks which are displayed on the submit and modify news pages.','QuickLinks');

$CConfig{'QuickLinks_Field'} = 'Text' unless ($CConfig{'QuickLinks_Field'});

sub QuickLinks_Load {
	@quicklinks = split(/\|x\|/,$CConfig{'QuickLinks'});
	foreach $i (@quicklinks) {
		($key,$value) = split(/!x!/,$i);
		$key =~ s/"/&quot;/g;
		$key =~ s/'/\\'/g;
		$value =~ s/"/&quot;/g;
		$value =~ s/'/\\'/g;
		$QuickLink{$key} = $value;
	}
}

sub QuickLinks {
	QuickLinks_Load();
	$addon->pageHeader('Edit QuickLinks');
	print qq~<table width="80%" border="0" align="center"><tr><td width="100%" colspan="2"><font size="-1"><div align="justify">When submitting or modifying news, you can click on a QuickLinks name and the corresponding QuickLinks value will be inserted into the field which should be configured on the Coranto's change settings page, in the administration section. To add a new entry, use the blank fields provided at the bottom. If you fill in all the available blank fields, click Submit Changes and then choose Edit QuickLinks again in the Coranto's administration section, and 5 new blank fields will appear. To delete an entry, delete everything in the QuickLinks name field for that entry.</div></font>~ . $addon->form({'action'=>'admin','adminarea'=>'QuickLinks_Save'}) . q~</td></tr><tr><td width="35%"><b>QuickLinks name</b></td><td width="65%"><b>QuickLinks value</b></td></tr>~;
	foreach $i (sort keys %QuickLink) {
		$quicklinkcount++;
		print qq~<tr><td width="35%"><input type="text" name="QuickLinks_text$quicklinkcount" value="$i" size="20"></td><td width="65%"><input type="text" name="QuickLinks_value$quicklinkcount" value="$QuickLink{$i}" size="45"></td></tr>~;
	}
	while ($extrafields < 5) {
		$quicklinkcount++;
		print qq~<tr><td width="35%"><input type="text" name="QuickLinks_text$quicklinkcount" size="20"></td><td width="65%"><input type="text" name="QuickLinks_value$quicklinkcount" size="45"></td></tr>~;
		$extrafields++;
	}
	print q~</table><br><div align="center"><input type="submit" name="submit" value="Submit Changes"></div></form>~;
	$addon->pageFooter;
}

sub QuickLinks_Save {
	foreach $i (keys %in) {
		$in{$i} =~ s/``x//g;
		$in{$i} =~ s/\|//g;
		if ($i =~ /QuickLinks_text(\d+)/) {
			push(@quicklinksnum,$1);
		}
	}
	foreach $i (sort @quicklinksnum) {
		if ($in{"QuickLinks_text$i"} ne '') {
			$QuickLink{$in{"QuickLinks_text$i"}} = $in{"QuickLinks_value$i"};
		}
	}
	foreach $i (keys %QuickLink) {
		push(@quicklinks,"$i!x!$QuickLink{$i}");
	}
	$CConfig{'QuickLinks'} = join('|x|',@quicklinks);
	$addon->simplePage('QuickLinks Saved','<font size="-1">Your changes to the QuickLinks have been saved. ' . $addon->link({'action'=>'admin','adminarea'=>'QuickLinks'}) . 'Back to Edit QuickLinks</a>.</font>');
}

my $QuickLinks_Settings = <<'END CODE';
	NeedCFG();
	$fieldlist = '<select name="QuickLinks_Field" size="5">';
	foreach $i (@fieldDB) {
		next unless (($fieldDB{$i}->{'FieldType'} == 1) or ($fieldDB{$i}->{'FieldType'} == 2));
		$selected{$i} = ' selected' if ($CConfig{'QuickLinks_Field'} eq $i);
		$fieldlist .= qq~<option value="$i"$selected{$i}>$fieldDB{$i}->{'DisplayName'}</option>~;
	}
	$fieldlist .= '</select>';
	$addon->addAdvancedSettingHeading('QuickLinks');
	$addon->addAdvancedSetting('QuickLinks_Field','Field','Select which field the QuickLinks should be inserted into.',$fieldlist);
	$addon->addAdvancedSetting('QuickLinks_Table','Table','If enabled, the QuickLinks will show up in a table on the submit/modify news pages. Otherwise, a simple dropdown menu will be used.',yn);
END CODE

my $QuickLinks_Display = <<'END CODE';
	if (($fn eq $CConfig{'QuickLinks_Field'}) && (!$error)) {
		if ($CConfig{'QuickLinks'}) {
			QuickLinks_Load();
			foreach $i (sort keys %QuickLink) {
				if ($CConfig{'QuickLinks_Table'}) {
					push(@links,qq~<a href="#" onclick="document.submitnews.$fn.value+=('$QuickLink{$i}')">$i</a>~);
				} else {
					push(@links,qq~<option value="$QuickLink{$i}">$i</option>~);
				}
			}
			if ($CConfig{'QuickLinks_Table'}) {
				$display = join(' | ',@links);
			} else {
				$display = join('',@links);
			}
		} else {
			$display = 'There are no QuickLinks to be displayed.';
		}
		if ($CConfig{'QuickLinks_Table'}) {
			$fcode = qq~<table width="100%" border="0" class="yellowbg"><tr><td width="100%"><b><font size="-1">QuickLinks</b> <i>(click to insert)</i><br>$display</font></td></tr></table>$fcode~;
		} else {
			$fcode = qq~<font size="-1"><b>QuickLinks</b>:</font> <select name="QuickLinks"><option value="" selected>Select...</option>$display</select> <input type="button" value="Insert" onclick="document.submitnews.$CConfig{'QuickLinks_Field'}.value+=document.submitnews.QuickLinks.options[document.submitnews.QuickLinks.selectedIndex].value"><br>$fcode~;
		}
	}
END CODE

my $QuickLinks_Top = <<'END CODE';
	NeedCFG();
	foreach $i (@fieldDB) {
		next unless (($fieldDB{$i}->{'FieldType'} == 1) or ($fieldDB{$i}->{'FieldType'} == 2));
		$field{$i} = 1;
	}
	$error = 'The selected field does not exist.' unless ($field{$CConfig{'QuickLinks_Field'}});
	$error = 'The QuickLinks settings have not been configured in the administration area.' unless ($CConfig{'QuickLinks_Field'});
	$error = 'QuickLinks is not compatible with WebWriter.' if ($CConfig{'AddonsLoaded'} =~ /cra_webwriter.pl/);
	print qq~<br><br><div align="center"><font size="-1"><b>QuickLinks Error:</b> $error</font></div><br><br>~ if ($error);
END CODE

$addon->hook(AdvSettings,\$QuickLinks_Settings);
$addon->hook(DisplaySubForm_Fields,\$QuickLinks_Display);
$addon->hook(ModifyNews_Edit_Fields,\$QuickLinks_Display);
$addon->hook(DisplaySubForm_FormStart,\$QuickLinks_Top);
$addon->hook(ModifyNews_Edit_TopRow,\$QuickLinks_Top);

1;
