#! CRADDON 1
#! NAME X MultiSubmit
#! DESCRIPTION Lets users manage multiple "Submit News" pages. Enhanced by Lawrence Williams, adding per-page Required Fields and User Permissions!! :)
#! VERSION 2.0
#! HOMEPAGE mailto:l0rdphi1@liquefyr.com">E-Mail Author</a>] [<a href="http://coranto.gweilo.org
#! DOC 1

#use strict;
#use vars qw(@XMS_Profs %CConfig %Subs %in %XMS_DB %newscategories %XMSFieldDB %userdata $CurrentUser $up %xms_hash %xms_selected_users @fieldDB_internalorder @fieldDB %fieldDB);
#no strict "refs";

my $addon = Addon->new('X MultiSubmit');

$::xms_build = 9;
$::xms_version = '2.0';

$addon->checkBuild(36);

eval {
$addon->isPrivacyCompatible;
};
if ($@){}

$addon->addAdminFunction('X MultiSubmit','Manage profiles, and change settings.','xms-admin');
$addon->registerAdminFunction('xms-admin','XMS_Admin');
$addon->registerAdminFunction('xms-settings','XMS_Settings');
$addon->registerAdminFunction('xms-settings-save','XMS_Settings_Save');
$addon->registerAdminFunction('xms-prof','XMS_Profiles');
$addon->registerAdminFunction('xms-prof-add','XMS_AddProf');
$addon->registerAdminFunction('xms-prof-edit','XMS_EditProfile');
$addon->registerAdminFunction('xms-prof-save','XMS_EditProfile_Save');
$addon->registerAdminFunction('xms-prof-endisable','XMS_EnDisAble');
$addon->registerAdminFunction('xms-prof-remove','XMS_RemoveProf');

$addon->registerAdminFunction('xms-prof-moveupdown','XMS_MoveUpDown1');

	# Check to see if XMS needs to upgrade and do so, if needed
	unless (exists $CConfig{'XMS_Installed'}){
	&XMS_AutoUpgrade();
	$CConfig{'XMS_Installed'} = 1;
	}

#####################################################################
	
{
NeedCFG();

	unless(@XMS_Profs){
		NeedFile('cradmin.pl');
		XMS_LoadProf();
		foreach my $prof(keys %::XMS_DB){
		push(@XMS_Profs, $prof);
		}
		SaveCRCFG();
	}
}
	
my $SaveCRCFG = <<'END_CODE';
	$crcfg .= ArraytoPerl('XMS_Profs');
END_CODE
	
$addon->hook('SaveCRCFG_1', \$SaveCRCFG, -5);

sub XMS_MoveUpDown1 {
NeedCFG();
XMS_MoveUpDown2(\@XMS_Profs, $in{'profname'}, $in{'direction'});
SaveCRCFG();
XMS_Profiles();
}

sub XMS_MoveUpDown2 {
# This is a general purpose sub that moves items in an array up/down by one each time
# Works ONLY with arrays passed by reference

my($arrayref, $object, $direction) = @_;

my @array = @{$arrayref};

my (%sorted, $swap);

	for(my $i=0;$i<@array;$i++){
	$sorted{$array[$i]} = $i;
	}

	CRcough('Invalid input error 1.') unless $sorted{$object} >= 0 && $sorted{$object} <= @array;
	CRcough('Invalid input error 2.') if $direction < 1 || $direction > 2;
	CRcough('This is already the first item.') if $direction == 1 && $sorted{$object} == 0;
	CRcough('This is already the last item.') if $direction == 2 && $sorted{$object} == @array - 1;

	$swap = ($sorted{$object} + 1) if $direction == 2;
	$swap = ($sorted{$object} - 1) if $direction == 1;
	@array[$sorted{$object}, $swap] = @array[$swap, $sorted{$object}];
	
	@{$arrayref} = @array;
}

######################################################################

my $PreHeader = <<'END_CODE';
	eval {
		XMS_LoadProf();

		# Get selected users into a hash
		# Hash format is:
		# $xms_selected_users{SUBMIT_PAGE}->{USER}

		%xms_selected_users = ();

		foreach my $i (@XMS_Profs){
			foreach my $id(split(/\`\|\`/,$XMS_DB{$i}->{'XMS_Users'})){
			$xms_selected_users{$i}->{$id} = 1;
			}
		}
	};
END_CODE

$addon->hook('PreHeader',\$PreHeader, -5);

#######################
# MODIFY NEWS CODE
#######################

sub XMS_ModifyNews_NavBar {
	my @xmst;

	foreach my $i(@XMS_Profs){
		if ((exists $XMS_DB{$i}->{'Enabled'} && $XMS_DB{$i}->{'Enabled'} == 1) && ($xms_selected_users{$i}->{$CurrentUser} || $xms_selected_users{$i}->{'(All)'} || $up > 2)){
			push(@xmst,$addon->link({'action'=>'modify','xMultiSubmitSP'=>$i}).($in{'xMultiSubmitSP'} eq $i?'<b>':'')."$XMS_DB{$i}->{'Name'}</b></a>");
		}
	}

	print "<hr>" . $addon->link({'action'=>'modify','xMultiSubmitSP'=>'all'}).($in{'xMultiSubmitSP'} eq 'all'?'<b>':'')."View All</b></a> Or Sort By Submit Page: ", join(' | ',@xmst). "<hr>";
}

my $XMS_ModifyNews_HiddenValue = <<'END_CODE';
	if ($in{'xMultiSubmitSP'} && $in{'xMultiSubmitSP'} ne 'all'){
		print qq~<input type="hidden" name="xMultiSubmitSP" value="$in{'xMultiSubmitSP'}">~;
	}
END_CODE

my $XMS_ModifyNews_Filter1 = <<'END_CODE';
	if ($in{'xMultiSubmitSP'}){
	$Filter = 'SubmitPage';
	}
END_CODE

my $XMS_ModifyNews_Filter2 = <<'END_CODE';
	if ($Filter eq 'SubmitPage'){
		unless ($xMultiSubmitSP eq $in{'xMultiSubmitSP'} || $in{'xMultiSubmitSP'} eq 'all'){
		#next NDLOOP;
		$stoppermnow = 1;
		}
	}
END_CODE

if ($CConfig{'xms_modifynewslayout'} eq 'links'){
$addon->hook('ModifyNews_Filter', \$XMS_ModifyNews_Filter2);
$addon->hook('ModifyNews_Permissions',\$XMS_ModifyNews_Filter1);
$addon->hook('ModifyNews_SearchForms','XMS_ModifyNews_NavBar');
$addon->hook('ModifyNews_StartForm', \$XMS_ModifyNews_HiddenValue, -5);
}

#########################################################################################

my $HookQuickMenu = <<'END_CODE';
	LoadFunctionList();

	{
	&ReadUserDBInfo();

		foreach my $i (reverse(@XMS_Profs)){
			if (exists $XMS_DB{$i}->{'Name'} && $XMS_DB{$i}->{'Enabled'} && $XMS_DB{$i}->{'QuickLink'} && $CConfig{'xms_dissubnews'} ne 'choose' && ($xms_selected_users{$i}->{$CurrentUser} || $xms_selected_users{$i}->{'(All)'} || $up > 2)){
			push(@AvailableFunctions, ['</a >' . $addon->link({'action'=>'xms-submit','profname'=>$i}) . "$XMS_DB{$i}->{'Name'}</a>", '', ''] )
			}
		}

	@funclist = map { $_->[0] =~ s/ /&nbsp;/; PageLink( {'action' => $_->[2]}) . "$_->[0]</a>&nbsp;" } @AvailableFunctions;
	}
END_CODE

my $HookMainPage = <<'END_CODE';
	{
	&ReadUserDBInfo();

		foreach my $i (reverse(@XMS_Profs)){
			if (exists $XMS_DB{$i}->{'Name'} && ($xms_selected_users{$i}->{$CurrentUser} || $xms_selected_users{$i}->{'(All)'} || $up > 2) && $XMS_DB{$i}->{'MainPage'} && $XMS_DB{$i}->{'Enabled'} && $CConfig{'xms_dissubnews'} ne 'choose'){
			push(@AvailableFunctions, ['</a >' . $addon->link({'action'=>'xms-submit','profname'=>$i}) . "$XMS_DB{$i}->{'Name'}</a>", $XMS_DB{$i}->{'Description'} ? $XMS_DB{$i}->{'Description'} : $CConfig{'xms_nodescmsg'}, ''] );
			}
		}

	}
END_CODE

my $HookModNewsHeader = <<'END_CODE';
	print $ColCount % 2 ? '<td class="yellowbg">' : '<td class="lightgbg">';
	print '<div align="center"><b>Submit Page</b></div></td>';
	$ColCount++;
END_CODE

my $HookModNewsBody = <<'END_CODE';
	print $ColCount % 2 ? '<td class="navlink"><div align="center">' : '<td class="lightgbg"><div align="center" class="footnote">';
	print qq~$XMS_DB{$::xMultiSubmitSP}->{'Name'}</div></td>~;
	$ColCount++;
END_CODE

if($CConfig{'xms_modifynewslayout'} eq 'column'){
    $addon->hook('ModifyNews_NewColumn_1',\$HookModNewsHeader);
    $addon->hook('ModifyNews_NewColumn_2',\$HookModNewsBody);
}

$addon->hook('EarlyHook','XMS_HookSubNewsDirect') if $in{'action'} eq 'submit' and exists($CConfig{'xms_dissubnews'}) and $CConfig{'xms_dissubnews'} ne 'disabled';
$addon->hook('CRHTMLFoot',\$HookQuickMenu);
$addon->hook('CRHTMLHead',\$HookMainPage);
$addon->hook('CRHTMLHead_UserBar','XMS_HookSubCRHTMLHead_UserBar');
$addon->hook('SaveNews_1','XMS_HookSubNewsSave_1');
$addon->hook('SaveNews_Pre','XMS_CheckRequiredFields');
$addon->hook('ModifyNews_EditSave_PreLoop','XMS_CheckRequiredFields');
$addon->hook('ModifyNews_EditSave_3','XMS_HookSubNewsSave_1');
$addon->hook('ModifyNews_Edit_TopRow','XMS_HookSubModifyNews_Edit_TopRow');

my @XMS_ProfDatFields = qw(XMS_Id XMS_Name XMS_Desc XMS_Fields XMS_EnDisAbled XMS_LockCats XMS_DispMP XMS_DispQM); # DONT EDIT THIS!!
my @XMS_SubmitPages;

$addon->registerMainFunction('xms-submit','XMS_Submit');

$CConfig{'xms_nodescmsg'} = 'No description available for this submit page.';
$CConfig{'xms_afteradd'} = 'Profile Listing' unless $CConfig{'xms_afteradd'};

sub XMS_LoadProf {
	%::XMS_DB = ();
	ReadInnerHash('XMS_DB','Prof',\%::XMS_DB);
}

sub XMS_SaveProf {
	WriteInnerHash('XMS_DB','Prof',\%::XMS_DB);
}

sub XMS_LoadFieldOrder {
	%::XMSFieldDB = ();
	ReadInnerHash('XMSFieldDB','XMS_FieldDB',\%::XMSFieldDB);
}

sub XMS_SaveFieldOrder {
	WriteInnerHash('XMSFieldDB','XMS_FieldDB',\%::XMSFieldDB);
}

sub XMS_Admin {
	my @XMS_AdminFunctions = (
	['Settings', 'Change a wide variety of X MultiSubmit settings.', 'xms-settings'],
	['Page Profiles', 'Create, edit, or remove submit page profiles, which control the flavor of submit pages.', 'xms-prof']);
	@XMS_AdminFunctions = reverse(@XMS_AdminFunctions);
	$addon->pageHeader('X MultiSubmit', 1);
	PrintFunctionList(\@XMS_AdminFunctions, 'adminarea', 'action', 'admin');
	$addon->pageFooter();
}

sub XMS_Settings {
	$addon->pageHeader('MultiSubmit Settings',1);
	print StartForm({'action'=>'admin','adminarea'=>'xms-settings-save'});
	print $addon->settingTable('No description message',qq~<input name="nodescmsg" type="text" value="$CConfig{'xms_nodescmsg'}" style="width: 100%" width="100%">~, 'Text displayed in the description area of a submit page with no description.');
	my $options = '';

		foreach my $i('Edit Profile','Profile Listing'){
		$options .= qq~<option value="$i"~.($CConfig{'xms_afteradd'} eq $i?' selected':'').qq~>$i</option>~;
		}

	print $addon->settingTable('After adding profile goto',qq~<select name="afteradd" style="width: 100%" width="100%">$options</select>~, 'After adding a profile, go directly to the edit profile page or back to the profile listing.');
	my $profopt = '<option value="choose"' . ($CConfig{'xms_dissubnews'} eq 'choose' ? ' selected' : '') . '>(Choose a submit page menu)</option>' .
	'<option value="choose_and_links"' . ($CConfig{'xms_dissubnews'} eq 'choose_and_links' ? ' selected' : '') . '>(Choose a submit page menu WITH Main Page/Quick Menu links)</option>';

		foreach my $i(@XMS_Profs){
			if(exists $XMS_DB{$i}->{'Name'}){
			$profopt .= qq~<option value="$i"~ . ($CConfig{'xms_dissubnews'} eq $i ? ' selected' : '') . qq~>$XMS_DB{$i}->{'Name'} (id: $i)</option>~ unless $XMS_DB{$i}->{'Enabled'} eq '0';
			}
		}

	print $addon->settingTable('Direct "Submit News" page to', qq~<select name="dissubnews" style="width: 100%" width="100%"><option value="disabled">(Disabled)</option>$profopt</select>~, 'When you click on Coranto\'s Submit News link you will be directed to this Submit Page/Menu.');
	print $addon->settingTable('"Modify News" layout',qq~<div align=left><input type="radio" name="mnl" value="column"~.($CConfig{'xms_modifynewslayout'} eq 'column'?' checked':'').qq~> Creat a "Submit Page" column on the default Modify News page.<br>
	<input type="radio" name="mnl" value="links"~.($CConfig{'xms_modifynewslayout'} eq 'links'?' checked':'').qq~> List the Submit News pages on the "Modify News" page and have each item on the list link to news items submitted to that Submit News page.<br>
	<input type="radio" name="mnl" value=""~.($CConfig{'xms_modifynewslayout'} eq ''?' checked':'').'> Dont change a thing.</div>','Select how you want the "Modify News" page to look.');
	print SubmitButton('Save Settings'),'</form>';
	$addon->pageFooter();
}

sub XMS_Settings_Save {
	&NeedCFG();

	$CConfig{'xms_nodescmsg'} = $in{'nodescmsg'};
	$CConfig{'xms_afteradd'} = $in{'afteradd'};
	$CConfig{'xms_dissubnews'} = $in{'dissubnews'};
	$CConfig{'xms_modifynewslayout'} = $in{'mnl'};

	#&SaveCConfig();

	$addon->simplePage('Settings Saved',qq~Settings have been saved. Click ~.$addon->link({'action'=>'admin','adminarea'=>'xms-admin'}).'here</a> to go back.');exit;
}

sub XMS_Profiles {
	$addon->pageHeader('MultiSubmit Profiles',1);

	print q~<table width="80%" cellpadding="2" border="0" align="center"><tr><td class="midheader"><div align="center">
	Current X MultiSubmit Profiles</div></td></tr></table><br>~;

	my ($status, $actions);

		foreach my $i (@XMS_Profs){

			if(exists $XMS_DB{$i}->{'Name'}){
			$status = 'Main Page link is <b>'.($XMS_DB{$i}->{'MainPage'} ? 'on':'off').'</b>. Quick Menu link is <b>'.($XMS_DB{$i}->{'QuickLink'} ? 'on':'off').'</b>.';
			$status .= '<br>Selected Fields: '.(join(', ',split(/\`\|\`/,$XMS_DB{$i}->{'Fields'}))?join(', ',split(/\`\|\`/,$XMS_DB{$i}->{'Fields'})):'none');

				unless ($XMS_DB{$i}->{'Enabled'}){
				$status .= '<br>This profile is <b>Disabled</b>';
				}

			$actions = '['.$addon->link({'action'=>'admin','adminarea'=>'xms-prof-edit','profname'=>$i}).'Edit</a>] '.
			'['.$addon->link({'action'=>'admin','adminarea'=>'xms-prof-endisable','profname'=>$i}).($XMS_DB{$i}->{'Enabled'} eq '0' ? 'Enable':'Disable').'</a>] '.
			'[' . PageLink( {'action' => 'admin', 'adminarea' => 'xms-prof-moveupdown', 'profname' => $i, 'direction' => 1} ) . 'Move Up</a>] '.
			'[' . PageLink( {'action' => 'admin', 'adminarea' => 'xms-prof-moveupdown', 'profname' => $i, 'direction' => 2} ) . 'Move Down</a>] '.
			'['. $addon->link({'action'=>'admin','adminarea'=>'xms-prof-remove','profname'=>$i}).'Delete</a>]';
			print Tricolore(($XMS_DB{$i}->{'Name'}),$status,$actions);
			}

		}

	print MidHeading('Create New Profile'),StartForm({'action'=>'admin','adminarea'=>'xms-prof-add'}),q~
	<table width="80%" border="0" cellspacing="2" cellpadding="2" align="center"><tr><td class="fieldtitle" width="50%" valign="top"><div align="right">Profile Name:</div></td>
	<td width="50%"><input type="text" size="30" name="name" style="width: 100%" width="100%"></td></tr><tr><td colspan="2" class="description">
	<div align="center">X MultiSubmit Profile names are used to identify profiles.</div></td></tr></table><br>~,
	SubmitButton('Create Profile'),'</form>';
	$addon->pageFooter();
}
sub XMS_AddProf {
	NeedCFG();
	my %LoadediO;
	foreach my $i(@fieldDB_internalorder){ $LoadediO{$i} = $i; }

	unless($LoadediO{'xMultiSubmitSP'}){ 
		push(@fieldDB_internalorder,'xMultiSubmitSP');
		XMS_AddCSQLField() if $CConfig{'CorantoSQL_built'} eq 'yes';
		NeedFile('cradmin.pl');
	}

	my $id = int(rand(9999)).time();

		while($XMS_DB{$id}){
		$id = int(rand(9999)).time();
		}

	$XMS_DB{$id}->{'Name'} = $in{'name'};
	$XMS_DB{$id}->{'Enabled'} = 0;
	$XMS_DB{$id}->{'LockCats'} = 'Disabled';
	$XMS_DB{$id}->{'MainPage'} = 1;
	$XMS_DB{$id}->{'QuickLink'} = 1;
	$XMS_DB{$id}->{'XMS_Users'} = '(All)';
	
	XMS_SaveProf();
	$in{'profname'} = $id;
	
	push(@XMS_Profs, $id);
	SaveCRCFG();

	XMS_EditProfile() unless $CConfig{'xms_afteradd'} eq 'Profile Listing';
	XMS_Profiles();
}

sub XMS_EditProfile {
	NeedCFG();
	
	XMS_LoadFieldOrder();

	my $id = $in{'profname'};
	CRcough('You\'ve requested an invalid profile id.') unless $XMS_DB{$id};

	XMS_MoveUpDown('field',$in{'field-move'},$id,$in{'fieldid'}) if $in{'field-move'};
	$addon->pageHeader(qq~X MultiSubmit Settings for "$XMS_DB{$id}->{'Name'}"~,1);
	print StartForm({'action'=>'admin','adminarea'=>'xms-prof-save','profname'=>$id});
	print $addon->settingTable('Profile Name',qq~<input name="name" type="text" value="$XMS_DB{$id}->{'Name'}" style="width: 100%" width="100%">~, 'Name of this Page Profile (may appear on main page and/or quick menu).');
	print $addon->settingTable('Profile Description',qq~<input name="desc" type="text" value="$XMS_DB{$id}->{'Description'}" style="width: 100%" width="100%">~, 'Description of this Page Profile (may appear on main page).');
	print $addon->settingTable('Display on Main Page?','<div align=left><input name="dispmp" type="checkbox" value="1"'.($XMS_DB{$id}->{'MainPage'} ?' checked':'').'></div>', 'Display Page Profile link on the Main Page?');
	print $addon->settingTable('Display on Quick Menu?','<div align=left><input name="dispqm" type="checkbox" value="1"'.($XMS_DB{$id}->{'QuickLink'} ?' checked':'').'></div>', 'Display Page Profile link on the Quck Menu?');

	my (%LoadedAddons, %lockcatsel, $categorylocking);

	foreach my $i(split(/~/,$CConfig{'AddonsLoaded'})){ $LoadedAddons{$i} = $i; }

	if($LoadedAddons{'cra_ncategory.pl'} or $LoadedAddons{'cra_tintinnabulum.pl'}){

		foreach my $i(split(/\`\|\`/,$XMS_DB{$id}->{'LockCats'})){ $lockcatsel{$i} = ' selected'; }
		my $catlockopts = '';

			foreach my $i(keys %newscategories){
			$catlockopts .= qq~<option value="$i"$lockcatsel{$i}>$i</option>~ unless $i eq '(default)';
			}

		$categorylocking = qq~<select name="lockcat" size="6" multiple style="width: 100%" width="100%">
		<option value="Disabled"$lockcatsel{'Disabled'}>(Disabled)</option>
		<option value="AllCategories"$lockcatsel{'AllCategories'}>(All Categories)</option>
		<option value="(default)"$lockcatsel{'(default)'}>(Default Category)</option>$catlockopts</select>~;

		print $addon->settingTable('Category Locking',$categorylocking?$categorylocking:'Please install the News Categories addon.',"Allows a category to be statically assigned to a Page Profile. Multiple selections are allowed: to make multiple selections, Windows users hold down CTRL, Mac users hold down Option, most UNIX users hold down CTRL, users of other operating systems see your browser's help. If you do make multiple selections, the user will get to choose which one they want to submit to.");
	}

	print MidHeading('Submit Fields');

	my $fieldslisting = '';
	my (%fldchk, @fDb);

		foreach my $i(split(/\`\|\`/,$XMS_DB{$id}->{'Fields'})){
		push(@fDb,$i);
		$fldchk{$i} = ' checked';
		}

		foreach my $i(@fieldDB){
		push(@fDb,$i) unless $fldchk{$i};
		}

		foreach my $i(@fDb){
			unless ($i eq 'User' or $i eq 'newsid' or $i eq 'newstime'){
			$fieldslisting .= qq~<tr><td align=left width=100%><input type="checkbox" name="field_$i" value="1"$fldchk{$i}> $fieldDB{$i}->{'DisplayName'}</td></tr>~;
			}
		}

	print $addon->settingTable('Fields',"<table border=0 cellpadding=1 cellspacing=2 width=100%>$fieldslisting</table>",'Check the fields that should be displayed on this submit page.');

		if ($XMS_DB{$id}->{'Fields'}){
			print MidHeading('Field Order');

			my $fieldorder;

			foreach my $i(split(/\`\|\`/,$XMS_DB{$id}->{'Fields'})){
			$fieldorder .= qq~<tr><td align=left width=100%>$fieldDB{$i}->{'DisplayName'}</td><td><input type="text" size="2" name="XMSOrder_$i" value="$XMSFieldDB{$id}->{$i}"></td></tr>~;
			}

			print $addon->settingTable('Field Order',"<table border=0 cellpadding=1 cellspacing=2 width=100%>$fieldorder</table>",'Enter a number, starting with 1, for each of the fields to control the order they appear on the submit page.');
		}

##########
# NEW REQUIRED FIELDS STUFF
##########

	my %RequiredFields;

	foreach my $i(split(/\`\|\`/,$XMS_DB{$id}->{'RequiredFields'})){
	$RequiredFields{$i} = 'selected';
	}

	my $fields_required = qq~<select name="RequiredFields" multiple>~;
	
		foreach my $i(split(/\`\|\`/,$XMS_DB{$id}->{'Fields'})){
		$fields_required .= qq~<option value="$i" $RequiredFields{$i}>$i</option>~;
		}

	$fields_required .= qq~</select>~;

	print MidHeading('Required Fields');
	print $addon->settingTable('Required Fields',"$fields_required",'Select the fields that must contain user input.');

##########
# END REQUIRED FIELDS STUFF
##########

	{
		&ReadUserDBInfo();

		# Get selected users into a hash
		my %selected_users = ();

		foreach my $i(split(/\`\|\`/,$XMS_DB{$id}->{'XMS_Users'})){
		$selected_users{$i} = 'selected';
		}

		my $userlist = qq~<select name="XMS_Users" multiple>~;

		foreach my $i (sort keys %userdata){
		$userlist .= qq~<option value="$i" $selected_users{$i}>$i</option>~;
		}

		$userlist .= qq~<option value="(All)" $selected_users{'(All)'}>(All)</option>~;

		$userlist .= qq~</select>~;

		print MidHeading('User Permissions');
		print $addon->settingTable('Users',"$userlist",'Select which users are allowed to post items using this submit page.');
	}

	print SubmitButton('Save Settings'), '</form>';
	$addon->pageFooter();exit;
}

sub XMS_EditProfile_Save {
my $addon = shift;

	&XMS_LoadFieldOrder();

	my $id = $in{'profname'};

	my (%prefield, @prefields, @fieldsout, @RequiredFields);

		foreach my $key (keys %in){
		push(@fieldsout,$1) if $key =~ /^field_(.*)/;
		}

		foreach my $i(split(/\`\|\`/,$XMS_DB{$id}->{'Fields'})){
		push(@prefields,$i) if $in{"field_$i"};
		$prefield{$i} = $i;
		}

		foreach my $i(@fieldsout){
		push(@prefields,$i) unless $prefield{$i};
		}

		$XMS_DB{$id}->{'Name'} = $in{'name'};
		$XMS_DB{$id}->{'Description'} = $in{'desc'};
		$XMS_DB{$id}->{'MainPage'} = $in{'dispmp'};
		$XMS_DB{$id}->{'QuickLink'} = $in{'dispqm'};
		$XMS_DB{$id}->{'Fields'} = join('`|`',@prefields);

		$in{'RequiredFields'} =~ s/\|x\|/\`\|\`/gi;
		$XMS_DB{$id}->{'RequiredFields'} = $in{'RequiredFields'};

		$in{'XMS_Users'} =~ s/\|x\|/\`\|\`/gi;

		foreach my $i (keys %in){
			if ($i =~ /^XMSOrder_(.*)/){
			my $field = $i;
			$field =~ s/XMSOrder_//gi;
			$XMSFieldDB{$id}->{$field} = $in{$i};
			#print qq~<p>$XMSFieldDB{$id}->{$i}</p>~;
			}
		}
		
	if($in{'lockcat'}){
	my @LockCats = split(/\|x\|/,$in{'lockcat'});
	my %LockCat;
		
		foreach my $i(@LockCats){
		$LockCat{$i} = $i;
		}

	$addon->minorError('You cannot disable Category Locking and select categories.') if scalar(@LockCats) > 1 and $LockCat{'Disabled'};
	$addon->minorError('If you select All Categories you cannot select other categories.') if scalar(@LockCats) > 1 and $LockCat{'AllCategories'};
	$addon->minorError('If you select All Categories you cannot select other categories.') if scalar(@LockCats) > 1 and $LockCat{'(All)'};
	$XMS_DB{$id}->{'LockCats'} = join('`|`',@LockCats);
	}

	if ($in{'XMS_Users'}){
	my @Users = split(/\`\|\`/,$in{'XMS_Users'});
	my %Users;

		foreach my $i(@Users){
		$Users{$i} = $i;
		}

		if (scalar(@Users) > 1 && $Users{'(All)'}){
		$addon->minorError('If you select (All) users, you cannot select other users.');
		}

		$XMS_DB{$id}->{'XMS_Users'} = $in{'XMS_Users'};
	}

	XMS_SaveProf();
	XMS_SaveFieldOrder();

	XMS_Profiles();
	exit;
}

sub XMS_EnDisAble {
	my $id = $in{'profname'};
	CRcough('You\'ve requested an invalid profile id.') unless $XMS_DB{$id};

		if ($XMS_DB{$id}->{'Enabled'} == 0){
		$XMS_DB{$id}->{'Enabled'} = 1;
		}
		else {
		$XMS_DB{$id}->{'Enabled'} = 0;
		}

	XMS_SaveProf();
	XMS_Profiles();
}

sub XMS_RemoveProf {
	&NeedCFG();
	
	XMS_LoadFieldOrder();

	my $id = $in{'profname'};
	CRcough('You\'ve requested an invalid profile id.') unless $XMS_DB{$id};
	AreYouSure("Are you sure you want to remove the profile <b>$XMS_DB{$id}->{'Name'}</b>? Deleting a profile ERASES ALL its data.") unless $in{'really'};
	my $count = 0;

	delete $CConfig{"Prof-$id"};
	delete $CConfig{"XMSFieldDB-$id"};
	delete $XMS_DB{$id};
	delete $XMSFieldDB{$id};

	XMS_SaveProf();
	XMS_SaveFieldOrder();
	
	{
		my @newarray = ();
		
		foreach my $profile(@XMS_Profs){
			unless ($profile eq $id){
			push(@newarray, $profile);
			}
		}
		@XMS_Profs = @newarray;
	}
	
	&SaveCRCFG();

	XMS_Profiles();
}

sub XMS_AddCSQLField {
	my ($corantosql_dbh, $sql_add_field);
	$corantosql_dbh = CorantoSQL_connectdb();
	eval {
		$sql_add_field = "ALTER TABLE $CConfig{'CorantoSQL_tblname'} ADD xMultiSubmitSP VARCHAR(255) null\;";
		$corantosql_dbh->do($sql_add_field);
	};
	CRcough("Could not add field xMultiSubmitSP to the cSQL table. Reason: $@") if $@;
	$corantosql_dbh->disconnect();
}

sub XMS_HookSubNewsDirect {
	LoadFunctionList();
	if ($CConfig{'xms_dissubnews'} eq 'choose' or $CConfig{'xms_dissubnews'} eq 'choose_and_links') {

		&ReadUserDBInfo();

		$addon->pageHeader('Choose a submit page');

		foreach my $i (@XMS_Profs){
			if ($XMS_DB{$i}->{'Enabled'} == 1 && exists $XMS_DB{$i}->{'Name'} && ($xms_selected_users{$i}->{$CurrentUser} || $xms_selected_users{$i}->{'(All)'} || $up > 2)){
			push(@XMS_SubmitPages, [$XMS_DB{$i}->{'Name'}, $XMS_DB{$i}->{'Description'} ? $XMS_DB{$i}->{'Description'} : $CConfig{'xms_nodescmsg'}, $i] );
			}
		}

		@XMS_SubmitPages = reverse(@XMS_SubmitPages);
		PrintFunctionList(\@XMS_SubmitPages, 'profname', 'action', 'xms-submit');
		$addon->pageFooter();
		exit;
	} else {
	  	$in{'profname'} = $CConfig{'xms_dissubnews'};
		XMS_Submit();
		exit;
	}
}

sub XMS_HookSubCRHTMLHead_UserBar {
	print ' | back to ' . $addon->link({'action'=>'admin','adminarea'=>'xms-admin'}) . 'X MultiSubmit</a>' if $in{'action'} eq 'admin' and $in{'adminarea'} =~ /^xms/ and $in{'adminarea'} ne 'xms-admin';
}

sub XMS_HookSubNewsSave_1 {
	my %LoadediO;
	foreach my $i(@fieldDB_internalorder){ $LoadediO{$i} = $i; }
	unless($LoadediO{'xMultiSubmitSP'}){ 
		push(@fieldDB_internalorder,'xMultiSubmitSP');
		XMS_AddCSQLField() if $CConfig{'CorantoSQL_built'} eq 'yes';
		NeedFile('cradmin.pl');
		SaveCRCFG();
	}
	$::xMultiSubmitSP = $in{'xMultiSubmitSP'};
}

sub XMS_HookSubModifyNews_Edit_TopRow {

	my $id = $::xMultiSubmitSP;

	# Load Field Order hashes
	&XMS_LoadFieldOrder();

	# This is where the sorted fields will be stored
	local %::xms_hash = ();

	# Loop through the field list for this profile

	foreach my $i(split(/\`\|\`/,$XMS_DB{$id}->{'Fields'})){
	# Set value in real hash... format: field => order number
	$xms_hash{$i} = $XMSFieldDB{$id}->{$i};
	}

	&ReadUserDBInfo();

	@fieldDB = sort XMS_SortSubmitFields (keys (%xms_hash)) if $::xMultiSubmitSP;

	my $submitpageopts;
	foreach my $i (@XMS_Profs) {
		if (exists $XMS_DB{$i}->{'Name'} && ($xms_selected_users{$i}->{$CurrentUser} || $xms_selected_users{$i}->{'(All)'} || $up > 2)){
		$submitpageopts .= qq~<option value="$i"~ . ($::xMultiSubmitSP eq $i ? ' selected' : '') . qq~>$XMS_DB{$i}->{'Name'}</option>~ if $XMS_DB{$i}->{'Enabled'};
		}
	}
	print $addon->fieldsTableRow('Submit Page', qq~<select name="xMultiSubmitSP"><option value="">(none)</option>$submitpageopts</select>~);
}

#######################################

sub XMS_Submit {

	{
	my $id = $in{'profname'};
	&ReadUserDBInfo();

		# Get selected users into a hash
		my %selected_users = ();

		foreach my $i(split(/\`\|\`/,$XMS_DB{$id}->{'XMS_Users'})){
		$selected_users{$i} = 1;
		}

		unless ($selected_users{$CurrentUser} || $selected_users{'(All)'} || $up > 2){
		&CRcough("You do not have permission to access this submit page!");
		}		
	}
	 
my $xms_submit_code = <<'END_CODE';

	my $id = $in{'profname'};

	# Load Profile and Field Order hashes
	&XMS_LoadFieldOrder();

	# This is where the sorted fields will be stored
	local %::xms_hash = ();

	# Loop through the field list for this profile

	foreach my $i(split(/\`\|\`/,$XMS_DB{$id}->{'Fields'})){
	# Set value in real hash... format: field => order number
	$xms_hash{$i} = $XMSFieldDB{$id}->{$i};
	}

	# Now the real hash has been setup.... Start looping as per usual

	foreach $fn (sort XMS_SortSubmitFields (keys (%xms_hash)))
	#print qq~$fn is $xms_hash{$fn}~;

END_CODE

$Subs{DisplaySubForm} =~ s/(NeedCFG\(\);)/my \$profname = \$in{profname};CRcough('You\\'ve requested an invalid profile id.') unless \$XMS_DB{\$profname};$1/;
$Subs{DisplaySubForm} =~ s/\$Messages\{'Section_Submit'\}/\$XMS_DB{\$profname}->{Name}/;
$Subs{DisplaySubForm} =~ s/(\{'action' => 'submitsave')/$1, 'xMultiSubmitSP' => \$profname/;
$Subs{DisplaySubForm} =~ s!# HOOK: DisplaySubForm_TopRow[\s\S]+?;\}!if(\$Addons{DisplaySubForm_TopRow}){for my \$w (\@{\$Addons{DisplaySubForm_TopRow}}){my \$addon=\$w->[2];if((\$addon->{file} eq 'cra_ncategory.pl' or \$addon->{file} eq 'cra_tintinnabulum.pl') and \$XMS_DB->{\$profname}->{LockCats} ne 'Disabled' and \$XMS_DB{\$profname}->{LockCats} ne 'AllCategories'){my \@LockCats = split(/\\`\\|\\`/, \$XMS_DB{\$profname}->{LockCats});my \$catopts = join '', map { qq~<option value="\$_">\$_</option>~ } \@LockCats;print FieldsRow('Category', ( \@LockCats > 1 ? qq~<select name="Category"~ . ( \$addon->{file} eq 'cra_tintinnabulum.pl' ? ' multiple' : '' ) . qq~>\$catopts</select>~ : qq~\$LockCats[0]<input name="Category" type="hidden" value="(default)">~));}else{eval \${\$w->[0]};AErr(\$addon,\$\@)if \$\@;};}!;

$Subs{DisplaySubForm} =~ s!foreach \$fn \(\@fieldDB\)!$xms_submit_code!;

#print qq~<!-- $Subs{DisplaySubForm} -->~;

&DisplaySubForm;
}

sub XMS_SortSubmitFields {
   $xms_hash{$a} <=> $xms_hash{$b};
}

#########################################


sub XMS_CheckRequiredFields {
&NeedCFG();

my $id = $in{'xMultiSubmitSP'};
my $cough;

	if ($XMS_DB{$id}->{'RequiredFields'}){
		foreach my $field(split(/\`\|\`/,$XMS_DB{$id}->{'RequiredFields'})){
			if ($in{$field} eq ""){
			$cough .= qq~$fieldDB{$field}->{'DisplayName'}<br>~;
			}
		}

		if ($cough){
		$addon->simplePage("Required Fields", "The following fields are required:<br><br> <b>$cough</b><br>Please go back and try again.");
		exit;
		}
	}
}

########################################
# UPGRADE FROM XMS 1.9x
########################################

sub XMS_AutoUpgrade {
&NeedCFG();
&XMS_LoadProf();
&XMS_LoadFieldOrder();

my @XMS_ProfDatFields = qw(XMS_Id XMS_Name XMS_Desc XMS_Fields XMS_EnDisAbled XMS_LockCats XMS_DispMP XMS_DispQM); # DONT EDIT THIS!!

		foreach my $prof (split(/\|x\|/,$CConfig{'XMS_Prof'})){
		my ($XMS_Id,$XMS_Name,$XMS_Desc,$XMS_Fields,$XMS_EnDisabled,$XMS_LockCats,$XMS_DispMP,$XMS_DispQM) = split(/\!x\!/, $prof);
		#print qq~<p>Id is $XMS_Id</p>~;
		#print qq~<p>Fields are $XMS_Fields</p>~;


		$XMS_DB{$XMS_Id}->{'Name'} = $XMS_Name;
		$XMS_DB{$XMS_Id}->{'Description'} = $XMS_Desc;
		$XMS_DB{$XMS_Id}->{'Fields'} = $XMS_Fields;
		$XMS_DB{$XMS_Id}->{'Enabled'} = $XMS_EnDisabled;
		$XMS_DB{$XMS_Id}->{'LockCats'} = $XMS_LockCats;
		$XMS_DB{$XMS_Id}->{'MainPage'} = $XMS_DispMP;
		$XMS_DB{$XMS_Id}->{'QuickLink'} = $XMS_DispQM;
		$XMS_DB{$XMS_Id}->{'RequiredFields'} = '';

			{
			my $field_number = 1;

				foreach my $field(split(/\`\|\`/,$XMS_Fields)){
				$XMSFieldDB{$XMS_Id}->{$field} = $field_number;
				$field_number++;
				}

			}			
		}

&XMS_SaveProf();
&XMS_SaveFieldOrder();
}

########################################
# XMS CATEGORIES STUFF
########################################

my $EditProfDefinition_1 = <<'END_CODE';
	my %selectedxmscats;
	$newsprofiles{$prof}->{xmscats} = 'AllProfiles' unless $newsprofiles{$prof}->{xmscats};

	foreach my $i (split (/\(delim\)/, $newsprofiles{$prof}->{xmscats})) {
		$selectedxmscats{$i} = 'selected';
		#print qq~<p>$i</p>~;
	}
	my $catselect = '';

	foreach my $i (@XMS_Profs) {
		$catselect .= qq~<option value="$i" $selectedxmscats{$i}>$XMS_DB{$i}->{'Name'}</option>~;
	}

	push(@EditProfileSettings,
	['xmscats', 'XMS Profiles', "Only news submited from selected XMS Profiles will be included in this profile. Multiple selections are allowed: to make multiple selections, Windows users hold down CTRL, Mac users hold down Option, most UNIX users hold down CTRL, users of other operating systems see your browser's help.",qq~<select name="xmscats" size="6" multiple><option value="AllProfiles" $selectedxmscats{'AllProfiles'}>(All Profiles)</option>$catselect</select>~]
	);
END_CODE

my $BuildNews_Filtering = <<'END_CODE';
	if (exists $newsprofiles{$i}->{xmscats} && $newsprofiles{$i}->{xmscats} ne ''){
	my (%ProfXMSCats);
		foreach my $j (split (/\(delim\)/, $newsprofiles{$i}->{'xmscats'})) {
		$ProfXMSCats{$j} = 1;
		}
		unless ($ProfXMSCats{$xMultiSubmitSP} || $ProfXMSCats{AllProfiles}) {
		next PROFLOOP;
		}
	}
END_CODE

my $InitActiveProfiles_2 = <<'END_CODE';
		foreach my $i (keys %newsprofiles) {
			if ($i =~ /-headlines$/){
				# so we know it's a headline, so we know we need to add the xmscats
				my $profname = substr ($i, 0, (length $i) - 10);
				$newsprofiles{$i}->{'xmscats'} = $newsprofiles{$profname}->{'xmscats'};
			}
		}
END_CODE

$addon->hook('EditProfDefinition_1', \$EditProfDefinition_1, 3);
$addon->hook('InitActiveProfiles_2', \$InitActiveProfiles_2);
$addon->hook('BuildNews_Filtering', \$BuildNews_Filtering);

1;
__END__
=head1 X MultiSubmit
=head2 Uhhh... no
I believe you should not be looking here but rather in the readme.txt contained in this addons zip file.
