# crlang.pl
# This file contains English-language messages for Coranto.
# Do not translate this file; see the Coranto website for more information on
# how to translate Coranto's messages into a foreign language.

$crlangVersion = 2;

%Messages = (
#####################################################################################
#HEADER: Setup Messages
#SECTION: Page 1
q~Coranto Setup~
  => q~Coranto Installatie~,
q~Welcome to Coranto~
  => q~Welkom bij Coranto~,
q~Congratulations: one of the most problematic parts of setup, getting Coranto to run as a CGI script, is complete. Now, you need to give Coranto some information -- the paths where its files are stored, the name you'd like to log in with, and various other important details. On this and the next couple of pages, Coranto will ask you for this information.~
  => q~Gefeliciteerd: Het meest ingewikkelde gedeelte van de installatie, Coranto als CGI-script werkend krijgen, is gelukt. Tijdens de volgende stappen stelt u Coranto in - De paden waar de bestanden worden opgeslagen, de door u gewenste log-in naam en andere belangrijke details. Op deze en volgende pagina's zal Coranto u hiernaar vragen.~,
q~Licensing~
  => q~Licentie~,
q~Please select an option~
  => q~Kies aub een optie~,
q~I agree -- I will comply with the Coranto license~
  => q~I agree -- Ik ga accoord met de Coranto licentie~,
q~Privacy~
  => q~Privacy~,
q~_PRIVACY_INFO~ # Privacy information, should this really be translated?
  => <<'EOSENTANCE',
	Coranto is designed to allow for a good degree of privacy for its users, and two privacy levels are available to
	cater for different users' needs.  No personal information about users is logged without your permission, and we do not share
	any information with third-parties or use it for junk mail.<p>
	The standard privacy setting, 'Public', will suit most users. At your option, you can choose to disable the version checking
	image (to speed page loading and/or to prevent the URL to your coranto.cgi appearing as a referrer in our server logs). You
	can also choose whether or not you would like to share the name and email address of your SuperAdmin user with us, solely to allow
	us to notify you of any major bugs or security holes discovered in the version of the script you are running.  You will be passed
	briefly to our server during the setup process to allow you to sign up for our forums and update mailing list if you desire. The
	URL to your coranto.cgi is passed to our server at this stage solely to allow us to provide you with a link back to your completed
	installation, and is not logged. For greater privacy, you can set your web browser or firewall to hide the referrer; this is a
	function of your computer's setup, and is beyond Coranto's control.<p>
	If you are running Coranto on a private network that is not linked to the Internet, or require the absolute maximum privacy
	possible, you may choose the 'Private' setting. You will not be passed to our server during the setup process, and all links
	or image calls to third-party servers in the script will be disabled.  Note that if you choose this option, YOU WILL BE UNABLE TO
	RUN ANY ADDONS WHICH DO NOT ALSO COMPLY WITH THIS PRIVACY SETTING. Be aware that if you choose this option, you are acknowledging
	that Coranto's creators bear no responsibility (and have no means) to contact you should a bug or security hole be found in the
	script, nor to provide you with support for the script's operation. You agree that it is your own responsibility to regularly
	check the News section of our site, and also the forum section where you may find news on new releases, bugs, etc.
EOSENTANCE
q~Please choose your privacy settings~
  => q~Kies uw Privacy instellingen~,
q~Public~
  => q~Publiek~,
q~Private~
  => q~Prive~,
q~Version Checking?~
  => q~Versie Controleren?~,
q~Set this to 'Yes' if you would like an image to be displayed on the main page indicating the version number of the most up to date stable release of Coranto.~
  => q~Zet op 'Yes' indien u een afbeelding met daarop het versienummer van de meest up-to-date stabiele versie op de Coranto hoofdpagina wilt.~,
q~Urgent Notification?~
  => q~Urgente Melding?~,
q~Set this to 'Yes' if you'd like us to notify you of important news (bug fixes, new releases, etc.). These news will automatically appear inside your Coranto Administration View. During connection some simple stats (such as version number, and win/unix server) might be transmitted to the Coranto site for statistical analysis. No private info (name, email etc) will be collected at all.~
  => q~Zet dit op 'Yes' indien u op de hoogte gehouden wenst te worden van belangrijk nieuws (bux fixes, nieuwe versies, enz.). Dit nieuws zal automatisch in uw Coranto Administratie Scherm zichtbaar zijn. Tijdens connectie worden enkele gegevens, zoals versienummer en het type server verzonden aan de Coranto site voor een statistische analyse. Geen persoonlijke informatie (naam, email, enz.) zullen worden verzonden.~,
q~File Paths~
  => q~Bestandspaden~,
q~It looks like the absolute path to the directory where coranto.cgi is located in is <b>[_1]</b>.~
  => q~Volgens Coranto is het absolute pad naar de map waar coranto.cgi is opgeslagen <b>[_1]</b>.~,
q~This guess is accurate 95% of the time. Please refer to the setup documentation for how to change this path if you are absolutely certain that the absolute path to your directory is something different.~
  => q~Deze gok is 95% van zijn tijd juist. Kijk in de setup documentatie hoe u dit pad kunt wijzigen indien u er zeker van bent dat het absolute pad naar uw map iets anders is.~,
q~Unfortunately, Coranto could not automatically determine the absolute path to where coranto.cgi is located. You can still continue with the setup, but please refer to the setup documentation for how to specify this path. If you are not sure what the path is, please contact your host.~
  => q~Helaas, Coranto is er niet in geslaagd automatisch het pad naar de map te bepalen waar coranto.cgi is opgeslagen. U kunt wel verder gaan met de installatie, maar kijk in de setup documentatie hoe u dit pad juist kunt instellen. Indien u niet zeker bent wat het pad is, neem dan contact op met uw host.~,
q~In the boxes below, please enter the absolute paths for the two different Coranto directories: <b>News Files</b> and <b>Archive Files</b>. You must enter <b>absolute paths</b> here, not URLs. (Use forward / slashes, even on Windows servers, and do not include a trailing slash.) It is possible to change these settings once you have completed the setup as well.~
  => q~Typ de absolute paden naar de verschillende Coranto mappen in de velden hieronder. <b>Nieuws bestanden</b> en <b>Archief bestanden</b>. U moet hier <b>absolute paden</b> invoeren, geen URLs. (Gebruik forward / slashes, ook op Windows servers, en sluit niet af met een slash.) Het is mogelijk deze paden te wijzigen wanneer u de installatie heeft afgerond.~,
q~News Files Path~
  => q~Nieuws Bestanden Pad~,
q~Absolute path to the directory where you'd like the news files -- the ones to be used on your web pages -- to be generated by default~
  => q~Absoluut pad naar de map waar u uw nieuwsbestanden - de bestanden zichtbaar op uw website - wenst te genereren.~,
q~Archive Files Path~
  => q~Archief Bestanden Pad~,
q~Absolute path to the directory where you'd like news archive to be generated by default. Often the same as the News File path~
  => q~Absoluut pad naar de map waar u uw nieuwsarchief bestanden wenst te genereren. Vaak hetzelfde als het Nieuws Bestanden pad.~,
q~Additional File Paths~
  => q~Overige Bestanden Paden~,
q~Coranto has discovered that some necessary folders doesn't exist at their default locations, see details below. Please verify that the folders exists and has the right permissions (CHMOD settings) or specify new paths below.~
  => q~Coranto heeft ontdekt dat enkele benodigde mappen niet bestaan op de zojuist ingestelde paden, zie details hieronder. Controleer dat de mappen bestaan met de juiste rechten (CHMOD instellingen) of wijzig de paden hieronder.~,
q~Continue Setup~
  => q~Vervolg Installatie~,
  
#SECTION: Page 1 error messages
q~This script appears to have already been set up. If you'd like to go through set up again, re-upload the original nsettings.cgi file.~
  => q~Het lijkt erop dat het script al geïnstalleerd is. Indien u nogmaals de installatie wenst uit te voeren, her-upload dan het originele nsettings.cgi-bestand.~,
q~If you do not agree to the license conditions, please delete the Coranto files from your server.~
  => q~Indien u niet accoord gaat met de licentieovereenkomst, verwijder dan de Coranto bestanden van uw server.~,
q~You must enter paths for both directories.~
  => q~U moet de paden naar beide mappen invoeren.~,
q~Could not locate directory <b>[_1]</b>~
  => q~Kan map <b>[_1]</b> niet vinden.~,
q~Could not locate file <b>[_1]</b>. The file does not appear to exist. Verify that this file is where it should be.~
  => q~Kan bestand <b>[_1]</b> niet vinden. Het lijkt erop dat het bestand niet bestaat. Controleer of het bestand is waar het moet zijn.~,
q~Could not read file <b>[_1]</b>. The file appears to exist but is not readable. Check file permissions.~
  => q~Kan het bestand <b>[_1]</b> niet lezen. Het lijkt erop dat het bestand bestaat, maar niet leesbaar is. Controleer de bestandspermissies.~,
q~Could not write to file <b>[_1]</b>. The file appears to exist but is not writable. Check file permissions.~
  => q~Kan niet naar het bestand <b>[_1]</b> schrijven. Het lijkt erop dat het bestand bestaat, maar niet beschrijfbaar is. Controleer de bestandspermissies.~,
q~Could not create a new file in your News Files directory ([_1]). Check permissions on this directory.~
  => q~Kan geen nieuw bestand in uw Nieuwsbestanden map ([_1]) aanmaken. Controleer de permissies van de map.~,
q~Whilst testing that all necessary files could be written to, Coranto encountered some errors. Details on the errors are below. Errors are probably caused either by incorrect paths, which you can correct in the boxes below, or incorrect file permissions (CHMOD settings).~
  => q~Tijdens de controle of alle benodigde bestanden beschreven kunnen worden, heeft Coranto een aantal fouten gevonden. Details vindt u hieronder. De fouten worden waarschijnlijk veroorzaakt door onjuiste paden, welke u kunt corrigeren in de velden hieronder, of door onjuiste bestandspermissies (CHMOD instellingen).~,
  
#SECTION: Page 2
q~File and Path Tests~
  => q~Bestand en Paden Tests~,
q~Testing paths and file permissions... all tests were successful. The paths you entered seem correct, as do file permissions.~
  => q~Test paden en bestandspermissies ... alle tests waren succesvol. De door u ingevoerde paden lijken juist te zijn, evenals de bestandspermissies.~,
q~Create New User~
  => q~Creëer Nieuwe Gebruiker~,
q~Please choose the username and password you'd like to use to log in to Coranto. By default, the username you choose will appear beside your news posts. This user will be your Super-Admin user, and will be the only user with authority to remove standard Admin-level users.~
  => q~Kies de gebruikersnaam en wachtwoord waarmee u wenst in te loggen in het Coranto systeem. Standaard zal deze gebruikersnaam naast uw nieuwsposts verschijnen. Deze gebruiker wordt de Super-Administrator en is de enige gebruiker met de mogelijkheid standaard Administrators te verwijderen.~,
q~Usernames may contain only letters, numbers, and underscores (_).~
  => q~Gebruikersnaam kan alleen bestaan uit letters, nummers en underscores (_).~,
q~Your password must be a minimum of five characters. A randomly-generated secure password is suggested in the box above.~
  => q~Uw wachtwoord moet uit minimaal vijf tekens bestaan. Een automatisch gegenereerde wachtwoord-suggestie wordt in het veld hierboven weergegeven.~,
q~E-mail~
  => q~E-mail~,
q~Your email address.~
  => q~Uw email adres.~,
q~Language Settings~
  => q~Taal Instellingen~,
q~This setting will allow you to have a global default language when a user logs in to Coranto but the prefered language can be changed individually user by user as well. The translations are kindly provided by Coranto users.~
  => q~Deze instelling geeft u de mogelijkheid een standaard taal weer te geven wanneer een gebruiker in Coranto inlogt, maar kan per gebruiker individueel gewijzigd worden. De vertalingen worden u aangeboden door Coranto gebruikers.~,
q~Choose your prefered language for Coranto~
  => q~Kies uw voorkeurstaal voor Coranto~,

#SECTION: Page 2 error messages
q~Username &quot;[_1]&quot; contains illegal characters. Only letters, numbers, and underscores are permitted in usernames.~
  => q~Gebruikersnaam &quot;[_1]&quot; bestaat uit niet- toegestane tekens. Alleen letters, nummers en underscores zijn toegestaan in gebruikersnamen.~,
q~Usernames have to be at least 3 characters long.~
  => q~Gebruikersnaam moet uit minimaal 3 tekens bestaan.~,
q~Passwords have to be at least 5 characters long.~
  => q~Wachtwoord moet uit minimaal 5 tekens bestaan.~,
q~You must enter a valid Email address.~
  => q~U moet een geldig E-mail adres invoeren.~,

#SECTION: Page 3
q~Account '[_1]' Created~
  => q~Account '[_1]' Created~,
q~Please remember your password. You will need it to use Coranto in the future, and it is not easily reset if you forget it.~
  => q~Onthoud uw wachtwoord. U heeft deze nodig bij het gebruik van Coranto en is niet eenvoudig te resetten indien u deze vergeet.~,
q~To get Coranto started quickly, some of the more essential settings are organized into a single page below. All these settings will be available in Coranto's Administration section in the future, and you will be able to change anything you enter here.~
  => q~Om Coranto snel werkend te krijgen, zijn enkele essentiële instellingen samengevoegd in een enkele pagina hieronder. Al deze instellingen zijn beschikbaar in het Coranto Administratiescherm in de toekomst. Hier heeft u de mogelijkheid de instellingen te wijzigen.~,
q~After you click the button below, there may be a delay of about thirty seconds as a basic security check is performed and setup continues at the Coranto site.~
  => q~Nadat u op de knop hieronder drukt, kan er een vertraging oplopend tot ongeveer dertig seconden ontstaan omdat er een standaard veiligheidscontrole plaatsvindt voordat u verder kunt gaan naar de Coranto site.~,
q~Your Site~
  => q~Uw site~,
q~Continue Setup (Almost finished!)~
  => q~Vervolg installatie (Bijna klaar!)~,
  
#SECTION: Page 4, Setup Complete
q~Setup Complete~
  => q~Installatie Afgerond~,
q~If you need any further assistence with Coranto, be welcome to the Coranto Unofficial Site Support Forums where you will find help and tutorials: [_1]~
  => q~Indien u verdere assistentie bij Coranto wenst, heten wij u welkom op het Coranto Unofficial Site support Forum waar u veel hulp en informatie vindt:  [_1]~,
q~Setup is complete.<p>Click [_1]here[_2] to continue~
  => q~Installatie is afgerond.<p>Klikk [_1]hier[_2] om verder te gaan.~,



#####################################################################################
#HEADER: General Sentances
# If your language needs a different character set, you may have to change this tag.
q~<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">~
  => q~<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">~,
# Coranto's SQL support check
q~You have tried to enable Coranto's SQL support, but DBI could not be loaded. It has been automatically disabled.~
  => q~U heeft geprobeerd Coranto's SQL support in te schakelen, maar de DBI kan niet geladen worden en is automatisch uitgeschakeld.~,
# Powered by Coranto
q~Powered by [_1]~
  => q~Powered by [_1]~,


    
#####################################################################################
#HEADER: Login & Logout Messages
q~Coranto Login (Authorized Users Only)~
  => q~Coranto Login (Alleen geautoriseerde gebruikers)~,
q~Password~
  => q~Wachtwoord~,
q~Remember Password?~
  => q~Wachtwoord onthouden?~,
q~Username~
  => q~Gebruikersnaam~,
q~Language~
  => q~Taal~,
q~User Setting~
  => q~Gebruikers Instellingen~,
q~Global Site Setting~
  => q~Algemene Site Instellingen~,
q~Log In~
  => q~Inloggen~,
q~Your account has been disabled. Contact the administrator of this site for more information.~
  => q~Uw account is uitgeschakeld. Neem contact op met de Administator van deze site voor meer informatie.~,
q~Login Failure~
  => q~Loginfout~,
q~The information you entered is incorrect. Please use the link below and try again.~
  => q~De informatie die u ingevoerd heeft is onjuist. Klik op de link hieronder om nogmaals te proberen.~,
q~You have been logged out.~
  => q~U bent uitgelogd.~,



#####################################################################################
#HEADER: Main Page
q~Main Page~
  => q~Hoofdpagina~,
q~Submit News~
  => q~Nieuws toevoegen~,
q~Create a new news item and add it to the database.~
  => q~Creëer een nieuwsbericht en voeg deze toe aan de database.~,
q~Build News~
  => q~Bouw Nieuws~,
q~Generate news HTML files from the database. News must be built before any new or changed items will appear on your site.~
  => q~Genereer nieuws HTML bestanden uit de database. Nieuws moet gebouwd worden voordat nieuwe of gewijzigde items zichtbaar zijn op uw website.~,
q~Modify News~
  => q~Wijzig Nieuws~,
q~Remove or edit existing news items.~
  => q~Verwijder of wijzig bestaande nieuwsberichten.~,
q~You may only edit items that you have previously submitted.~
  => q~U mag alleen nieuwsberichten wijzigen die u zelf hiervoor heeft toegevoegd.~,
q~You may edit any news items, including those submitted by others.~
  => q~U mag alle nieuwsberichten wijzigen, inclusief berichten toegevoegd door anderen.~,
q~User Info~
  => q~Gebruikers Info~,
q~Change information associated with your user account, such as your password.~
  => q~Wijzig gebruikersinformatie welke te maken heeft met uw account, zoals uw wachtwoord.~,
q~Administration~
  => q~Administratie~,
q~Configure Coranto and change all available settings.~
  => q~Stel Coranto in en wijzig alle beschikbare instellingen.~,
q~Log Out~
  => q~Log Uit~,
q~Log out of Coranto. You will have to enter your username and password to gain access again.~
  => q~Log uit Coranto. Indien u weer wenst in te loggen moet u uw gebruikersnaam en wachtwoord invoeren.~,

#SECTION: Misc information
q~You are logged in as user [_1].~
  => q~U bent ingelogd als gebruiker [_1].~,
q~Back To [_1]~
  => q~Terug naar [_1]~,
q~Your Version~
  => q~Uw versie~,
q~Current Version~
  => q~Huidige versie~,
q~Unofficial Coranto Web Site~
  => q~Onofficiële Coranto Web Site~,
q~<b>Download Upgrade</b> (if available)~
  => q~<b>Download Upgrade</b> (indien beschikbaar)~,



#####################################################################################
#HEADER: Submit News
q~Submit~
  => q~Verzend~,
q~Reset~
  => q~Wis~,
q~Date~
  => q~Datum~,
q~Save Changes~
  => q~Sla wijzigingen op~,
q~News Saved~
  => q~Nieuws Opgeslagen~,
q~The submitted news item has been added to the database.~
  => q~Het toegevoegde nieuws is opgeslagen in de database.~,
q~<b>Build News has been run automatically</b>, so the item should be visible on your site immediately.~
  => q~<b>Nieuws is automatisch opgebouwd</b>, Het bericht is direct zichtbaar op uw website.~,
q~<b>You must build news</b> before this item will be visible on your site.~
  => q~<b>U moet eerst het nieuws opbouwen</b> voordat het zichtbaar wordt op uw website.~,
q~News Built~
  => q~Nieuws Opgebouwd~,
q~News HTML files have been built from the database. This means that your site should now reflect any new or changed items.~
  => q~Nieuws HTML bestanden zijn opgebouwd uit de database. Dit betekent dat op uw site de wijzigingen direct zichtbaar moeten zijn.~,



#####################################################################################
#HEADER: Modify News Page
# Used as: Search for (text box) in field (select box).
q~Search for~
  => q~Zoek naar~,
q~in field~
  => q~in veld~,
q~(All Fields)~
  => q~(Alle Velden)~,
# Used as: Jump to: (date select boxes)
q~Jump to~
  => q~Ga naar~,
# Used as a verb, not a noun. (it's a label on a button)
q~Preview~
  => q~Voorbeeld~,
# Also used as a verb.
q~Search~
  => q~Zoek~,
# Again, a button label.
q~Go~
  => q~Ga~,
# An abbreviation for Delete, used to label the checkbox column in Modify News.
q~Del.~
  => q~Verw.~,
q~Edit~
  => q~Wijzig~,
q~User~
  => q~Gebruiker~,
q~Category~
  => q~Categorie~,
q~Delete Checked Items~
  => q~Verwijder aangevinkte berichten~,
q~Next Page~
  => q~Volgende Pagina~,
q~Previous Page~
  => q~Vorige Pagina~,
q~First Page~
  => q~Eerste Pagina~,
q~No items could be found.~
  => q~Geen berichten gevonden.~,
q~Changes Saved~
  => q~Wijzigingen opgeslagen~,
q~Your changes to this item have been saved. Now, close this window to return to Modify News.~
  => q~Uw wijzigingen aan dit bericht zijn opgeslagen. U kunt dit venster sluiten om terug te keren naar Wijzig Nieuws.~,
q~<b>Build News has been run automatically</b>, so your changes should be visible on your site immediately.~
  => q~<b>Nieuw automatisch opgebouwd</b>, de wijzigingen zijn direct zichtbaar op uw website.~,
q~<b>You must build news</b> before your changes will be visible on your site.~
  => q~<b>U moet eerst nieuws opbouwen</b> voordat deze zichtbaar worden op uw site.~,


#####################################################################################
#HEADER: User Info
q~Change Password~
  => q~Wijzig Wachtwoord~,
q~Leave the password fields blank if you do not want to change the password.~
  => q~Laat de wachtwoord velden leeg indien u het wachtwoord niet wenst te wijzigen.~,
q~Leave the password fields blank if you don't want to change your password.~
  => q~Laat de wachtwoord velden leeg indien u het wachtwoord niet wenst te wijzigen.~,
q~Current Password~
  => q~Huidig Wachtwoord~,
q~New Password~
  => q~Nieuw Wachtwoord~,
q~Verify New Password~
  => q~Verifiëer Nieuw Wachtwoord~,
q~Edit User Profile~
  => q~Wijzig Gebruikersprofiel~,
q~The current password that you entered is not correct.~
  => q~Het huidige wachtwoord door u ingevoerd is incorrect.~,
q~The passwords entered do not match. Please type in your new password again, and retype it in the "Verify Password" field.~
  => q~De wachtwoorden komen niet overeen. Typ uw nieuwe wachtwoord overnieuw in en hertype deze in het "Verifiëer Wachtwoord" veld.~,
q~Passwords must be at least 5 characters long.~
  => q~Wachtwoord moet uit minimaal 5 tekens bestaan.~,
q~User Info Saved~
  => q~Gebruikersinformatie Opgeslagen~,
q~Changes to your user info have been saved. If you changed your password, you will be asked to log in again once you move to another page. If you changed other information, you may need to build news before changes appear on your site.~
  => q~Wijzigingen aan Gebruikersinformatie zijn opgeslagen. Indien u uw wachtwoord gewijzigd hebt, wordt u gevraagd overnieuw in te loggen voordat u een andere pagina kunt bezoeken. Indien u andere informatie hebt gewijzigd, kan het zijn dat u het nieuws moet herbouwen voordat de wijzigingen zichtbaar zullen zijn op uw site.~,



#####################################################################################
#HEADER: Administration Page
q~Change Settings~
  => q~Wijzig instellingen~,
q~Change a wide variety of program settings, including file paths.~
  => q~Wijzig een groot aantal programma instellingen, inclusief de bestandspaden.~,
q~Manage Profiles~
  => q~Beheer Profielen~,
q~Create, edit, or remove news profiles, which control how news is selected from the database and published or displayed.~
  => q~Creëer, wijzig of verwijder nieuwsprofielen, welke bepalen hoe nieuws uit de database geselecteerd en gepubliceerd wordt.~,
q~Edit Users~
  => q~Bewerk Gebruikers~,
q~Add new user accounts or remove/edit existing ones.~
  => q~Voeg nieuwe gebruikersaccounts toe of wijzig/verwijder bestaande accounts.~,
q~Edit News Styles~
  => q~Beheer Nieuws Stijlen~,
q~Create, edit, or remove news styles, which control what news looks like (that is, what HTML is used to display news items) on your site.~
  => q~Creëer, wijzig of verwijder nieuws stijlen, welke bepalen hoe het nieuws er uit ziet (hoe HTML wordt gebruikt om nieuws items weer te geven) op uw website.~,
q~Edit User Fields~
  => q~Wijzig Gebruikers Velden~,
q~Create, edit, or remove user information fields (the fields users see in User Info).~
  => q~Creëer, wijzig of verwijder gebruikersinformatievelden (de velden zichtbaar in Gebruikers Informatie).~,
q~Edit News Fields~
  => q~Wijzig Nieuws Velden~,
q~Create, edit, or remove news fields (the fields on Submit and Modify News forms).~
  => q~Creëer, wijzig of verwijder nieuwsvelden (de velden op de Nieuws Toevoegen Wijzig Nieuws pagina's).~,
q~Date &amp; Time Settings~
  => qq~Date &amp; Tijdsinstellingen~,
q~Change settings involving times, like time zones and date formats.~
  => q~Wijzig instellingen welke te maken hebben met tijd, zoals tijdszones en datuminstellingen.~,
q~Addon Manager~
  => q~Addon Beheer~,
q~Enable, disable, or view information on installed addons, and download new addons.~
  => q~In- en Uitschakelen of informatie inzien van geïnstalleerde addons. Tevens nieuwe addons downloaden.~,
q~Edit File Paths~
  => q~Wijzig Bestands Paden~,
q~Change settings regarding all the filepaths.~


  => q~Wijzig instellingen van alle bestandspaden.~,
q~Full Rebuild~
  => q~Volledig Herbouwen~,
q~Rebuild all news items. (Build News tries to build only changed items.) Necessary if you edit files manually.~
  => q~Herbouw alle nieuwsartikelen. (Bouw Nieuws bouwt alleen de gewijzigde artikelen). Nodig indien u bestanden handmatig gewijzigd hebt. ~,
q~You are not authorized to access administrative functions.~
  => q~U hebt geen toestemming administratieve functies te wijzigen.~,


#####################################################################################
#HEADER: General Settings Page
q~Change Settings~
  => q~Wijzig Instellingen~,
q~General Settings~
  => q~Algemene Instellingen~,
q~Site Name~
  => q~Website Naam~,
q~The name of your site. This will be displayed on Coranto script pages.~
  => q~De naam van uw website. Dit wordt weergegeven op de Coranto script pagina's.~,
q~Site Link~
  => q~Website Link~,
q~If you'd like a &quot;Back to Your Site&quot; link on Coranto script pages, enter a URL here. Otherwise, leave blank.~
  => q~Indien u een &quot;Terug naar uw Site&quot; link op de Coranto script pagina's, plaats hier uw URL. Anders kunt u dit veld leeglaten.~,
q~Super Administrator~
  => q~Hoofd Administrator~,
q~Choose who the Super Administrator should be. Since you can see this box you are either the current Super Admin or there isn't a Super Admin set.~
  => q~Kies wie Hoofd Administrator moet zijn. Omdat u dit kan zien bent u of de huidige Hoofd Administrator of er is geen Hoofd Administrator ingesteld.~,
q~Language Global Settings~
  => q~Taal Instellingen~,
q~Choose the language for your site. This is valid for all users without a specific setting (i.e. user-settings overule this parameter).~
  => q~Kies de taal voor uw site. Deze instelling is geldig voor alle gebruikers zonder specifieke instellingen (i.e. gebruikersinstellingen overheersen deze parameter).~,
q~Option Pages Layout~
  => q~Optie Pagina's Layout~,
q~Choose the type of layout you want to use when presenting option overview pages like the Main and Admin pages, either the normal two box column layout or the one option per line (the 'Facelift') layout.~
  => q~Kies het type layout dat u wenst te gebruiken als overzicht van de Hoofd- en Administratiepagina's, of de normale tweekoloms indeling of de enkele koloms layout.~,
q~Option Sections Layout~
  => q~Optie Sectie Layout~,
q~Some option pages have the options grouped together in logical sections, choose the type of header layout you want to use above such a group of options.~
  => q~Sommige optiepagina's hebben de opties gegroepeerd in logische secties. Kies het type kop dat u wilt gebruiken dat u wilt boven zo'n groep opties.~,
q~Two Box Column Layout~
  => q~Tweekoloms Layout~,
q~One Option Per Line Layout~
  => q~Enkelkoloms Layout~,
q~Show a headline above each option section~
  => q~Toon een Kop boven elke optiesectie~,
q~Create a visual separation between the sections~
  => q~Creëer een visuele separatie tussen de secties~,
q~No header or separation between the sections~
  => q~Geen kop of separatie tussen de secties~,
q~Privacy~
  => q~Privacy~,
q~Public or Private~
  => q~Publiek of Prive~,
q~Set this to 'Public' if you would like to have a version check image on the main page, be notified of new releases of Coranto, enable links to the Coranto website and documentation, or allow all addons to work regardless of their privacy status. Set this to 'Private' if you are running Coranto on a private network with no connection to the Internet, or if you would like the highest level of privacy available. Note that on the 'Private' setting, you will find links to our server and documentation hosted there are disabled, and you will not be able to use addons which haven't been certified as compliant with your privacy setting by their authors~
  => q~Stel in op 'Publiek' indien u een versie check afbeelding op de hoofdpagina wilt, en door Coranto op de hoogte gehouden wilt worden, of alle addons werkend wil hebben onafhankelijk van de privacy status. Stel dit in op 'Prive' indien u Coranto op een privenetwerk zonder verbinding naar het internet heeft of de hoogste waarde van privacy wenst. Met de 'Private' instelling zijn links naar onze server en documentatie uitgeschakeld. Ook kunt u de addons zonder Private Compliant certificaat niet gebruiken. ~,
q~Version Check Image~
  => q~Versie Check Afbeelding~,
q~Set this to 'Yes' if you would like an image to be displayed on the main page indicating the current version number.~
  => q~Stel dit in op 'Yes' indien u op de homepagina een afbeelding met daarop het huidige versienummer wenst.~,
q~Urgent Notification~
  => q~Urgente Notificatie~,
q~Set this to 'Yes' if you'd like us to notify you of important news (bug fixes, new releases, etc.). These news will automatically appear inside your Coranto Administration View.~
  => q~Stel in op 'Yes' indieun u wenst dat wij u op de hoogte houden van nieuws (bug fixes, nieuwe versies, enz.). Dit nieuws verschijnt automatisch op het Coranto Administratie Venster.~,
q~Misc~
  => q~Overige~,
q~Enable XHTML BR~
  => q~Inschakelen XHTML BR~,
q~If set to <b>Yes</b>, newlines in news posts will be replaced with &lt;br /&gt;, instead of the usual &lt;br&gt;.~
  => q~Indien ingesteld op <b>Yes</b>, nieuwe regels in nieuwsartikelen worden vervangen door &lt;br /&gt;, in plaats van het gebruikelijke &lt;br&gt;.~,
q~Modify News Link','Do you want the Modify News Edit link to open in the current window, instead of a new one?~
  => q~Wijzig Nieuws Link','Wilt u de Wijzig Nieuws Link openen in het huidige venster in plaats van een nieuwe?~,
q~Enable SQL~
  => q~SQL inschakelen~,
q~Do you want to allow Coranto to work with SQL-based addons such as CorantoSQL~
  => q~Wilt u Coranto instellen om met SQL-gebaseerde addons als CorantoSQL samen te werken?~,
q~Debug Options~
  => q~Debug Opties~,
q~Show Config~
  => q~Toon Config~,
q~Do you want to allow you to display the configuration when debugging? This can be a security risk, so be careful. If not sure, set it to <b>No</b>~
  => q~Wilt u de configuratie zien tijdens het debuggen? Dit kan een veiligheidsrisico zijn, dus blijf voorzichtig. Indien niet zeker, zet op <b>No</b>~,
q~Show Newsdat.txt~
  => q~Toon Newsdat.txt~,
q~Do you want to allow you to display the contents of newsdat.txt when debugging? This can be a security risk, so be careful. If not sure, set it to <b>No</b>~
  => q~Wilt u de inhoud van newsdat.txt zien tijdens het debuggen? Dit kan een veiligheidsrisico zijn, dus blijf voorzichtig. Indien niet zeker, zet op <b>No</b>~,
q~Show Addons~
  => q~Toon Addons~,
q~Do you want to allow you to display which addons you have installed when debugging? This can be a security risk, so be careful. If not sure, set it to <b>No</b>~
  => q~Wilt u zien welke addons geïnstalleerd zijn tijdens het debuggen? Dit kan een veiligheidsrisico zijn, dus blijf voorzichtig. Indien niet zeker, zet op  <b>No</b>~,

#SECTION: Advanced Settings
q~Advanced Settings~
  => q~Geavanceerde instellingen~,
q~Build News Automatically (Submit)~
  => q~Bouw Nieuws Automatisch (Toevoegen)~,
q~If set to Yes, Coranto will automatically build news when you submit news. This results in changes being visible to users immediately after making them.~
  => q~Indien ingeschakeld zal Coranto automatisch het nieuws bouwen wanneer u een nieuwsartikel toevoegt. Deze wijzigingen zijn voor gebruikers direct zichtbaar.~,
q~Build News Automatically (Modify)~
  => q~Bouw Nieuws Automatisch (Wijzig)~,
q~If set to Yes, Coranto will automatically build news when you modify a news item. This means that changes will be visible as soon as you make them, but it also means that things may be slow if you modify several news items~
  => q~Indien ingeschakeld zal Coranto automatisch het nieuws bouwen wanneer u een nieuwsartikel wijzigt. Deze wijzigingen zijn voor gebruikers direct zichtbaar.~,
q~Archive HTML file extension~
  => q~Archief HTML extentie~,
q~The extension that will be given to to archive HTML files. (No period, just the extension.) For instance, <b>html</b> or <b>shtml</b>. You will need to perform a full rebuild for changes to this setting to take effect.~
  => q~De extentie dat wordt gegeven aan een archief HTML file. Zonder punt, alleen de extentie. Bijvoorbeeld, <b>html</b> of <b>shtml</b>. U moet een volledige herbouw doen voordat de wijzigingen zichtbaar zijn.~,
q~Items Per Modify News Page~
  => q~Aantal Artikelen Wijzig Nieuws Pagina ~,
q~The number of news items that are displayed on each Modify News page.~
  => q~Het aantal nieuwsartikelen dat weergegeven wordt op iedere Wijzig Nieuws pagina.~,
q~Default Search Field at Modify News Page~
  => q~Standaard Zoek Veld op Wijzig Nieuws Pagina~,
q~Choose which field that should be selected by default for the search box when you enter the Modify News page.~
  => q~Kies welk veld standaard geselecteerd staat in het zoekveld van de Wijzig Nieuws pagina.~,



#####################################################################################
#HEADER: General Edit Profiles Page
q~Current Profiles~
  => q~Huidige Profielen~,
q~Archiving is currently <b>[_1]</b>.~
  => q~Archiveren is <b>[_1]</b>.~,
q~This profile is not filtered by time or number.~
  => q~Dit profiel wordt niet gefilterd door tijd of aantal.~,
q~A maximum of <b>[quant,_1,day,days,]</b> [bool,_2,or,] <b>[quant,_3,item,items,]</b> will be included in this profile.~
  => q~Een maximum van <b>[quant,_1,dag,dagen,]</b> [bool,_2,of,] <b>[quant,_3,artikel,artikelen,]</b> worden in dit profiel ingevoegd.~,
q~Items must be older than <b>[quant,_1,day,days]</b>.~
  => q~Artikelen moeten ouder zijn dan <b>[quant,_1,dag,dagen]</b>.~,
q~This profile is set to skip the first <b>[quant,_1,item,items]</b>.~
  => q~Dit profiel is ingesteld om <b>[quant,_1,artikel,artikelen]</b> over te slaan.~,
q~Profile type~
  => q~Profieltype~,
# Description label of a Standard Profile
q~Standard Profile~
  => q~Standaard Profiel~,
q~Profile &quot;[_1]&quot; is currently <b>disabled</b>.~
  => q~Profiel &quot;[_1]&quot; is <b>uitgeschakeld</b>.~,
q~Edit General Settings~
  => q~Wijzig Algemene Instellingen~,
q~Edit Archiving Settings~
  => q~Wijzig Archivering Instellingen~,
q~Profile Name~
  => q~Profiel Naam~,
q~Profile names may only contain letters, numbers, and underscores (_). As well, while uppercase letters are allowed, use of lowercase letters only is recommended to avoid confusion. (<b>After creating a profile, you must edit & enable it.</b>)~
  => q~Profielnamen mogen alleen letters, nummers en underscores(_) bevatten. Hoofd- en kleine letters zijn toegestaan maar om verwarring te voorkomen wordt aanbevolen alleen kleine letters te gebruiken. (<b>Na het creëeren van het profiel moet deze worden gewijzigd en geactiveerd.</b>)~,
q~Create Profile~
  => q~Creëer Profiel~,
q~Invalid profile information.~
  => q~Onjuiste profiel informatie.~,
q~Archiving Settings for &quot;[_1]&quot;~
  => q~Archivering ingesteld voor &quot;[_1]&quot;~,
q~The File Path you have specified (<strong>[_1]</strong>) does not seem to exist, are you sure it is correct?~
  => q~Het bestandspad dat u opgegeven heeft (<strong>[_1]</strong>) lijkt niet te bestaan. Weet u zeker dat dit correct is?~,
q~Invalid profile &quot;[_1]&quot;.~
  => q~Onjuist Profiel &quot;[_1]&quot;.~,
q~Profile name &quot;[_1]&quot; contains illegal characters. Only letters, numbers, and underscores are permitted in profile names.~
  => q~Profiel naam &quot;[_1]&quot; bevat onjuiste tekens. Alleen letters, nummers en underscores zijn toegestaan.~,
q~Profile [_1] already exists.~
  => q~Profiel [_1] bestaat al.~,
q~Please enter a profile name.~
  => q~Voer profielnaam in.~,
q~Are you sure you would like to delete profile <strong>[_1]</strong>?~
  => q~Weet u zeker dat u profiel <strong>[_1]</strong> wilt verwijderen?~,


#####################################################################################
#HEADER: Edit Specific Profile Settings Page
q~The display name you want to use for this profile. Default is the profile name.~
  => q~De weer te geven naam u wilt gebruiken voor dit profiel. Standaard is dit de profielnaam.~,
q~File Name~
  => q~Bestandsnaam~,
q~The name of the text file which this profile will generate (example: [_1].txt)~
  => q~De naam van het tekstbestand dat dit profiel genereert (example: [_1].txt)~,
q~File Path~
  => q~Bestandspad~,
q~The absolute path to the directory in which files will be created, with no trailing slash. <b>Leave blank</b> to use the default HTML Files path (currently [_1]).~
  => q~Het absolute pad naar de map waarin de files worden geplaatst, zonder slash aan het eind. <b>Laat leeg</b>om het huidige HTML bestanden pad te gebruiken. (currently [_1]).~,
q~Filter By Time~
  => q~Filter Door Tijd~,
q~The number of days after which news will be considered old. News posted more than the specified number of days ago will not be included in this profile (though it will be archived, if that is enabled). <b>Leave blank</b> if you do not want to filter by time.~
  => q~Het aantal dagen waarna het nieuws als oud beschouwd wordt. Nieuws ouder dan het gespecificeerd aantal dagen geleden wordt niet door dit profiel gebouwd(maar wordt gearchiveerd, indien ingeschakeld). <b>Laat leeg</b> indien u niet door tijd wenst te filteren.~,
q~Filter By Number~
  => q~Filter door Aantal~,
q~The maximum number of news items that will be included in this profile. For instance, if you set this to 10, then the 11th-newest item will not be included (though it will be archived, if that is enabled). <b>Leave blank</b> if you do not want to filter by number.~
  => q~Het maximum aantal nieuwsberichten dat in dit profiel wordt gebruikt. Bijvoorbeeld als u het aantal instelt op 10, dan wordt het op 11 na nieuwste bericht niet meer geplaatst (maar wordt gearchiveerd, indien ingeschakeld).~,
q~Skip Days~
  => q~Sla Dagen Over~,
q~If you want to skip news items rather than start with the most recent item, set this to the number of days to be skipped. For instance, if you set this to 3, the first item in this profile will be over 3 days old. <b>Leave blank</b> if you do not want to skip items by days.~
  => q~Indien u nieuwsberichten over wilt slaan, in plaats van met de nieuwste te starten, stel dit in op het aantal dagen dat overgeslagen moet worden. Bijvoorbeeld, als u dit instelt op 3, het eerste bericht dat weergegeven wordt is meer dan 3 dagen oud. <b>Laat leeg</b> indien u geen items wilt overslaan.~,
q~Skip Items~
  => q~Sla Berichten Over~,
q~Headlines~
  => q~Nieuws Koppen~,
q~If you want to skip news items rather than start with the most recent item, set this to the number of items to be skipped. For instance, if you set this to 3, the first item in this profile will be the 4th available item. <b>Leave blank</b> if you do not want to skip items. This is applied after <b>Skip Days</b>~
  => q~Indien u nieuwsberichten over wilt slaan, in plaats van met de nieuwste te starten, stel dit in op het aantal berichten dat overgeslagen moet worden. Bijvoorbeeld, als u dit instelt op 3, het eerste bericht dat weergegeven wordt is het 4e beschikbare bericht. <b>Laat leeg</b> indien u geen items wilt overslaan.~,
q~News Style~
  => q~Nieuws Stijl~,
q~The news style to use when generating HTML. [_1]~
  => q~De nieuwsstijl te gebruiken bij het genereren van HTML. [_1]~,
q~Display Coranto Link~
  => q~Geef Coranto Link Weer~,
q~Adds a link to the Coranto home page to the end of the generated text file. With this version of Coranto, you should include a link on every page of your site that contains news items. If a page contains only headlines that link to full news items, it is exempt from the linking requirement. The default will be link turned off (as the old AmphibianWeb website is in the hands of cybersuqatters). As options, you can choose to link to the unofficial site, or to display the 'Powered by Coranto' text with no link.~
  => q~Voegt een link toe aan het einde van een gegenereerd tekstbestand. Met deze versie van Coranto dient u een link in te voegen op iedere pagina van uw site dat nieuwsberichten bevat. Indien een pagina alleen nieuwskoppen bevat, welke naar het volledige artikel linken, is deze vrijgesteld van de link-verplichting. Standaard staat de link uitgeschakeld (aangezien de oude AmphibianWeb website in handen is van cybersquatters). U kunt kiezen een link te plaatsen naar de onofficiële website of een 'Powered by Coranto' tekst zonder link te plaatsen.~,
q~No link~
  => q~Geen link~,
q~Link pointing to Unofficial Site~
  => q~Link naar de Onofficiële Site~,
q~Link pointing to Coranto Support Forum~
  => q~Link naar Coranto Support Forum~,
q~Text without link~
  => q~Tekst zonder link~,
  
#SECTION: Headlines
q~Enable Headlines~
  => q~Nieuwskoppen Aan~,
q~Creates a file called [_1] that contains the same news items as this profile does, but uses a different style. (Headline styles are generally more concise than normal styles and don't include the full news text.)~
  => q~Creëert een bestand, genaamd [_1] dat dezelfde nieuwsberichten als dit profiel bevat, maar een andere stijl gebruikt. Nieuwskoppen stijlen zijn meestal bondiger dan normale stijlen en bevatten niet de volledige nieuwstekst. ~,
q~Headlines Style~
  => q~Nieuwskoppen Stijl~,
q~The news style used when creating headlines. Only necessary if headlines are enabled. [_1]~
  => q~De gebruikte nieuwsstijl bij het creëeren van nieuwskoppen. Alleen nodig indien nieuwskoppen is ingeschakeld. [_1]~,
q~Number of Headlines~
  => q~Aantal Nieuwskoppen~,
q~The maximum number of news items headlines will be generated for. Useful for including headlines of only the few most recent items. <b>Leave blank</b> to create headlines for all items included in this profile.~
  => q~Het maximum aantal nieuwsbericht-koppen dat gegenereerd wordt. Bruikbaar indien alleen de meest recente berichten zichtbaar moeten zijn.<b>Laat leeg</b> om koppen voor alle nieuwsberichten in dit profiel te genereren.~,
q~Headline Sort Order~
  => q~Koppen sorteervolgorde~,
q~Allows news to be sorted in an order other than the default. Note that no matter what the sort order, filtering by number will restrict the headlines to the <i>n</i> newest items.~
  => q~Zorgt ervoor dat nieuws gesorteerd wordt in een volgorde anders dan de standaard. Denk erom dat, ondanks de gekozen sorteervolgorde, filteren door middel van nummer toch de <i>n</i> nieuwste koppen kiest.~,

#SECTION: Advanced Profile Settings
q~Advanced Profile Settings~
  => q~Geavanceerde Profiel Instellingen~,
q~HTML Template~
  => q~HTML Template~,
q~To generate an HTML file containing the news from the profile, enter the name of a standard .tmpl file below. If creation of an HTML file isn't needed, as is usually the case, <b>leave this blank</b>.~
  => q~Om een HTML bestand met nieuws uit een profiel te genereren, kies de naam van een standaard .tmpl bestand hieronder. Indien het creëren van een HTML bestand niet nodig is, zoals gewoonlijk het geval is, <b>laat dit leeg</b>.~,
q~HTML User File Name~
  => q~HTML Gebruiker Bestandsnaam~,
q~The name (+ extension) of the file to be generated using the above template and the style for this profile. Only necessary if an HTML template has been specified in the previous setting.~
  => q~De naam (+extentie) van het te genereren bestand met het hierboven gekozen template en stijl voor dit profiel. Alleen nodig als een HTML template bij de vorige instelling gekozen is.~,
q~HTML File Title~
  => q~HTML Bestand Titel~,
q~The title of the generated HTML file. Only necessary if an HTML template has been specified in the previous setting.~
  => q~De titel van het te genereren HTML bestand. Alleen nodig als een HTML template bij de vorige instelling gekozen is.~,
q~Sort Order~
  => q~Sorteervolgorde~,
q~Allows news to be sorted in an order other than the default. Note that no matter what the sort order, filtering by number will restrict the profile to the <i>n</i> newest items. As well, archives always use the default sort order.'~
  => q~Zorgt ervoor dat nieuws gesorteerd wordt in een volgorde anders dan de standaard. Denk erom dat, ondaks de gekozen sorteervolgorde, filteren door middel van nummer, toch de <i>n</i> nieuwste berichten kiest. Ook gebruiken archieven altijd de standaard sorteervolgorde.~,
q~Anchor Tags~
  => q~Anker Markering~,
q~Creates &lt;a name&gt; tags with news, allowing links directly to news items. Unless you're going to be including more than one profile (that is, two or more text files) on a single HTML page, you should leave this on.~
  => q~Creëert een  &lt;a name&gt; markering bij ieder nieuwsitem, zodat het mogelijk is direct naar het nieuwsitem op een pagina te linken. Tenzij u meer dan één profiel (dus twee of meer tekstbestanden) op een enkele HTML pagina maakt, zou u dit aan moeten laten staan.~,
  
#SECTION: Sorting options
q~Default (Reverse Chronological)~
  => q~Standaard (Omgekeerd Chronologisch)~,
q~Chronological (Oldest First)~
  => q~Chronologisch (Oudste Eerst)~,
q~Alphabetical (By Subject)~
  => q~Alfabetisch (Volgens Onderwerp)~,
q~True Alphabetical (aAbBcC) (By Subject)~
  => q~Werkelijk Alfabetisch (aAbBcC)(Volgens Onderwerp)~,


    
#####################################################################################
#HEADER: Edit Specific Profile Archive Settings Page
q~General Archiving Settings~
  => q~Algemene Archiverings Instellingen~,
q~Archive Type~
   => q~Archiverings Type~,
q~_ARCHIVE_TYPE_DESCRIPTION~ # Description of the different archive types
  => <<'EOSENTANCE',
Controls if and how archiving is performed. When archiving is enabled, news items which are too old to be included in [_1] 
are placed in archives.<br><br> Set to Disabled to disable all archiving for this profile. Set to Single File to place all old items in one text file, called [_2]. 
Set to Monthly, Weekly, or Daily to create multiple archives, each holding a month's, week's, or day's news, respectively.
EOSENTANCE
q~Disabled (News will not be archived)~
  => q~Uitgeschakeld (Nieuws wordt niet gearchiveerd)~,
q~Single File~
  => q~Enkel Bestand~,
q~Monthly Archives~
  => q~Maandelijkse Archieven~,
q~Weekly Archives~
  => q~Wekelijkse Archieven~,
q~Daily Archives~
  => q~Dagelijkse Archieven~,
q~Archive File Path~
  => q~Archief Bestandspad~,
q~The absolute path to the directory in which archive files will be created, with no trailing slash. <b>Leave blank</b> to use the default Archive Files path (currently [_1]).~
  => q~Het absolute pad naar de map waarin archiefbestanden gecreëerd worden, zonder afsluitende slash. <b> Laat leeg</b> om het standaard Archiefpad te gebruiken (momenteel [_1]).~,
q~News Style~
  => q~Nieuws Stijl~,
q~The news style to use for the archives. [_1]~
  => q~De te gebruiken nieuws stijl voor archieven. [_1]~,
q~Settings for Monthly, Weekly, and Daily Archiving Only~
  => q~Instellingen alleen voor Maandelijkse, Wekelijkse en Dagelijkse archivering~,
q~Archive Links File~
  => q~Archief Links Bestanden~,
q~The name of the file which will contain links to the various archives. For example, <b>[_1]-archive.html</b>.~
  => q~De naam van het bestand dat de links bevat naar de archieven. Bijvoorbeeld, <b>[_1]-archive.html</b>.~,
q~Archive Links Template~
  => q~Archief Links Template~,
q~The name of the template (.tmpl) file used to configure the style of the archive links page. Most users should use the default, <b>arclink.tmpl</b>.~
  => q~De naam van het template (.tmpl)bestand dat gebruikt wordt om de stijl te configureren van de archief links pagina. De meeste gebruikers zouden de standaard, <b>arclink.tmpl</b> moeten gebruiken.~,
q~Archive Template~
  => q~Archief Template~,
q~The name of the template (.tmpl) file used to configure the style of the archives. Most users should use the default, <b>archive.tmpl</b>.~
  => q~De naam van het template (.tmpl) bestand dat gebruikt wordt om de stijl te configureren van de archieven. De meeste gebruikers zouden de standaard, <b>archive.tmpl</b> moeten gebruiken.~,
  


#####################################################################################
#HEADER: File Settings Page
q~News Files Path~
  => q~Nieuws Bestanden Pad~,
q~Absolute path (<b>not</b> URL) to the directory where you'd like the news files (the ones included in your pages) to be generated by default. The news database (newsdat.txt) will also be kept here. Often the same as the Program Files path, though this will not work if your Program Files directory is located within a cgi-bin directory. The directory must be world-writable. On UNIX servers, this means you must CHMOD the directory 777. Use forward slashes (/), even on Windows systems. Do not include a trailing slash.~
  => q~Absoluut pad, (<b>niet</b> de URL) naar de map waar u de nieuws bestanden (die op de pagina's moeten verschijnen) standaard gegenereerd moeten worden. De database (newsdat.txt) wordt hier ook bewaard. Meestal hetzelfde als het Programma Bestanden Pad, maar kan niet werken indien de Programma Bestanden map in de cgi-bin map is geplaatst. De map moet op UNIX-servers world-writable zijn. Dit betekent dat u de map op CHMOD 777 moet instellen. Gebruik forward slashes (/), ook op Windows systemen. Niet afsluiten met een slash.~,
q~Archive Files Path~
  => q~Archief Bestanden Pad~,
q~Absolute path (<b>not</b> URL) to the directory where you'd like your news archives to be generated. Often the same as the News Files path. The directory must be world-writable. On UNIX servers, this means you must CHMOD the directory 777. Use forward slashes (/), even on Windows systems. Do not include a trailing slash.~
  => q~Absoluut pad (<b>niet</b> de URL) naar de map waar u de nieuws archief bestanden gegenereerd wilt hebben. Dit is vaak hetzelfde als het Nieuws Bestanden pad. De map moet world-writable zijn. Dit betekent dat u de map op CHMOD 777 moet instellen. Gebruik forward slashes (/), ook op Windows systemen. Niet afsluiten met een slash.~,
q~Addon Path~
  => q~Addon Pad~,
q~Absolute path (<b>not</b> URL) to the directory where the addons are located. Use forward slashes (/), even on Windows systems. Do not include a trailing slash.~
  => q~Absoluut pad (<b>niet</b> de URL) naar de map waar de addons zijn. Gebruik forward slashes (/), ook op Windows systemen. Niet afsluiten met een slash.~,
q~Documentation Path~
  => q~Documentatie Pad~,
q~Absolute path (<b>not</b> URL) to the directory where the (addon) documenation files are located. Use forward slashes (/), even on Windows systems. Do not include a trailing slash.~
  => q~Absoluut pad (<b>niet</b> de URL) naar de map waar de (addon) documentatiebestanden zijn. Gebruik forward slashes (/), ook op Windows systemen. Niet afsluiten met een slash.~,
q~Language Path~
  => q~Talen Pad~,
q~Absolute path (<b>not</b> URL) to the directory where the language files are located. Use forward slashes (/), even on Windows systems. Do not include a trailing slash.~
  => q~Absoluut pad (<b>niet</b> de URL) naar de map waar de taal bestanden zijn. Gebruik forward slashes (/), ook op Windows systemen. Niet afsluiten met een slash.~,
q~Template Path~
  => q~Template Pad~,
q~Absolute path (<b>not</b> URL) to the directory where the templates are located. Use forward slashes (/), even on Windows systems. Do not include a trailing slash.~
  => q~Absoluut pad (<b>niet</b> de URL) naar de map waar de template bestanden zijn. Gebruik forward slashes (/), ook op Windows systemen. Niet afsluiten met een slash.~,
q~Program & Data File Paths~
  => q~Programma & Data Bestanden Pad~,
q~Program Files Path~
  => q~Programma Bestanden Pad~,
q~Absolute path (<b>not</b> URL) to the directory where this script and its program files are located. If you need to change this, please do so by specifying the $abspath variable in the files coranto.cgi and viewnews.cgi~
  => q~Absoluut pad (<b>niet</b> de URL) naar de map waar dit script en de programma bestanden zijn. Indien u dit moet wijzigen, doe dit dan via de $abspath variabele in de bestanden coranto.cgi en viewnews.cgi.~,
q~Data Path~
  => q~Data Paden~,
q~Absolute path (<b>not</b> URL) to the directory where the data files (nsettings.cgi, newsdat.txt and crcfg.dat) are located. If you would like to change this path, please do so by specifying the $data_path variable in the file cruser.pl.~
  => q~Absoluut bad (<b>niet</b> de URL) naar de map waar de data bestanden (nsettings.cgi, newsdat.txt en crcfg.dat) zijn. Indien u dit moet wijzigen doe dit dan via de $data_path variabele in het bestand cruser.pl.~,



#####################################################################################
#HEADER: Date & Time Settings
q~Time Options~
  => q~Tijdsinstellingen~,
q~Time Zone~
  => q~Tijdszone~,
q~Your time zone. Any name or abbreviation is acceptable -- this is for display purposes only."],~
  => q~Uw tijdszone. Iedere benaming is goed - alleen gebruikt voor weergave."],~,
q~Daylight Savings Time Zone~
  => q~Zomer- / Wintertijd~,
q~As above, but during Daylight Savings Time.~
  => q~Als boven, maar gedurende wintertijd~,
q~Server Time Offset~
  => q~Server tijdsverschil~,
q~Often, your server will be in a different time zone than you are. You can enter the difference, in hours, between the server's time and the time you would like displayed on news items. For instance, if your server is in London and you are in Boston, set this to -5. Changing this setting will not affect existing news items; only new items will have an adjusted time. (The server's current time is: [_1])~
  => q~Vaak staat uw server in een andere tijdszone dan uzelf bent. U kunt hier het verschil in uren invullen tussen de servertijd en de tijd die u op het nieuws wilt hebben.~
  => q~12/24 Hour Clock?~,
q~Choose between a 12 hour (AM/PM) and 24 hour clock.~
  => q~Kies tussen een 12 uurs (AM/PM) en een 24 uurs klok.~,
q~12 Hour (AM/PM)~
  => q~12 uur (AM/PM)~,
q~24 Hour~
  => q~24 uur~,
q~Date Formats~
  => q~Datum instellingen~,
'_DATE_SETTINGS_INTRO' => <<'EOSENTANCE', # Introduction text for date & time
	The following settings allow you to configure how dates &amp;
	times appear. The general date format controls the date used in news items.
	The internal date format controls the date used on Coranto administrative pages.
	The three archive date formats control the date used to label monthly, weekly, and daily archives
	respectively. To insert a component of the date or time, use &lt;Field: Name&gt; where Name is one of:
	<b>Year</b>, <b>TwoDigitYear</b>, <b>Month_Name</b>, <b>Abbrev_Month_Name</b>, <b>Month_Number</b>,
	<b>TwoDigitMonth</b>, <b>Weekday</b>, <b>Abbrev_Weekday</b>, <b>Day</b>, <b>TwoDigitDay</b>, <b>Hour</b>,
	<b>TwoDigitHour</b>, <b>Minute</b>, <b>Second</b>, <b>AMPM</b>, or <b>Time_Zone</b>. Remember that spacing and capitalization
	matter: &lt;Field: Day&gt; is valid, but &lt;field:day&gt is not (it contains three errors, actually).
EOSENTANCE
q~General Date Format~
  => q~Algemeen Datumformaat~,
q~Internal Date Format~
  => q~Intern Datumformaat~,
q~Monthly Archive Date Format~
  => q~Maandelijks Archief Datumformaat~,
q~Weekly Archive Date Format~
  => q~Wekelijks Archief Datumformaat~,
q~Daily Archive Date Format~
  => q~Dagelijks Archief Datumformaat~,
q~Example of current format: [_1]	~
  => q~Voorbeeld van huidig formaat: [_1]	~,



#####################################################################################
#HEADER: Edit Users Settings
q~Current Users~
  => q~Huidige gebruikers~,
q~Administrator Level~
  => q~Administrator~,
q~complete access to all functions~
  => q~volledige toegan tot alle functies~,
q~High Level~
  => q~Hoog~,
q~can post news and modify all posts~
  => q~Kan nieuws posten en alle nieuwsitems wijzigen~,
q~Standard Level~
  => q~Standaard~,
q~can post news and modify own posts~
  => q~Kan nieuws posten en eigen nieuwsitems wijzigen~,
q~User &quot;[_1]&quot; last logged in on [_2]. User level: <b>[_3]</b>~
  => q~Gebruiker &quot;[_1]&quot; was voor het laats ingelogd op [_2]. Gebruikerslevel: <b>[_3]</b>~,
q~never~ # As in: User last logged in on (never).
  => q~nooit~,
q~Administrator users can only be edited or deleted by the Super Administrator.~
  => q~Administrator gebruikers kunnen alleen gewijzigd of verwijderd worden door de Super Administrator.~,
q~Edit User Info~
  => q~Wijzig Gebruikers Info~,
q~Convert to [_1] Level User~
  => q~Verander Naar [_1] Level Gebruiker~,
q~Enable User~
  => q~Gebruiker Inschakelen~,
q~Disable User~
  => q~Gebruiker Uitschakelen~,
q~Delete User~
  => q~Gebruiker Verwijderen~,
q~Create New User~
  => q~Creëer Nieuwe Gebruiker~,
q~Usernames may contain only letters, numbers, and underscores (_).~
  => q~Gebruikersnamen mogen alleen letters, nummers en underscores (_) bevatten.~,
q~User [_1] does not exist.~
  => q~Gebruiker [_1] bestaat niet.~,
q~That is an administrative user.~
  => q~Dit is een administratieve gebruiker.~,
q~The username must be at least 3 characters long.~
  => q~De gebruikersnaam moet minimaal 3 tekens lang zijn.~,
q~Username &quot;[_1]&quot; contains illegal characters. Only letters, numbers, and underscores are permitted in usernames.~
  => q~Gebruikersnaam &quot;[_1]&quot; bevat verboden tekens. Alleen letters, nummers, en underscores zijn beschikbaar in gebruikersnamen.~,
q~That user already exists.~
  => q~Gebruiker bestaat al.~,
q~Passwords must be at least 5 characters long.~
  => q~Wachtwoorden moeten minimaal 5 tekens lang zijn.~,
q~Invalid user level.~
  => q~onjuiste gebruikerslevel.~,
q~Are you sure that you want to create an Administrator user? Administrator users have complete access to all functions, and, once created, <b>can only be deleted by the Super Administrator</b>. Administrator users can delete or modify your files. Administrator users can do almost anything. As a general rule, only give Administrator accounts to those who already have full access to your server.~
  => q~Bent u zeker dat u een Administrator gebruiker wilt creëren? Administrator gebruikers hebben volledige toegang tot alle functies, en, eenmaal aangemaakt, <b>kunnen ze alleen maar door de Super Administrator verwijderd worden</b>. Administrator gebruikers kunnen bestanden wijzigen en verwijderen. Administrator gebruikers kunnen bijna alles. Als algemene regel geldt, alleen Administrator gebruikers aanmaken die ook al volledig toegang tot de server hebben.~,
q~Are you sure that you want to create a guest user? Users which start with the word guest are special: they can't access User Info or Modify News.~
  => q~Bent u er zeker van dat u een nieuwe gastgebruiker wilt creëren? Gebruikers beginnend met het woord gast zijn speciaal: Ze kunnen niet bij de gebruikersinfo komen en ook geen nieuwsitems wijzigen.~,
q~User [_1] does not exist.~
  => q~Gebruiker [_1] bestaat niet.~,
q~Cannot remove administrative users.~
  => q~Kan geen administratieve gebruikers wijzigen.~,
q~Are you sure you want to remove user &quot;[_1]&quot? When a user is removed, everything in the user database associated with that user is removed as well. For instance, the user's e-mail address will be deleted, and will no longer be displayed in news items posted by that user. Disabling rather than removing the user is usually a better choice.~
  => q~Bent u er zeker van gebruiker &quot;[_1]&quot; te verwijderen? Wanneer een gebruiker verwijderd is, wordt alles in de gebruikersdatabase dat geassocieerd word met deze gebruiker verwijderd. Bijvoorbeeld, de gebruikers e-mailadres wordt niet langer weergegeven in de nieuwsitems van deze gebruiker. Blokkeren in plaats van verwijderen is vaak een betere optie.~,
q~The User Fields allow you to associate information with a particular user and display that information in news items posted by that user. For example, you could store the email addresses of users and display a user's address on the items that he or she posts.~
  => q~De gebruikersvelden geven u de mogelijkheid informatie van een bepaalde gebruiker te associëren met een bepaald nieuwsitem, dat gepost is door deze gebruiker. U kunt bijvoorbeeld de email adressen van gebruikers opslaan en weergeven bij nieuwsberichten.~,
q~Current User Fields~
  => q~Huidige Gebruikersvelden~,
q~Editable by user~
  => q~Wijzigbaar door gebruiker~,
q~Editable only by administrator~
  => q~Alleen wijzigbaar door administrator~,
q~HTML forbidden~
  => q~HTML verboden~,
q~HTML allowed~
  => q~HTML toegestaan~,
q~Create New User Field~
  => q~Creëer Nieuwe Gebruikersveld~,
q~User Field Name~
  => q~Gebruikersveld Naam~,
q~User field names may only contain letters, numbers, and underscores (_).~
  => q~Gebruikersvelden mogen alleen letters, nummers en underscores (_) bevatten.~,
q~Field &quot;[_1]&quot; does not exist.~
  => q~Veld &quot;[_1]&quot; bestaat niet.~,
q~Sorry, but you cannot remove the Email field.~
  => q~Sorry, maar u kunt niet het Email veld verwijderen.~,
q~Are you sure that you want to delete field &quot;[_1]&quot;? If you delete the field, all information that has previously been stored in it will be deleted as well.~
  => q~Bent u er zeker van dat u het veld &quot;[_1]&quot; wilt verwijderen? Als u het veld verwijdert, wordt alle informatie dat hierin opgeslagen is, ook verwijderd..~,
q~Field name &quot;[_1]&quot; contains illegal characters. Only letters, numbers, and underscores are permitted in field names.~
  => q~Veldnaam &quot;[_1]&quot; bevat niet toegestane tekens. Alleen letters, nummers, en underscores zijn toegestaan in veldnamen.~,
q~Field &quot;[_1]&quot; already exists.~
  => q~Veld &quot;[_1]&quot; bestaat al.~,
q~Please enter a field name.~
  => q~Geef het veld een naam.~,



#####################################################################################
#HEADER: General Edit News Fields Page
q~News fields are the fields available for users to enter information when submitting or modifying news.~
  => q~Nieuwsvelden zijn velden beschikbaar voor gebruikers om informatie in te voeren wanneer ze een nieuw nieuwsitem aanmaken of een bestaand item wijzigen.~,
q~Current News Fields~
  => q~Bestaande Nieuwsvelden~,
q~Single-Line Text Field~
  => q~Enkele Lijn Tekstveld~,
q~Multi-Line Text Field~
  => q~Multi-lijn Tekstveld~,
q~Drop-Down Box~
  => q~Drop-Down Box~,
q~Checkbox~
  => q~Checkbox~,
q~Radio Button~
  => q~Radio Button~,
q~Move Up~
  => q~Omhoog Verplaatsen~,
q~Move Down~
  => q~Omlaag Verplaatsen~,
q~Create New News Field~
  => q~Creëer Nieuw Nieuwsveld~,
q~Enter both the internal and display name of the field that you wish to create. The internal name is the name which will be used to refer to this field in your news style settings; it may contain only letters, numbers, and underscores, and will always begin with &quot;CustomField_&quot;. The display name is the name shown to users when submitting or modifying news.~
  => q~Typ de interne- en weergavenaam van het veld dat u wenst te creëren. De interne naam is de naam welke gebruikt wordt om te refereren aan dit veld in uw nieuwsstijl instellingen; het mag alleen letters, nummers en underscores bevatten en beginnen met &quot;CustomField_&quot;. De weergavenaam is de naam welke gebruikers te zien krijgen wanneer ze een nieuwsitem toevoegen of wijzigen.~,
q~Field Type~
  => q~Veld Type~,
q~Edit Field &quot;[_1]&quot;~
  => q~Wijzig Veld &quot;[_1]&quot;~,
q~That field does not exist.~
  => q~Dit veld bestaat niet.~,
q~Could not find field.~
  => q~Kan veld niet vinden.~,
q~This is already the first item.~
  => q~Dit is al het eerste item.~,
q~This is already the last item.~
  => q~Dit is al het laatste item.~,
q~Please enter an internal name.~
  => q~Typ een interne naam.~,
q~Field name [_1] contains illegal characters. Only letters, numbers, and underscores are permitted in field names.~
  => q~Veldnaam [_1] bevat niet toegestane tekens. Alleen letters, nummers en underscores (_) zijn toegestaan in veldnamen.~,
q~Field [_1] already exists.~
  => q~Veld [_1] bestaat al.~,
q~That field cannot be deleted.~
  => q~Dit veld kan niet verwijderd worden.~,
q~Are you sure that you want to delete field &quot;[_1]&quot;? Any data that has been stored in this field will be deleted!~
  => q~Bent u er zeker van dat u veld &quot;[_1]&quot; wilt verwijderen? Alle data die in dit veld opgeslagen is wordt verwijderd!~,


#####################################################################################
#HEADER: Edit Specific News Field Page
q~The name that will label this field in Submit News and Modify News. This is that name that users will see.~
  => q~De weergavenaam van dit veld in Nieuws Toevoegen en Nieuws Wijzigen. Dit is de naam die voor gebruikers zichtbaar is.~,
q~Submit Permissions~
  => q~Permissies Opslaan~,
q~Controls which users will be shown this field when submitting news. (Administrators are always shown all fields.)~
  => q~Bepaalt welke gebruikers dit veld te zien krijgen bij het toevoegen van nieuws. Administrators krijgen altijd alle velden te zien.~,
q~All Users~
  => q~Alle Gebruikers~,
q~&quot;High&quot; level users~
  => q~&quot;Hoge&quot; level gebruikers~,
q~Administrators only~

  => q~Alleen Administrators~,
q~Modify Permissions~
  => q~Wijzig Permissies~,
q~Controls which users will be shown this field when modifying news. (Administrators are always shown all fields.)~
  => q~Bepaalt welke gebruikers dit veld te zien krijgen bij het wijzigen van nieuws. Administrator krijgen altijd alle velden te zien.~,
q~Disable HTML~
  => q~Blokkeer HTML~,
q~When enabled, prevents HTML from being used in this field by causing HTML tags to be displayed as part of the news item rather than be interpreted by the browser.~
  => q~Wanneer ingeschakeld, wordt HTML code die eventueel die door gebruikers ingevoerd wordt, omgezet als deel van de tekst in plaats van geïnterpreteerd door de browser.~,
q~Field Size~
  => q~Veld Grootte~,
q~The size, in characters, of the text box.~
  => q~De grootte, in tekens, van het tekstvak.~,
q~Maximum Length~
  => q~Maximale Lengte~,
q~The number of characters users will be able to enter into this field. Leave blank to not provide a maximum length.~
  => q~Het aantal tekens dat gebruikers in dit veld in mogen typen. Laat leeg om geen maximum op te geven.~,
q~Parse Links~
  => q~Maak Links~,
q~Automatically parse links in this field during Submit/Modify. Most users should leave this on.~
  => q~Maak automatisch links tijdens Toevoegen/Wijzigen. Meeste gebruikers zouden dit aan moeten laten.~,
q~Parse Links Attributes~
  => q~Maak Links Attributen~,
q~If you have enabled the Parse Links option above, here is where you specify what attributes the automatically created A tag should contain, eg <em>class="linkstyle"</em>. Leave blank to create a plain (clean) link.~
  => q~Als u Maak Links hierboven aan heeft staan, kunt u hier opgeven welke attributen de automatisch gecreëerde A tag moet gebruiken, bijvoorbeeld <em> class="linkstyle"</em>. Laat leeg om een gewone link te maken.~,
q~Default Value~
  => q~Standaardwaarde~,
q~What will initially be in the text box when a user goes to the Submit News page. Leave blank for a normal, empty text box.~
  => q~Wat in standaard in een tekstbox staat, wanneer een gebruiker naar de Nieuws Toevoegen pagina gaat. Laat leeg voor een normaal, leeg tekstvak.~,
q~Rows~
  => q~Rijen~,
q~The height, in lines, of the text box~
  => q~De hoogte, in regels, van een tekstbox~,
q~Columns~
  => q~Kolommen~,
q~The width, in characters, of the text box.~
  => q~De breedte, in tekens, van een tekstbox.~,
q~Convert Newlines~
  => q~Maak Nieuwe Regel~,
q~Convert newlines (what you type when you hit Enter) into &lt;br&gt; tags? This is necessary for HTML. Most users should leave this on.~
  => q~Maakt nieuwe regel (wanneer u op Enter drukt) als HTML code &lt;br&gt;? Dit is nodig voor HTML. Meeste gebruikers dienen dit aan te laten staan.~,
q~On Value~
  => q~Op Waarde~,
q~What will be saved in the field if the checkbox is checked.~
  => q~Wat wordt opgeslagen als checkbox aangevinkt is.~,
q~Checked By Default~
  => q~Standaard Aangevinkt~,
q~Do you want the checkbox to be automatically checked by default?~
  => q~Wilt u de checkbox standaard automatisch aangevinkt hebben?~,
q~Options~
  => q~Opties~,
q~Enter the options you want this field to contain. Seperate each option with a | (pipe) and put the option you want to be default in brackets. In the following example the option "is" would be default: coranto|[is]|cool~
  => q~Typ de opties die het veldt moet bevatten. Scheidt iedere optie met een | (pipe) en zet de standaard optie in brackets.
In het volgende voorbeeld is optie "is" standaard: coranto|[is]|cool~,
q~Split Options~
  => q~Verdeel Optiesl~,
q~What do you want radio button options to be split by? A good choice would be something like &lt;br&gt; (line break).~
  => q~Hoe wilt u de radio button opties verdelen? Een goede keuze is iets als &lt;br&gt; (volgende regel).~,
q~Field Size~
  => q~Veldgrootte~,
q~The size of the drop-down box (number of options you want to be displayed). Leave blank if you do not want to use this feature.~
  => q~De grootte van de drop-down box (aantal opties dat weergegeven wordt). Laat leeg indien u deze mogelijkheid niet wenst te gebruiken.~,
q~Strip Code~
  => q~Strip Code~,
q~Do you want to strip SSI, PHP, and other codes from the field input?~
  => q~Wilt u SSI, PHP en andere codes verwijderen uit het input veld?~,



#####################################################################################
#HEADER: The Addon Manager Page
q~For a list of current addons, click [_1]here[_2]~
  => q~Voor een lijst van de huidige addons, klik[_1]hier[_2]~,
q~Filename~
  => q~Bestandsnaam~,
q~Version~
  => q~Versie~,
q~Documentation Available~
  => q~Documentatie Beschikbaar~,
q~View Documentation~
  => q~Bekijk Documentatie~,
q~Visit Site~
  => q~Bezoek Website~,
q~No addons found.~
  => q~Geen addons gevonden.~,
q~Addons Found~
  => q~Addons Gevonden~,
q~You must provide an addon name.~
  => q~U moet een addon name ingeven.~,
q~Couldn't find addon [_1].~
  => q~Kan addon [_1] niet vinden.~,
q~Was asked to display documentation for addon [_1], but could not find [_2].~
  => q~Documentatie van addon [_1], kan niet gevonden worden [_2].~,
q~Coranto Documentation~
  => q~Coranto Documentatie~,
q~close window to return to Coranto~
  => q~Sluit venster om terug te keren naar Coranto~,


#####################################################################################
#HEADER: News Style Page
q~Current News Styles~
  => q~Huidige Nieuws Stijlen~,
q~Style Name~
  => q~Stijlnaam~,
q~This style is empty.~
  => q~Deze stijl is leeg.~,
q~This style is used by all archives.~
  => q~Deze stijl wordt gebruikt door alle archieven.~,
q~This style is currently used by <b>no</b> profiles.~
  => q~Deze stijl wordt door <b>geen</b> profiel gebruikt.~,
q~This style is currently used by profile <b>[_1]</b>.~
  => q~Deze stijl wordt door profiel <b>[_1]</b> gebruikt.~,
q~This style is currently used by profiles~
  => q~Deze stijl wordt gebruikt door profielen~,
q~Style type~
  => q~Stijltype~,
q~Create New News Style~
  => q~Creëer Nieuwe Nieuwsstijl~,
# Description label of a Standard Style
q~Standard Style~
  => q~Standaard~,
q~Create Style~
  => q~Creëer Stijl~,
q~Style name must contain at least 3 alphanumeric characters.~
  => q~Stijlnaam moet minimaal 3 alfanumerieke tekens hebben.~,
q~A style with that name (or a similar name) already exists.~
  => q~Een stijl met deze naam (of gelijkende naam) bestaat al.~,
q~That style doesn't exist.~
  => q~Deze stijl bestaat niet.~,

# SECTION: Edit Style
q~Edit Style [_1]~
  => q~Wijzig Stijl [_1]~,
q~Below, enter the HTML code you'd like this style to use. Where you'd like to include one of the various components of a news item, enter &lt;Field: FieldName&gt; where FieldName is the name of the appropriate field. For example, use &lt;Field: Text&gt; to insert the text of the news item.~
  => q~Typ de HTML code die u wenst te gebruiken voor deze stijl. Waar u één van de vele componenten van een nieuwsitem wilt invoegen, typt u &lt;Field: FieldName&gt; waar FieldName de naam voor het te gebruiken veld is. Bijvoorbeeld, &lt;Field: Text&gt; om de tekst van het nieuwsitem in te voegen.~,
q~The following basic fields are available~
  => q~De volgende standaardvelden zijn beschikbaar~,
q~[_1]Fuller documentation[_2] of style-editing options is available.~
  => q~[_1]Meer documentatie [_2] over stijl-wijzigen mogelijkheden is beschikbaar.~,
q~That style doesn't exist.~
  => q~Deze stijl bestaat niet.~,
q~Style cannot be empty. (You can delete a style instead.)~
  => q~Stijl kan niet leeg zijn. (U kunt hiervoor een stijl verwijdern.)~,
q~Edit Style~
  => q~Wijzig Stijl~,
q~That style is invalid and has a syntax error. Check, in particular, that all ifs are properly matched and ended. Perl reported the following error, which may or may not be helpful~
  => q~Deze stijl is onjuist en heeft een syntax fout. Controleer, in het bijzonder of alle ifs goed kloppen en geëindigd zijn. Perl gaf de volgende error, welke misschien kan helpen~,
q~Style Changes Saved~
  => q~Wijzigingen Stijl Opgeslagen~,
q~Your changes to style &quot;[_1]&quot; have been saved.~
  => q~Uw wijzigingen in stijl &quot;[_1]&quot; zijn opgeslagen.~,
q~That style doesn't exist.~
  => q~Deze stijl bestaat niet.~,
q~That style can't be deleted.~
  => q~Deze stijl kan niet worden verwijder.~,
q~That style is still being used by profile(s)~
  => q~Deze stijl wordt gebruikt door profielen~,
q~That style is still being used by [bool,_1,profile,profiles] [_2]. While [bool,_1,a profile,profiles] are still using this style, it cannot be deleted.~
  => q~Deze stijl wordt gebruikt door [bool,_1,profile,profiles] [_2]. Wanneer [bool,_1,a profile,profiles] deze stijl gebruiken, kan het niet verwijderd worden.~,
q~Any changes that you made have been saved.~
  => q~Alle door u gemaakte wijzigingen zijn opgeslagen.~,
q~You may have to build news for the results of your changes to become visible.~
  => q~U moet misschien het nieuws opbouwen voor het zichtbaar wordt.~,



#####################################################################################
#HEADER: Buttons and 'labels'
q~Confirm Action~
  => q~Confirmeer Actie~,
q~Yes, I'm sure~
  => q~Ja, ik ben zeker~,
q~Reset~
  => q~Reset~,
q~Yes (On)~
  => q~Ja (Aan)~,
q~No (Off)~
  => q~Nee (Uit)~,
q~Save Settings~
  => q~Wijzig Instellingen~,
q~Delete~
  => q~Wis~,
q~Edit~
  => q~Wijzig~,
q~Disable~
  => q~Uitschakelen~,
q~Enable~
  => q~Inschakelen~,

#SECTION: Informational messages
q~Error~
  => q~Fout~,
q~on~
  => q~aan~,
q~off~
  => q~uit~,
q~disabled~ # As in: User (disabled)
  => q~uitgeschakeld~,
q~Internal Name~
  => q~Interne Naam~,
q~Display Name~
  => q~Weergavenaam~,
q~Create Field~
  => q~Creëer Veld~,
q~Changes has NOT been saved~
  => q~Wijzigingen zijn NIET opgeslagen~,

);



#####################################################################################
#HEADER: The Days Of The Week
#SECTION: Full weekday names
@Week_Days = (
	q~Zondag~,
	q~Maandag~,
	q~Dinsdag~,
	q~Woensdag~,
	q~Donderdag~,
	q~Vrijdag~,
	q~Zaterdag~
);

#SECTION: Abbrevated weekday names
@Abbrev_Week_Days = (
	q~Zo~,
	q~Ma~,
	q~Di~,
	q~Wo~,
	q~Do~,
	q~Vr~,
	q~Za~
);



#####################################################################################
#HEADER: The Name Of The Months
#SECTION: Full month names
@Months = ( # The name of the months 
	q~januari~,
	q~februari~,
	q~maart~,
	q~april~,
	q~mei~,
	q~juni~,
	q~juli~,
	q~augustus~,
	q~september~,
	q~oktober~,
	q~november~,
	q~december~
);

#SECTION: Abbrevated month names
@Abbrev_Months = (
	q~jan~,
	q~feb~,
	q~maa~,
	q~apr~,
	q~mei~,
	q~jun~,
	q~jul~,
	q~aug~,
	q~sep~,
	q~okt~,
	q~nov~,
	q~dec~
);


1;

