# cruser.pl
# This file contains Coranto settings which, for one reason
# or another, couldn't be included in the web-based interface.
# (EXCEPTION: The Server Problems settings, which is 
# in coranto.cgi.)
#
# It is also the place to put any custom subroutines you have.
#
# Please note that the three old settings 'nsettingspath',
# 'nsbkpath' and 'cfgpath' have all (from Coranto 1.31.x) been
# replaced with the single setting 'data_path', which defines
# the common folder where to place nsettings.cgi, nsbk.cgi,
# crcfg.dat and newsdat.txt.
#


# ** RAW PERL IN NEWS STYLES **
# When editing news styles, it's possible to use raw Perl code
# enclosed inside <PerlCode>print 'code here';</PerlCode> tags.
# This is a useful and powerful feature if you know Perl, but can
# also be slightly dangerous: it allows anyone who can gain access
# to an Administrator-level account to run arbitrary commands on 
# your server. Set to 1 to enable this feature, 0 to disable.

$EnableRawPerl = 1;

# ** FILE LOCKING **
# File locking is a feature, provided by the operating system, which
# prevents possible serious problems when Coranto is being used by
# multiple users. Almost every operating system supports this, except
# for Windows 9x/ME. Possible settings:
# 2  Enable file locking. If you know your server supports it, set
#	UseFlock to this.
# 0  Disable file locking. This may result in file corruption.

$UseFlock = 2;


# ** DATA FOLDER LOCATION **
# Normally the files nsettings.cgi, nsbk.cgi, crcfg.dat and newsdat.txt
# is located in a subfolder to your Coranto installation called 'data'.
# However, it is important that your nsettings.cgi and crcfg.dat files
# are not visible over the web and if your webserver is not restricting
# access to them you can move all the files in the data-folder to a
# different directory not visible over the web and specify the new path
# below. Use an absolute path (no trailing slash).
# Example:
# $data_path = '/usr/home/me/securefiles/coranto-data';

$data_path = '';


# ** EARLY LOADING OF ADDONS **
# Normally addons are loaded after the user is verified and logged in
# to Coranto. This feature make addons to be loaded before that point
# which can be very useful and powerful if you need to interact with
# other scripts to create single sign on functionality or for some
# reason needs to modify the login page but it can also be slightly
# dangerous since it allow addons to see the password you submit at
# the login page. Set to 1 to enable this feature, 0 to disable.

$EarlyAddonLoad = 0;


# ** ADVANCED TIMING FEATURES **
# Don't change these settings unless you know exactly what you're doing.

# Lifespan of cookies, in seconds.
# 7776000 seconds is equal to 90 days.
$cookieExpLength = 7776000;
# Lifespan of sessions, in seconds.
# 7200 seconds = 2 hours
$SessionLength = 7200;

# ** INSERT CUSTOM SUBROUTINES HERE **
# Below is the place to put in any custom subroutines you have. (If you don't
# know what this means, just ignore this section.)










# ** END CUSTOM SUBROUTINE AREA **


1;
