#! CRADDON 1
#! NAME WebWriter
#! VERSION 3.1
#! HOMEPAGE http://webwriter.sourceforge.net/
#! DESCRIPTION Write & edit your news and apply formatting without seeing the HTML code forever. It is like writing a letter in MS Word (r). MAKE YOUR LIFE EASIER with this wysiwyg based editor. With Internet Explorer 5.5+ and Mozilla 1.4+ support!! Also, smiley images support is back :)<br><b>Authors:</b> <a href="mailto:kri.ko@hot.ee">kriko</a> & <a href="mailto:aero-soul@rogers.com">AeroSoul</a><br><b>Check for updates & news, from the Coranto Factory [ http://webwriter.sourceforge.net/ ] </b>
#! DOC 1

# version 3.1
# 25th July 2003 03:50 (GMT +2)
# homepage: http://webwriter.sourceforge.net/ ,,, possible mirror at: http://kriko.neosurge.net/webwriter/

$WebWriter_Version = '3.1';
my $addon = new Addon('WebWriter');
$addon->checkBuild(31);
$addon->isPrivacyCompatible;

$addon->addAdminFunction('WebWriter','Setup and configure WebWriter addon, configure your submit & modify news outlook, modify custom colors and other WebWriter settings.','WebWriter');
$addon->registerAdminFunction(WebWriter,WebWriterSettings);
$addon->registerAdminFunction(WebWriterSettings,WebWriterSettings);
$addon->registerAdminFunction(WebWriterSettingsSave,WebWriterSettingsSave);

$addon->hook(DisplaySubForm_Submit,WebWriter_Submit);
$addon->hook(DisplaySubForm_AfterTable,WebWriter_AfterTable_Submit);
$addon->hook(ModifyNews_Edit_AfterTable,WebWriter_AfterTable_Modify);
$addon->hook(SaveNews_Pre,WebWriterCheckNewlinesHTML);
$addon->hook(ModifyNews_EditSave_2,WebWriterCheckNewlinesHTML);

sub WebWriterSettings 
{
	WebWriterCheckBrowser();
	WebWriterCheckConfig();
	WebWriterCheckAddons();
	NeedCFG();

	$addon->pageHeader('WebWriter');
	CRHTMLHead('WebWriter - Settings');

	print $addon->heading('Settings for WebWriter');

	if ($CConfig{'isPublicSite'}) 
	{ 
		push(@WebWriter_Notes,'You browser is not compatible with WebWriter. Please download the latest version of <a href="http://www.microsoft.com/windows/ie" target="_dlmsie">Microsoft Internet Explorer</a> or <a href="http://www.mozilla.org" target="_dlmoz">Mozilla</a>. You will not be able to use the WebWriter wysiwyg area until you upgrade.') unless ($WebWriter_OkBrowser);
	} 
	else 
	{ 
		push(@WebWriter_Notes,'You browser is not compatible with WebWriter. PPlease download the latest version of Microsoft Internet Explorer [http://www.microsoft.com/windows/ie] or Mozilla [http://www.mozilla.org]. You will not be able to use the WebWriter wysiwyg area until you upgrade.') unless ($WebWriter_OkBrowser);
	}
	push(@WebWriter_Notes,'Your Coranto is running in privacy mode, please check that no user defined urls point out from this server! ') unless ($CConfig{'isPublicSite'});
	push(@WebWriter_Notes,'You have not configured all settings for WebWriter. You will not be able to use the editor untill you do so.') unless ($WebWriter_ConfigOk);
	push(@WebWriter_Notes,'Please disable newlines on the field "Text". If you do not, WebWriter will continue to function and will tempararily disable them everytime you post or modify news.') if ($fieldDB{'Text'}->{'Newlines'});
	push(@WebWriter_Notes,'Please enable HTML on the field "Text". If you do not, WebWriter will continue to function and will tempararily enable it everytime you post or modify news.') if ($fieldDB{'Text'}->{'DisableHTML'});
	push(@WebWriter_Notes,'Please disable the HTML Builder addon. Failure to do so will result in longer loading times on the Submit News page. It will not effect the functionality of WebWriter in any way.') if ($WebWriter_LoadedAddon{'htmlbuild'});

	if (@WebWriter_Notes) 
	{
		$WebWriter_Notes = join('|x|',@WebWriter_Notes);
		WebWriterNotes($WebWriter_Notes);
	} 
	else 
	{
		print '<p align="center">You currently have no notes in need of your attention</p>';
	}

	print qq~<hr size="1" width="80%" noshadow>~;

	print $addon->form({'action'=>'admin','adminarea'=>'WebWriterSettingsSave'},'name="WebWriter_SettingsSave"') . 
q~
<p align="center">
<table width="80%" align="center" border="0" cellpadding="2" cellspacing="2" class="description">
<tr>
<td width="15%" align="center" valign="top"><font size="6"><b>?</font><br>info</b></td><td width="85%" valign="top"><div align="left">General settings of WebWriter. These must be configured before you can use WebWriter. The defaults are not necessarily correct, they are there only to give you a general idea.</div>
</td>
</tr>
</table>
<br>

<table width="80%" align="center" border="0" cellpadding="2" cellspacing="2">~;
	print q~
	<tr>
	<td width="30%" align="right" class="fieldtitle">
	Includes URL
	</td>
	<td width="60%" valign="top">
	~;
	$WebWriter_ImageURL=$scripturl;
	if ($WebWriter_ImageURL =~ /coranto\.cgi/) 
	{
		$WebWriter_ImageURL =~ s/coranto\.cgi/includes/g;
	} 
	else 
	{
		$WebWriter_ImageURL=~s/$ENV{'SCRIPT_NAME'}/\/includes/g;
	}
	if ($CConfig{'WebWriter_ImageURL'})
	{
		print qq~<input type="text" size="40" name="WebWriter_ImageURL" value="$CConfig{'WebWriter_ImageURL'}">~;
	} 
	else
	{
		print qq~<input type="text" size="40" name="WebWriter_ImageURL" value="$WebWriter_ImageURL">~;
	}
	print qq~
	</td>
	<td width="10%" align="center" valign="top">
	<div align="center">
	<input type="button" value="Default" onclick="document.WebWriter_SettingsSave.WebWriter_ImageURL.value='$WebWriter_ImageURL'">
	</div>
	</td>
	</tr>
	<tr>
	<td width="100%" valign="top" colspan="3" class="description">
	<div align="left"><font size="2" style="font-size: 10px">
The URL to the directory where the includes (images, html dialog files, javascript) for WebWriter are located. <br>
Please include full URL, starting with "http://" or a relative url (for example "/images" this would point to "http://www.yourdomain.com/images").  <br>
Do not include a trailing slash ( / ).
	<br>
	~;
	if ($CConfig{'isPublicSite'})
	{ 
	print qq~
<br>
You can use some pre-set image url\'s, they might not work forever, so it is best to use your own server, anyway here they are:
<li>http://factory.eatsleepcode.ca/ww/src  &nbsp; (Canada) 
<li>http://www.hot.ee/npfactory/ww/src  &nbsp; (Europe, Estonia)
</font>
	~;
	} 
	else
	{ 
	print qq~ <br><b><font color="red">You have turned on the privacy features, this means, you MUST NOT use images from other servers than yours. Because it would be against the privacy rules.</font></b>~;
	} 
	print qq~
	</font>
	</div>
	</td>
	</tr>
	<tr>
	<td width="30%" align="right" class="fieldtitle">
	htmlArea version 2?
	</td>
	<td width="60%" valign="top">
	~;
	if ($CConfig{'WebWriter_htmlArea'})
	{
		print qq~
		<input type="checkbox" size="4" name="WebWriter_htmlArea" value="on" checked>
		~;
	} 
	else
	{
		print q~
		<input type="checkbox" size="4" name="WebWriter_htmlArea">
		~;
	}
	print qq~
	</td>
	<td width="10%" align="center" valign="top">
	<div align="center">
	<input type="button" value="Default" onclick="document.WebWriter_SettingsSave.WebWriter_htmlArea.status=false">
	</div>
	</td>
	</tr>
	<tr>
	<td width="100%" valign="top" colspan="3" class="description">
	<div align="left">
	The version of htmlArea installed. Default what comes with this package is version 3. Older version 2 is also supported. If you don\'t know what it is then leave unchecked.<br>
	If checked then htmlArea version 2 must be uploaded from the ZIP file this product came with (located in directory named: "includes_with_htmlArea2"). It is more stable but works only with Internet Explorer, but it also allows you to use the smiley pack.
	</div>
	</td>
	</tr>
	<tr>
	<td width="30%" align="right" class="fieldtitle">
	Smileys?
	</td>
	<td width="60%" valign="top">
	~;
	if ($CConfig{'WebWriter_smileys'})
	{
		print qq~
		<input type="checkbox" size="4" name="WebWriter_smileys" value="on" checked>
		~;
	} 
	else
	{
		print q~
		<input type="checkbox" size="4" name="WebWriter_smileys" value="on">
		~;
	}
	print qq~
	</td>
	<td width="10%" align="center" valign="top">
	<div align="center">
	<input type="button" value="Default" onclick="document.WebWriter_SettingsSave.WebWriter_smileys.status=false">
	</div>
	</td>
	</tr>
	<tr>
	<td width="100%" valign="top" colspan="3" class="description">
	<div align="left">
	Enables smiley images bar in the right hand corner of the editor. 
	</div>
	</td>
	</tr>
	<tr>
	<td width="30%" align="right" class="fieldtitle">
	How many smileys?
	</td>
	<td width="60%" valign="top">
	~;
	if (defined($CConfig{'WebWriter_smileysCount'}))
	{
		print qq~
		<input type="text" size="4" name="WebWriter_smileysCount" value="$CConfig{'WebWriter_smileysCount'}">
		~;
	} 
	else
	{
		print q~
		<input type="text" size="4" name="WebWriter_smileysCount" value="52">
		~;
	}
	print qq~
	</td>
	<td width="10%" align="center" valign="top">
	<div align="center">
	<input type="button" value="Default" onclick="document.WebWriter_SettingsSave.WebWriter_smileysCount.value='52'">
	</div>
	</td>
	</tr>
	<tr>
	<td width="100%" valign="top" colspan="3" class="description">
	<div align="left">
	When smileys enabled. Webwriter will display this count of images from includes/icons directory with COUNT.gif. Default number of smileys is 52, you may alter that if you add/delete some of them. Must be between 0 and 1000.
	</div>
	</td>
	</tr>
	<tr>
	<td width="30%" align="right" class="fieldtitle">
	Editor Width
	</td>
	<td width="60%" valign="top">
	~;
	if ($CConfig{'WebWriter_EditorWidth'})
	{
		print qq~
		<input type="text" size="4" name="WebWriter_EditorWidth" value="$CConfig{'WebWriter_EditorWidth'}">
		~;
	} 
	else
	{
		print q~
		<input type="text" size="4" name="WebWriter_EditorWidth" value="580">
		~;
	}
	print qq~
	</td>
	<td width="10%" align="center" valign="top">
	<div align="center">
	<input type="button" value="Default" onclick="document.WebWriter_SettingsSave.WebWriter_EditorWidth.value='580'">
	</div>
	</td>
	</tr>
	<tr>
	<td width="100%" valign="top" colspan="3" class="description">
	<div align="left">
	The width in pixels of the editor that appears on the submit news page. Must be between 100 and 3000. Default value is 580.
	</div>
	</td>
	</tr>
	<tr>
	<td width="30%" align="right" class="fieldtitle">
	Editor Height
	</td>
	<td width="60%" valign="top">
	~;
	if ($CConfig{'WebWriter_EditorHeight'})
	{
		print qq~
		<input type="text" size="4" name="WebWriter_EditorHeight" value="$CConfig{'WebWriter_EditorHeight'}">
		~;
	} 
	else
	{
		print q~
		<input type="text" size="4" name="WebWriter_EditorHeight" value="300">
		~;
	}
	print qq~
	</td>
	<td width="10%" align="center" valign="top">
	<input type="button" value="Default" onclick="document.WebWriter_SettingsSave.WebWriter_EditorHeight.value='300'">
	</td>
	</tr>
	<tr>
	<td width="100%" valign="top" colspan="3" class="description">
	<div align="left">
	The height in pixels of the editor that appears on the submit news page. Must be between 100 and 3000. Default value is 300.
	</div>
	</td>
	</tr>
	</table>
	</p>
	<table width="80%" align="center" border="0" cellpadding="2" cellspacing="2" class="description">
	<tr>
	<td width="100%" align="center" valign="top">
	<input type="submit" value="Save Settings">
	<input type="reset" value="Reset All">
	<input type="button" value="Default All" onclick="
	document.WebWriter_SettingsSave.WebWriter_ImageURL.value='$WebWriter_ImageURL';
	document.WebWriter_SettingsSave.WebWriter_EditorWidth.value='580';
	document.WebWriter_SettingsSave.WebWriter_EditorHeight.value='300';
	document.WebWriter_SettingsSave.WebWriter_htmlArea.status=false;
	document.WebWriter_SettingsSave.WebWriter_smileys.status=false;
	document.WebWriter_SettingsSave.WebWriter_smileysCount.value='52';
	">
	</td>
	</tr>
	</table>
	</form>
	~;
	WebWriterFooter();
	$addon->pageFooter();
}

sub WebWriterSettingsSave
{
	CRHTMLHead('WebWriter - Settings Save');
	print q~
	<p align="center">
	~;
	if ($in{'WebWriter_ImageURL'})
	{
		if (($in{'WebWriter_ImageURL'} =~ /http\:\/\//) or ($in{'WebWriter_ImageURL'} =~ /\//))
		{
			if ($in{'WebWriter_ImageURL'} =~ /\/$/)
			{
				push(@WebWriter_Errors,q~
				The "Image URL" contains a trailing slash ("/").
				~);
			}
		} 
		else
		{
			push(@WebWriter_Errors,q~
			The "Image URL" does not start with "http://" or not with "/". Are you sure you provided the URL or Relative Web URL instead of the Absolute Path?
			~);
		}
	} 
	else 
	{
		push(@WebWriter_Errors,q~
		The field "Image URL" was left empty.
		~);
	}

	if ($in{'WebWriter_EditorWidth'}) 
	{
		unless (($in{'WebWriter_EditorWidth'} >= 100) && ($in{'WebWriter_EditorWidth'} <= 3000))
		{
			push(@WebWriter_Errors,q~
			The "Editor Width" value must be between 100 and 3000.
			~);
		}
	}
	else 
	{
		$in{'WebWriter_EditorHeight'} = 580;
	}


	if ($in{'WebWriter_EditorHeight'})
	{
		unless (($in{'WebWriter_EditorHeight'} >= 100) && ($in{'WebWriter_EditorHeight'} <= 3000))
		{
			push(@WebWriter_Errors,q~
			The "Editor Height" value must be between 100 and 3000.
			~);
		}
	}
	else
	{
		$in{'WebWriter_EditorHeight'} = 300;
	}

	if (defined($in{'WebWriter_smileysCount'}))
	{
		unless (($in{'WebWriter_smileysCount'} >= 0) && ($in{'WebWriter_smileysCount'} <= 1000))
		{
			push(@WebWriter_Errors,q~
			The "Smileys count" value must be between 0 and 1000.
			~);
		}
	}
	else
	{
		$in{'WebWriter_smileysCount'} = 52;
	}

	if (@WebWriter_Errors)
	{
		$WebWriter_Errors = join('|x|',@WebWriter_Errors);
		WebWriterError($WebWriter_Errors);
	}
	else
	{
		$CConfig{'WebWriter_ImageURL'} = HTMLescape($in{'WebWriter_ImageURL'});
		$CConfig{'WebWriter_EditorWidth'} = HTMLescape($in{'WebWriter_EditorWidth'});
		$CConfig{'WebWriter_EditorHeight'} = HTMLescape($in{'WebWriter_EditorHeight'});
		$CConfig{'WebWriter_smileys'} = HTMLescape($in{'WebWriter_smileys'});
		$CConfig{'WebWriter_htmlArea'} = HTMLescape($in{'WebWriter_htmlArea'});
		$CConfig{'WebWriter_smileysCount'} = HTMLescape($in{'WebWriter_smileysCount'});
		print q~
		<table width="80%" border="0" cellpadding="2" cellspacing="2">
		<tr>
		<td width="100%" align="center" valign="top" class="fieldtitle">
		Success!
		</td>
		</tr>
		<tr>
		<td width="100%" align="center" valign="top" class="description">
		WebWriter Settings have been successfully saved.
		</td>
		</tr>
		</table>
		~;
	}
	print q~
	</p>
	~;
	WebWriterFooter();
	$addon->pageFooter();
}

$WebWriter_EditorSubmit = <<'END CODE';
	WebWriterCheckConfig();
	WebWriterCheckBrowser();
	$fcode = WebWriterEditor('Submit') if (($fn eq 'Text') && ($WebWriter_OkBrowser) && ($WebWriter_ConfigOk));
END CODE

$WebWriter_EditorModify = <<'END CODE';
	WebWriterCheckConfig();
	WebWriterCheckBrowser();
	$fcode = WebWriterEditor('Modify') if (($fn eq 'Text') && ($WebWriter_OkBrowser) && ($WebWriter_ConfigOk));
END CODE


sub WebWriter_Submit
{
	WebWriterCheckConfig();
	WebWriterCheckBrowser();
	if (($WebWriter_OkBrowser) && ($WebWriter_ConfigOk))
	{
		print "\n";
		$WebWriterMessageSubmitOriginal = $Messages{'Submit'};
		$WebWriterMessageResetOriginal  = $Messages{'Reset'};
		$WebWriterMessagePreviewOriginal  = $Messages{'Preview'};

#		$Messages{'Submit'} .= q~" onClick="Save();document.forms.submitnews.target = '_top'~;
		$Messages{'Reset'} .= q~" type="button" onClick="WWFormReset()~;
#		$Messages{'Preview'} .= q~" onClick="Save();document.forms.submitnews.target = '_blank'~;
	}
}

sub WebWriter_AfterTable_Modify
{
	WebWriterCheckConfig();
	WebWriterCheckBrowser();
	if (($WebWriter_OkBrowser) && ($WebWriter_ConfigOk))
	{
#		print qq~<br><table width="80%" align="center" border="0" cellpadding="2" cellspacing="2"><tr><td width="100%" valign="top" class="description"><div align="center">~;
		$WebWriterMessageSubmitOriginal = $Messages{'Submit'};
		$WebWriterMessagePreviewOriginal  = $Messages{'Preview'};
		$WebWriterMessageResetOriginal  = $Messages{'Reset'};
#		$Messages{'Submit'} .= q~" onClick="Save();document.forms.submitnews.target = '_top'~;
		$Messages{'Reset'} .= q~" type="button" onClick="WWFormReset()~;
#		$Messages{'Preview'} .= q~" onClick="Save();document.forms.submitnews.target = '_blank'~;

		WebWriterCheckAddons();
		if ($WebWriter_LoadedAddon{'htmlbuild'})
		{
			@WebWriter_LoadedAddons = split(/~/,$CConfig{'AddonsLoaded'});
			foreach $i (@WebWriter_LoadedAddons)
			{
				next if (($i eq 'cra_htmlbuild.pl') or ($i eq 'cra_webwriter.pl'));
				push(@WebWriter_LoadedAddons2,$i);
			}
			$CConfig{'AddonsLoaded'} = 'cra_webwriter.pl~';
			$CConfig{'AddonsLoaded'} .= join('~',@WebWriter_LoadedAddons2);
			if (@WebWriter_LoadedAddons2)
			{
				$CConfig{'AddonsLoaded'} .= '~cra_htmlbuild.pl';
			} 
			else 
			{
				$CConfig{'AddonsLoaded'} .= 'cra_htmlbuild.pl';
			}
		}
	} 
	else 
	{
		if ($WebWriter_OkBrowser) 
		{
			print '<center><font size=1 color=red>The WebWriter addon is installed, but is not yet configured in the Administration section.</font></center>';
		} 
		unless ($WebWriter_OkBrowser) 
		{

			if ($CConfig{'isPublicSite'}) 
			{ 
				print '<center><font  size="1">Your browser not compatible with WebWriter. Please download the latest version of <a href="http://www.microsoft.com/windows/ie" target="_dlmsie">Microsoft Internet Explorer</a> or <a href="http://www.mozilla.org" target="_dlmoz">Mozilla</a>.</center>';
			} 
			else 
			{ 
				print '<center><font  size="1">Your browser not compatible with WebWriter. Please download the latest version of Microsoft Internet Explorer or Mozilla.</center>';
			}

			unless ($WebWriter_ConfigOk) 
			{
				print '<center><font size=1 color=red>The WebWriter addon is installed, but is not yet configured in the Administration section.</font></center>';
			}

		}
	}
}

sub WebWriter_AfterTable_Submit 
{
	WebWriterCheckConfig();
	WebWriterCheckBrowser();
	if (($WebWriter_OkBrowser) && ($WebWriter_ConfigOk)) 
	{
		WebWriterCheckAddons();
		if ($WebWriter_LoadedAddon{'htmlbuild'}) 
		{
			@WebWriter_LoadedAddons = split(/~/,$CConfig{'AddonsLoaded'});
			foreach $i (@WebWriter_LoadedAddons) 
			{
				next if (($i eq 'cra_htmlbuild.pl') or ($i eq 'cra_webwriter.pl'));
				push(@WebWriter_LoadedAddons2,$i);
			}
			$CConfig{'AddonsLoaded'} = 'cra_webwriter.pl~';
			$CConfig{'AddonsLoaded'} .= join('~',@WebWriter_LoadedAddons2);
			if (@WebWriter_LoadedAddons2) 
			{
				$CConfig{'AddonsLoaded'} .= '~cra_htmlbuild.pl';
			}
			else 
			{
				$CConfig{'AddonsLoaded'} .= 'cra_htmlbuild.pl';
			}
		}
	}
	else 
	{
		if ($WebWriter_OkBrowser) 
		{
			print '<center><font size=1 color=red>The WebWriter addon is installed, but is not yet configured in the Administration section.</font></center>';
		} 
		unless ($WebWriter_OkBrowser) 
		{

			if ($CConfig{'isPublicSite'}) 
			{ 
				print '<center><font  size="1">Your browser not compatible with WebWriter. Please download the latest version of <a href="http://www.microsoft.com/windows/ie" target="_dlmsie">Microsoft Internet Explorer</a> or <a href="http://www.mozilla.org" target="_dlmoz">Mozilla</a>.</center>';
			} 
			else 
			{ 
				print '<center><font  size="1">Your browser not compatible with WebWriter. Please download the latest version of Microsoft Internet Explorer or Mozilla.</center>';
			}

			unless ($WebWriter_ConfigOk) 
			{
				print '<center><font size=1 color=red>The WebWriter addon is installed, but is not yet configured in the Administration section.</font></center>';
			}

		}
	}
}

sub WebWriterCheckNewlinesHTML 
{
	WebWriterCheckConfig();
	WebWriterCheckBrowser();
	if (($WebWriter_OkBrowser) && ($WebWriter_ConfigOk)) 
	{
		$fieldDB{'Text'}->{'Newlines'} = 0 if ($fieldDB{'Text'}->{'Newlines'});
		$fieldDB{'Text'}->{'DisableHTML'} = 0 if ($fieldDB{'Text'}->{'DisableHTML'});
	}
}

sub WebWriterEditor 
{
	$WebWriter_EditorType = shift;
	WebWriterCheckAddons();
	WebWriterCheckBrowser();
	ForceDisableAddon('cra_htmlbuild.pl') if ($WebWriter_LoaderAddon{'htmlbuild'});
	$WebWriter_DefaultValue = HTMLescape($fieldDB{'Text'}->{'DefaultValue'});
	$WebWriter_NewsText = HTMLescape(${'Text'});

#WebWriter_htmlArea
#WebWriter_smileys
	$WebWriter_antiMultiPart = '';


	if($WebWriter_LoadedAddon{'multipart'})
	{
		$WebWriter_antiMultiPart = qq~<script language="javascript">function spawn_preview(fn, url, w, h) {}</script>~;
	}

	$WebWriterEditor_for_htmlArea2_js = qq~
<script language="Javascript1.2">
<!-- 

_editor_url = "$CConfig{'WebWriter_ImageURL'}/";

var win_ie_ver = parseFloat(navigator.appVersion.split("MSIE")[1]);
if (navigator.userAgent.indexOf('Mac')        >= 0) { win_ie_ver = 0; }
if (navigator.userAgent.indexOf('Windows CE') >= 0) { win_ie_ver = 0; }
if (navigator.userAgent.indexOf('Opera')      >= 0) { win_ie_ver = 0; }
if (win_ie_ver >= 5.5) {
  document.write('<scr' + 'ipt src="' +_editor_url+ 'editor.js"');
  document.write(' language="Javascript1.2"></scr' + 'ipt>');  
} else { document.write('<scr'+'ipt>function editor_generate() { return false; }</scr'+'ipt>'); }


//-------[ Image Toolbar ]--[ MouseOver

function WWimgon() 
{
window.status= "Click to insert icon.";
}

//-------[ Image Toolbar ]--[ MouseOut

function WWimgout() 
{
window.status= "";
}

//-------[ Image Toolbar ]--[ Onclick

function WWimg(i) 
{
  if (win_ie_ver >= 5.5)
  {
    editor_insertHTML('Text',"<img src='$CConfig{'WebWriter_ImageURL'}/icons/" +i+ ".gif'>");
  } 
  else 
  { 
    document.submitnews.Text.value = document.submitnews.Text.value + "<img src='$CConfig{'WebWriter_ImageURL'}/icons/" +i+ ".gif'>";
  }
}

//-------[ Form ]--[ Reset

function WWFormReset(i) 
{
  if (win_ie_ver >= 5.5)
  {
	if(confirm('Do you want to reset your WYSIWYG area?'))
	  editor_setHTML('Text',document.submitnews.WebWriter_TextAreaReset.value);
	else
	  return false;
  } 
}

// --></script>
~;

	$WebWriterEditor_for_htmlArea3_js = qq~
<link href="$CConfig{'WebWriter_ImageURL'}/htmlarea.css" rel="stylesheet" type="text/css">
<script type="text/javascript" src="$CConfig{'WebWriter_ImageURL'}/htmlarea.js"></script>
<script type="text/javascript" src="$CConfig{'WebWriter_ImageURL'}/htmlarea-lang-en.js"></script>
<script type="text/javascript" src="$CConfig{'WebWriter_ImageURL'}/dialog.js"></script>
<script type="text/javascript" src="$CConfig{'WebWriter_ImageURL'}/popupwin.js"></script>
<script type="text/javascript" src="$CConfig{'WebWriter_ImageURL'}/plugins/TableOperations/table-operations.js"></script>
<script type="text/javascript" src="$CConfig{'WebWriter_ImageURL'}/plugins/TableOperations/table-operations-lang-en.js"></script>
<script language="Javascript1.2">
<!-- 
_editor_url = "$CConfig{'WebWriter_ImageURL'}/";

var editor = null;
function initEditor() {
  // create an editor for the "ta" textbox
  editor = new HTMLArea("Text");

  // register the TableOperations plugin with our editor
  editor.registerPlugin("TableOperations");

  // comment the following two lines to see how customization works
  editor.generate();
  return false;
}

//-------[ Image Toolbar ]--[ MouseOver

function WWimgon() 
{
window.status= "Click to insert icon.";
}

//-------[ Image Toolbar ]--[ MouseOut

function WWimgout() 
{
window.status= "";
}

//-------[ Image Toolbar ]--[ Onclick

function WWimg(i) 
{
  editor.insertHTML("<img src='$CConfig{'WebWriter_ImageURL'}/icons/" +i+ ".gif'>");
}

//-------[ Form ]--[ Reset

function WWFormReset(i) 
{
	if(confirm('Do you want to reset your WYSIWYG area?'))
	  editor.setHTML(document.submitnews.WebWriter_TextAreaReset.value);
	else
	  return false;
}
// --></script>
~;

	$tablewidth = $CConfig{'WebWriter_EditorWidth'}+60; 

	$WebWriterEditor_for_smileys_TABLE1 = qq~
<table cellpadding="2" cellspacing="0" border="0" height="$CConfig{'WebWriter_EditorHeight'}" width="$tablewidth"><tr><td width="$CConfig{'WebWriter_EditorWidth'}" height="$CConfig{'WebWriter_EditorHeight'}" align="left" valign="top">
~;

	if ($WebWriter_EditorType eq "Submit") 
	{
		$WebWriterEditor = qq~<input type="hidden" name="WebWriter_TextAreaReset" value="$WebWriter_DefaultValue">~;
	} 
	elsif ($WebWriter_EditorType eq "Modify") 
	{
		$WebWriterEditor = qq~<input type="hidden" name="WebWriter_TextAreaReset" value="$WebWriter_NewsText">~;
	}

	$WebWriterEditor .= qq~
<textarea name="Text" rows="24" cols="80" wrap="VIRTUAL" style="width: $CConfig{'WebWriter_EditorWidth'}px; height: $CConfig{'WebWriter_EditorHeight'}px; padding:1px; color:menutext;  border-width:1px; border-style:solid;" id="Text">$WebWriter_NewsText</textarea>
~;

	$WebWriterEditor_for_htmlArea2_init .= qq~
<script language="javascript1.2"> editor_generate('Text'); </script>
 ~;
	$WebWriterEditor_for_htmlArea3_init .= qq~
<script language="javascript1.2" defer="1"> initEditor(); </script>
 ~;



	print '</td>';

	$CConfig{'WebWriter_smileys'} = '' unless $CConfig{'WebWriter_smileys'};
	$CConfig{'WebWriter_smileys'} = '' if ($CConfig{'WebWriter_smileysCount'} eq 0);
	$WebWriterEditorSMILEYS = '';
	if ($CConfig{'WebWriter_smileys'} eq 'on') 
	{
		$WebWriterEditorSMILEYS = qq~<td width="60" valign="bottom">
		<div align="" style="border:0px solid; width:60px; height:$CConfig{'WebWriter_EditorHeight'}px;overflow:auto;padding:0px;margin:0px;text-align: center;">
		~;

#		$CConfig{'WebWriter_smileysCount'} 

		for ($WebWriter_IconCount=1; $WebWriter_IconCount <= $CConfig{'WebWriter_smileysCount'}; $WebWriter_IconCount++) # (53 > $WebWriter_IconCount) {
		{
			$WebWriterEditorSMILEYS .= qq~<a onMouseOver="WWimgon();" onMouseOut="WWimgout();" onClick="javascript: WWimg('$WebWriter_IconCount');" style="cursor:hand"><img alt="Click to insert icon" src="$CConfig{'WebWriter_ImageURL'}/icons/$WebWriter_IconCount.gif" border="0" vspace="2"></a><br>\n~;
		}
		$WebWriterEditorSMILEYS .= '</div></td>';
	}
	$WebWriterEditor_for_smileys_TABLE2 = '</tr></table>';

	if(($CConfig{'WebWriter_htmlArea'} eq 'on') && ($CConfig{'WebWriter_smileys'} eq 'on'))
	{
		return 
			$WebWriter_antiMultiPart.
			$WebWriterEditor_for_htmlArea2_js.
			$WebWriterEditor_for_smileys_TABLE1.
			$WebWriterEditor.
			$WebWriterEditorSMILEYS.
			$WebWriterEditor_for_htmlArea2_init.
			$WebWriterEditor_for_smileys_TABLE2;
	}
	elsif($CConfig{'WebWriter_htmlArea'} eq 'on' && $CConfig{'WebWriter_smileys'} eq '')
	{
		return 
			$WebWriter_antiMultiPart.
			$WebWriterEditor_for_htmlArea2_js.
			$WebWriterEditor.
			$WebWriterEditor_for_htmlArea2_init;
	}
	elsif($CConfig{'WebWriter_htmlArea'} eq '' && $CConfig{'WebWriter_smileys'} eq 'on')
	{
		return 
			$WebWriter_antiMultiPart.
			$WebWriterEditor_for_htmlArea3_js.
			$WebWriterEditor_for_smileys_TABLE1.
			$WebWriterEditor.
			$WebWriterEditorSMILEYS.
			$WebWriterEditor_for_htmlArea3_init.
			$WebWriterEditor_for_smileys_TABLE2;
	}
	else
	{
		return 
			$WebWriter_antiMultiPart.
			$WebWriterEditor_for_htmlArea3_js.
			$WebWriterEditor.
			$WebWriterEditor_for_htmlArea3_init;
	}

}

sub WebWriterCheckAddons 
{
	ForceDisableAddon('cra_wysiwyg.pl') if ($WebWriter_LoadedAddon{'wysiwyg'});

	@WebWriter_AddonsLoaded = split(/~/,$CConfig{'AddonsLoaded'});
	foreach $i (@WebWriter_AddonsLoaded) 
	{
		$i =~ s/cra_//;
		$i =~ s/\.pl//;
		$WebWriter_LoadedAddon{$i} = 1;
	}
}

sub WebWriterCheckConfig 
{
	$WebWriter_ConfigOk = 1 if (($CConfig{'WebWriter_ImageURL'}) && ($CConfig{'WebWriter_EditorWidth'}) && ($CConfig{'WebWriter_EditorHeight'}));
}

sub WebWriterCheckBrowser 
{
	$WebWriter_OkBrowser = 1 if (($ENV{'HTTP_USER_AGENT'} =~ /win/i) && ($ENV{'HTTP_USER_AGENT'} =~ /msie/i) && (($ENV{'HTTP_USER_AGENT'} =~ /5.5/i) or ($ENV{'HTTP_USER_AGENT'} =~ /6/i) or ($ENV{'HTTP_USER_AGENT'} =~ /7/i)));
	$WebWriter_OkBrowser = 1 if (($ENV{'HTTP_USER_AGENT'} =~ /Mozilla/i) && !($ENV{'HTTP_USER_AGENT'} =~ /Firebird/i) && !($ENV{'HTTP_USER_AGENT'} =~ /Phoenix/i));
	$WebWriter_OkBrowser = 0 if ($ENV{'HTTP_USER_AGENT'} =~ /Opera/i);
}

sub WebWriterNotes 
{
	$WebWriter_Notes = shift;
	@WebWriter_Notes = split(/\|x\|/,$WebWriter_Notes);
	foreach (@WebWriter_Notes) { $WebWriter_NoteNum++; } 
	print '<div align="center"><font size="-1">';
	if ($WebWriter_NoteNum > 1) 
	{
		print "You have <b>$WebWriter_NoteNum</b> notes in need of your attention. They are listed below<br><br>";
	}
	else 
	{
		print 'You have <b>1</b> note in need of your attention. It is listed below.<br><br>';
	}
	$WebWriter_NoteNum = 0;
	print '</font><table width="80%" align="center" border="0" cellpadding="2" cellspacing="2">';
	foreach $i (@WebWriter_Notes) 
	{
		$WebWriter_NoteNum++;
		print qq~<tr><td width="25%" align="right" valign="top" class="fieldtitle">Note #$WebWriter_NoteNum</div></td><td width="75%" valign="top" class="description"><div align="left">$i</font></div></td></tr>~;
	}
	print '</table><br>';
}

sub WebWriterError {
	$WebWriter_Errors = shift;
	@WebWriter_Errors = split(/\|x\|/,$WebWriter_Errors);
	foreach (@WebWriter_Errors) { $WebWriter_ErrorNum++; }
	print '<table width="80%" border="0" cellpadding="2" cellspacing="2"><tr><td width="100%" align="center" valign="top" class="fieldtitle">Error!</td></tr><tr><td width="100%" align="center" class="description">';
	if ($WebWriter_ErrorNum > 1) 
	{
		print "<b>$WebWriter_ErrorNum</b> errors occured with your submission. They are listed below.";
	} 
	else 
	{
		print '<b>1</b> error occured with your submission. It is listed below.';
	}
	$WebWriter_ErrorNum = 0;
	print '</td></tr></table><br><table width="80%" align="center" border="0" cellpadding="2" cellspacing="2">';
	foreach $i (@WebWriter_Errors) 
	{
		$WebWriter_ErrorNum++;
		print qq~<tr><td width="20%" align="right" valign="top" class="fieldtitle">Error #$WebWriter_ErrorNum</td><td width="80%" valign="top" class="description"><div align="left">$i</div></td></tr>~;
	}
	print '</table><br><table width="80%" border="0" cellpadding="2" cellspacing="2"><td width="100%" align="center" class="description">';
	if ($WebWriter_ErrorNum > 1) 
	{
		print qq~Please press your browser's back button and correct the <b>$WebWriter_ErrorNum</b> errors listed above. If this indicates an error that you can't solve, please post on the  ~;
		if ($CConfig{'isPublicSite'}) 
		{ 
			print '<a href="http://coranto.gweilo.org/forum/" target="_blank">Coranto Forums</a>. ';
		}
		else 
		{ 
			print 'Coranto Forums [ http://coranto.gweilo.org/forum/ ]. ';
		}
	} 
	else 
	{
		print q~Please press your browser's back button and correct the <b>1</b> error listed above. If this indicates an error that you can't solve, please post on the ~;
		if ($CConfig{'isPublicSite'}) 
		{ 
			print '<a href="http://coranto.gweilo.org/forum/" target="_blank">Coranto Forums</a>. ';
		}
		else 
		{ 
			print 'Coranto Forums [ http://coranto.gweilo.org/forum/ ]. ';
		}
	}
	print '</td></tr></table>';
}

sub WebWriterFooter 
{
	print '<hr width="80%" size="1" noshade><div align="center">Back to ' . PageLink({'action' => 'admin' , 'adminarea' => 'WebWriter'}) . 'WebWriter - Settings main page</a></div>';
}

#$addon->hook("DisplaySubForm_FormStart",\$WebWriter_FormTag);
$addon->hook("DisplaySubForm_Fields",\$WebWriter_EditorSubmit);
$addon->hook("ModifyNews_Edit_Fields",\$WebWriter_EditorModify);	

1;

__END__

=head1 WebWriter - Help
=head1 For more help go to the forums!
=head2 About
=begin html
The homepage of this addon is located at: http://webwriter.sourceforge.net/ (mirror: http://kriko.neosurge.net/webwriter/ )<br>
All the versions of this addon are released as open source.<br>
This addon should be compatible with all of the versions of Coranto from 1.02.
=end html

=head2 Setup
=begin html
Upload ALL the files. Read the readme and license. Enable the addon. Goto Administration -> WebWriter, there configure the settings for webwriter and you are done.
=end html
=head2 Updates:
=begin html
<pre style="background-color: white;">
Updates in version 3.1 :
 * Compatible with htmlArea ver 2 and 3 (alpha).
 * Session forgetting bug fixed.
 * Smileys support back. Smileys supported for both, 
   htmlArea versions - 2 and 3.
 * Ability to enable or disable the smileys toolbar. 
   If smiley count is 0 then smiley toolbar is disabled.
 * Ability to enter the number of smileys used in the 
   smiley toolbar. The loaded smileys will be from 1 to 
	SMILEYCOUNT.
 * Better settings saving. When value left blank then 
   default is used.
 * Partial fix to a Multipart and WebWriter problem. 
   Multipart previews can not be used anymore. Their 
	javascript is disabled by Webwriter.
<hr size="1" noshade>
Updates in version 3.0 :
 * Now using htmlArea (ver 3.0 alpha) javascript 
   program as the WYSIWYG editor module. This change was 
	done, because this edior is more stable and includes 
	many new features.
 * Deleted alot of old code, what came obsolete with
   this new wysiwyg module.
 * New license - OPEN-SOURCE!
<hr size="1" noshade>
Updates in version 2.5 :
 * NB! This version works with Coranto 1.02 and newer!
 * Now privacy compatible.
 * Fixed loading code that disabled loading the news
   contents from CorantoSQL database.
 * Fixed a small bug which prevented users seeing the
   Usage help. Sorry for that one, I had overlooked it
   before.
 * Fixed some perl code, which prevented WebWriter 
   working correctly under servers which had old Perl
   version.
<hr size="1" noshade>
Updates in version 2.4 :
 * Better image managment 
 * Fixed some bugs
 * Remove link feature
<hr size="1" noshade>
Updates in version 2.3 :
 * compatible with SelectImage addon
 * better working with Preview addon (with the latest version)
<hr size="1" noshade>
Updates in version 2.2 :
 * modified the toolbar code
 * modified the js code
 * compatible with news preview (the original)
 * !!! t a b l e !!!  support :)
 * backround music support :)
 * updated the css generating sub what inserted #DADADA as 
   default color of Button Out color (if no color was present). 
   Used a better way for that.
 * image toolbar refreshed, now using a bit less code
 * some other minor/major fixes that I can't remember right now.
</pre>
=end html
=head2 Why? What?
If you have such browser like Microsoft Internet Explorer or a distro of Mozilla with the Gecko engine (from Mozilla 1.4) then you can make your life with Coranto much easier.
You can submit your news and modify them like you are writing in MS Word. But actully you are in your submit/modify news page.
You will have a toolbar and a text entering box with the most common and useful functions ever.
When you apply formatting then you will see what you made, you will not see any nasty html code.
=head2 WebWriter licence:
I am announcing this addon OPEN-SOURCE. This means, anybody who wants may edit this addon and use it as they like. But I do not want people selling this addon or any way including it into a product what is commercial. This addon must remain free. I think the license for this is GNU-GPL license, you can find a copy of it from everywhere around the web, I am too lazy to read it, so I'll leave the job for you ;) Just please, enjoy this fine product :) All the previous versions of this addon are now also released under OPEN-SOURCE license. But it is provided under "AS-IS", that I am not responsiable for any damage this might do to your system (very unlikely tho).

But, please, if you like to make improvements to this addon what would really help the users of it, then please send the modified code to me, and I will review it, and release it as a new version :)

=head2 htmlArea license:

htmlArea License (based on BSD license)
Copyright (c) 2002, interactivetools.com, inc.
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

1) Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer. 

2) Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution. 

3) Neither the name of interactivetools.com, inc. nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission. 

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=head2 Addon authors:
=begin html
<font size="4">kriko</font><ul><b>e-mail:</b> <a href="mailto:kri.ko@hot.ee">kri.ko@hot.ee</a><br><b>website:</b> (homepage) http://kriko.neosurge.net/<br><b>website:</b> (factory sites) http://factory.eatsleepcode.ca<br><b>location:</b> Estonia (one of the Baltic States) - Europe<br><br>*NewsPro Factory contains all addons, mods and other stuff for NewsPro what are made by various addonmakers<br>*Coranto Factory contains all addons, mods and other stuff for Coranto what are made by mostly kriko, AeroSoul & Xzyon</ul><font size="4">AeroSoul</font><ul><b>email:</b> <a href="mailto:aero-soul@rogers.com">aero-soul@rogers.com</a><br><b>website:</b> http://www.eatsleepcode.ca/<br><b>location:</b> Toronto - Canada</ul>
=end html