#!/usr/bin/perl
# Debug script useful to auto-generate random news
# v 0.2 - 11 Dec 2004

# finds paths for crcfg.dat and newsdat.txt (default configuration)
my $dirname; 
eval q~use Cwd; $dirname = cwd();~;
unless ($dirname) {$dirname = `pwd`; chomp $pwd;}
$dirname =~ s!\\!/!g;
$dirname =~ /(\S+)\/(\S+)$/;
my $dirnameup=$1;

# crcfg.dat path
$crcfgpath= "$dirnameup/data";
$newsdatpath= "$dirnameup/data";


# The number of news items to include
$ItemNumber = 200;

# How far apart these items should be, in seconds.
$ItemSpacing = (60 * 60 * 60 * 3);

# How many words per item
$WordsPerItem = 150;

# How many letters in each "word"
$LettersPerWord = 6;

$newsid = 'a';

print "Content-type: text/html\n\n";
print "<h1>News Generation for Coranto</h1>";
print "1) Attempting to read configuration file: <br>$crcfgpath/crcfg.dat";

$TheCounter = 1;
$NowTime = time;
if (-e "$crcfgpath/crcfg.dat") {
  require "$crcfgpath/crcfg.dat";
  print "<br><br>---> Correctly read configuration file:<br> $crcfgpath/crcfg.dat";
}
else { print "<br><br>Error: the configuration file: $crcfgpath/crcfg.dat does not exist or is not readable";
}

$TimeDiff = (($ItemNumber + 1) * $ItemSpacing);
@alpha = split(//, 'abcdefghijklmnopqrstuvwxyz');
print "<br><br>2) Attempting to write to the newsdat file: <br>$newsdatpath/newsdat.txt<br>";
open(ND, ">$newsdatpath/newsdat.txt");
while ($TheCounter < $ItemNumber) {
	$Text = '';
	for ($Count2 = 0; $Count2 < $WordsPerItem; $Count2++) {
		for ($Count3 = 0; $Count3 <= $LettersPerWord; $Count3++) {
			$Text .= $alpha[int(rand(26))];
		}
		$Text .= " ";
	}
	$User = 'FakePoster';
	$Subject = "Fake News Item #$TheCounter";
	$Category = "(default)";
	$newstime = ($NowTime - ($ItemSpacing * $TheCounter));
	$newsline = JoinDataFile();
	print ND $newsline . "\n";

	$newsid++;
	$TheCounter++;
	unless ($TheCounter % 50) { print '.'; }
}
close(ND);
print "\n<br><br>---> Correctly written database file<br> $newsdatpath/newsdat.txt";
print "\n<br><br><b>Summary</b>\n<br>Generated $ItemNumber items with $WordsPerItem words each.";