
sub FirstTimePage {

	$crlang = $in{'SessionLanguage'};
	if($crlang && -e "$CConfig{'lang_path'}/$crlang") {
		NeedFile("$CConfig{'lang_path'}/$crlang");
		unless ($crlangVersion == $crlangVer) {
			CRcough('Your crsetup.pl and language files are mismatched -- that is, they come from different versions or builds of Coranto. Visit <a href="http://coranto.gweilo.org/">the Coranto homepage</a>, download a new copy of Coranto, and upload new versions of crsetup.pl and the language files.',1);
		}
	}
	
	print &header;
	my $prog = $abspath || GetDirInfo();
		
	CRHTMLHead(CRgetmsg('Coranto Setup'));
	print
		MidHeading(CRgetmsg('Welcome to Coranto')),
		StartForm({'action' => 'setup', 'setupstep' => 1}, 'name="setup"'),
	
		MidParagraph(CRgetmsg(q~Congratulations: one of the most problematic parts of setup, getting Coranto to run as a CGI script, is complete. Now, you need to give Coranto some information -- the paths where its files are stored, the name you'd like to log in with, and various other important details. On this and the next couple of pages, Coranto will ask you for this information.~), 1),

		MidHeading(CRgetmsg('Licensing')),
		MidParagraph(q~
	This is the download version of Coranto. Although it is and will continue to be available for free download,
	in order to prevent confusion and make support easier, we ask that you do not distribute copies of it yourself.<p>
	The primary license requirement for this version is that you include a link to the Coranto homepage on your news page(s).
	Specifically, every page which contains full news items must include a link to the Coranto site,
	preferably via the phrase Powered by Coranto. Pages which contain only headlines linking to full news items are exempt. Since
	the old Coranto official site (http://www.amphibianweb.com/) is at present in the hands of cyberquatters with no relation to Coranto, 
	as an option you can choose to remove the link text, or to link to the Unofficial
	site, on a per profile basis.<p>
	The Display Link option, off by default, makes Coranto include the link automatically. If you prefer, you can turn include the link yourself, 
	provided that it remains in a visible location and is not significantly smaller than the main text on the page.
					~ . qq~<br><br>		<center><select name="license" onchange="safety(document.setup)"><option value="" selected>~  . CRgetmsg('Please select an option') . q~</option>
			<option value="1">~ . CRgetmsg('I agree -- I will comply with the Coranto license') . q~</option><option value="0">~ . CRgetmsg('I disagree') . q~</option></select></center>~, 1),
	
		MidHeading(CRgetmsg('Privacy')),
		MidParagraph(CRgetmsg('_PRIVACY_INFO') . q~
			<center><P>~ . CRgetmsg('Please choose your privacy settings') . q~: <select name="PublicOrPrivate" onchange="pvtoggle(document.setup)"><option value="1">~ . CRgetmsg('Public') . q~</option><option value="0">~ . CRgetmsg('Private') . q~</option></select></center>~, 1),
		SettingsTable(CRgetmsg('Version Checking?'), qq~<select name="VersionChecking"><option value="1" selected>~ . CRgetmsg('Yes (On)') . q~</option><option value="0">~ . CRgetmsg('No (Off)') . q~</option></select>~, CRgetmsg(q~Set this to 'Yes' if you would like an image to be displayed on the main page indicating the version number of the most up to date stable release of Coranto.~)),
		SettingsTable(CRgetmsg('Urgent Notification?'), qq~<select name="UrgentNotification"><option value="1" selected>~ . CRgetmsg('Yes (On)') . q~</option><option value="0">~ . CRgetmsg('No (Off)') . q~</option></select>~, CRgetmsg(q~Set this to 'Yes' if you'd like us to notify you of important news (bug fixes, new releases, etc.). These news will automatically appear inside your Coranto Administration View. During connection some simple stats (such as version number, and win/unix server) might be transmitted to the Coranto site for statistical analysis. No private info (name, email etc) will be collected at all.~)),
	
		MidHeading(CRgetmsg('File Paths')),
		MidParagraph(($prog ne '.' ? CRgetmsg('It looks like the absolute path to the directory where coranto.cgi is located in is <b>[_1]</b>.', $prog) . CRgetmsg('This guess is accurate 95% of the time. Please refer to the setup documentation for how to change this path if you are absolutely certain that the absolute path to your directory is something different.') : CRgetmsg('Unfortunately, Coranto could not automatically determine the absolute path to where coranto.cgi is located. You can still continue with the setup, but please refer to the setup documentation for how to specify this path. If you are not sure what the path is, please contact your host.')) .
			q~<P>~ . CRgetmsg('In the boxes below, please enter the absolute paths for the two different Coranto directories: <b>News Files</b> and <b>Archive Files</b>. You must enter <b>absolute paths</b> here, not URLs. (Use forward / slashes, even on Windows servers, and do not include a trailing slash.) It is possible to change these settings once you have completed the setup as well.'), 1);
	Setup_PathSettings("$prog/data", "$prog/data/arc");

	my @dirpaths = ("$prog/addons", "$prog/docs", "$prog/languages", "$prog/templates");
	my $direrr = Setup_VerifyDirectories(@dirpaths);
	if( $direrr ) {
		print
			MidHeading(CRgetmsg('Additional File Paths')),
			MidParagraph(CRgetmsg(q~Coranto has discovered that some necessary folders doesn't exist at their default locations, see details below. Please verify that the folders exists and has the right permissions (CHMOD settings) or specify new paths below.~) . qq~<p>$direrr~, 1);
		Setup_ExtraPathSettings(@dirpaths);
	}
		
	print qq~<input type="hidden" name="SessionLanguage" value="$crlang">~;
	print q~<table align="center" width="80%" border="0"><tr><td class="description"><div align="center"><input type="submit" class="inputsubmit" name="sbmt" value="Continue Setup"></div></td></tr></table></form><script language="javascript">
		function pvtoggle (form) {
			if (form.PublicOrPrivate[form.PublicOrPrivate.selectedIndex].value == 0) {
				form.VersionChecking.disabled = true;
				form.VersionChecking.value = 0;
				form.UrgentNotification.disabled = true;
				form.UrgentNotification.value = 0;
			}
			else {
				form.VersionChecking.disabled = false;
				form.VersionChecking.value = 1;
				form.UrgentNotification.disabled = false;
				form.UrgentNotification.value = 1;
			}
		}
		function safety (form) {
			if (form.license[form.license.selectedIndex].value == 1) {
				form.PublicOrPrivate.disabled = false;
				form.VersionChecking.disabled = false;
				form.UrgentNotification.disabled = false;
				form.htmlfile_path.disabled = false;
				form.archive_path.disabled = false;
				form.sbmt.disabled = false;
			}
			else {
				form.PublicOrPrivate.disabled = true;
				form.VersionChecking.disabled = true;
				form.UrgentNotification.disabled = true;
				form.htmlfile_path.disabled = true;
				form.archive_path.disabled = true;
				form.sbmt.disabled = true;
			}
		}
		safety(document.setup);</script>~;
	&CRHTMLFoot_NoNav;
}

sub Setup_PathSettings {
	my ($news, $arc) = @_;
	print
		SettingsTable(CRgetmsg('News Files Path') . ':', qq~<input type="text" name="htmlfile_path" size="50" value="$news">~, CRgetmsg(q~Absolute path to the directory where you'd like the news files -- the ones to be used on your web pages -- to be generated by default~)),
		SettingsTable(CRgetmsg('Archive Files Path') . ':', qq~<input type="text" name="archive_path" size="50" value="$arc">~, CRgetmsg(q~Absolute path to the directory where you'd like news archive to be generated by default. Often the same as the News File path~));
}

sub Setup_ExtraPathSettings {
	my ($addondir, $docsdir, $langdir, $tmpldir) = @_;
	print
		SettingsTable(CRgetmsg('Addon Path') . ':', qq~<input type="text" name="addon_path" size="50" value="$addondir">~, CRgetmsg(q~Absolute path (<b>not</b> URL) to the directory where the addons are located. Use forward slashes (/), even on Windows systems. Do not include a trailing slash.~)),
		SettingsTable(CRgetmsg('Documentation Path') . ':', qq~<input type="text" name="docs_path" size="50" value="$docsdir">~, CRgetmsg(q~Absolute path (<b>not</b> URL) to the directory where the (addon) documenation files are located. Use forward slashes (/), even on Windows systems. Do not include a trailing slash.~)),
		SettingsTable(CRgetmsg('Language Path') . ':', qq~<input type="text" name="lang_path" size="50" value="$langdir">~, CRgetmsg(q~Absolute path (<b>not</b> URL) to the directory where the language files are located. Use forward slashes (/), even on Windows systems. Do not include a trailing slash.~)),
		SettingsTable(CRgetmsg('Template Path') . ':', qq~<input type="text" name="tmpl_path" size="50" value="$tmpldir">~, CRgetmsg(q~Absolute path (<b>not</b> URL) to the directory where the templates are located. Use forward slashes (/), even on Windows systems. Do not include a trailing slash.~));
}

sub Setup_VerifyDirectories {
	my (@dirpaths) = @_;
	my $errmsg = '';
	for $dir (@dirpaths) {
		if (!-d $dir) {
			$errmsg .= CRgetmsg('Could not locate directory <b>[_1]</b>', $dir) . "<br>";
		}
	}
	return $errmsg;
}
  

sub SetupHandler {
	
	$crlang = $in{'SessionLanguage'};
	if($crlang && -e "$CConfig{'lang_path'}/$crlang") {
		NeedFile("$CConfig{'lang_path'}/$crlang");
		unless ($crlangVersion == $crlangVer) {
			CRcough('Your crsetup.pl and language files are mismatched -- that is, they come from different versions or builds of Coranto. Visit <a href="http://coranto.gweilo.org/">the Coranto homepage</a>, download a new copy of Coranto, and upload new versions of crsetup.pl and the language files.',1);
		}
	}

		
	if ($CConfig{'firsttime'} ne 'yes') {
		CRcough(CRgetmsg(q~This script appears to have already been set up. If you'd like to go through set up again, re-upload the original nsettings.cgi file.~));
	}
	
	my $prog = $abspath || GetDirInfo();
	
	if ($in{'setupstep'} == 1) {
		print &header;
		unless ($in{'license'}) {
			CRcough(CRgetmsg(q~If you do not agree to the license conditions, please delete the Coranto files from your server.~));
		}
		unless ($in{'htmlfile_path'} && $in{'archive_path'}) {
			CRcough(CRgetmsg('You must enter paths for both directories.'));
		}
		my ($news, $arc) = (SecurePath($in{'htmlfile_path'}), SecurePath($in{'archive_path'}));
		my $err;

		# PARAHEAD: Fetch the folders the user has specified or set them to the default locations (2005-05-09)
		my $addondir = $in{'addon_path'} || "$prog/addons";
		my $docsdir = $in{'docs_path'} || "$prog/docs";
		my $langdir = $in{'lang_path'} || "$prog/languages";
		my $tmpldir = $in{'tmpl_path'} || "$prog/templates";

		my @dirpaths = ("$prog", "$news", "$arc", "$addondir", "$docsdir", "$langdir", "$tmpldir");
		# PARAHEAD: Verify that the folders the user has specified exists (2005-05-09)
		my $direrr = Setup_VerifyDirectories(@dirpaths);
		$err .= $direrr;

		# TRIES TO READ Coranto paths from cruser first (allowing easier installation from sites with no writing access to the cgi-bin directory)
		# this falls back to the default case if no settings are found in cruser
		NeedFile('cruser.pl');
		my $data = $data_path?"$data_path":($abspath?"$abspath/data":"$prog/data");
		my @paths = ("$data/nsettings.cgi", "$data/crcfg.dat", "$data/nsbk.cgi", "$data/newsdat.txt", "$prog/crlang.pl");

		for $file (@paths) {
			if (!-e $file) {
				$err .= CRgetmsg('Could not locate file <b>[_1]</b>. The file does not appear to exist. Verify that this file is where it should be.', $file) . "<br>";
			} elsif(!-r $file) {
				$err .= CRgetmsg('Could not read file <b>[_1]</b>. The file appears to exist but is not readable. Check file permissions.', $file) . "<br>";
			} elsif(!-w $file) {
				$err .= CRgetmsg('Could not write to file <b>[_1]</b>. The file appears to exist but is not writable. Check file permissions.', $file) . "<br>";
			}
		}

		unless (open(TEST, ">>$news/delete.me")) {
			$err .= CRgetmsg('Could not create a new file in your News Files directory ([_1]). Check permissions on this directory.', $news);
		}
		close(TEST);
		unlink("$news/delete.me");

		$CConfig{'PublicOrPrivate'} = $in{'PublicOrPrivate'} unless(defined($CConfig{'PublicOrPrivate'}));
		$CConfig{'isPublicSite'} = $in{'PublicOrPrivate'} unless(defined($CConfig{'isPublicSite'}));
		
		$CConfig{'UrgentNotification'} = $in{'UrgentNotification'} unless(defined($CConfig{'UrgentNotification'}));
		$CConfig{'VersionChecking'} = $in{'VersionChecking'} unless(defined($CConfig{'VersionChecking'}));
				
		if ($err) {
			CRHTMLHead('File Error');
			print
				StartForm({'action' => 'setup', 'setupstep' => 1, 'license' => 1}),
				MidParagraph(CRgetmsg('Whilst testing that all necessary files could be written to, Coranto encountered some errors. Details on the errors are below. Errors are probably caused either by incorrect paths, which you can correct in the boxes below, or incorrect file permissions (CHMOD settings).') . qq~<p>$err~, 1);
			Setup_PathSettings($news, $arc);
			Setup_ExtraPathSettings("$addondir", "$docsdir", "$langdir", "$tmpldir") if($direrr);
			print qq~<input type="hidden" name="SessionLanguage" value="$crlang">~;
			print SubmitButton(CRgetmsg('Continue Setup')), '</form>';
			CRHTMLFoot_NoNav();
			exit;
		}
		
		$CConfig{'htmlfile_path'} = $news;
		$CConfig{'archive_path'} = $arc;
		$CConfig{'addon_path'} = $addondir;
		$CConfig{'docs_path'} = $docsdir;
		$CConfig{'lang_path'} = $langdir;
		$CConfig{'tmpl_path'} = $tmpldir;
		
		CRHTMLHead(CRgetmsg('Coranto Setup'));
		my $rpass = RandomWord(8);

		# Present the available languages, the language that was choosen when the user logged in is preselected
		my $langoptstr = &GetLangOptions({}, $crlang);

		# Fallback gracefully
#		$langoptstr ||= qq~<option value="$prog/crlang.pl" selected>English</option>~;

		print
			StartForm({'action' => 'setup', 'setupstep' => 2}),
			MidHeading(CRgetmsg('File and Path Tests')),
			MidParagraph(CRgetmsg('Testing paths and file permissions... all tests were successful. The paths you entered seem correct, as do file permissions.'), 1),
			MidHeading(CRgetmsg('Create New User')),
			MidParagraph(CRgetmsg(q~Please choose the username and password you'd like to use to log in to Coranto. By default, the username you choose will appear beside your news posts. This user will be your Super-Admin user, and will be the only user with authority to remove standard Admin-level users.~), 1),
			SettingsTable(CRgetmsg('Username') . ':', '<input type="text" name="user">', CRgetmsg('Usernames may contain only letters, numbers, and underscores (_).')),
			SettingsTable(CRgetmsg('Password') . ':', qq~<input type="text" name="pass" value="$rpass">~, CRgetmsg('Your password must be a minimum of five characters. A randomly-generated secure password is suggested in the box above.')),
			SettingsTable(CRgetmsg('E-mail') . ':', qq~<input type="text" name="email">~, CRgetmsg('Your email address.')),
			MidHeading(CRgetmsg('Language Settings') . ':'),
			MidParagraph(CRgetmsg('This setting will allow you to have a global default language when a user logs in to Coranto but the prefered language can be changed individually user by user as well. The translations are kindly provided by Coranto users.')),
			SettingsTable(CRgetmsg('Language') . ':', qq~<select name="GlobalLanguage">$langoptstr</select>~, CRgetmsg('Choose your prefered language for Coranto'));
		
		print qq~<input type="hidden" name="SessionLanguage" value="$crlang">~;
			
		print SubmitButton(CRgetmsg('Continue Setup')), '</form>';
		CRHTMLFoot_NoNav();
		exit;
	}
	elsif ($in{'setupstep'} == 2) {
		print header();
		my $user = $in{'user'};
		my $pass = $in{'pass'};
		$CConfig{'GlobalLanguage'} = $in{'GlobalLanguage'};
		CRcough(CRgetmsg('Username &quot;[_1]&quot; contains illegal characters. Only letters, numbers, and underscores are permitted in usernames.', $user)) if ($user =~ /[^a-zA-Z0-9_]/);
		CRcough(CRgetmsg('Usernames have to be at least 3 characters long.')) unless length($user) > 2;
		CRcough(CRgetmsg('Passwords have to be at least 5 characters long.')) unless length($pass) > 4;
		CRcough(CRgetmsg('You must enter a valid Email address.')) unless length $in{'email'} > 2;
		NeedFile('crcrypt.pl');
		my $crcrypt = new CRcrypt;
		$userdata{$user}->{'CPassword'} = $crcrypt->GetHash($pass . $user);
		$userdata{$user}->{'UserLevel'} = 3;
		$userdata{$user}->{'Email'} = $in{'email'};
		WriteUserInfo();
		CRHTMLHead(CRgetmsg('Coranto Setup'));
		
		print 
			StartForm({'action' => 'setup', 'setupstep' => 3, 'user' => $user, 'email' => $in{'email'}}),
			MidHeading(CRgetmsg(q~Account '[_1]' Created~, $user)),
			MidParagraph(CRgetmsg('Please remember your password. You will need it to use Coranto in the future, and it is not easily reset if you forget it.'), 1),
			MidParagraph(CRgetmsg(q~To get Coranto started quickly, some of the more essential settings are organized into a single page below. All these settings will be available in Coranto's Administration section in the future, and you will be able to change anything you enter here.~), 1);
		NeedFile('cradmin.pl');

		SettingsEngine_Display(SetupSettingsLoad(), \%CConfig);
		print qq~<input type="hidden" name="SessionLanguage" value="$crlang">~;
		print 
			MidParagraph(CRgetmsg('After you click the button below, there may be a delay of about thirty seconds as a basic security check is performed and setup continues at the Coranto site.')),
			SubmitButton(CRgetmsg('Continue Setup (Almost finished!)'));
		CRHTMLFoot_NoNav();
		exit;
	}
	elsif ($in{'setupstep'} == 3) {
		NeedFile('cradmin.pl');
		$CConfig{'currentversion'} = $crcgiVer;
		$CConfig{'currentrc'} = $crcgiRC;
		$CConfig{'currentbuild'} = $crcgiBuild;
		$CConfig{'firsttime'} = 'no';
		$CConfig{'SuperAdmin'} = $in{'user'};
		my $afi = OpenAddons();
		if ($afi->{'backup'}) {
			my @AddonsLoaded = split(/~/, $CConfig{'AddonsLoaded'});
			push(@AddonsLoaded, 'cra_backup.pl');
			$CConfig{'AddonsLoaded'} = join('~', @AddonsLoaded);
		}

		SettingsEngine_Save(&SetupSettingsLoad(), \%CConfig);

		if ($CConfig{'PublicOrPrivate'}) {
			# public installation
#			print "Location: http://coranto.gweilo.org/scripts/done.php?b=$crcgiBuild&rc=$crcgiRC&u=" . URLescape($scripturl) . '&v=' . URLescape($crcgiVer) . "\n\n";
			print &header;
			CRHTMLHead(CRgetmsg('Setup Complete'));
			my $coranto_support_link=URLescape("http://coranto.gweilo.org/forum");
			my $coranto_mail_link=URLescape("http://www.gweilo.org/mailman/listinfo/coranto_gweilo.org");
			print MidParagraph('<br>' . CRgetmsg('If you need any further assistence with Coranto, be welcome to the Coranto Unofficial Site Support Forums where you will find help and tutorials: [_1]', qq~<a href="$coranto_support_link">$coranto_support_link</a>~) . '<br>');
			print MidParagraph(CRgetmsg('Setup is complete.<p>Click [_1]here[_2] to continue', PageLink(), '</a>'));
			&CRHTMLFoot_NoNav;
		}
		else {#private installation
			print &header;
			CRHTMLHead(CRgetmsg('Setup Complete'));
			print MidParagraph(CRgetmsg('Setup is complete.<p>Click [_1]here[_2] to continue', PageLink(), '</a>'));
			&CRHTMLFoot_NoNav;
		}
		exit;
	}
}


sub SetupSettingsLoad {
	NeedFile('cruser.pl');
	my $cfgfupa = $data_path?"$data_path":($abspath?"$abspath/data":GetDirInfo() . "/data");
	NeedFile("$cfgfupa/crcfg.dat");
	
	InitGTD('<Field: Hour>:<Field: Minute>:<Field: Second> <Field: AMPM>, <Field: Month_Name> <Field: Day>', 'GetFullDisplayTime');
	my @SetupSettings = (
	['heading: ' . CRgetmsg('Your Site')],		
	['SiteTitle', CRgetmsg('Site Name'), CRgetmsg('The name of your site. This will be displayed on Coranto script pages.')],
	['SiteLink', CRgetmsg('Site Link'), CRgetmsg(q~If you'd like a &quot;Back to Your Site&quot; link on Coranto script pages, enter a URL here. Otherwise, leave blank.~)],
	['heading: ' . CRgetmsg('Date &amp; Time Settings')],
	['Standard_Time_Zone', CRgetmsg('Time Zone'), CRgetmsg('Your time zone. Any name or abbreviation is acceptable -- this is for display purposes only.')],
	['Daylight_Time_Zone', CRgetmsg('Daylight Savings Time Zone'), CRgetmsg('As above, but during Daylight Savings Time.')],
	['TimeOffset', CRgetmsg('Server Time Offset'), CRgetmsg(q~Often, your server will be in a different time zone than you are. You can enter the difference, in hours, between the server's time and the time you would like displayed on news items. For instance, if your server is in London and you are in Boston, set this to -5. Changing this setting will not affect existing news items; only new items will have an adjusted time. (The server's current time is: [_1])~, GetFullDisplayTime($CurrentTime))],
	['12HourClock', CRgetmsg('12/24 Hour Clock?'), CRgetmsg('Choose between a 12 hour (AM/PM) and 24 hour clock.'), 
		[ ['1', CRgetmsg('12 Hour (AM/PM)')], ['0', CRgetmsg('24 Hour')] ] ]);
	return \@SetupSettings;
}
 
sub UpgradeToNewFolderStructure {
		my $msg = "";
		my $datafolder = $data_path?"$data_path":($abspath?"$abspath/data":GetDirInfo() . "/data");
		unless(-d $datafolder) {
			$msg .= "<li><p>Your data folder does not seem to be at the default location, please refer to the upgrade documentation for assistance. An intelligent guess is that you should create the folder below and move the files nsettings.cgi, crcfg.dat and newsdat.txt to it.<br>'<strong>" . GetDirInfo() . "/data</strong>'</p>";
#		} else {
#			unless(-e "$datafolder/nsettings.cgi") {
#				$msg .= "<li><p>Your nsettings.cgi file does not seem to be located in your data folder. An intelligent guess is that you should move your current nsettings.cgi file to the folder:<br>'<strong>$datafolder</strong>'</p>";
#			}
		}
		
		if($CConfig{'htmlfile_path'} && -d $CConfig{'htmlfile_path'}) {
			$msg .= "<li>Your html output folder does not seem to exists, make sure you have created one and that it is defined: '" . $CConfig{'htmlfile_path'} . "'";
		}
		if($CConfig{'archive_path'} && -d $CConfig{'archive_path'}) {
			$msg .= "<li>Your html archive output folder does not seem to exists, make sure you have created one and that it is defined: '" . $CConfig{'archive_path'} . "'";
		}
		my $addondir = "$CConfig{'admin_path'}/addons";
		unless(-d $addondir) {
			$msg .= "<li><p>Your addon folder does not seem to be at the default location, make sure you have created: '$addondir'</p>";
		}
		my $docsdir = "$CConfig{'admin_path'}/docs";
		unless(-d $docsdir) {
			$msg .= "<li>Your documentation folder does not seem to be at the default location, make sure you have created: '$docsdir'";
		}
		my $langdir = "$CConfig{'admin_path'}/languages";
		unless(-d $langdir) {
			$msg .= "<li>Your language folder does not seem to be at the default location, make sure you have created: '$langdir'";
		}
		my $tmpldir = "$CConfig{'admin_path'}/templates";
		unless(-d $tmpldir) {
			$msg .= "<li>Your template folder does not seem to be at the default location, make sure you have created: '$tmpldir'";
		}
				
		if($nsettingspath) {
			$msg .= '<li>You have previously used the $nsettingspath variable defined in cruser.pl. This variable has now been replaced with the $data_path variable, please read the upgrade documentation for more details on how to upgrade your cruser.pl file!';
			$msg .= qq~<br>Your path to nsettings.cgi is currently <b>$nsettingspath</b>~;
		}
		if($nsbkpath) {
			$msg .= '<li>You have previously used the $nsbkpath variable defined in cruser.pl. This variable has now been replaced with the $data_path variable, please read the upgrade documentation for more details on how to upgrade your cruser.pl file!';
			$msg .= qq~<br>Your path to nsbk.cgi is currently <b>$nsbkpath</b>~;
		}
		if($cfgpath) {
			$msg .= '<li>You have previously used the $cfgpath variable defined in cruser.pl. This variable has now been replaced with the $data_path variable, please read the upgrade documentation for more details on how to upgrade your cruser.pl file!';
			$msg .= qq~<br>Your path to crcfg.dat is currently <b>$cfgpath</b>~;
		}

		if($msg) {
			if(defined $CConfig{'currentbuild'} && ($CConfig{'currentbuild'} < 45)) {
				SimpleConfirmationPage("Upgrade Failure!", "<strong>It looks like you have used an old version of Coranto which doesnt use the new folder structure. Please follow the directions below to complete the upgrade!</strong><br><ul>$msg</ul>");
				exit;
			}
		}
		
}

 
1;
